/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.entity.entities;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1409;
import net.minecraft.class_1548;
import net.minecraft.class_1560;
import net.minecraft.class_1569;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1738;
import net.minecraft.class_1743;
import net.minecraft.class_1753;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1819;
import net.minecraft.class_1829;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4051;
import net.minecraft.class_4059;
import net.minecraft.class_4255;
import net.minecraft.class_5134;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.config.RecruitBalanceConfig;
import ydmsama.hundred_years_war.config.ServerModConfig;
import ydmsama.hundred_years_war.entity.action.Action;
import ydmsama.hundred_years_war.entity.action.AttackAction;
import ydmsama.hundred_years_war.entity.action.CancelAction;
import ydmsama.hundred_years_war.entity.action.HoldAction;
import ydmsama.hundred_years_war.entity.action.PatrolAction;
import ydmsama.hundred_years_war.entity.entities.ArcherEntity;
import ydmsama.hundred_years_war.entity.entities.HywHorseEntity;
import ydmsama.hundred_years_war.entity.entities.HywSkeletonArcherEntity;
import ydmsama.hundred_years_war.entity.entities.SpearManEntity;
import ydmsama.hundred_years_war.entity.entities.UseCrossbow;
import ydmsama.hundred_years_war.entity.entities.UseShield;
import ydmsama.hundred_years_war.entity.entities.puppets.IPuppet;
import ydmsama.hundred_years_war.entity.entities.siege.PositionAttackable;
import ydmsama.hundred_years_war.entity.entities.tags.CavalryUnit;
import ydmsama.hundred_years_war.entity.entities.tags.CounterCavalry;
import ydmsama.hundred_years_war.entity.entities.tags.CounterHeavy;
import ydmsama.hundred_years_war.entity.entities.tags.CounterLight;
import ydmsama.hundred_years_war.entity.entities.tags.CounterRanged;
import ydmsama.hundred_years_war.entity.entities.tags.CounterSiege;
import ydmsama.hundred_years_war.entity.entities.tags.HeavyUnit;
import ydmsama.hundred_years_war.entity.entities.tags.LightUnit;
import ydmsama.hundred_years_war.entity.entities.tags.RangedUnit;
import ydmsama.hundred_years_war.entity.entities.tags.SiegeUnit;
import ydmsama.hundred_years_war.entity.goals.BaseCombatEntityAttackGoal;
import ydmsama.hundred_years_war.entity.goals.CommandedGoal;
import ydmsama.hundred_years_war.entity.goals.FollowEntityGoal;
import ydmsama.hundred_years_war.entity.goals.FormMoveGoal;
import ydmsama.hundred_years_war.entity.goals.MoveGoal;
import ydmsama.hundred_years_war.entity.goals.PatrolGoal;
import ydmsama.hundred_years_war.entity.goals.PrioritizedGoal;
import ydmsama.hundred_years_war.entity.goals.ReturnToHomeGoal;
import ydmsama.hundred_years_war.entity.utils.FormationManager;
import ydmsama.hundred_years_war.entity.utils.MeleeCapableRangedAttacker;
import ydmsama.hundred_years_war.entity.utils.Rideable;
import ydmsama.hundred_years_war.entity.utils.json.EnchantmentData;
import ydmsama.hundred_years_war.entity.utils.json.EquipmentData;
import ydmsama.hundred_years_war.entity.utils.json.EquipmentLevelData;
import ydmsama.hundred_years_war.entity.utils.json.EquipmentOption;
import ydmsama.hundred_years_war.item.BaseScrollItem;
import ydmsama.hundred_years_war.mixins.EntityAccessor;
import ydmsama.hundred_years_war.registry.HywAttributes;
import ydmsama.hundred_years_war.utils.BetterMobCombatIntegration;
import ydmsama.hundred_years_war.utils.ExpBlacklistManager;
import ydmsama.hundred_years_war.utils.RelationSystem;
import ydmsama.hundred_years_war.utils.ServerRelationHelper;
import ydmsama.hundred_years_war.utils.TargetListManager;
import ydmsama.hundred_years_war.utils.WeaponTypeHelper;
import ydmsama.hundred_years_war.utils.WorldTickCounter;

public abstract class BaseCombatEntity
extends class_1314 {
    protected float currentRot;
    protected float targetRot;
    protected float rotationLimit = 90.0f;
    protected class_1309 startTarget;
    private int equipmentLevel;
    private double desiredDistance = 1.5;
    private int targetNullTicks = 0;
    protected boolean isAttacking = false;
    protected int attackAnimationTime = -1;
    protected int attackDamageTick = -1;
    private int attackCoolDown = 0;
    private UUID followTargetUUID;
    private class_1309 followTarget;
    private final List<class_2338> patrolPoints;
    private int healCooldown = 1200;
    private int shieldCoolDown;
    private final double defaultHomeReturnRadius = 0.5;
    private double homeReturnRadius = 0.5;
    private long unloadTime = -1L;
    private double[] screenPos;
    private UUID formationUUID;
    private class_2338 homePosition;
    private static final class_2940<Boolean> START_ATTACKING = class_2945.method_12791(BaseCombatEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> CURRENT_SKIN_INDEX = class_2945.method_12791(BaseCombatEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> EXPERIENCE_POINTS = class_2945.method_12791(BaseCombatEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> LEVEL = class_2945.method_12791(BaseCombatEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> HAS_TARGET = class_2945.method_12791(BaseCombatEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Optional<UUID>> OWNER_UUID = class_2945.method_12791(BaseCombatEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Integer> KILL_COUNT = class_2945.method_12791(BaseCombatEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> Y_BODY_ROT = class_2945.method_12791(BaseCombatEntity.class, (class_2941)class_2943.field_13320);
    private boolean queueMode = false;
    private boolean holding = false;
    private boolean commandHold = false;
    private Queue<PrioritizedGoal> goalQueue = new LinkedList<PrioritizedGoal>();
    private PrioritizedGoal currentCommandedGoal;
    private boolean shouldExecuteNext;
    public final class_7094 attackAnimationState = new class_7094();
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 moveAnimationState = new class_7094();
    private long lastInteractionTime = 0L;
    private static final long INTERACTION_COOLDOWN = 500L;
    protected long lastWeaponReplaceTime = 0L;
    protected static final long WEAPON_REPLACE_COOLDOWN = 1000L;
    protected class_1309 hywTarget;
    protected int targetResetTick = 10;
    private static final int TARGET_RESET_TIME = 10;
    private boolean forceAttackTarget = false;
    private final List<Action> actions = new ArrayList<Action>();
    private static final UUID WATER_SPEED_MODIFIER_UUID = UUID.fromString("550e8400-e29b-41d4-a716-446655440000");
    private static final UUID WEAKNESS_RANGED_DAMAGE_MODIFIER_UUID = UUID.fromString("550e8400-e29b-41d4-a716-446655440001");
    private int summonWeaknessTimer = 0;
    private int comboCount = 0;
    private static EquipmentData equipmentData;
    private final Random random = new Random();

    public int getComboCount() {
        return this.comboCount;
    }

    public void setComboCount(int comboCount) {
        this.comboCount = comboCount;
    }

    public int getSummonWeaknessTimer() {
        return this.summonWeaknessTimer;
    }

    public void setSummonWeaknessTimer(int timer) {
        this.summonWeaknessTimer = timer;
    }

    public BaseCombatEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.patrolPoints = new ArrayList<class_2338>();
        this.method_5841().method_12784(START_ATTACKING, (Object)false);
        this.method_5841().method_12784(HAS_TARGET, (Object)false);
        this.method_5841().method_12784(OWNER_UUID, Optional.empty());
        this.method_5971();
        this.field_6011.method_12784(EXPERIENCE_POINTS, (Object)0);
        this.field_6011.method_12784(LEVEL, (Object)1);
        this.field_6011.method_12784(CURRENT_SKIN_INDEX, (Object)1);
        this.setCurrentSkinIndex(new Random().nextInt(this.getSkinCounts()) + 1);
        ((class_1409)this.method_5942()).method_6363(true);
        ((class_1409)this.method_5942()).method_35139(true);
        this.method_5941(class_7.field_21, 0.0f);
        this.method_5941(class_7.field_25418, 0.0f);
        this.method_5941(class_7.field_19, 16.0f);
        this.initActions();
    }

    public int getSkinCounts() {
        return 20;
    }

    public boolean isHolding() {
        return this.holding;
    }

    public void setHolding(boolean holding) {
        this.holding = holding;
    }

    public boolean commandHold() {
        return this.commandHold;
    }

    public void setCommandHold(boolean commandHold) {
        if (commandHold) {
            this.method_5942().method_6340();
            this.setHywTarget(null);
            if (this.homePosition == null) {
                this.setHomePosition(this.method_24515());
            }
        }
        this.commandHold = commandHold;
    }

    public boolean getWithinAttackRange() {
        if (this.getHywTarget() != null) {
            float attackReach;
            double distanceSq = this.method_5649(this.getHywTarget().method_23317(), this.getHywTarget().method_23318(), this.getHywTarget().method_23321());
            return distanceSq <= (double)((attackReach = this.getAttackReach()) * attackReach);
        }
        return false;
    }

    public boolean getWithinPushRange() {
        if (this.getHywTarget() != null) {
            double distanceSq = this.method_5649(this.getHywTarget().method_23317(), this.getHywTarget().method_23318(), this.getHywTarget().method_23321());
            return distanceSq <= (double)(10.0f * this.getAttackReach());
        }
        return false;
    }

    public double[] getScreenPos() {
        return this.screenPos;
    }

    public double getDefaultHomeReturnRadius() {
        return 0.5;
    }

    public double getHomeReturnRadius() {
        return this.homeReturnRadius;
    }

    public void setHomeReturnRadius(double homeReturnRadius) {
        this.homeReturnRadius = homeReturnRadius;
    }

    public void setScreenPos(double[] screenPos) {
        this.screenPos = screenPos;
    }

    public int getCurrentSkinIndex() {
        return (Integer)this.method_5841().method_12789(CURRENT_SKIN_INDEX);
    }

    public void setCurrentSkinIndex(int index) {
        this.method_5841().method_12778(CURRENT_SKIN_INDEX, (Object)index);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(KILL_COUNT, (Object)0);
        this.field_6011.method_12784(Y_BODY_ROT, (Object)Float.valueOf(0.0f));
    }

    public void setOwnerUUID(UUID uuid) {
        if (uuid == null) {
            this.field_6011.method_12778(OWNER_UUID, Optional.empty());
        } else {
            this.field_6011.method_12778(OWNER_UUID, Optional.of(uuid));
        }
    }

    public class_3222 getOwner() {
        MinecraftServer server;
        Optional optionalUUID = (Optional)this.field_6011.method_12789(OWNER_UUID);
        if (optionalUUID.isPresent() && (server = ((EntityAccessor)((Object)this)).getLevel().method_8503()) != null) {
            return server.method_3760().method_14602((UUID)optionalUUID.get());
        }
        return null;
    }

    public int getExperiencePoints() {
        return (Integer)this.field_6011.method_12789(EXPERIENCE_POINTS);
    }

    public void setExperiencePoints(int experiencePoints) {
        this.field_6011.method_12778(EXPERIENCE_POINTS, (Object)experiencePoints);
    }

    public int getLevel() {
        return (Integer)this.field_6011.method_12789(LEVEL);
    }

    public void setLevel(int level) {
        this.field_6011.method_12778(LEVEL, (Object)level);
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.field_6011.method_12789(OWNER_UUID)).orElse(null);
    }

    public void setHomePosition(class_2338 homePosition) {
        this.homePosition = homePosition;
    }

    public class_2338 getHomePosition() {
        return this.homePosition;
    }

    public void removeCustomGoal(class_1352 goal) {
        this.field_6201.method_6280(goal);
    }

    public void clearAllGoals() {
        this.field_6201.method_35115().clear();
    }

    public void addCustomGoal(int priority, class_1352 goal) {
        this.goalQueue.add(new PrioritizedGoal(priority, goal));
        if (this.goalQueue.size() == 1) {
            this.executeNextGoal();
        }
    }

    public void executeNextGoal() {
        if (!this.goalQueue.isEmpty()) {
            PrioritizedGoal prioritizedGoal;
            this.currentCommandedGoal = prioritizedGoal = this.goalQueue.peek();
            this.field_6201.method_6277(prioritizedGoal.priority, this.currentCommandedGoal.goal);
        }
    }

    public void goalFinished() {
        this.goalQueue.poll();
        this.currentCommandedGoal = null;
    }

    public void clearCommandedGoals() {
        for (Object passenger : this.method_5685()) {
            if (!(passenger instanceof BaseCombatEntity)) continue;
            ((BaseCombatEntity)((Object)passenger)).clearCommandedGoals();
        }
        ArrayList toRemove = new ArrayList();
        this.field_6201.method_35115().stream().filter(pair -> pair.method_19058() instanceof CommandedGoal).forEach(pair -> {
            toRemove.add(pair.method_19058());
            pair.method_19058().method_6270();
        });
        for (class_1352 goal : toRemove) {
            this.field_6201.method_6280(goal);
            goal.method_6270();
        }
        BaseCombatEntity baseCombatEntity = this;
        if (baseCombatEntity instanceof PositionAttackable) {
            PositionAttackable positionAttackable = (PositionAttackable)((Object)baseCombatEntity);
            positionAttackable.setPositionTarget(null);
        }
        this.clearGoalQueue();
        this.clearPatrolPoints();
        this.setFollowTarget(null);
        this.setHywTarget(null);
        this.setCommandHold(false);
    }

    public void clearGoalQueue() {
        for (PrioritizedGoal goal : this.goalQueue) {
            if (!(goal.goal instanceof FormMoveGoal)) continue;
            UUID formationUUID = ((FormMoveGoal)goal.goal).getFormationUUID();
            FormationManager.getFormationStatus(formationUUID).removeEntityFromFormation(this);
        }
        this.goalQueue.clear();
        this.currentCommandedGoal = null;
    }

    public boolean isShouldExecuteNext() {
        return this.shouldExecuteNext;
    }

    public void setShouldExecuteNext(boolean shouldExecuteNext) {
        this.shouldExecuteNext = shouldExecuteNext;
    }

    public UUID getFormationUUID() {
        return this.formationUUID;
    }

    public void setFormationUUID(UUID formationUUID) {
        this.formationUUID = formationUUID;
    }

    public void setQueueMode(boolean queueMode) {
        this.queueMode = queueMode;
    }

    public boolean getQueueMode() {
        return this.queueMode;
    }

    public void setStartAttacking(boolean start) {
        this.method_5841().method_12778(START_ATTACKING, (Object)start);
    }

    public boolean getStartAttacking() {
        return (Boolean)this.method_5841().method_12789(START_ATTACKING);
    }

    public boolean getHasTarget() {
        return (Boolean)this.field_6011.method_12789(HAS_TARGET);
    }

    public void setHasTarget(boolean hasTarget) {
        this.field_6011.method_12778(HAS_TARGET, (Object)hasTarget);
    }

    protected void setDefaultEquipment() {
    }

    public void method_5652(class_2487 compound) {
        MinecraftServer server;
        class_1324 attackAttribute;
        Optional ownerUUID;
        super.method_5652(compound);
        if (this.homePosition != null) {
            compound.method_10569("HomePosX", this.homePosition.method_10263());
            compound.method_10569("HomePosY", this.homePosition.method_10264());
            compound.method_10569("HomePosZ", this.homePosition.method_10260());
        }
        if ((ownerUUID = (Optional)this.field_6011.method_12789(OWNER_UUID)).isPresent()) {
            compound.method_25927("OwnerUUID", (UUID)ownerUUID.get());
        }
        compound.method_10549("HomeReturnRadius", this.getHomeReturnRadius());
        ArrayList<Integer> patrolList = new ArrayList<Integer>();
        for (class_2338 pos : this.patrolPoints) {
            patrolList.add(pos.method_10263());
            patrolList.add(pos.method_10264());
            patrolList.add(pos.method_10260());
        }
        compound.method_10572("PatrolPoints", patrolList);
        if (this.followTarget != null) {
            compound.method_25927("FollowTargetUUID", this.followTarget.method_5667());
        }
        compound.method_10569("ExperiencePoints", this.getExperiencePoints());
        compound.method_10569("Level", this.getLevel());
        compound.method_10549("Health", (double)this.method_6032());
        class_1324 maxHealthAttribute = this.method_5996(class_5134.field_23716);
        if (maxHealthAttribute != null) {
            compound.method_10549("MaxHealth", maxHealthAttribute.method_6201());
        }
        if ((attackAttribute = this.method_5996(class_5134.field_23721)) != null) {
            compound.method_10549("AttackDamage", attackAttribute.method_6201());
        }
        compound.method_10569("Skin", this.getCurrentSkinIndex());
        compound.method_10569("EquipmentLevel", this.getEquipmentLevel());
        compound.method_10556("CommandHold", this.commandHold);
        compound.method_10569("KillCount", this.getKillCount());
        compound.method_10569("SummonWeaknessTimer", this.summonWeaknessTimer);
        if (!this.method_37908().field_9236 && (server = this.method_37908().method_8503()) != null) {
            WorldTickCounter counter = WorldTickCounter.get(server);
            compound.method_10544("UnloadWorldTicks", counter.getTotalWorldTicks());
        }
    }

    public void method_5749(class_2487 compound) {
        class_1324 attackAttribute;
        class_1324 maxHealthAttribute;
        super.method_5749(compound);
        if (compound.method_10545("HomePosX") && compound.method_10545("HomePosY") && compound.method_10545("HomePosZ")) {
            int homeX = compound.method_10550("HomePosX");
            int homeY = compound.method_10550("HomePosY");
            int homeZ = compound.method_10550("HomePosZ");
            this.setHomePosition(new class_2338(homeX, homeY, homeZ));
        }
        if (compound.method_25928("OwnerUUID")) {
            UUID ownerUUID = compound.method_25926("OwnerUUID");
            this.field_6011.method_12778(OWNER_UUID, Optional.of(ownerUUID));
        } else {
            this.field_6011.method_12778(OWNER_UUID, Optional.empty());
        }
        if (compound.method_10545("HomeReturnRadius")) {
            this.setHomeReturnRadius(compound.method_10574("HomeReturnRadius"));
        }
        int[] patrolList = compound.method_10561("PatrolPoints");
        this.patrolPoints.clear();
        for (int i = 0; i < patrolList.length; i += 3) {
            class_2338 pos = new class_2338(patrolList[i], patrolList[i + 1], patrolList[i + 2]);
            this.patrolPoints.add(pos);
        }
        if (compound.method_25928("FollowTargetUUID")) {
            this.followTargetUUID = compound.method_25926("FollowTargetUUID");
        }
        if (compound.method_10545("ExperiencePoints")) {
            this.setExperiencePoints(compound.method_10550("ExperiencePoints"));
        }
        if (compound.method_10545("Level")) {
            this.setLevel(compound.method_10550("Level"));
        }
        if (compound.method_10545("MaxHealth") && (maxHealthAttribute = this.method_5996(class_5134.field_23716)) != null) {
            maxHealthAttribute.method_6192(compound.method_10574("MaxHealth"));
        }
        if (compound.method_10545("Health")) {
            this.method_6033((float)compound.method_10574("Health"));
        }
        if (compound.method_10545("AttackDamage") && (attackAttribute = this.method_5996(class_5134.field_23721)) != null) {
            attackAttribute.method_6192(compound.method_10574("AttackDamage"));
        }
        if (compound.method_10545("Skin")) {
            this.setCurrentSkinIndex(compound.method_10550("Skin"));
        }
        if (compound.method_10545("EquipmentLevel")) {
            this.setEquipmentLevel(compound.method_10550("EquipmentLevel"));
        }
        if (compound.method_10545("CommandHold")) {
            this.commandHold = compound.method_10577("CommandHold");
        }
        if (compound.method_10545("KillCount")) {
            this.setKillCount(compound.method_10550("KillCount"));
        }
        if (compound.method_10545("SummonWeaknessTimer")) {
            this.summonWeaknessTimer = compound.method_10550("SummonWeaknessTimer");
        }
        if (!this.method_37908().field_9236 && compound.method_10545("UnloadWorldTicks")) {
            this.unloadTime = compound.method_10537("UnloadWorldTicks");
            this.handleTimeBasedRecovery(compound);
        }
    }

    public void method_5773() {
        class_1297 entity2;
        MinecraftServer server;
        PositionAttackable positionAttackable;
        BaseCombatEntity inWater2;
        super.method_5773();
        if (!this.method_37908().field_9236) {
            class_1324 speedAttr;
            if (!(this instanceof IPuppet)) {
                if (this.summonWeaknessTimer > 0) {
                    --this.summonWeaknessTimer;
                }
                this.manageWeaknessRangedDamageModifier();
            }
            if ((speedAttr = this.method_5996(class_5134.field_23719)) == null) {
                return;
            }
            boolean inWater2 = this.method_5799();
            class_1322 waterBoost = speedAttr.method_6199(WATER_SPEED_MODIFIER_UUID);
            if (inWater2) {
                if (waterBoost == null) {
                    speedAttr.method_26835(new class_1322(WATER_SPEED_MODIFIER_UUID, "In water speed boost", 1.0, class_1322.class_1323.field_6331));
                }
            } else if (waterBoost != null) {
                speedAttr.method_6200(WATER_SPEED_MODIFIER_UUID);
            }
        }
        if (!this.method_37908().field_9236) {
            this.setHasTarget(this.getHywTarget() != null);
            this.checkAndUpdateTarget();
        }
        if (this.method_37908().field_9236) {
            this.updateAnimationState();
            if (this.method_18798().method_37268() < 1.0E-6) {
                this.moveAnimationState.method_41325();
            }
        }
        if (!this.method_37908().field_9236) {
            this.setHolding(this.commandHold());
        }
        if (!this.method_37908().field_9236 && this.shouldExecuteNext) {
            this.executeNextGoal();
            this.shouldExecuteNext = false;
        }
        if (!this.method_37908().field_9236 && !(this instanceof IPuppet)) {
            if (this.healCooldown > 0) {
                --this.healCooldown;
            } else {
                if (this.method_6032() < this.method_6063()) {
                    this.method_6025(1.0f);
                }
                this.healCooldown = 1200;
            }
        }
        if (!this.method_37908().field_9236 && (inWater2 = this) instanceof PositionAttackable && (positionAttackable = (PositionAttackable)((Object)inWater2)).hasPositionTarget()) {
            double attackReachSq;
            double dz;
            class_243 targetPos = positionAttackable.getPositionTarget();
            double dx = targetPos.field_1352 - this.method_23317();
            double horizontalDistanceSq = dx * dx + (dz = targetPos.field_1350 - this.method_23321()) * dz;
            if (horizontalDistanceSq > (attackReachSq = (double)(this.getAttackReach() * this.getAttackReach())) && this.goalQueue.isEmpty() && !this.commandHold) {
                if (this.getHomePosition() != null) {
                    this.setHomePosition(null);
                }
                this.method_5942().method_6337(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, 1.0);
            } else if (horizontalDistanceSq <= attackReachSq && this.method_5942().method_23966()) {
                this.method_5942().method_6340();
            }
        }
        if (!this.method_37908().field_9236 && this.followTargetUUID != null && this.followTarget == null && (server = this.method_37908().method_8503()) != null && (entity2 = server.method_3847(this.method_37908().method_27983()).method_14190(this.followTargetUUID)) instanceof class_1309) {
            this.followTarget = (class_1309)entity2;
        }
        if (!this.method_37908().field_9236 && this.attackCoolDown > 0) {
            --this.attackCoolDown;
        }
        if (!this.method_37908().field_9236) {
            if (this.getHywTarget() == null) {
                ++this.targetNullTicks;
                if (this.targetNullTicks >= 20 && this.getAttackAnimationTime() <= 0) {
                    this.setStartAttacking(false);
                    this.setAttacking(false);
                    this.method_6021();
                    this.targetNullTicks = 0;
                }
            } else {
                this.targetNullTicks = 0;
            }
        }
        if (!(this.method_37908().field_9236 || this.getHywTarget() != null || this.method_5968() == null || this.method_5968() instanceof BaseCombatEntity && !ServerRelationHelper.isEnemyRelation((class_1297)this, (class_1297)this.method_5968()))) {
            this.setHywTarget(this.method_5968());
        }
        if (!this.method_37908().field_9236) {
            double desiredDistance = this.getDesiredDistance();
            List nearbyEntities = this.method_37908().method_8390(BaseCombatEntity.class, this.method_5829().method_1014(desiredDistance), entity -> entity != this);
            class_243 repulsion = class_243.field_1353;
            for (BaseCombatEntity otherEntity : nearbyEntities) {
                List overlappingEntities;
                BaseCombatEntity selfCombat = this;
                BaseCombatEntity otherCombat = otherEntity;
                if (this.method_5765() || otherCombat.method_5765() || otherEntity == this.method_5854() || this.method_5685().contains((Object)otherEntity)) continue;
                if (otherEntity instanceof SiegeUnit && !ServerRelationHelper.isEnemyRelation((class_1297)selfCombat, (class_1297)otherCombat)) {
                    desiredDistance *= 2.0;
                }
                if (!this.getWithinPushRange() && !ServerRelationHelper.isEnemyRelation((class_1297)selfCombat, (class_1297)otherCombat) && (selfCombat.method_5942().method_23966() || otherCombat.method_5942().method_23966()) && (overlappingEntities = ((EntityAccessor)((Object)selfCombat)).getLevel().method_8335((class_1297)selfCombat, selfCombat.method_5829().method_1014(0.5))).size() <= 3) continue;
                class_243 difference = this.method_19538().method_1020(otherEntity.method_19538());
                difference = new class_243(difference.field_1352, 0.0, difference.field_1350);
                double distance = difference.method_1033();
                if (!(distance < desiredDistance) || !(distance > 0.0)) continue;
                double strength = (desiredDistance - distance) / desiredDistance;
                strength = !selfCombat.method_5942().method_23966() && this.getHywTarget() != null ? (!(otherCombat instanceof Rideable) && !(selfCombat instanceof Rideable) ? (strength *= 0.2) : (strength *= 1.5)) : (!(selfCombat instanceof Rideable) || !ServerRelationHelper.isEnemyRelation((class_1297)selfCombat, (class_1297)otherCombat) ? (this.getWithinPushRange() ? (strength *= 4.0) : (strength *= 2.0)) : (strength *= 1.5));
                class_243 repulsionVector = difference.method_1029().method_1021(strength * 0.1);
                repulsion = repulsion.method_1019(repulsionVector);
            }
            if (!repulsion.equals((Object)class_243.field_1353)) {
                this.method_18799(this.method_18798().method_1019(repulsion));
            }
        }
        if (!(!this.method_37908().field_9236 || this.method_5854() == null || this instanceof class_1603 && this.getHasTarget())) {
            this.field_6241 = this.method_5854().method_36454();
        }
        if (!this.method_37908().field_9236 && this.field_6012 % 2 == 0) {
            this.handleAttackLogic();
        }
        this.manageRotation();
    }

    private void handleAttackLogic() {
        PositionAttackable positionAttackable;
        BaseCombatEntity baseCombatEntity = this;
        if (baseCombatEntity instanceof PositionAttackable && (positionAttackable = (PositionAttackable)((Object)baseCombatEntity)).hasPositionTarget()) {
            boolean withinAttackRange;
            class_243 targetPos = positionAttackable.getPositionTarget();
            double distanceSq = this.method_5649(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350);
            boolean bl = withinAttackRange = distanceSq <= (double)(this.getAttackReach() * this.getAttackReach());
            if (this.isAttacking() && this.getAttackAnimationTime() > 0) {
                this.handlePositionAttackAnimation(targetPos);
            } else if (withinAttackRange && this.getAttackCoolDown() == 0) {
                this.startNewAttackCycleForPosition(targetPos);
            }
            return;
        }
        class_1309 target = this.getHywTarget();
        if (target == null || !target.method_5805() || !this.method_5805()) {
            if (this.getAttackAnimationTime() > 0) {
                this.setAttackAnimationTime(this.getAttackAnimationTime() - 1);
            }
        } else {
            boolean withinAttackRange;
            double distanceSq = this.method_5649(target.method_23317(), target.method_23318(), target.method_23321());
            boolean bl = this.usingBetterCombat() ? BetterMobCombatIntegration.isWithinBetterCombatRange(this, target) : (withinAttackRange = distanceSq <= (double)(this.getAttackReach() * this.getAttackReach()));
            if (this.isAttacking() && this.getAttackAnimationTime() > 0) {
                this.handleAttackAnimation();
            } else if (withinAttackRange && this.getAttackCoolDown() == 0) {
                this.startNewAttackCycle();
            }
            if (this instanceof UseShield) {
                if (this.getShieldCoolDown() > 0) {
                    this.coolDown();
                } else {
                    class_1799 offhandItem = this.method_6118(class_1304.field_6171);
                    if (offhandItem.method_7909() instanceof class_1819 && (!BetterMobCombatIntegration.isActivated() || this.method_6032() < this.method_6063() * 0.5f)) {
                        this.method_6019(class_1268.field_5810);
                    }
                }
            }
        }
    }

    private void handlePositionAttackAnimation(class_243 targetPos) {
        this.method_5942().method_6340();
        this.method_5988().method_6230(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, 30.0f, 30.0f);
        this.setAttackAnimationTime(this.getAttackAnimationTime() - 1);
        this.setAttackDamageTick(this.getAttackDamageTick() - 1);
        if (this.getAttackDamageTick() == 0) {
            BaseCombatEntity baseCombatEntity;
            if (this instanceof class_1603 && (baseCombatEntity = this) instanceof PositionAttackable) {
                PositionAttackable positionAttackable = (PositionAttackable)((Object)baseCombatEntity);
                positionAttackable.performPositionAttack(targetPos, 1.0f);
            }
            this.setAttackDamageTick(-1);
        }
        if (this.getAttackAnimationTime() == 0) {
            this.resetAttackCycle();
            this.startTarget = null;
        }
    }

    private void startNewAttackCycleForPosition(class_243 targetPos) {
        PositionAttackable positionAttackable;
        BaseCombatEntity baseCombatEntity = this;
        if (baseCombatEntity instanceof PositionAttackable && !(positionAttackable = (PositionAttackable)((Object)baseCombatEntity)).canFireAtPosition(targetPos)) {
            return;
        }
        this.setAttacking(true);
        this.setStartAttacking(true);
        this.setAttackAnimationTime(this.getBaseAttackAnimationTime());
        this.setAttackDamageTick(this.getAttackDamageTickDelay());
        if (this instanceof class_1603) {
            class_1268 hand;
            class_1799 itemStack;
            MeleeCapableRangedAttacker meleeCapable;
            baseCombatEntity = this;
            if (baseCombatEntity instanceof MeleeCapableRangedAttacker && !(meleeCapable = (MeleeCapableRangedAttacker)((Object)baseCombatEntity)).isUsingRanged()) {
                return;
            }
            if ((this instanceof ArcherEntity || this instanceof HywSkeletonArcherEntity) && ((itemStack = this.method_5998(hand = class_1268.field_5808)).method_31574(class_1802.field_8102) || WeaponTypeHelper.isBowLikeWeapon(itemStack))) {
                this.method_6019(hand);
            }
            if (this instanceof UseCrossbow && ((itemStack = this.method_5998(hand = class_1268.field_5808)).method_31574(class_1802.field_8399) || WeaponTypeHelper.isCrossbowLikeWeapon(itemStack))) {
                this.method_6019(hand);
            }
        }
    }

    private void handleAttackAnimation() {
        class_1309 target = this.getHywTarget();
        this.method_5942().method_6340();
        this.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
        this.setAttackAnimationTime(this.getAttackAnimationTime() - 1);
        this.setAttackDamageTick(this.getAttackDamageTick() - 1);
        if (this.getAttackDamageTick() == 0) {
            BaseCombatEntity baseCombatEntity;
            if (this instanceof class_1603 && (baseCombatEntity = this) instanceof MeleeCapableRangedAttacker) {
                MeleeCapableRangedAttacker meleeCapable = (MeleeCapableRangedAttacker)((Object)baseCombatEntity);
                if (meleeCapable.isUsingRanged()) {
                    ((class_1603)this).method_7105(target, 1.0f);
                } else {
                    float meleeReach;
                    boolean withinAttackRange;
                    double distanceSq = this.method_5649(target.method_23317(), target.method_23318(), target.method_23321());
                    boolean bl = withinAttackRange = distanceSq <= (double)((meleeReach = meleeCapable.getMeleeAttackReach()) * meleeReach);
                    if ((target == this.startTarget || withinAttackRange) && !this.usingBetterCombat()) {
                        this.method_23667(class_1268.field_5808, true);
                        this.method_6121((class_1297)target);
                        ++this.comboCount;
                    }
                }
            } else {
                BaseCombatEntity distanceSq = this;
                if (distanceSq instanceof class_1603) {
                    class_1603 rangedAttackMob = (class_1603)distanceSq;
                    rangedAttackMob.method_7105(target, 1.0f);
                } else {
                    float attackReach;
                    boolean withinAttackRange;
                    double distanceSq2 = this.method_5649(target.method_23317(), target.method_23318(), target.method_23321());
                    boolean bl = withinAttackRange = distanceSq2 <= (double)((attackReach = (float)this.method_26825(HywAttributes.ATTACK_REACH)) * attackReach);
                    if ((target == this.startTarget || withinAttackRange) && !this.usingBetterCombat()) {
                        this.method_23667(class_1268.field_5808, true);
                        this.method_6121((class_1297)target);
                        ++this.comboCount;
                    }
                }
            }
            this.setAttackDamageTick(-1);
        }
        if (this.getAttackAnimationTime() == 0) {
            this.resetAttackCycle();
            this.startTarget = null;
        }
    }

    public boolean usingBetterCombat() {
        MeleeCapableRangedAttacker meleeCapable;
        BaseCombatEntity baseCombatEntity;
        if (!BetterMobCombatIntegration.isActivated()) {
            return false;
        }
        boolean isMeleeUnit = !(this instanceof class_1603) || (baseCombatEntity = this) instanceof MeleeCapableRangedAttacker && !(meleeCapable = (MeleeCapableRangedAttacker)((Object)baseCombatEntity)).isUsingRanged();
        boolean canUse = !this.method_6115() && BetterMobCombatIntegration.isBetterCombatWeapon(this.method_6047());
        return isMeleeUnit && canUse;
    }

    private void startNewAttackCycle() {
        class_1309 target = this.getHywTarget();
        if (!this.canFireAtTarget(target)) {
            return;
        }
        this.startTarget = target;
        this.setAttacking(true);
        this.setStartAttacking(true);
        this.setAttackAnimationTime(this.getBaseAttackAnimationTime());
        this.setAttackDamageTick(this.getAttackDamageTickDelay());
        if (this.usingBetterCombat()) {
            try {
                if (BetterMobCombatIntegration.performBetterMobCombatAttack(this, target)) {
                    return;
                }
            }
            catch (Exception e) {
                System.out.println("[HundredYearsWar] Better Mob Combat attack failed for " + this + ", falling back to vanilla attack: " + e.getMessage());
            }
        }
        if (this instanceof class_1603) {
            class_1268 hand;
            class_1799 itemStack;
            MeleeCapableRangedAttacker meleeCapable;
            BaseCombatEntity baseCombatEntity = this;
            if (baseCombatEntity instanceof MeleeCapableRangedAttacker && !(meleeCapable = (MeleeCapableRangedAttacker)((Object)baseCombatEntity)).isUsingRanged()) {
                return;
            }
            if ((this instanceof ArcherEntity || this instanceof HywSkeletonArcherEntity) && ((itemStack = this.method_5998(hand = class_1268.field_5808)).method_31574(class_1802.field_8102) || itemStack.method_7909() instanceof class_1753)) {
                this.method_6019(hand);
            }
            if (this instanceof UseCrossbow) {
                hand = class_1268.field_5808;
                this.method_6019(hand);
            }
        }
    }

    private void resetAttackCycle() {
        this.setAttacking(false);
        this.setStartAttacking(false);
        this.setAttackCoolDown(this.getAttackCoolDownDuration());
        if (!BetterMobCombatIntegration.isActivated() || !BetterMobCombatIntegration.isBetterCombatWeapon(this.method_6047())) {
            this.comboCount = 0;
        }
    }

    protected void updateAnimationState() {
        if (this.getStartAttacking()) {
            if (!this.attackAnimationState.method_41327()) {
                this.moveAnimationState.method_41325();
                this.idleAnimationState.method_41325();
                this.attackAnimationState.method_41322(this.field_6012);
            }
        } else if (this.method_18798().method_37268() < 1.0E-6) {
            this.moveAnimationState.method_41325();
            this.attackAnimationState.method_41325();
            if (!this.idleAnimationState.method_41327()) {
                this.idleAnimationState.method_41322(this.field_6012);
            }
        } else {
            this.attackAnimationState.method_41325();
            this.idleAnimationState.method_41325();
            if (!this.moveAnimationState.method_41327()) {
                this.moveAnimationState.method_41322(this.field_6012);
            }
        }
    }

    public int getBaseAttackAnimationTime() {
        return 0;
    }

    public int getAttackDamageTickDelay() {
        return 0;
    }

    public int getAttackCoolDownDuration() {
        return 0;
    }

    public float getAttackReach() {
        class_1324 attackReachAttr = this.method_5996(HywAttributes.ATTACK_REACH);
        return attackReachAttr != null ? (float)attackReachAttr.method_6194() : 3.0f;
    }

    private void manageWeaknessRangedDamageModifier() {
        boolean hasModifier;
        if (!ServerModConfig.INSTANCE.isEnableRecruitBalance()) {
            return;
        }
        class_1324 rangedDamageAttr = this.method_5996(HywAttributes.RANGED_ATTACK_DAMAGE);
        if (rangedDamageAttr == null) {
            return;
        }
        boolean hasWeakness = this.method_6059(class_1294.field_5911);
        boolean bl = hasModifier = rangedDamageAttr.method_6199(WEAKNESS_RANGED_DAMAGE_MODIFIER_UUID) != null;
        if (hasWeakness && !hasModifier) {
            int weaknessLevel = this.method_6112(class_1294.field_5911).method_5578() + 1;
            double damageMultiplier = this.summonWeaknessTimer > 0 ? RecruitBalanceConfig.getWeaknessRangedDamageMultiplier(weaknessLevel) : Math.pow(0.8, weaknessLevel);
            double reductionPercentage = 1.0 - damageMultiplier;
            class_1322 weaknessModifier = new class_1322(WEAKNESS_RANGED_DAMAGE_MODIFIER_UUID, "Weakness ranged damage reduction", -reductionPercentage, class_1322.class_1323.field_6331);
            rangedDamageAttr.method_26837(weaknessModifier);
        } else if (!hasWeakness && hasModifier) {
            rangedDamageAttr.method_6200(WEAKNESS_RANGED_DAMAGE_MODIFIER_UUID);
        } else if (hasWeakness && hasModifier) {
            int currentWeaknessLevel = this.method_6112(class_1294.field_5911).method_5578() + 1;
            class_1322 currentModifier = rangedDamageAttr.method_6199(WEAKNESS_RANGED_DAMAGE_MODIFIER_UUID);
            double expectedMultiplier = this.summonWeaknessTimer > 0 ? RecruitBalanceConfig.getWeaknessRangedDamageMultiplier(currentWeaknessLevel) : Math.pow(0.5, currentWeaknessLevel);
            double expectedReduction = 1.0 - expectedMultiplier;
            if (currentModifier != null && Math.abs(currentModifier.method_6186() + expectedReduction) > 0.001) {
                rangedDamageAttr.method_6200(WEAKNESS_RANGED_DAMAGE_MODIFIER_UUID);
                class_1322 newWeaknessModifier = new class_1322(WEAKNESS_RANGED_DAMAGE_MODIFIER_UUID, "Weakness ranged damage reduction", -expectedReduction, class_1322.class_1323.field_6331);
                rangedDamageAttr.method_26837(newWeaknessModifier);
            }
        }
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_4255((class_1308)this, true));
        this.field_6201.method_6277(1, (class_1352)new FollowEntityGoal(this, 1.0, ServerModConfig.INSTANCE.getFollowDistanceInner(), ServerModConfig.INSTANCE.getFollowDistanceOuter(), 25.0, 50.0));
        this.field_6201.method_6277(2, (class_1352)new BaseCombatEntityAttackGoal(this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new PatrolGoal(this, 1.0, 40));
        this.field_6201.method_6277(3, (class_1352)new FollowEntityGoal(this, 1.0, ServerModConfig.INSTANCE.getFollowDistanceInner(), ServerModConfig.INSTANCE.getFollowDistanceInner(), Double.MAX_VALUE, 0.0));
        this.field_6201.method_6277(4, (class_1352)new ReturnToHomeGoal(this, 1.0));
        this.addTargetSelector();
    }

    public void addTargetSelector() {
        Predicate<class_1309> unifiedPredicate = this::isValidTarget;
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1309.class, 10, true, false, unifiedPredicate));
    }

    public boolean isValidTarget(class_1309 potentialTarget) {
        if (potentialTarget instanceof class_1569) {
            if (this instanceof class_1603) {
                return !(potentialTarget instanceof class_1560);
            }
            if (potentialTarget instanceof class_1548) {
                return ServerModConfig.INSTANCE.isAllowMeleeAttackCreeper();
            }
            return true;
        }
        if (TargetListManager.isInTargetList(potentialTarget)) {
            return true;
        }
        if (potentialTarget instanceof BaseCombatEntity || potentialTarget instanceof class_1657) {
            return ServerRelationHelper.isEnemyRelation((class_1297)this, (class_1297)potentialTarget);
        }
        return false;
    }

    protected void method_6090(class_1309 livingEntity) {
        if (livingEntity.method_42149()) {
            this.disableShield(true);
        }
    }

    public void disableShield(boolean bl) {
        float f = 0.25f + (float)class_1890.method_8234((class_1309)this) * 0.05f;
        if (bl) {
            f += 0.75f;
        }
        if (this.random.nextFloat() < f) {
            this.shieldCoolDown += 100;
            this.method_6021();
            this.method_37908().method_8421((class_1297)this, (byte)30);
        }
    }

    public int getShieldCoolDown() {
        return this.shieldCoolDown;
    }

    public void coolDown() {
        --this.shieldCoolDown;
    }

    public Queue<PrioritizedGoal> getGoalQueue() {
        return this.goalQueue;
    }

    public void setGoalQueue(Queue<PrioritizedGoal> goalQueue) {
        this.goalQueue = goalQueue != null ? goalQueue : new LinkedList();
    }

    public List<class_2338> getPatrolPoints() {
        return this.patrolPoints;
    }

    public void clearPatrolPoints() {
        this.patrolPoints.clear();
    }

    public class_1309 getFollowTarget() {
        return this.followTarget;
    }

    public void setFollowTarget(class_1309 followTarget) {
        this.followTarget = followTarget;
        if (followTarget == null) {
            this.followTargetUUID = null;
        }
    }

    public int getAttackCoolDown() {
        return this.attackCoolDown;
    }

    public void setAttackCoolDown(int attackCoolDown) {
        this.attackCoolDown = attackCoolDown;
    }

    protected String getEquipmentJsonPath() {
        class_2960 entityId = class_7923.field_41177.method_10221((Object)this.method_5864());
        if (entityId == null) {
            return null;
        }
        String entityName = entityId.method_12832();
        String equipmentFile = ServerModConfig.getCurrentEquipmentFileName();
        return "hundred_years_war:hyw/npc/" + entityName + "/" + equipmentFile;
    }

    protected void loadEquipmentData() {
        String configResourcePath = this.getEquipmentJsonPath();
        if (configResourcePath == null) {
            return;
        }
        String[] parts = configResourcePath.split(":");
        if (parts.length != 2) {
            return;
        }
        String namespace = parts[0];
        String path = parts[1];
        String fullPath = "/assets/" + namespace + "/" + path;
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(fullPath);
        if (is == null) {
            return;
        }
        try (InputStream inputStream = is;
             InputStreamReader reader = new InputStreamReader(inputStream);){
            Gson gson = new Gson();
            equipmentData = (EquipmentData)gson.fromJson((Reader)reader, EquipmentData.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected EquipmentOption selectRandomItem(List<EquipmentOption> options) {
        if (options == null || options.isEmpty()) {
            return null;
        }
        double totalProbability = 0.0;
        for (EquipmentOption option : options) {
            totalProbability += option.getProbability();
        }
        double randomValue = this.random.nextDouble() * totalProbability;
        double cumulativeProbability = 0.0;
        for (EquipmentOption option : options) {
            if (!(randomValue <= (cumulativeProbability += option.getProbability()))) continue;
            return option;
        }
        return null;
    }

    protected class_1799 createItemStack(EquipmentOption option) {
        if (option == null || option.getItem() == null) {
            return class_1799.field_8037;
        }
        class_2960 itemId = new class_2960(option.getItem());
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemId);
        if (item == class_1802.field_8162) {
            System.err.println("missing\uff1a" + option.getItem());
            return class_1799.field_8037;
        }
        class_1799 itemStack = new class_1799((class_1935)item);
        if (option.getEnchantments() != null) {
            for (EnchantmentData enchantmentData : option.getEnchantments()) {
                class_2960 enchantmentId = new class_2960(enchantmentData.getEnchantment());
                class_1887 enchantment = (class_1887)class_7923.field_41176.method_10223(enchantmentId);
                if (enchantment != null) {
                    itemStack.method_7978(enchantment, enchantmentData.getLevel());
                    continue;
                }
                System.err.println("missing\uff1a" + enchantmentData.getEnchantment());
            }
        }
        return itemStack;
    }

    public void setEquipment(int level) {
        this.loadEquipmentData();
        if (equipmentData != null) {
            EquipmentLevelData levelData = equipmentData.getLevels().get(String.valueOf(level));
            if (levelData == null) {
                this.setDefaultEquipment();
                return;
            }
            this.setEquipmentFromLevelData(levelData);
            this.setEquipmentLevel(level);
        } else {
            this.setDefaultEquipment();
        }
    }

    protected void setEquipmentFromLevelData(EquipmentLevelData levelData) {
        class_1304[] equipmentSlots = new class_1304[]{class_1304.field_6173, class_1304.field_6171, class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};
        List<List> optionsList = Arrays.asList(levelData.getMainHand(), levelData.getOffHand(), levelData.getHead(), levelData.getChest(), levelData.getLegs(), levelData.getFeet());
        for (int i = 0; i < equipmentSlots.length; ++i) {
            class_1304 slot = equipmentSlots[i];
            List options = optionsList.get(i);
            EquipmentOption option = this.selectRandomItem(options);
            class_1799 itemStack = this.createItemStack(option);
            this.method_5673(slot, itemStack);
        }
    }

    protected class_1792 getScrollType() {
        return null;
    }

    @NotNull
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (!this.method_37908().field_9236) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastInteractionTime < 500L) {
                return class_1269.field_5812;
            }
            this.lastInteractionTime = currentTime;
            if (player.method_5715() && ServerRelationHelper.hasControlOver(player, (class_1297)this)) {
                if (this.getScrollType() != null) {
                    boolean canRecall = false;
                    canRecall = player.method_7337() ? true : (this instanceof SiegeUnit ? ServerModConfig.INSTANCE.isAllowSiegeRecall() : ServerModConfig.INSTANCE.isAllowSoldierRecall());
                    if (canRecall) {
                        class_1799 stack = new class_1799((class_1935)this.getScrollType());
                        class_2487 entityData = new class_2487();
                        this.method_5647(entityData);
                        ((BaseScrollItem)stack.method_7909()).saveEntityDataToItem(stack, entityData);
                        if (!player.method_31548().method_7394(stack)) {
                            player.method_7328(stack, false);
                        }
                        this.spawnParticles(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321());
                        this.method_31472();
                    }
                }
                return class_1269.field_5812;
            }
            if (ServerRelationHelper.hasControlOver(player, (class_1297)this) && !(player.method_5998(hand).method_7909() instanceof BaseScrollItem)) {
                BaseCombatEntity vehicle;
                class_1297 class_12972;
                BaseCombatEntity target = this.method_5854() != null && (class_12972 = this.method_5854()) instanceof BaseCombatEntity ? (vehicle = (BaseCombatEntity)class_12972) : this;
                if (target.getFollowTarget() == null) {
                    target.setFollowTarget((class_1309)player);
                    if (player instanceof class_3222) {
                        serverPlayer = (class_3222)player;
                        serverPlayer.method_7353((class_2561)class_2561.method_43471((String)"message.hundred_years_war.following").method_27692(class_124.field_1060), true);
                    }
                } else {
                    target.setFollowTarget(null);
                    target.setHomePosition(target.method_24515());
                    if (player instanceof class_3222) {
                        serverPlayer = (class_3222)player;
                        serverPlayer.method_7353((class_2561)class_2561.method_43471((String)"message.hundred_years_war.stop_following").method_27692(class_124.field_1061), true);
                    }
                }
                return class_1269.field_5812;
            }
        }
        return super.method_5992(player, hand);
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1676 projectile;
        Object attackerMeleeCapable;
        MeleeCapableRangedAttacker meleeCapable;
        class_1676 projectile2;
        class_1676 projectile3;
        class_1657 player;
        Object owner;
        class_1657 player2;
        if (this.method_37908().field_9236) {
            return super.method_5643(source, amount);
        }
        if (this instanceof IPuppet || source.method_5529() instanceof IPuppet) {
            return super.method_5643(source, amount);
        }
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657 && (player2 = (class_1657)class_12972).method_5715() && ServerRelationHelper.hasControlOver(player2, (class_1297)this) && ServerModConfig.INSTANCE.isAllowEquipmentChange()) {
            class_1738 armorItem;
            class_1304 slotForArmor;
            class_1799 entityArmorItem;
            class_1304[] class_1304Array;
            class_1799 playerItem = player2.method_5998(class_1268.field_5808);
            if (playerItem.method_7960()) {
                class_1304[] armorSlots;
                class_1304Array = armorSlots = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};
                int n = class_1304Array.length;
                for (int i = 0; i < n; ++i) {
                    class_1304 slot = class_1304Array[i];
                    class_1799 armorItem2 = this.method_6118(slot);
                    if (armorItem2.method_7960()) continue;
                    this.method_5775(armorItem2);
                    this.method_5673(slot, class_1799.field_8037);
                    return false;
                }
            }
            if ((class_1304Array = playerItem.method_7909()) instanceof class_1738 && (entityArmorItem = this.method_6118(slotForArmor = (armorItem = (class_1738)class_1304Array).method_7685())).method_7960()) {
                this.method_5673(slotForArmor, playerItem.method_7972());
                player2.method_6122(class_1268.field_5808, class_1799.field_8037);
                return false;
            }
            class_1304 slotToCheck = this.determineEquipmentSlot(playerItem);
            class_1799 entityItem = this.method_6118(slotToCheck);
            boolean itemReplaced = false;
            if ((!(this instanceof SpearManEntity) || WeaponTypeHelper.isPikeLikeWeapon(playerItem)) && this.isSameItemType(playerItem, entityItem)) {
                long currentTime;
                boolean isWeaponItem;
                boolean bl = isWeaponItem = WeaponTypeHelper.isSwordLikeWeapon(playerItem) || WeaponTypeHelper.isAxeLikeWeapon(playerItem) || WeaponTypeHelper.isBowLikeWeapon(playerItem) || WeaponTypeHelper.isLanceLikeWeapon(playerItem) || WeaponTypeHelper.isPikeLikeWeapon(playerItem);
                if (isWeaponItem && (currentTime = System.currentTimeMillis()) - this.lastWeaponReplaceTime < 1000L) {
                    return false;
                }
                this.method_5673(slotToCheck, playerItem.method_7972());
                player2.method_6122(class_1268.field_5808, class_1799.field_8037);
                if (!entityItem.method_7960()) {
                    player2.method_6122(class_1268.field_5808, entityItem);
                }
                itemReplaced = true;
                if (isWeaponItem) {
                    long currentTime2;
                    this.lastWeaponReplaceTime = currentTime2 = System.currentTimeMillis();
                }
            }
            if (playerItem.method_7909() instanceof class_4059 && this instanceof HywHorseEntity) {
                entityItem = ((HywHorseEntity)this).getHorseArmor();
                ((HywHorseEntity)this).setHorseArmor(playerItem.method_7972());
                player2.method_6122(class_1268.field_5808, class_1799.field_8037);
                if (!entityItem.method_7960()) {
                    player2.method_6122(class_1268.field_5808, entityItem);
                }
                itemReplaced = true;
            }
            return false;
        }
        if (source.method_5529() != null) {
            int damageCount;
            class_1676 projectile4;
            class_1297 sourceEntity = source.method_5529();
            UUID attackerOwnerUUID = null;
            if (sourceEntity instanceof class_1657) {
                class_1657 player3 = (class_1657)sourceEntity;
                attackerOwnerUUID = player3.method_5667();
            } else if (sourceEntity instanceof BaseCombatEntity) {
                BaseCombatEntity baseCombatEntity = (BaseCombatEntity)sourceEntity;
                attackerOwnerUUID = baseCombatEntity.getOwnerUUID();
            } else if (sourceEntity instanceof class_1676 && (projectile4 = (class_1676)sourceEntity).method_24921() instanceof class_1309) {
                owner = projectile4.method_24921();
                if (owner instanceof class_1657) {
                    player = (class_1657)owner;
                    attackerOwnerUUID = player.method_5667();
                } else if (owner instanceof BaseCombatEntity) {
                    BaseCombatEntity baseCombatEntity = (BaseCombatEntity)((Object)owner);
                    attackerOwnerUUID = baseCombatEntity.getOwnerUUID();
                }
            }
            UUID victimOwnerUUID = this.getOwnerUUID();
            if (attackerOwnerUUID != null && victimOwnerUUID != null && !attackerOwnerUUID.equals(victimOwnerUUID) && ServerRelationHelper.isNeutralRelation((class_1297)this, sourceEntity) && (damageCount = RelationSystem.recordDamage(attackerOwnerUUID, victimOwnerUUID)) >= 3) {
                RelationSystem.setRelation(victimOwnerUUID, attackerOwnerUUID, RelationSystem.RelationType.HOSTILE);
                System.out.println("\u56e0\u591a\u6b21\u53d7\u5230\u653b\u51fb\uff0c" + victimOwnerUUID + " \u73b0\u5728\u5bf9 " + attackerOwnerUUID + " \u662f\u654c\u5bf9\u5173\u7cfb");
            }
        }
        class_1657 attackingPlayer = null;
        class_1297 directEntity = source.method_5526();
        if (directEntity instanceof class_1657) {
            attackingPlayer = (class_1657)directEntity;
        } else if (directEntity instanceof class_1676 && (projectile3 = (class_1676)directEntity).method_24921() instanceof class_1657) {
            attackingPlayer = (class_1657)projectile3.method_24921();
        }
        if (attackingPlayer != null && !attackingPlayer.method_7337() && (ServerRelationHelper.hasControlOver(attackingPlayer, (class_1297)this) || ServerRelationHelper.isFriendlyRelation((class_1297)attackingPlayer, (class_1297)this))) {
            amount *= (float)ServerModConfig.INSTANCE.getPlayerFriendlyFireDamageMultiplier();
        }
        BaseCombatEntity attacker = null;
        if (directEntity instanceof BaseCombatEntity) {
            attacker = (BaseCombatEntity)directEntity;
        } else if (directEntity instanceof class_1676 && (projectile2 = (class_1676)directEntity).method_24921() instanceof BaseCombatEntity) {
            attacker = (BaseCombatEntity)projectile2.method_24921();
        }
        if (attacker != null) {
            double damageModifier = this.calculateDamageModifier(attacker, this);
            amount *= (float)damageModifier;
        }
        boolean isDefenderMelee = !(this instanceof class_1603) || (owner = this) instanceof MeleeCapableRangedAttacker && !(meleeCapable = (MeleeCapableRangedAttacker)owner).isUsingRanged();
        boolean isAttackerMelee = false;
        player = source.method_5526();
        if (player instanceof BaseCombatEntity) {
            BaseCombatEntity baseCombatEntity = (BaseCombatEntity)player;
            boolean bl = isAttackerMelee = !(baseCombatEntity instanceof class_1603) || baseCombatEntity instanceof MeleeCapableRangedAttacker && !(attackerMeleeCapable = (MeleeCapableRangedAttacker)((Object)baseCombatEntity)).isUsingRanged();
        }
        if (isDefenderMelee && isAttackerMelee) {
            amount *= 0.5f;
        }
        if (this instanceof class_1603 && (attackerMeleeCapable = source.method_5526()) instanceof class_1676 && (projectile = (class_1676)attackerMeleeCapable).method_24921() instanceof BaseCombatEntity) {
            amount *= 1.0f;
        }
        if (source.method_5526() instanceof BaseCombatEntity || (attackerMeleeCapable = source.method_5526()) instanceof class_1676 && (projectile = (class_1676)attackerMeleeCapable).method_24921() instanceof BaseCombatEntity) {
            amount *= 0.5f;
        }
        if (this.method_5854() != null && this.method_5854() instanceof BaseCombatEntity) {
            amount *= 0.8f;
        }
        if (this instanceof SiegeUnit && source.method_5526() instanceof class_1676) {
            amount *= 0.5f;
        } else if (this instanceof SiegeUnit) {
            amount *= 1.5f;
        }
        if (ServerModConfig.INSTANCE.isEnableRecruitBalance() && this.method_6059(class_1294.field_5911) && this.summonWeaknessTimer > 0) {
            int weaknessLevel = this.method_6112(class_1294.field_5911).method_5578() + 1;
            float damageMultiplier = RecruitBalanceConfig.getWeaknessDamageMultiplier(weaknessLevel);
            amount *= damageMultiplier;
        }
        return super.method_5643(source, amount);
    }

    private double calculateDamageModifier(BaseCombatEntity attacker, BaseCombatEntity defender) {
        double modifier = 1.0;
        boolean defenderIsLight = defender instanceof LightUnit;
        boolean defenderIsHeavy = defender instanceof HeavyUnit;
        boolean defenderIsCavalry = defender instanceof CavalryUnit;
        boolean defenderIsRanged = defender instanceof RangedUnit;
        boolean defenderIsSiege = defender instanceof SiegeUnit;
        if (defenderIsLight && attacker instanceof CounterLight) {
            CounterLight counterLight = (CounterLight)((Object)attacker);
            modifier *= counterLight.getLightDamageModifier();
        } else if (defenderIsLight && attacker instanceof CounterHeavy) {
            CounterHeavy counterHeavy = (CounterHeavy)((Object)attacker);
            modifier *= counterHeavy.getLightDamageModifier();
        }
        if (defenderIsHeavy && attacker instanceof CounterHeavy) {
            CounterHeavy counterHeavy = (CounterHeavy)((Object)attacker);
            modifier *= counterHeavy.getHeavyDamageModifier();
        } else if (defenderIsHeavy && attacker instanceof CounterLight) {
            CounterLight counterLight = (CounterLight)((Object)attacker);
            modifier *= counterLight.getHeavyDamageModifier();
        }
        if (defenderIsCavalry && attacker instanceof CounterCavalry) {
            CounterCavalry counterCavalry = (CounterCavalry)((Object)attacker);
            modifier *= counterCavalry.getCavalryDamageModifier();
        }
        if (defenderIsRanged && attacker instanceof CounterRanged) {
            CounterRanged counterRanged = (CounterRanged)((Object)attacker);
            modifier *= counterRanged.getRangedDamageModifier();
        }
        if (defenderIsSiege && attacker instanceof CounterSiege) {
            CounterSiege counterSiege = (CounterSiege)((Object)attacker);
            modifier *= counterSiege.getSiegeDamageModifier();
        }
        return modifier;
    }

    protected class_1304 determineEquipmentSlot(class_1799 item) {
        if (item.method_7909() instanceof class_1819) {
            return class_1304.field_6171;
        }
        if (item.method_7909() instanceof class_1738) {
            return ((class_1738)item.method_7909()).method_7685();
        }
        if (item.method_7909() instanceof class_1811 || item.method_7909() instanceof class_1829 || item.method_7909() instanceof class_1743) {
            return class_1304.field_6173;
        }
        return class_1304.field_6173;
    }

    private boolean isSameItemType(class_1799 item1, class_1799 item2) {
        if (item1.method_7960() || item2.method_7960()) {
            return false;
        }
        if (WeaponTypeHelper.isSameWeaponType(item1, item2)) {
            return true;
        }
        if (item1.method_7909() instanceof class_1738 && item2.method_7909() instanceof class_1738) {
            return ((class_1738)item1.method_7909()).method_48398().method_48399() == ((class_1738)item2.method_7909()).method_48398().method_48399();
        }
        return false;
    }

    private void spawnParticles(class_1937 world, double x, double y, double z) {
        int particleCount = 40;
        if (world instanceof class_3218) {
            class_3218 serverLevel = (class_3218)world;
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = (world.field_9229.method_43058() - 0.5) * 1.0;
                double offsetY = world.field_9229.method_43058() * 0.5 + 0.5;
                double offsetZ = (world.field_9229.method_43058() - 0.5) * 1.0;
                serverLevel.method_14199((class_2394)class_2398.field_11204, x, y + 0.5, z, 1, offsetX, offsetY, offsetZ, 0.0);
            }
        }
    }

    public void method_5716(class_1297 killedEntity, int score, class_1282 damageSource) {
        class_1309 target;
        super.method_5716(killedEntity, score, damageSource);
        if (killedEntity instanceof class_1309 && this.isValidTarget(target = (class_1309)killedEntity)) {
            if (ExpBlacklistManager.isInExpBlacklist(target)) {
                return;
            }
            int xpGained = (int)((class_1309)killedEntity).method_6063();
            class_3222 owner = this.getOwner();
            if (owner != null) {
                owner.method_7255(xpGained / 6);
            }
            this.incrementKillCount();
            this.addExperience(xpGained);
        }
    }

    public int method_6110() {
        return (int)(this.method_6063() / 3.0f);
    }

    public void addExperience(int amount) {
        if (this instanceof IPuppet) {
            return;
        }
        int newXP = this.getExperiencePoints() + amount;
        this.setExperiencePoints(newXP);
        this.checkLevelUp();
    }

    private void checkLevelUp() {
        while (this.getExperiencePoints() >= this.getXpThresholdForNextLevel() && this.getLevel() < ServerModConfig.INSTANCE.getSoldierLevelCap()) {
            this.levelUp();
        }
    }

    private int getXpThresholdForNextLevel() {
        return this.getLevel() * 20;
    }

    public void levelUp() {
        this.setExperiencePoints(this.getExperiencePoints() - this.getXpThresholdForNextLevel());
        this.setLevel(this.getLevel() + 1);
        this.increaseStatsOnLevelUp();
    }

    protected void increaseStatsOnLevelUp() {
        class_1324 attackDamage;
        class_1324 maxHealth = this.method_5996(class_5134.field_23716);
        if (maxHealth != null) {
            maxHealth.method_6192(maxHealth.method_6201() + 1.0);
            this.method_6025(1.0f);
        }
        if ((attackDamage = this.method_5996(class_5134.field_23721)) != null) {
            attackDamage.method_6192(attackDamage.method_6201() + 0.25);
        }
    }

    public int getAttackAnimationTime() {
        return this.attackAnimationTime;
    }

    public void setAttackAnimationTime(int attackAnimationTime) {
        this.attackAnimationTime = attackAnimationTime;
    }

    public int getAttackDamageTick() {
        return this.attackDamageTick;
    }

    public void setAttackDamageTick(int attackDamageTick) {
        this.attackDamageTick = attackDamageTick;
    }

    public boolean isAttacking() {
        return this.isAttacking;
    }

    public void setAttacking(boolean attacking) {
        this.isAttacking = attacking;
    }

    public double getDesiredDistance() {
        return this.desiredDistance;
    }

    public void setDesiredDistance(double desiredDistance) {
        this.desiredDistance = desiredDistance;
    }

    public double getArrivalThreshold() {
        return 0.2;
    }

    public int getEquipmentLevel() {
        return this.equipmentLevel;
    }

    public void setEquipmentLevel(int equipmentLevel) {
        this.equipmentLevel = equipmentLevel;
    }

    public void method_5697(class_1297 entity) {
        double e;
        double d;
        double f;
        if (this.method_5765() || entity.method_5765()) {
            return;
        }
        if (entity instanceof BaseCombatEntity) {
            return;
        }
        if (!this.method_5794(entity) && !entity.field_5960 && !this.field_5960 && (f = class_3532.method_15391((double)(d = entity.method_23317() - this.method_23317()), (double)(e = entity.method_23321() - this.method_23321()))) >= (double)0.01f) {
            f = Math.sqrt(f);
            d /= f;
            e /= f;
            double g = 1.0 / f;
            if (g > 1.0) {
                g = 1.0;
            }
            d *= g;
            e *= g;
            d *= (double)0.05f;
            e *= (double)0.05f;
            if (this.method_5810()) {
                this.method_5762(-d, 0.0, -e);
            }
            if (entity.method_5810()) {
                entity.method_5762(d, 0.0, e);
            }
        }
    }

    public boolean method_5810() {
        return true;
    }

    public void method_6078(class_1282 damageSource) {
        class_1297 class_12972;
        if (damageSource.method_5529() != null) {
            class_1676 projectile;
            class_1297 sourceEntity = damageSource.method_5529();
            UUID attackerOwnerUUID = null;
            if (sourceEntity instanceof class_1657) {
                class_1657 player = (class_1657)sourceEntity;
                attackerOwnerUUID = player.method_5667();
            } else if (sourceEntity instanceof BaseCombatEntity) {
                BaseCombatEntity baseCombatEntity = (BaseCombatEntity)sourceEntity;
                attackerOwnerUUID = baseCombatEntity.getOwnerUUID();
            } else if (sourceEntity instanceof class_1676 && (projectile = (class_1676)sourceEntity).method_24921() instanceof class_1309) {
                class_1297 owner = projectile.method_24921();
                if (owner instanceof class_1657) {
                    class_1657 player = (class_1657)owner;
                    attackerOwnerUUID = player.method_5667();
                } else if (owner instanceof BaseCombatEntity) {
                    BaseCombatEntity baseCombatEntity = (BaseCombatEntity)owner;
                    attackerOwnerUUID = baseCombatEntity.getOwnerUUID();
                }
            }
            UUID victimOwnerUUID = this.getOwnerUUID();
            if (attackerOwnerUUID != null && victimOwnerUUID != null && !attackerOwnerUUID.equals(victimOwnerUUID) && ServerRelationHelper.isNeutralRelation((class_1297)this, sourceEntity)) {
                RelationSystem.setRelation(victimOwnerUUID, attackerOwnerUUID, RelationSystem.RelationType.HOSTILE);
                System.out.println("\u56e0\u88ab\u6740\u6b7b\uff0c" + victimOwnerUUID + " \u73b0\u5728\u5bf9 " + attackerOwnerUUID + " \u662f\u654c\u5bf9\u5173\u7cfb");
            }
        }
        if (this.method_5854() != null && (class_12972 = this.method_5854()) instanceof BaseCombatEntity) {
            BaseCombatEntity vehicle = (BaseCombatEntity)class_12972;
            this.method_5848();
            vehicle.method_5768();
        }
        super.method_6078(damageSource);
    }

    public boolean isObstructed(class_1309 target) {
        class_243 startPos = this.method_33571();
        class_243 endPos = target.method_33571();
        class_3965 blockHitResult = this.method_37908().method_17742(new class_3959(startPos, endPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
        if (blockHitResult.method_17783() != class_239.class_240.field_1333) {
            return true;
        }
        class_238 boundingBox = new class_238(startPos, endPos);
        List entities = this.method_37908().method_8333((class_1297)this, boundingBox, entity -> !entity.method_7325() && entity.method_5863() && entity != this && entity != target);
        for (class_1297 entity2 : entities) {
            Optional optionalHit = entity2.method_5829().method_992(startPos, endPos);
            if (!optionalHit.isPresent() || !(entity2 instanceof BaseCombatEntity) || ServerRelationHelper.isEnemyRelation((class_1297)this, (class_1297)((BaseCombatEntity)entity2))) continue;
            return true;
        }
        return false;
    }

    public class_1309 getHywTarget() {
        return this.hywTarget;
    }

    public void setHywTarget(class_1309 hywTarget) {
        if (this.hywTarget != hywTarget) {
            if (BetterMobCombatIntegration.isActivated() && BetterMobCombatIntegration.isBetterCombatWeapon(this.method_6047())) {
                BetterMobCombatIntegration.resetComboCount(this);
            } else {
                this.comboCount = 0;
            }
        }
        this.hywTarget = hywTarget;
    }

    public void resetTargetTick() {
        this.targetResetTick = 10;
    }

    public int getTargetResetTick() {
        return this.targetResetTick;
    }

    public boolean isForceAttackTarget() {
        return this.forceAttackTarget;
    }

    public void setForceAttackTarget(boolean forceAttackTarget) {
        this.forceAttackTarget = forceAttackTarget;
    }

    public void checkAndUpdateTarget() {
        if (this.forceAttackTarget) {
            return;
        }
        if (this.method_5968() != null && this.hywTarget != null && this.targetResetTick > 0) {
            --this.targetResetTick;
        } else if (this.hywTarget != null) {
            class_1309 nearestTarget = this.findNearestTarget();
            if (nearestTarget != null && !nearestTarget.equals((Object)this.hywTarget)) {
                this.setHywTarget(nearestTarget);
            }
            if (!this.isValidTarget(this.hywTarget)) {
                this.setHywTarget(null);
            }
            this.targetResetTick = 10;
        }
    }

    private class_1309 findNearestTarget() {
        class_4051 conditions = this.createTargetingConditions();
        List list = ((EntityAccessor)((Object)this)).getLevel().method_18466(class_1309.class, conditions, (class_1309)this, this.method_5829().method_1014(this.method_26825(class_5134.field_23717)));
        class_1309 nearestTarget = null;
        double nearestDistanceSq = Double.MAX_VALUE;
        for (class_1309 entity : list) {
            double distanceSq = this.method_5858((class_1297)entity);
            if (!(distanceSq < nearestDistanceSq)) continue;
            nearestDistanceSq = distanceSq;
            nearestTarget = entity;
        }
        return nearestTarget;
    }

    private class_4051 createTargetingConditions() {
        return class_4051.method_36625().method_18418(this.method_26825(class_5134.field_23717)).method_18420(target -> target.method_5805() && this.isValidTarget((class_1309)target));
    }

    public boolean canFireAtTarget(class_1309 target) {
        return true;
    }

    public void method_6007() {
        super.method_6007();
        this.method_6119();
    }

    public void method_6099(class_1282 damageSource, int looting, boolean hitByPlayer) {
    }

    protected void method_16078() {
        HywHorseEntity horseEntity;
        class_1799 horseArmor;
        class_1304[] equipmentSlots;
        if (!ServerModConfig.INSTANCE.isAllowEquipmentDrop()) {
            return;
        }
        for (class_1304 slot : equipmentSlots = new class_1304[]{class_1304.field_6173, class_1304.field_6171, class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166}) {
            class_1799 itemStack = this.method_6118(slot);
            if (itemStack.method_7960()) continue;
            this.method_5775(itemStack);
            this.method_5673(slot, class_1799.field_8037);
        }
        BaseCombatEntity baseCombatEntity = this;
        if (baseCombatEntity instanceof HywHorseEntity && !(horseArmor = (horseEntity = (HywHorseEntity)baseCombatEntity).getHorseArmor()).method_7960()) {
            this.method_5775(horseArmor);
            horseEntity.setHorseArmor(class_1799.field_8037);
        }
    }

    public List<Action> getActions() {
        return this.actions;
    }

    protected void initActions() {
        this.initDefaultActions();
        this.initCustomActions();
    }

    protected void initDefaultActions() {
        this.actions.add(new AttackAction());
        this.actions.add(new HoldAction());
        this.actions.add(new CancelAction());
        this.actions.add(new PatrolAction());
    }

    protected void initCustomActions() {
    }

    public PrioritizedGoal getCurrentCommandedGoal() {
        return this.currentCommandedGoal;
    }

    public int getKillCount() {
        return (Integer)this.field_6011.method_12789(KILL_COUNT);
    }

    public void setKillCount(int killCount) {
        this.field_6011.method_12778(KILL_COUNT, (Object)killCount);
    }

    public void incrementKillCount() {
        this.setKillCount(this.getKillCount() + 1);
    }

    protected void setAttributeBaseValue(class_1320 attribute, double value) {
        class_1324 attr = this.method_5996(attribute);
        if (attr != null) {
            attr.method_6192(value);
        }
    }

    private void handleTimeBasedRecovery(class_2487 compound) {
        if (this.unloadTime <= 0L) {
            return;
        }
        MinecraftServer server = this.method_37908().method_8503();
        if (server == null) {
            return;
        }
        WorldTickCounter counter = WorldTickCounter.get(server);
        long currentWorldTicks = counter.getTotalWorldTicks();
        long tickDiff = currentWorldTicks - this.unloadTime;
        if (tickDiff <= 0L) {
            System.out.println("\u8b66\u544a: \u4e16\u754ctick\u8ba1\u6570\u5f02\u5e38\uff0ctickDiff = " + tickDiff);
            return;
        }
        long healTicks = tickDiff / 1200L;
        if (healTicks > 0L) {
            float currentHealth = this.method_6032();
            float maxHealth = this.method_6063();
            float healAmount = Math.min((float)healTicks, maxHealth - currentHealth);
            if (healAmount > 0.0f) {
                this.method_6025(healAmount);
            }
        }
        if (this.summonWeaknessTimer > 0) {
            long newTimer = (long)this.summonWeaknessTimer - tickDiff;
            this.summonWeaknessTimer = (int)Math.max(0L, newTimer);
        }
        this.handleOfflinePotionEffects(tickDiff);
        this.unloadTime = -1L;
    }

    private void handleOfflinePotionEffects(long tickDiff) {
        ArrayList activeEffects = new ArrayList(this.method_6026());
        for (class_1293 effect : activeEffects) {
            int remainingDuration = effect.method_5584();
            if (tickDiff >= (long)remainingDuration) {
                this.method_6016(effect.method_5579());
                continue;
            }
            this.method_6016(effect.method_5579());
            int newDuration = (int)((long)remainingDuration - tickDiff);
            class_1293 newEffect = new class_1293(effect.method_5579(), newDuration, effect.method_5578(), effect.method_5591(), effect.method_5581(), effect.method_5592());
            this.method_6092(newEffect);
        }
    }

    private void manageRotation() {
        if (this instanceof SiegeUnit) {
            this.manageSiegeRotation();
            return;
        }
        if (!this.method_37908().field_9236) {
            double speedThreshold;
            double velocityZ;
            double velocityX;
            double speedSq;
            double attackRangeSq;
            double distanceSq;
            class_1309 target = this.getHywTarget();
            if (target != null && !target.method_31481() && target.method_5805() && !this.shouldMoveOnly() && (distanceSq = this.method_5858((class_1297)target)) <= (attackRangeSq = (double)(this.getAttackReach() * this.getAttackReach())) * 1.5) {
                float effectiveRotationLimit;
                double dx = target.method_23317() - this.method_23317();
                double dz = target.method_23321() - this.method_23321();
                this.targetRot = (float)(class_3532.method_15349((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                float rotationDifference = class_3532.method_15393((float)(this.targetRot - this.currentRot));
                float f = effectiveRotationLimit = distanceSq <= attackRangeSq ? this.getRotationLimit() * 1.5f : this.getRotationLimit();
                if (rotationDifference > effectiveRotationLimit) {
                    rotationDifference = effectiveRotationLimit;
                } else if (rotationDifference < -effectiveRotationLimit) {
                    rotationDifference = -effectiveRotationLimit;
                }
                this.currentRot += rotationDifference;
                this.method_36456(this.currentRot);
                this.method_5636(this.currentRot);
                this.field_6011.method_12778(Y_BODY_ROT, (Object)Float.valueOf(this.currentRot));
                return;
            }
            if (this instanceof HywHorseEntity && (speedSq = (velocityX = this.method_18798().field_1352) * velocityX + (velocityZ = this.method_18798().field_1350) * velocityZ) > (speedThreshold = 1.0E-4)) {
                float currentRotationLimit;
                this.targetRot = (float)(class_3532.method_15349((double)velocityZ, (double)velocityX) * 57.29577951308232) - 90.0f;
                float rotationDifference = class_3532.method_15393((float)(this.targetRot - this.currentRot));
                if (rotationDifference > (currentRotationLimit = this.getRotationLimit())) {
                    rotationDifference = currentRotationLimit;
                } else if (rotationDifference < -currentRotationLimit) {
                    rotationDifference = -currentRotationLimit;
                }
                this.currentRot += rotationDifference;
                this.method_36456(this.currentRot);
                this.method_5636(this.currentRot);
            }
            this.field_6011.method_12778(Y_BODY_ROT, (Object)Float.valueOf(this.currentRot));
        }
    }

    public float getCurrentRot() {
        return this.currentRot;
    }

    public float getTargetRot() {
        return this.targetRot;
    }

    public float getRotationLimit() {
        return this.rotationLimit;
    }

    public boolean shouldMoveOnly() {
        if (this.getCurrentCommandedGoal() != null && this.getCurrentCommandedGoal().goal instanceof MoveGoal && this.getCurrentCommandedGoal().priority == 1) {
            return true;
        }
        return this.field_6201.method_35115().stream().anyMatch(pair -> pair.method_19058() instanceof FollowEntityGoal && pair.method_19056());
    }

    protected void manageSiegeRotation() {
        if (!this.method_37908().field_9236) {
            double velocityX = this.method_18798().field_1352;
            double velocityZ = this.method_18798().field_1350;
            double speedSq = velocityX * velocityX + velocityZ * velocityZ;
            double speedThreshold = 1.0E-4;
            if (speedSq > speedThreshold) {
                float rotLimit;
                this.targetRot = (float)(class_3532.method_15349((double)velocityZ, (double)velocityX) * 57.29577951308232) - 90.0f;
                float rotationDifference = class_3532.method_15393((float)(this.targetRot - this.currentRot));
                if (rotationDifference > (rotLimit = this.getRotationLimit())) {
                    rotationDifference = rotLimit;
                } else if (rotationDifference < -rotLimit) {
                    rotationDifference = -rotLimit;
                }
                this.currentRot += rotationDifference;
            } else {
                class_243 targetPosition = this.getSiegeTargetPosition();
                if (targetPosition != null) {
                    float rotLimit;
                    double targetX = targetPosition.field_1352 - this.method_23317();
                    double targetZ = targetPosition.field_1350 - this.method_23321();
                    this.targetRot = (float)(class_3532.method_15349((double)targetZ, (double)targetX) * 57.29577951308232) - 90.0f;
                    float rotationDifference = class_3532.method_15393((float)(this.targetRot - this.currentRot));
                    if (rotationDifference > (rotLimit = this.getRotationLimit())) {
                        rotationDifference = rotLimit;
                    } else if (rotationDifference < -rotLimit) {
                        rotationDifference = -rotLimit;
                    }
                    this.currentRot += rotationDifference;
                } else {
                    this.targetRot = this.currentRot;
                }
            }
            this.field_6011.method_12778(Y_BODY_ROT, (Object)Float.valueOf(this.currentRot));
        } else {
            this.field_6283 = ((Float)this.field_6011.method_12789(Y_BODY_ROT)).floatValue();
        }
    }

    public float getTrueYBodyRot() {
        return ((Float)this.field_6011.method_12789(Y_BODY_ROT)).floatValue();
    }

    protected class_243 getSiegeTargetPosition() {
        PositionAttackable positionAttackable;
        BaseCombatEntity baseCombatEntity = this;
        if (baseCombatEntity instanceof PositionAttackable && (positionAttackable = (PositionAttackable)((Object)baseCombatEntity)).hasPositionTarget()) {
            return positionAttackable.getPositionTarget();
        }
        if (this.getHywTarget() != null) {
            return new class_243(this.getHywTarget().method_23317(), this.getHywTarget().method_23318(), this.getHywTarget().method_23321());
        }
        return null;
    }
}

