/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.entity.entities;

import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1324;
import net.minecraft.class_1603;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2675;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import ydmsama.hundred_years_war.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.entity.entities.UseCrossbow;
import ydmsama.hundred_years_war.entity.entities.projectile.BulletEntity;
import ydmsama.hundred_years_war.entity.entities.tags.CounterCavalry;
import ydmsama.hundred_years_war.entity.entities.tags.CounterHeavy;
import ydmsama.hundred_years_war.entity.entities.tags.LightUnit;
import ydmsama.hundred_years_war.entity.entities.tags.RangedUnit;
import ydmsama.hundred_years_war.registry.HywAttributes;
import ydmsama.hundred_years_war.registry.HywEntityRegistry;
import ydmsama.hundred_years_war.registry.HywItemRegistry;

public class HandgonneManEntity
extends BaseCombatEntity
implements class_1603,
UseCrossbow,
LightUnit,
RangedUnit,
CounterHeavy,
CounterCavalry {
    private static final float ATTACK_REACH = 80.0f;
    private static final float MOVEMENT_SPEED = 0.3f;
    private static final float BASE_RANGED_ATTACK_DAMAGE = 1.5f;
    private static final class_2940<Integer> USE_ANGLE = class_2945.method_12791(HandgonneManEntity.class, (class_2941)class_2943.field_13327);

    public HandgonneManEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.method_49477(1.0f);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(USE_ANGLE, (Object)1);
    }

    public static class_5132.class_5133 createHandgonneManAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23717, 80.0).method_26868(class_5134.field_23719, (double)0.3f).method_26868(class_5134.field_23721, 8.0).method_26868(class_5134.field_23724, 2.0).method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23718, 0.0).method_26868(HywAttributes.ATTACK_REACH, 80.0).method_26868(HywAttributes.RANGED_ATTACK_DAMAGE, 1.5);
    }

    @Override
    public void method_5773() {
        super.method_5773();
    }

    @Override
    protected void setDefaultEquipment() {
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)HywItemRegistry.HANDGONNE));
        this.method_5673(class_1304.field_6171, class_1799.field_8037);
        this.method_5673(class_1304.field_6169, new class_1799((class_1935)class_1802.field_8283));
        this.method_5673(class_1304.field_6174, new class_1799((class_1935)class_1802.field_8873));
        this.method_5673(class_1304.field_6172, new class_1799((class_1935)class_1802.field_8218));
        this.method_5673(class_1304.field_6166, new class_1799((class_1935)class_1802.field_8313));
    }

    @Override
    public int getBaseAttackAnimationTime() {
        int baseCooldown = 20;
        return baseCooldown;
    }

    @Override
    public int getAttackDamageTickDelay() {
        Random random = new Random();
        return Math.max(this.getBaseAttackAnimationTime() - random.nextInt(15), 5);
    }

    @Override
    public int getAttackCoolDownDuration() {
        Random random = new Random();
        return 70 + random.nextInt(30);
    }

    public void method_7105(class_1309 target, float pullProgress) {
        float speed = 10.0f;
        float inaccuracy = 5.0f;
        BulletEntity bulletEntity = new BulletEntity(HywEntityRegistry.BULLET, (class_1309)this, this.method_37908());
        bulletEntity.method_7438(this.method_26825(HywAttributes.RANGED_ATTACK_DAMAGE));
        double dx = target.method_23317() - this.method_23317();
        double dz = target.method_23321() - this.method_23321();
        double dy = target.method_23323(0.5) - bulletEntity.method_23318();
        double distance = Math.sqrt(dx * dx + dz * dz + dy * dy);
        if (distance == 0.0) {
            return;
        }
        double gravity = 0.05;
        double[] angles = this.calculateLaunchAngles(speed, gravity, distance, dy);
        if (!(!Double.isNaN(angles[1]) && this.isPathClear((class_1297)bulletEntity, angles[1], speed, dx, dy, dz, distance, target) || distance < 5.0)) {
            return;
        }
        double angle = angles[1];
        double randomSpeedOffset = HandgonneManEntity.getRandomInRange(-0.25, 0.75);
        double timeToTarget = distance / (((double)speed - randomSpeedOffset) * Math.cos(angle));
        double targetVelocityX = target.method_18798().method_10216();
        double targetVelocityZ = target.method_18798().method_10215();
        double predictedX = target.method_23317() + targetVelocityX * timeToTarget;
        double predictedZ = target.method_23321() + targetVelocityZ * timeToTarget;
        double predictedDistance = Math.sqrt((predictedX - this.method_23317()) * (predictedX - this.method_23317()) + (predictedZ - this.method_23321()) * (predictedZ - this.method_23321()));
        angles = this.calculateLaunchAngles(speed, gravity, predictedDistance, dy);
        angle = angles[1];
        double yaw = Math.atan2(predictedZ - this.method_23321(), predictedX - this.method_23317());
        double horizontalSpeed = Math.cos(angle) * (double)speed;
        float velocityX = (float)(horizontalSpeed * Math.cos(yaw));
        float velocityY = (float)(Math.sin(angle) * (double)speed);
        float velocityZ = (float)(horizontalSpeed * Math.sin(yaw));
        bulletEntity.method_7485(velocityX, velocityY, velocityZ, speed, inaccuracy);
        this.method_37908().method_8649((class_1297)bulletEntity);
        float randomPitch = 1.3f + (float)HandgonneManEntity.getRandomInRange(0.0, 0.5);
        this.method_5783(class_3417.field_15152, 10.0f, randomPitch);
        this.method_6021();
        if (this.method_37908() instanceof class_3218) {
            double dirX = Math.cos(yaw);
            double dirZ = Math.sin(yaw);
            double eyeX = this.method_23317();
            double eyeY = this.method_23318() + (double)this.method_5751() - 0.15;
            double eyeZ = this.method_23321();
            this.spawnParticles(this.method_37908(), eyeX + dirX * 1.5, eyeY + Math.sin(angle) * 1.5, eyeZ + dirZ * 1.5);
        }
    }

    private void spawnParticles(class_1937 world, double x, double y, double z) {
        if (world instanceof class_3218) {
            class_3218 serverLevel = (class_3218)world;
            this.sendParticlesToAllNearby(serverLevel, class_2398.field_11251, x, y, z, 20, 0.1, 0.1, 0.1, 0.02);
            this.sendParticlesToAllNearby(serverLevel, class_2398.field_11240, x, y, z, 5, 0.1, 0.1, 0.1, 0.2);
        }
    }

    public <T extends class_2394> int sendParticlesToAllNearby(class_3218 serverLevel, T particleOptions, double x, double y, double z, int count, double xOffset, double yOffset, double zOffset, double speed) {
        class_2675 packet = new class_2675(particleOptions, true, x, y, z, (float)xOffset, (float)yOffset, (float)zOffset, (float)speed, count);
        int sentCount = 0;
        for (class_3222 serverPlayer : serverLevel.method_18456()) {
            if (!this.sendParticlesToPlayer(serverLevel, serverPlayer, x, y, z, (class_2596<?>)packet)) continue;
            ++sentCount;
        }
        return sentCount;
    }

    private boolean sendParticlesToPlayer(class_3218 serverLevel, class_3222 serverPlayer, double x, double y, double z, class_2596<?> packet) {
        if (serverPlayer.method_37908() != serverLevel) {
            return false;
        }
        double distanceSquared = serverPlayer.method_19538().method_1025(new class_243(x, y, z));
        if (distanceSquared < 262144.0) {
            serverPlayer.field_13987.method_14364(packet);
            return true;
        }
        return false;
    }

    private boolean isPathClear(class_1297 entity, double angle, float speed, double dx, double dy, double dz, double distance, class_1309 target) {
        return true;
    }

    private double[] calculateLaunchAngles(double speed, double gravity, double distance, double heightDifference) {
        double speedSquared = speed * speed;
        double horizontalDistanceSquared = distance * distance;
        double heightDifferenceSquared = heightDifference * heightDifference;
        double discriminant = speedSquared * speedSquared - gravity * (gravity * horizontalDistanceSquared + 2.0 * heightDifference * speedSquared);
        if (discriminant < 0.0) {
            return new double[]{Double.NaN, Double.NaN};
        }
        double discriminantSqrt = Math.sqrt(discriminant);
        double term1 = Math.atan((speedSquared + discriminantSqrt) / (gravity * distance));
        double term2 = Math.atan((speedSquared - discriminantSqrt) / (gravity * distance));
        return new double[]{term1, term2};
    }

    public static double getRandomInRange(double min, double max) {
        return min + Math.random() * (max - min);
    }

    @Override
    protected class_1792 getScrollType() {
        return switch (this.getEquipmentLevel()) {
            case 1 -> HywItemRegistry.SCROLL_HANDGONNE_MAN;
            case 2 -> HywItemRegistry.SCROLL_HANDGONNE_MAN_1;
            default -> null;
        };
    }

    @Override
    protected void increaseStatsOnLevelUp() {
        super.increaseStatsOnLevelUp();
        class_1324 rangedAttackDamage = this.method_5996(HywAttributes.RANGED_ATTACK_DAMAGE);
        if (rangedAttackDamage != null) {
            rangedAttackDamage.method_6192(rangedAttackDamage.method_6201() + 0.1);
        }
    }

    @Override
    public boolean isValidTarget(class_1309 potentialTarget) {
        if (this.isObstructed(potentialTarget)) {
            return false;
        }
        return super.isValidTarget(potentialTarget);
    }

    @Override
    public boolean canFireAtTarget(class_1309 target) {
        if (this.isObstructed(target)) {
            return false;
        }
        return super.canFireAtTarget(target);
    }

    @Override
    public double getLightDamageModifier() {
        return 1.0;
    }

    @Override
    public double getHeavyDamageModifier() {
        return 1.5;
    }

    @Override
    public double getCavalryDamageModifier() {
        return 1.5;
    }
}

