/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.entity.entities;

import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_4059;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import ydmsama.hundred_years_war.config.ServerModConfig;
import ydmsama.hundred_years_war.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.entity.entities.mounted.NpcHorse;
import ydmsama.hundred_years_war.entity.goals.MoveGoal;
import ydmsama.hundred_years_war.entity.utils.Rideable;
import ydmsama.hundred_years_war.entity.utils.json.EquipmentLevelData;
import ydmsama.hundred_years_war.entity.utils.json.EquipmentOption;
import ydmsama.hundred_years_war.item.BaseScrollItem;
import ydmsama.hundred_years_war.registry.HywAttributes;
import ydmsama.hundred_years_war.registry.HywItemRegistry;
import ydmsama.hundred_years_war.utils.ServerRelationHelper;

public class HywHorseEntity
extends BaseCombatEntity
implements Rideable {
    protected float MOVEMENT_SPEED = 0.38f;
    private static final class_2940<class_1799> HORSE_ARMOR = class_2945.method_12791(HywHorseEntity.class, (class_2941)class_2943.field_13322);
    private static final UUID ATTACK_MODIFIER_UUID = UUID.fromString("e8d55f0d-8f97-4c99-86b1-c5cd3b3e9f9f");
    private static final class_1322 ATTACK_MODIFIER = new class_1322(ATTACK_MODIFIER_UUID, "Horse Attack Boost", 0.25, class_1322.class_1323.field_6330);
    private static final class_2940<Boolean> IS_CHARGING = class_2945.method_12791(HywHorseEntity.class, (class_2941)class_2943.field_13323);
    private float currentRot;
    private float targetRot;
    protected float rotationLimit = 20.0f;
    protected float rotationLimitCharge = 5.0f;

    public HywHorseEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.method_49477(1.0f);
        this.setHorseArmor(new class_1799((class_1935)class_1802.field_8560));
    }

    public class_1309 method_5642() {
        return null;
    }

    public static class_5132.class_5133 createHorseAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23717, 30.0).method_26868(class_5134.field_23719, (double)0.38f).method_26868(class_5134.field_23724, 2.0).method_26868(class_5134.field_23716, 40.0).method_26868(class_5134.field_23718, 0.8).method_26868(HywAttributes.ATTACK_REACH, 55.0);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.syncHealthWithPassenger();
    }

    @Override
    public float getCurrentRot() {
        return this.currentRot;
    }

    @Override
    public float getTargetRot() {
        return this.targetRot;
    }

    private void syncHealthWithPassenger() {
        class_1297 class_12972;
        if (!this.method_37908().field_9236 && (class_12972 = this.method_31483()) instanceof class_1309) {
            class_1309 passenger = (class_1309)class_12972;
            float passengerMaxHealth = passenger.method_6063();
            if (this.method_6063() != passengerMaxHealth) {
                this.method_5996(class_5134.field_23716).method_6192((double)passengerMaxHealth);
            }
            float passengerHealth = passenger.method_6032();
            if (this.method_6032() != passengerHealth) {
                this.method_6033(passengerHealth);
            }
        }
    }

    public double method_5621() {
        if (this.method_5685().get(0) instanceof class_1657) {
            return (double)this.method_17682() * 0.9;
        }
        return (double)this.method_17682() * 0.6;
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(HORSE_ARMOR, (Object)class_1799.field_8037);
        this.field_6011.method_12784(IS_CHARGING, (Object)false);
    }

    public class_1799 getHorseArmor() {
        return (class_1799)this.field_6011.method_12789(HORSE_ARMOR);
    }

    public void setHorseArmor(class_1799 horseArmor) {
        this.field_6011.method_12778(HORSE_ARMOR, (Object)horseArmor);
    }

    public boolean isCharging() {
        return (Boolean)this.field_6011.method_12789(IS_CHARGING);
    }

    public void setCharging(boolean charging) {
        this.field_6011.method_12778(IS_CHARGING, (Object)charging);
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        class_2487 armorTag = new class_2487();
        this.getHorseArmor().method_7953(armorTag);
        compound.method_10566("HorseArmor", (class_2520)armorTag);
        compound.method_10548("CurrentRot", this.currentRot);
        compound.method_10548("TargetRot", this.targetRot);
        compound.method_10556("IsCharging", this.isCharging());
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10573("HorseArmor", 10)) {
            this.setHorseArmor(class_1799.method_7915((class_2487)compound.method_10562("HorseArmor")));
        }
        if (compound.method_10545("CurrentRot")) {
            this.currentRot = compound.method_10583("CurrentRot");
        }
        if (compound.method_10545("TargetRot")) {
            this.targetRot = compound.method_10583("TargetRot");
        }
        if (compound.method_10545("IsCharging")) {
            this.setCharging(compound.method_10577("IsCharging"));
        }
    }

    @Override
    protected class_1792 getScrollType() {
        return switch (this.getEquipmentLevel()) {
            case 1 -> HywItemRegistry.SCROLL_HORSE;
            case 2 -> HywItemRegistry.SCROLL_HORSE_1;
            case 3 -> HywItemRegistry.SCROLL_HORSE_2;
            case 4 -> HywItemRegistry.SCROLL_HORSE_3;
            default -> null;
        };
    }

    @Override
    protected void setEquipmentFromLevelData(EquipmentLevelData levelData) {
        super.setEquipmentFromLevelData(levelData);
        EquipmentOption horseArmorOption = this.selectRandomItem(levelData.getHorseArmor());
        class_1799 horseArmorStack = this.createItemStack(horseArmorOption);
        this.setHorseArmor(horseArmorStack);
    }

    @Override
    public int getSkinCounts() {
        return 5;
    }

    @Override
    public float getAttackReach() {
        if (this.method_31483() != null && this.method_31483() instanceof BaseCombatEntity) {
            return ((BaseCombatEntity)this.method_31483()).getAttackReach() * 0.8f;
        }
        return super.getAttackReach();
    }

    @Override
    protected void updateAnimationState() {
        if (!this.field_42108.method_48571()) {
            this.moveAnimationState.method_41325();
            this.attackAnimationState.method_41325();
            if (!this.idleAnimationState.method_41327()) {
                this.idleAnimationState.method_41322(this.field_6012);
            }
        } else {
            this.attackAnimationState.method_41325();
            this.idleAnimationState.method_41325();
            if (!this.moveAnimationState.method_41327()) {
                this.moveAnimationState.method_41322(this.field_6012);
            }
        }
    }

    public int getHorseArmorValue(class_1799 horseArmor) {
        if (horseArmor.method_7960()) {
            return 0;
        }
        class_1792 item = horseArmor.method_7909();
        if (item == class_1802.field_18138) {
            return 6;
        }
        if (item == class_1802.field_8578) {
            return 10;
        }
        if (item == class_1802.field_8560) {
            return 10;
        }
        if (item == class_1802.field_8807) {
            return 16;
        }
        return 2;
    }

    public int method_6096() {
        return this.getHorseArmorValue(this.getHorseArmor());
    }

    public void method_5627(class_1297 passenger) {
        class_1309 livingPassenger;
        class_1324 attackDamageAttribute;
        super.method_5627(passenger);
        if (!this.method_37908().field_9236 && passenger instanceof class_1309 && (attackDamageAttribute = (livingPassenger = (class_1309)passenger).method_5996(class_5134.field_23721)) != null && attackDamageAttribute.method_6199(ATTACK_MODIFIER_UUID) == null) {
            attackDamageAttribute.method_26835(ATTACK_MODIFIER);
        }
    }

    public void method_5793(class_1297 passenger) {
        class_1309 livingPassenger;
        class_1324 attackDamageAttribute;
        if (!this.method_37908().field_9236 && passenger instanceof class_1309 && (attackDamageAttribute = (livingPassenger = (class_1309)passenger).method_5996(class_5134.field_23721)) != null) {
            attackDamageAttribute.method_6200(ATTACK_MODIFIER_UUID);
        }
        super.method_5793(passenger);
    }

    @Override
    public double getDesiredDistance() {
        return 2.5;
    }

    @Override
    public double getArrivalThreshold() {
        return 0.5;
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        class_1297 playerItem;
        class_1657 player;
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657 && (player = (class_1657)class_12972).method_5715() && ServerRelationHelper.hasControlOver(player, (class_1297)this) && ServerModConfig.INSTANCE.isAllowEquipmentChange()) {
            class_1799 horseArmor;
            playerItem = player.method_5998(class_1268.field_5808);
            if (playerItem.method_7960() && !(horseArmor = this.getHorseArmor()).method_7960()) {
                this.method_5775(horseArmor);
                this.setHorseArmor(class_1799.field_8037);
                return false;
            }
            if (playerItem.method_7909() instanceof class_4059) {
                class_1799 entityHorseArmor = this.getHorseArmor();
                this.setHorseArmor(playerItem.method_7972());
                player.method_6122(class_1268.field_5808, class_1799.field_8037);
                if (!entityHorseArmor.method_7960()) {
                    player.method_6122(class_1268.field_5808, entityHorseArmor);
                }
                return false;
            }
        }
        if (!this.method_37908().field_9236 && (playerItem = this.method_31483()) instanceof class_1309) {
            class_1657 player2;
            class_1309 passenger = (class_1309)playerItem;
            class_1297 class_12973 = source.method_5529();
            if (!(class_12973 instanceof class_1657 && (player2 = (class_1657)class_12973).method_5715() && ServerRelationHelper.hasControlOver(player2, (class_1297)this))) {
                passenger.method_5643(source, amount);
                return super.method_5643(source, 0.0f);
            }
        }
        return super.method_5643(source, amount);
    }

    @Override
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (this instanceof NpcHorse) {
            return super.method_5992(player, hand);
        }
        if (!this.method_37908().field_9236 && player.method_5715() && ServerRelationHelper.hasControlOver(player, (class_1297)this)) {
            if (ServerModConfig.INSTANCE.isAllowSoldierRecall() && this.getScrollType() != null) {
                class_1799 stack = new class_1799((class_1935)this.getScrollType());
                class_2487 entityData = new class_2487();
                this.method_5647(entityData);
                ((BaseScrollItem)stack.method_7909()).saveEntityDataToItem(stack, entityData);
                if (!player.method_31548().method_7394(stack)) {
                    player.method_7328(stack, false);
                }
                this.spawnDespawnParticles();
                this.method_31472();
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private void spawnDespawnParticles() {
        int particleCount = 40;
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = (this.method_37908().field_9229.method_43058() - 0.5) * 1.0;
                double offsetY = this.method_37908().field_9229.method_43058() * 0.5 + 0.5;
                double offsetZ = (this.method_37908().field_9229.method_43058() - 0.5) * 1.0;
                serverLevel.method_14199((class_2394)class_2398.field_11204, this.method_23317(), this.method_23318() + 0.5, this.method_23321(), 1, offsetX, offsetY, offsetZ, 0.0);
            }
        }
    }

    public float getMOVEMENT_SPEED() {
        return this.MOVEMENT_SPEED;
    }

    @Override
    public boolean shouldMoveOnly() {
        return this.getCurrentCommandedGoal() != null && this.getCurrentCommandedGoal().goal instanceof MoveGoal && this.getCurrentCommandedGoal().priority == 1;
    }

    @Override
    public float getRotationLimit() {
        if (this.isCharging()) {
            return this.rotationLimitCharge;
        }
        return this.rotationLimit;
    }
}

