/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.entity.entities.mounted;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1314;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_5132;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.config.ServerModConfig;
import ydmsama.hundred_years_war.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.entity.entities.HywHorseEntity;
import ydmsama.hundred_years_war.entity.entities.mounted.NpcHorse;
import ydmsama.hundred_years_war.entity.entities.tags.CavalryUnit;
import ydmsama.hundred_years_war.entity.entities.tags.HeavyUnit;
import ydmsama.hundred_years_war.registry.HywEntityRegistry;
import ydmsama.hundred_years_war.registry.HywItemRegistry;
import ydmsama.hundred_years_war.utils.ServerRelationHelper;

public class MountedLancerHorseEntity
extends HywHorseEntity
implements NpcHorse,
CavalryUnit,
HeavyUnit {
    protected boolean riderSpawned = false;
    protected class_2487 riderData = null;
    protected BaseCombatEntity rider;

    public MountedLancerHorseEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 createMountedLancerHorseAttributes() {
        return HywHorseEntity.createHorseAttributes();
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236 && !this.riderSpawned && this.method_5805()) {
            this.spawnRider();
        }
    }

    protected BaseCombatEntity createRiderEntity() {
        return (BaseCombatEntity)HywEntityRegistry.MOUNTED_LANCER_RIDER.method_5883(this.method_37908());
    }

    protected void spawnRider() {
        this.rider = this.createRiderEntity();
        if (this.rider != null) {
            if (this.riderData != null) {
                this.rider.method_5749(this.riderData);
            } else {
                this.rider.setEquipment(this.getEquipmentLevel());
            }
            this.rider.setOwnerUUID(this.getOwnerUUID());
            this.rider.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
            this.rider.method_5873((class_1297)this, true);
            this.method_37908().method_8649((class_1297)this.rider);
            this.riderSpawned = true;
        }
    }

    protected void saveRiderData() {
        if (this.rider != null && this.rider.method_5805()) {
            this.riderData = new class_2487();
            this.rider.method_5652(this.riderData);
        } else {
            this.riderData = null;
        }
    }

    protected void loadRiderData(class_2487 compound) {
        if (compound.method_10545("RiderData")) {
            this.riderData = compound.method_10562("RiderData");
        }
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        this.saveRiderData();
        compound.method_10556("RiderSpawned", this.riderSpawned);
        if (this.riderData != null) {
            compound.method_10566("RiderData", (class_2520)this.riderData);
        }
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.loadRiderData(compound);
        this.riderSpawned = compound.method_10577("RiderSpawned");
    }

    @Override
    protected class_1792 getScrollType() {
        return switch (this.getEquipmentLevel()) {
            case 1 -> HywItemRegistry.SCROLL_MOUNTED_LANCER;
            case 2 -> HywItemRegistry.SCROLL_MOUNTED_LANCER_1;
            case 3 -> HywItemRegistry.SCROLL_MOUNTED_LANCER_2;
            case 4 -> HywItemRegistry.SCROLL_MOUNTED_LANCER_3;
            default -> null;
        };
    }

    @Override
    @NotNull
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (!this.method_37908().field_9236 && player.method_5715() && hand == class_1268.field_5808 && (ServerRelationHelper.hasControlOver(player, (class_1297)this) || player.method_7337())) {
            class_1792 scrollItemType = this.getScrollType();
            if (scrollItemType == null) {
                return class_1269.field_5811;
            }
            class_1799 scrollItemStack = new class_1799((class_1935)scrollItemType);
            class_2487 entityDataForScroll = new class_2487();
            class_1297 actualRiderPassenger = null;
            for (class_1297 passenger : this.method_5685()) {
                BaseCombatEntity templateRider = this.createRiderEntity();
                if (templateRider == null || !((Object)((Object)templateRider)).getClass().isInstance(passenger) || !passenger.method_5805()) continue;
                actualRiderPassenger = passenger;
                break;
            }
            if (actualRiderPassenger instanceof BaseCombatEntity) {
                this.riderData = new class_2487();
                ((BaseCombatEntity)actualRiderPassenger).method_5652(this.riderData);
                if (this.rider != actualRiderPassenger) {
                    this.rider = (BaseCombatEntity)actualRiderPassenger;
                    this.riderSpawned = true;
                }
            } else {
                this.riderData = null;
                this.rider = null;
                this.riderSpawned = false;
            }
            this.method_5652(entityDataForScroll);
            entityDataForScroll.method_10551("RiderSpawned");
            scrollItemStack.method_7948().method_10566("EntityData", (class_2520)entityDataForScroll);
            if (!player.method_31548().method_7394(scrollItemStack)) {
                player.method_7328(scrollItemStack, false);
            }
            if (actualRiderPassenger != null) {
                actualRiderPassenger.method_31472();
            }
            this.spawnDespawnParticles();
            this.method_31472();
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    protected void spawnDespawnParticles() {
        class_1937 class_19372;
        if (!this.method_37908().field_9236 && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            int particleCount = 40;
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = (this.method_37908().field_9229.method_43058() - 0.5) * 1.0;
                double offsetY = this.method_37908().field_9229.method_43058() * 0.5 + 0.5;
                double offsetZ = (this.method_37908().field_9229.method_43058() - 0.5) * 1.0;
                serverLevel.method_14199((class_2394)class_2398.field_11204, this.method_23317(), this.method_23318() + 0.5, this.method_23321(), 1, offsetX, offsetY, offsetZ, 0.0);
            }
        }
    }

    @Override
    protected String getEquipmentJsonPath() {
        String equipmentFile = ServerModConfig.getCurrentEquipmentFileName();
        return "hundred_years_war:hyw/npc/hyw_horse/" + equipmentFile;
    }
}

