/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.entity.goals;

import java.util.EnumSet;
import java.util.function.Consumer;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import ydmsama.hundred_years_war.entity.entities.ArcherEntity;
import ydmsama.hundred_years_war.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.entity.entities.HywHorseEntity;
import ydmsama.hundred_years_war.entity.entities.tags.SiegeUnit;
import ydmsama.hundred_years_war.entity.goals.MoveGoal;
import ydmsama.hundred_years_war.entity.utils.PathingTask;
import ydmsama.hundred_years_war.entity.utils.PathingTaskManager;
import ydmsama.hundred_years_war.entity.utils.PathingTaskManagerRegistry;
import ydmsama.hundred_years_war.entity.utils.Rideable;
import ydmsama.hundred_years_war.entity.utils.Rider;
import ydmsama.hundred_years_war.selection.SelectionSystem;
import ydmsama.hundred_years_war.utils.ServerRelationHelper;

public class FollowEntityGoal
extends class_1352
implements MoveGoal {
    private final BaseCombatEntity mob;
    private final double speed;
    private class_1309 targetEntity;
    private final double followRange;
    private final double triggerRange;
    private final double teleportRange;
    private final double maxTeleportRange;
    private boolean shouldRemove;
    private boolean tryRiding;
    private class_11 currentPath;
    private boolean pathGenerated = false;

    public FollowEntityGoal(BaseCombatEntity mob, double speed, double followRange, double triggerRange, double teleportRange, double maxTeleportRange) {
        this.mob = mob;
        this.speed = speed;
        this.followRange = followRange;
        this.triggerRange = triggerRange;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        this.shouldRemove = true;
        this.teleportRange = teleportRange;
        this.maxTeleportRange = maxTeleportRange;
    }

    public boolean method_6264() {
        if (this.mob instanceof Rider && this.targetEntity instanceof Rideable) {
            this.tryRiding = true;
        }
        this.targetEntity = this.mob.getFollowTarget();
        if (this.targetEntity == null || !this.targetEntity.method_5805()) {
            return false;
        }
        double distanceToTarget = this.mob.method_5858((class_1297)this.targetEntity);
        return distanceToTarget > this.triggerRange * this.triggerRange || !this.shouldRemove || this.tryRiding && !this.mob.method_5765();
    }

    public boolean method_6266() {
        if (this.mob instanceof ArcherEntity && this.targetEntity instanceof HywHorseEntity) {
            this.tryRiding = true;
        }
        this.targetEntity = this.mob.getFollowTarget();
        if (this.targetEntity == null || !this.targetEntity.method_5805()) {
            return false;
        }
        double distanceToTarget = this.mob.method_5858((class_1297)this.targetEntity);
        return distanceToTarget > this.triggerRange * this.triggerRange || !this.shouldRemove || this.tryRiding;
    }

    public void method_6269() {
        this.mob.setHomePosition(null);
        this.targetEntity = this.mob.getFollowTarget();
        if (!this.mob.commandHold()) {
            this.mob.setCommandHold(false);
        }
        this.shouldRemove = false;
        this.updatePath();
    }

    public void method_6270() {
        this.mob.method_5942().method_6340();
    }

    public void method_6268() {
        class_1309 class_13092;
        this.targetEntity = this.mob.getFollowTarget();
        if (this.targetEntity == null) {
            return;
        }
        double distanceToTarget = this.mob.method_5858((class_1297)this.targetEntity);
        if (distanceToTarget > this.followRange * this.followRange) {
            this.mob.method_5942().method_6335((class_1297)this.targetEntity, this.speed);
        } else {
            if (this.tryRiding && this.mob instanceof Rider && this.targetEntity instanceof Rideable && !this.mob.method_5765() && this.targetEntity.method_5685().isEmpty()) {
                this.mob.method_5873((class_1297)this.targetEntity, true);
                SelectionSystem.clearEntityFromAllSelections(this.mob);
                this.tryRiding = false;
            }
            this.shouldRemove = true;
        }
        if (distanceToTarget > this.teleportRange * this.teleportRange && distanceToTarget < this.maxTeleportRange * this.maxTeleportRange && (class_13092 = this.targetEntity) instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            if (!(this.mob instanceof SiegeUnit) && ServerRelationHelper.hasControlOver(player, (class_1297)this.mob)) {
                class_243 teleportPos = this.findSafeTeleportPosition();
                if (teleportPos != null) {
                    this.mob.method_5859(teleportPos.field_1352, teleportPos.field_1351, teleportPos.field_1350);
                    this.currentPath = null;
                }
                this.shouldRemove = true;
            }
        }
    }

    private void updatePath() {
        if (this.pathGenerated) {
            if (this.currentPath == null || this.currentPath.method_46() || !this.mob.method_5942().method_23966()) {
                this.currentPath = this.mob.method_5942().method_35141(this.targetEntity.method_24515(), 0, 16);
            }
        } else {
            this.createPathingTask(this.mob, this.targetEntity);
        }
    }

    private void createPathingTask(BaseCombatEntity mob, class_1309 target) {
        Consumer<class_11> pathConsumer = path -> {
            this.currentPath = path;
            this.pathGenerated = true;
        };
        PathingTask task = new PathingTask(mob, target.method_24515(), pathConsumer);
        PathingTaskManagerRegistry registry = PathingTaskManagerRegistry.getInstance();
        PathingTaskManager manager = registry.getTaskManager(mob.getOwnerUUID());
        manager.addTask(task);
    }

    private class_243 findSafeTeleportPosition() {
        class_2338 pos;
        int yOffset;
        double distanceToNewPos;
        int newZ;
        int newX;
        int offsetZ;
        int offsetX;
        int i;
        class_2338 targetPos = this.targetEntity.method_24515();
        class_2338 mobPos = this.mob.method_24515();
        int range = 10;
        int heightLimit = 5;
        double distanceToTarget = Math.sqrt(this.mob.method_5858((class_1297)this.targetEntity));
        for (i = 0; i < 10; ++i) {
            offsetX = this.mob.method_6051().method_43048(range * 2) - range;
            offsetZ = this.mob.method_6051().method_43048(range * 2) - range;
            newX = targetPos.method_10263() + offsetX;
            newZ = targetPos.method_10260() + offsetZ;
            distanceToNewPos = Math.sqrt(mobPos.method_10262((class_2382)new class_2338(newX, targetPos.method_10264(), newZ)));
            if (distanceToNewPos > distanceToTarget) continue;
            for (yOffset = 1; yOffset <= heightLimit; ++yOffset) {
                pos = new class_2338(newX, targetPos.method_10264() + yOffset, newZ);
                if (!this.isSafeTeleportLocation(pos, false)) continue;
                return new class_243((double)newX + 0.5, (double)pos.method_10264(), (double)newZ + 0.5);
            }
            for (yOffset = 0; yOffset < heightLimit; ++yOffset) {
                pos = new class_2338(newX, targetPos.method_10264() - yOffset, newZ);
                if (!this.isSafeTeleportLocation(pos, false)) continue;
                return new class_243((double)newX + 0.5, (double)pos.method_10264(), (double)newZ + 0.5);
            }
        }
        for (i = 0; i < 10; ++i) {
            offsetX = this.mob.method_6051().method_43048(range * 2) - range;
            offsetZ = this.mob.method_6051().method_43048(range * 2) - range;
            newX = targetPos.method_10263() + offsetX;
            newZ = targetPos.method_10260() + offsetZ;
            distanceToNewPos = Math.sqrt(mobPos.method_10262((class_2382)new class_2338(newX, targetPos.method_10264(), newZ)));
            if (distanceToNewPos > distanceToTarget) continue;
            for (yOffset = 1; yOffset <= heightLimit; ++yOffset) {
                pos = new class_2338(newX, targetPos.method_10264() + yOffset, newZ);
                if (!this.isSafeTeleportLocation(pos, true)) continue;
                return new class_243((double)newX + 0.5, (double)pos.method_10264(), (double)newZ + 0.5);
            }
            for (yOffset = 0; yOffset < heightLimit; ++yOffset) {
                pos = new class_2338(newX, targetPos.method_10264() - yOffset, newZ);
                if (!this.isSafeTeleportLocation(pos, true)) continue;
                return new class_243((double)newX + 0.5, (double)pos.method_10264(), (double)newZ + 0.5);
            }
        }
        return null;
    }

    private boolean isSafeTeleportLocation(class_2338 pos, boolean allowWater) {
        double entityWidth = this.mob.method_17681();
        double entityHeight = this.mob.method_17682();
        class_2680 blockStateBelow = this.mob.method_37908().method_8320(pos.method_10074());
        if (!(blockStateBelow.method_51367() || allowWater && blockStateBelow.method_27852(class_2246.field_10382))) {
            return false;
        }
        class_243 minPos = new class_243((double)pos.method_10263() - entityWidth / 2.0, (double)pos.method_10264(), (double)pos.method_10260() - entityWidth / 2.0);
        class_243 maxPos = new class_243((double)pos.method_10263() + entityWidth / 2.0, (double)pos.method_10264() + entityHeight, (double)pos.method_10260() + entityWidth / 2.0);
        for (double x = minPos.field_1352; x <= maxPos.field_1352; x += 1.0) {
            for (double z = minPos.field_1350; z <= maxPos.field_1350; z += 1.0) {
                for (double y = minPos.field_1351; y <= maxPos.field_1351; y += 1.0) {
                    class_2338 checkPos = new class_2338((int)x, (int)y, (int)z);
                    class_2680 blockState = this.mob.method_37908().method_8320(checkPos);
                    if (blockState.method_26215() || allowWater && blockState.method_27852(class_2246.field_10382)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

