/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.entity.goals;

import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_11;
import net.minecraft.class_1352;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import ydmsama.hundred_years_war.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.entity.goals.CommandedGoal;
import ydmsama.hundred_years_war.entity.goals.MoveGoal;
import ydmsama.hundred_years_war.entity.utils.FormationManager;
import ydmsama.hundred_years_war.entity.utils.PathingTask;
import ydmsama.hundred_years_war.entity.utils.PathingTaskManager;
import ydmsama.hundred_years_war.entity.utils.PathingTaskManagerRegistry;
import ydmsama.hundred_years_war.mixins.EntityAccessor;

public class MoveToBlockGoal
extends class_1352
implements CommandedGoal,
MoveGoal {
    private boolean init = true;
    private final UUID FormationUUID;
    private boolean shouldRemove = false;
    private BaseCombatEntity mob;
    private final double speed;
    private class_2338 targetPos;
    private class_11 currentPath;
    private boolean pathGenerated = false;

    public MoveToBlockGoal(BaseCombatEntity mob, double speed, UUID formationUUID) {
        this.mob = mob;
        this.speed = speed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        this.FormationUUID = formationUUID;
    }

    public void setTargetPos(class_2338 targetPos) {
        class_2680 blockState = ((EntityAccessor)((Object)this.mob)).getLevel().method_8320(targetPos);
        this.targetPos = !blockState.method_26216((class_1922)((EntityAccessor)((Object)this.mob)).getLevel(), targetPos) || blockState.method_26215() ? targetPos : targetPos.method_10084();
    }

    public boolean method_6264() {
        if (this.targetPos == null) {
            return false;
        }
        return !this.shouldRemove && !this.mob.method_5765();
    }

    public boolean method_6266() {
        return !this.shouldRemove;
    }

    public void method_6269() {
        if (this.init) {
            this.mob.setHomePosition(this.targetPos);
            this.mob.setFormationUUID(this.FormationUUID);
            this.createPathingTask(this.mob);
            this.mob.setCommandHold(false);
            this.init = false;
        } else {
            this.currentPath = null;
        }
    }

    public void method_6270() {
        this.mob.method_5942().method_6340();
    }

    public void method_6268() {
        if (this.targetPos == null) {
            return;
        }
        class_2338 currentHorizontalPos = new class_2338((int)Math.floor(this.mob.method_23317()), this.targetPos.method_10264(), (int)Math.floor(this.mob.method_23321()));
        double verticalDistance = Math.abs(this.mob.method_23318() - (double)this.targetPos.method_10264());
        if (currentHorizontalPos.method_19771((class_2382)this.targetPos, this.mob.getArrivalThreshold()) && verticalDistance < 1.0 + this.mob.getArrivalThreshold()) {
            this.shouldRemove = true;
            this.executeNext();
        } else {
            this.startMove(this.mob, this.speed);
        }
    }

    private void createPathingTask(BaseCombatEntity mob) {
        Consumer<class_11> pathConsumer = path -> {
            this.currentPath = path;
            this.pathGenerated = true;
        };
        PathingTask task = new PathingTask(mob, this.targetPos, pathConsumer);
        PathingTaskManagerRegistry registry = PathingTaskManagerRegistry.getInstance();
        PathingTaskManager manager = registry.getTaskManager(mob.getOwnerUUID());
        manager.addTask(task);
    }

    private void startMove(BaseCombatEntity mob, double speed) {
        double deltaZ;
        double deltaX;
        double distance;
        if (this.pathGenerated && (this.currentPath == null || this.currentPath.method_46() || !mob.method_5942().method_23966())) {
            this.currentPath = mob.method_5942().method_35141(this.targetPos, 0, 16);
        }
        mob.method_5942().method_6334(this.currentPath, speed);
        if (!mob.method_5942().method_23966() && (distance = Math.sqrt((deltaX = (double)this.targetPos.method_10263() - mob.method_23317()) * deltaX + (deltaZ = (double)this.targetPos.method_10260() - mob.method_23321()) * deltaZ)) < 10.0 * mob.getArrivalThreshold() && distance > 0.01) {
            double smallMoveSpeed = 0.05;
            mob.method_18800(deltaX / distance * smallMoveSpeed, mob.method_18798().field_1351, deltaZ / distance * smallMoveSpeed);
        }
    }

    @Override
    public void executeNext() {
        this.mob.setShouldExecuteNext(true);
        this.mob.goalFinished();
    }

    @Override
    public void updateEntityReference(BaseCombatEntity newEntity) {
        FormationManager.FormationStatus formationStatus;
        this.mob = newEntity;
        this.mob.setFormationUUID(this.FormationUUID);
        if (this.FormationUUID != null && (formationStatus = FormationManager.getFormationStatus(this.FormationUUID)) != null) {
            formationStatus.getEntities().add(newEntity);
            int currentSize = formationStatus.getEntities().size();
            formationStatus.setFormationSize(currentSize);
        }
    }
}

