/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.entity.goals;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_11;
import net.minecraft.class_1352;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import ydmsama.hundred_years_war.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.mixins.EntityAccessor;

public class PatrolGoal
extends class_1352 {
    private final BaseCombatEntity mob;
    private final double speed;
    private int currentIndex = 0;
    private boolean reverse = false;
    private int stayTicks = 0;
    private final int maxStayTicks;
    private class_11 currentPath;
    private class_2338 targetPos;
    private boolean arrived;

    public PatrolGoal(BaseCombatEntity mob, double speed, int maxStayTicks) {
        this.mob = mob;
        this.speed = speed;
        this.maxStayTicks = maxStayTicks;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        if (this.mob.commandHold()) {
            return false;
        }
        return !this.mob.getPatrolPoints().isEmpty() && !this.mob.method_5765();
    }

    public boolean method_6266() {
        if (this.mob.commandHold()) {
            return false;
        }
        return !this.mob.getPatrolPoints().isEmpty();
    }

    public void method_6270() {
        this.mob.method_5942().method_6340();
    }

    public void method_6269() {
        this.arrived = false;
    }

    public void method_6268() {
        if (this.mob.commandHold()) {
            return;
        }
        if (this.currentIndex > this.mob.getPatrolPoints().size() - 1) {
            this.currentIndex = this.mob.getPatrolPoints().size() - 1;
        } else if (this.currentIndex < 0) {
            this.currentIndex = 0;
        }
        if (this.mob.getPatrolPoints().get(this.currentIndex) != null) {
            this.setTargetPos(this.mob.getPatrolPoints().get(this.currentIndex));
        }
        if (this.targetPos != null) {
            class_2338 currentPos = new class_2338((int)Math.floor(this.mob.method_23317()), this.targetPos.method_10264(), (int)Math.floor(this.mob.method_23321()));
            if (currentPos.method_19771((class_2382)this.targetPos, this.mob.getArrivalThreshold())) {
                this.arrived = true;
            } else if (!this.arrived) {
                this.moveToCurrentPoint();
            }
            if (this.arrived) {
                if (this.stayTicks < this.maxStayTicks) {
                    ++this.stayTicks;
                } else {
                    this.stayTicks = 0;
                    this.moveToNextPoint();
                    this.arrived = false;
                }
            }
        }
    }

    private void moveToCurrentPoint() {
        double deltaZ;
        double deltaX;
        double distance;
        if (this.currentPath == null || this.currentPath.method_46() || !this.mob.method_5942().method_23966()) {
            this.currentPath = this.mob.method_5942().method_35141(this.targetPos, 0, 16);
        }
        this.mob.method_5942().method_6334(this.currentPath, this.speed);
        if (!this.mob.method_5942().method_23966() && (distance = Math.sqrt((deltaX = (double)this.targetPos.method_10263() - this.mob.method_23317()) * deltaX + (deltaZ = (double)this.targetPos.method_10260() - this.mob.method_23321()) * deltaZ)) < 10.0 * this.mob.getArrivalThreshold() && distance > 0.01) {
            double smallMoveSpeed = 0.05;
            this.mob.method_18800(deltaX / distance * smallMoveSpeed, this.mob.method_18798().field_1351, deltaZ / distance * smallMoveSpeed);
        }
    }

    private void moveToNextPoint() {
        List<class_2338> patrolPoints = this.mob.getPatrolPoints();
        if (this.reverse) {
            --this.currentIndex;
            if (this.currentIndex <= 0) {
                this.reverse = false;
            }
        } else {
            ++this.currentIndex;
            if (this.currentIndex >= patrolPoints.size() - 1) {
                if (patrolPoints.get(0).equals((Object)patrolPoints.get(patrolPoints.size() - 1))) {
                    this.currentIndex = 0;
                } else {
                    this.reverse = true;
                }
            }
        }
        this.moveToCurrentPoint();
    }

    public void setTargetPos(class_2338 targetPos) {
        class_2680 blockState = ((EntityAccessor)((Object)this.mob)).getLevel().method_8320(targetPos);
        this.targetPos = !blockState.method_26216((class_1922)((EntityAccessor)((Object)this.mob)).getLevel(), targetPos) || blockState.method_26215() ? targetPos : targetPos.method_10084();
    }
}

