/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.entity.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import ydmsama.hundred_years_war.entity.utils.PathingTaskManager;

public class PathingTaskManagerRegistry {
    private static PathingTaskManagerRegistry instance = null;
    private Map<UUID, PathingTaskManager> playerTaskManagers = new HashMap<UUID, PathingTaskManager>();
    private int defaultMaxTasksPerTick;

    private PathingTaskManagerRegistry(int defaultMaxTasksPerTick) {
        this.defaultMaxTasksPerTick = defaultMaxTasksPerTick;
    }

    public static PathingTaskManagerRegistry getInstance() {
        if (instance == null) {
            instance = new PathingTaskManagerRegistry(4);
        }
        return instance;
    }

    public PathingTaskManager getTaskManager(UUID playerUUID) {
        return this.playerTaskManagers.computeIfAbsent(playerUUID, k -> new PathingTaskManager(this.defaultMaxTasksPerTick));
    }

    public void removeTaskManager(UUID playerUUID) {
        this.playerTaskManagers.remove(playerUUID);
    }

    public void executeAllTasks() {
        for (PathingTaskManager manager : this.playerTaskManagers.values()) {
            manager.executeTasks();
        }
    }

    public int getMaxTasksPerTick() {
        return this.defaultMaxTasksPerTick;
    }
}

