/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.freecam.ui;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_6379;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.freecam.ui.CustomButton;
import ydmsama.hundred_years_war.freecam.ui.TeamApplicationsWidget;

@Environment(value=EnvType.CLIENT)
public class TeamApplicationEntry
extends class_4265.class_4266<TeamApplicationEntry> {
    private final String playerName;
    private final UUID playerUUID;
    private final long applyTime;
    private final TeamApplicationsWidget parent;
    private final List<class_364> children = new ArrayList<class_364>();
    private final class_310 minecraft;
    private CustomButton acceptButton;
    private CustomButton rejectButton;
    private static final class_2960 PLAYER_ICON = new class_2960("hundred_years_war", "textures/gui/player.png");
    private static final int ICON_SIZE = 16;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public TeamApplicationEntry(String playerName, UUID playerUUID, long applyTime, TeamApplicationsWidget parent) {
        this.playerName = playerName;
        this.playerUUID = playerUUID;
        this.applyTime = applyTime;
        this.parent = parent;
        this.minecraft = class_310.method_1551();
        this.acceptButton = new CustomButton(0, 0, 50, 20, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.accept"), button -> {});
        this.rejectButton = new CustomButton(0, 0, 50, 20, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.reject"), button -> {});
        this.rejectButton.setColor(-5636096, -3407872, -11206656);
        this.children.add(this.acceptButton);
        this.children.add(this.rejectButton);
    }

    public void setAcceptClickHandler(Runnable handler) {
        this.children.remove((Object)this.acceptButton);
        this.acceptButton = new CustomButton(this.acceptButton.method_46426(), this.acceptButton.method_46427(), this.acceptButton.method_25368(), this.acceptButton.method_25364(), this.acceptButton.method_25369(), button -> handler.run());
        this.children.add(this.acceptButton);
    }

    public void setRejectClickHandler(Runnable handler) {
        this.children.remove((Object)this.rejectButton);
        this.rejectButton = new CustomButton(this.rejectButton.method_46426(), this.rejectButton.method_46427(), this.rejectButton.method_25368(), this.rejectButton.method_25364(), this.rejectButton.method_25369(), button -> handler.run());
        this.rejectButton.setColor(-5636096, -3407872, -11206656);
        this.children.add(this.rejectButton);
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public long getApplyTime() {
        return this.applyTime;
    }

    public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
        if (isHovering) {
            guiGraphics.method_25294(left, top, left + width, top + height, 0x33FFFFFF);
        }
        Objects.requireNonNull(this.minecraft.field_1772);
        int textY = top + (height - 9) / 2;
        guiGraphics.method_25303(this.minecraft.field_1772, this.playerName, left + 10, textY, 0xFFFFFF);
        int buttonWidth = 50;
        int buttonHeight = 20;
        int buttonY = top + (height - buttonHeight) / 2;
        this.acceptButton.method_46421(left + width - buttonWidth * 2 - 10);
        this.acceptButton.method_46419(buttonY);
        this.acceptButton.method_25358(buttonWidth);
        this.acceptButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.rejectButton.method_46421(left + width - buttonWidth - 5);
        this.rejectButton.method_46419(buttonY);
        this.rejectButton.method_25358(buttonWidth);
        this.rejectButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    @NotNull
    public List<? extends class_364> method_25396() {
        return this.children;
    }

    @NotNull
    public List<? extends class_6379> method_37025() {
        return this.children.stream().filter(child -> child instanceof class_6379).map(child -> (class_6379)child).collect(Collectors.toList());
    }
}

