/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.freecam.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import ydmsama.hundred_years_war.freecam.ui.CustomButton;
import ydmsama.hundred_years_war.freecam.ui.MemberDisplayListEntry;
import ydmsama.hundred_years_war.freecam.ui.MemberDisplayListWidget;
import ydmsama.hundred_years_war.network.ClientPacketHandler;
import ydmsama.hundred_years_war.network.packets.TeamMembersResponsePacket;

@Environment(value=EnvType.CLIENT)
public class TeamInfoUI
extends class_437 {
    private static final int WINDOW_WIDTH = 240;
    private static final int WINDOW_HEIGHT = 250;
    private final class_437 parentScreen;
    private final UUID teamUUID;
    private String teamName;
    private int leftPos;
    private int topPos;
    private class_342 searchBox;
    private MemberDisplayListWidget memberListWidget;
    private CustomButton backButton;
    private String searchText = "";
    private List<TeamMembersResponsePacket.Member> allMembers = new ArrayList<TeamMembersResponsePacket.Member>();
    private List<TeamMembersResponsePacket.Member> filteredMembers = new ArrayList<TeamMembersResponsePacket.Member>();
    private long lastRequestTime = 0L;
    private static final long REQUEST_INTERVAL = 1000L;

    public TeamInfoUI(class_437 parentScreen, UUID teamUUID, String teamName) {
        super((class_2561)class_2561.method_43471((String)"ui.hundred_years_war.team_info_ui"));
        this.parentScreen = parentScreen;
        this.teamUUID = teamUUID;
        this.teamName = teamName;
        ClientPacketHandler.requestTeamMembers(teamUUID);
    }

    public void onMembersDataUpdate(TeamMembersResponsePacket packet) {
        if (!packet.getTeamUUID().equals(this.teamUUID)) {
            return;
        }
        this.allMembers.clear();
        this.teamName = packet.getTeamName();
        this.allMembers.addAll(packet.getMembers());
        System.out.println("\u6536\u5230\u56e2\u961f\u6210\u5458\u6570\u636e: " + packet.getTeamName() + ", \u6210\u5458\u6570\u91cf: " + this.allMembers.size());
        for (TeamMembersResponsePacket.Member member : this.allMembers) {
            System.out.println("\u6210\u5458: " + member.getPlayerName() + ", \u89d2\u8272: " + member.getRole());
        }
        if (this.searchBox != null && this.memberListWidget != null) {
            this.updateFilteredMembers();
            this.memberListWidget.method_25307(0.0);
        }
    }

    private void updateFilteredMembers() {
        if (this.searchBox == null) {
            return;
        }
        String searchText = this.searchBox.method_1882().toLowerCase();
        this.filteredMembers.clear();
        if (searchText.isEmpty()) {
            this.filteredMembers.addAll(this.allMembers);
        } else {
            for (TeamMembersResponsePacket.Member member : this.allMembers) {
                if (!member.getPlayerName().toLowerCase().contains(searchText)) continue;
                this.filteredMembers.add(member);
            }
        }
        this.updateMemberList();
    }

    private void updateMemberList() {
        if (this.memberListWidget == null) {
            return;
        }
        this.memberListWidget.method_25339();
        for (TeamMembersResponsePacket.Member member : this.filteredMembers) {
            MemberDisplayListEntry entry = new MemberDisplayListEntry(member.getPlayerName(), member.getPlayerUUID(), member.getRole(), member.getJoinTime(), this.memberListWidget);
            this.memberListWidget.addEntry(entry);
        }
        this.memberListWidget.method_25307(0.0);
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (this.searchBox.method_25400(codePoint, modifiers)) {
            this.updateFilteredMembers();
            return true;
        }
        return super.method_25400(codePoint, modifiers);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox.method_25404(keyCode, scanCode, modifiers)) {
            this.updateFilteredMembers();
            return true;
        }
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        if (this.searchBox.method_25370()) {
            return this.searchBox.method_25404(keyCode, scanCode, modifiers);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected void method_25426() {
        super.method_25426();
        this.leftPos = (this.field_22789 - 240) / 2;
        this.topPos = (this.field_22790 - 250) / 2;
        this.searchBox = new class_342(this.field_22793, this.leftPos + 20, this.topPos + 20 + 25, 200, 20, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.search"));
        this.searchBox.method_1880(32);
        this.searchBox.method_1858(true);
        this.searchBox.method_1856(true);
        this.searchBox.method_1868(0xFFFFFF);
        this.searchBox.method_1852(this.searchText);
        this.searchBox.method_1863(s -> {
            this.searchText = s;
            this.updateFilteredMembers();
        });
        this.method_37063((class_364)this.searchBox);
        this.memberListWidget = new MemberDisplayListWidget(this.field_22787, 200, 140, this.topPos + 20 + 50, this.topPos + 250 - 20 - 20 - 5, 24);
        this.memberListWidget.method_25333(this.leftPos + 20);
        this.method_37063((class_364)this.memberListWidget);
        this.backButton = new CustomButton(this.leftPos + 240 - 60 - 10, this.topPos + 250 - 20 - 10, 60, 20, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.back"), button -> this.method_25419());
        this.method_37063(this.backButton);
        this.allMembers.clear();
        this.filteredMembers.clear();
        ClientPacketHandler.requestTeamMembers(this.teamUUID);
        TeamMembersResponsePacket latestData = ClientPacketHandler.getLatestTeamMembersData();
        if (latestData != null && latestData.getTeamUUID().equals(this.teamUUID)) {
            this.onMembersDataUpdate(latestData);
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.method_25294(this.leftPos, this.topPos, this.leftPos + 240, this.topPos + 250, -1073741824);
        guiGraphics.method_25294(this.leftPos, this.topPos, this.leftPos + 240, this.topPos + 1, -1);
        guiGraphics.method_25294(this.leftPos, this.topPos + 250 - 1, this.leftPos + 240, this.topPos + 250, -1);
        guiGraphics.method_25294(this.leftPos, this.topPos, this.leftPos + 1, this.topPos + 250, -1);
        guiGraphics.method_25294(this.leftPos + 240 - 1, this.topPos, this.leftPos + 240, this.topPos + 250, -1);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.leftPos + 120, this.topPos + 10, 0xFFFFFF);
        guiGraphics.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)this.teamName), this.leftPos + 120, this.topPos + 20, 0xFFFFFF);
        if (this.allMembers.isEmpty()) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastRequestTime > 1000L) {
                this.requestMembersData();
                this.lastRequestTime = currentTime;
            }
            guiGraphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.loading"), this.leftPos + 120, this.topPos + 125, 0xFFFFFF);
        } else if (this.filteredMembers.isEmpty() && !this.searchText.isEmpty()) {
            guiGraphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.no_members_found"), this.leftPos + 120, this.topPos + 125, 0xFFFFFF);
        }
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void requestMembersData() {
        System.out.println("\u8bf7\u6c42\u56e2\u961f\u6210\u5458\u6570\u636e\uff0cteamUUID: " + this.teamUUID);
        ClientPacketHandler.requestTeamMembers(this.teamUUID);
    }

    public void method_25419() {
        class_310.method_1551().method_1507(this.parentScreen);
    }
}

