/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.freecam.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import ydmsama.hundred_years_war.freecam.ui.CustomButton;
import ydmsama.hundred_years_war.freecam.ui.TeamListEntry;
import ydmsama.hundred_years_war.freecam.ui.TeamListWidget;
import ydmsama.hundred_years_war.network.ClientPacketHandler;
import ydmsama.hundred_years_war.network.packets.TeamListResponsePacket;
import ydmsama.hundred_years_war.utils.RelationSystem;

@Environment(value=EnvType.CLIENT)
public class TeamJoinUI
extends class_437 {
    private static final int WINDOW_WIDTH = 240;
    private static final int WINDOW_HEIGHT = 250;
    private static final int SEARCH_BOX_HEIGHT = 20;
    private static final int TEAM_ITEM_HEIGHT = 24;
    private static final int TEAM_LIST_HEIGHT = 150;
    private final class_437 parentScreen;
    private int leftPos;
    private int topPos;
    private class_342 searchBox;
    private TeamListWidget teamListWidget;
    private CustomButton cancelButton;
    private String errorMessage = "";
    private String searchText = "";
    private List<TeamInfo> allTeams = new ArrayList<TeamInfo>();
    private List<TeamInfo> filteredTeams = new ArrayList<TeamInfo>();

    public TeamJoinUI(class_437 parentScreen) {
        super((class_2561)class_2561.method_43471((String)"ui.hundred_years_war.team_join_ui"));
        this.parentScreen = parentScreen;
        ClientPacketHandler.requestTeamList();
    }

    public void onTeamListUpdate(TeamListResponsePacket packet) {
        System.out.println("TeamJoinUI\u6536\u5230\u56e2\u961f\u5217\u8868\u6570\u636e\u5305\uff0c\u56e2\u961f\u6570\u91cf: " + packet.getTeams().size());
        this.allTeams.clear();
        for (Map.Entry<UUID, TeamListResponsePacket.TeamInfo> entry : packet.getTeams().entrySet()) {
            UUID teamUUID = entry.getKey();
            TeamListResponsePacket.TeamInfo teamInfo = entry.getValue();
            this.allTeams.add(new TeamInfo(teamUUID, teamInfo.getTeamName(), teamInfo.getMemberCount(), teamInfo.getOwnerName(), teamInfo.getRelation()));
        }
        if (this.searchBox != null && this.teamListWidget != null) {
            this.updateFilteredTeams();
            this.teamListWidget.method_25307(0.0);
        }
    }

    private void updateFilteredTeams() {
        if (this.searchBox == null) {
            System.out.println("\u8b66\u544a: updateFilteredTeams() \u88ab\u8c03\u7528\u4f46searchBox\u4e3a\u7a7a");
            return;
        }
        String searchText = this.searchBox.method_1882().toLowerCase();
        System.out.println("\u66f4\u65b0\u8fc7\u6ee4\u56e2\u961f\u5217\u8868: \u641c\u7d22\u6587\u672c=" + searchText + ", \u5f53\u524d\u6240\u6709\u56e2\u961f\u6570\u91cf=" + this.allTeams.size());
        this.filteredTeams.clear();
        if (searchText.isEmpty()) {
            this.filteredTeams.addAll(this.allTeams);
        } else {
            for (TeamInfo team : this.allTeams) {
                if (!team.teamName.toLowerCase().contains(searchText)) continue;
                this.filteredTeams.add(team);
            }
        }
        System.out.println("\u8fc7\u6ee4\u540e\u56e2\u961f\u6570\u91cf: " + this.filteredTeams.size());
        this.updateTeamList();
    }

    private void updateTeamList() {
        if (this.teamListWidget == null) {
            return;
        }
        this.teamListWidget.method_25339();
        for (TeamInfo team : this.filteredTeams) {
            TeamListEntry entry = new TeamListEntry(team.teamName, team.teamUUID, this.teamListWidget);
            entry.setButtonText((class_2561)class_2561.method_43471((String)"button.hundred_years_war.join"));
            entry.setButtonClickHandler(() -> this.joinTeam(team.teamUUID));
            this.teamListWidget.addEntry(entry);
        }
        this.teamListWidget.method_25307(0.0);
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (this.searchBox.method_25400(codePoint, modifiers)) {
            this.updateFilteredTeams();
            return true;
        }
        return super.method_25400(codePoint, modifiers);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox.method_25404(keyCode, scanCode, modifiers)) {
            this.updateFilteredTeams();
            return true;
        }
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected void method_25426() {
        super.method_25426();
        this.leftPos = (this.field_22789 - 240) / 2;
        this.topPos = (this.field_22790 - 250) / 2;
        this.searchBox = new class_342(this.field_22793, this.leftPos + 10, this.topPos + 20 + 15, 220, 20, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.search"));
        this.searchBox.method_1880(50);
        this.searchBox.method_1858(true);
        this.searchBox.method_1862(true);
        this.searchBox.method_1868(0xFFFFFF);
        this.searchBox.method_1852(this.searchText);
        this.searchBox.method_1863(this::onSearchTextChanged);
        this.method_37063((class_364)this.searchBox);
        int teamListTop = this.topPos + 20 + 15 + 20 + 5;
        this.teamListWidget = new TeamListWidget(this.field_22787, 220, 150, teamListTop, teamListTop + 150, 24);
        this.teamListWidget.method_25333(this.leftPos + 10);
        this.method_25429((class_364)this.teamListWidget);
        this.cancelButton = new CustomButton(this.leftPos + 120 - 40, this.topPos + 250 - 20 - 20, 80, 20, (class_2561)class_2561.method_43471((String)"button.hundred_years_war.cancel"), button -> this.method_25419());
        this.method_37063(this.cancelButton);
        this.allTeams.clear();
        this.filteredTeams.clear();
        ClientPacketHandler.requestTeamList();
        System.out.println("TeamJoinUI.init: \u8bf7\u6c42\u56e2\u961f\u5217\u8868\u6570\u636e");
        TeamListResponsePacket latestData = ClientPacketHandler.getLatestTeamListData();
        if (latestData != null) {
            System.out.println("TeamJoinUI.init: \u4f7f\u7528\u5df2\u6709\u7684\u56e2\u961f\u5217\u8868\u6570\u636e");
            this.onTeamListUpdate(latestData);
        }
        if (this.allTeams.isEmpty()) {
            System.out.println("TeamJoinUI.init: \u6dfb\u52a0\u6a21\u62df\u6570\u636e");
            this.addMockTeams();
        }
        if (this.filteredTeams.isEmpty() && !this.allTeams.isEmpty()) {
            this.filteredTeams.addAll(this.allTeams);
            this.updateTeamList();
        }
    }

    private void onSearchTextChanged(String text) {
        this.searchText = text;
        this.updateFilteredTeams();
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.method_25294(this.leftPos, this.topPos, this.leftPos + 240, this.topPos + 250, -1073741824);
        guiGraphics.method_25294(this.leftPos, this.topPos, this.leftPos + 240, this.topPos + 1, -1);
        guiGraphics.method_25294(this.leftPos, this.topPos + 250 - 1, this.leftPos + 240, this.topPos + 250, -1);
        guiGraphics.method_25294(this.leftPos, this.topPos + 1, this.leftPos + 1, this.topPos + 250 - 1, -1);
        guiGraphics.method_25294(this.leftPos + 240 - 1, this.topPos + 1, this.leftPos + 240, this.topPos + 250 - 1, -1);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.leftPos + 120, this.topPos + 10, 0xFFFFFF);
        guiGraphics.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.search_team"), this.leftPos + 10, this.topPos + 20, 0xFFFFFF);
        if (!this.errorMessage.isEmpty()) {
            guiGraphics.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)this.errorMessage), this.leftPos + 10, this.topPos + 250 - 20 - 10, 0xFF5555);
        }
        if (this.filteredTeams.isEmpty()) {
            guiGraphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.no_teams_found"), this.leftPos + 120, this.topPos + 20 + 15 + 20 + 75, 0xBBBBBB);
        }
        this.teamListWidget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void joinTeam(UUID teamUUID) {
        try {
            ClientPacketHandler.requestJoinTeam(teamUUID);
            class_310.method_1551().method_1507(this.parentScreen);
        }
        catch (Exception e) {
            this.errorMessage = "\u65e0\u6cd5\u53d1\u9001\u56e2\u961f\u52a0\u5165\u8bf7\u6c42: " + e.getMessage();
        }
    }

    public void method_25419() {
        class_310.method_1551().method_1507(this.parentScreen);
    }

    private void addMockTeams() {
        System.out.println("\u6dfb\u52a0\u6a21\u62df\u56e2\u961f\u6570\u636e");
        this.allTeams.add(new TeamInfo(UUID.randomUUID(), "[\u6a21\u62df]\u82f1\u683c\u5170\u9a91\u58eb\u56e2", 5, "\u56fd\u738b\u4ea8\u5229\u4e94\u4e16", RelationSystem.RelationType.NEUTRAL));
        this.allTeams.add(new TeamInfo(UUID.randomUUID(), "[\u6a21\u62df]\u6cd5\u56fd\u7981\u536b\u519b", 7, "\u56fd\u738b\u67e5\u7406\u516d\u4e16", RelationSystem.RelationType.HOSTILE));
        this.allTeams.add(new TeamInfo(UUID.randomUUID(), "[\u6a21\u62df]\u82cf\u683c\u5170\u9ad8\u5730\u519b", 3, "\u7f57\u4f2f\u7279\u4e00\u4e16", RelationSystem.RelationType.FRIENDLY));
        this.allTeams.add(new TeamInfo(UUID.randomUUID(), "[\u6a21\u62df]\u52c3\u826e\u7b2c\u96c7\u4f63\u5175", 9, "\u52c7\u6562\u7684\u67e5\u7406", RelationSystem.RelationType.NEUTRAL));
        this.allTeams.add(new TeamInfo(UUID.randomUUID(), "[\u6a21\u62df]\u610f\u5927\u5229\u5f13\u7bad\u624b", 6, "\u795e\u5723\u7f57\u9a6c\u7687\u5e1d", RelationSystem.RelationType.NEUTRAL));
        this.filteredTeams.clear();
        this.filteredTeams.addAll(this.allTeams);
        if (this.searchBox != null && this.teamListWidget != null) {
            this.updateTeamList();
        }
        System.out.println("\u6dfb\u52a0\u5b8c\u6a21\u62df\u6570\u636e\u540e\uff0c\u56e2\u961f\u603b\u6570: " + this.allTeams.size());
    }

    @Environment(value=EnvType.CLIENT)
    public static class TeamInfo {
        private final UUID teamUUID;
        private final String teamName;
        private final int memberCount;
        private final String ownerName;
        private final RelationSystem.RelationType relation;

        public TeamInfo(UUID teamUUID, String teamName, int memberCount, String ownerName, RelationSystem.RelationType relation) {
            this.teamUUID = teamUUID;
            this.teamName = teamName;
            this.memberCount = memberCount;
            this.ownerName = ownerName;
            this.relation = relation;
        }

        public UUID getTeamUUID() {
            return this.teamUUID;
        }

        public String getTeamName() {
            return this.teamName;
        }

        public int getMemberCount() {
            return this.memberCount;
        }

        public String getOwnerName() {
            return this.ownerName;
        }

        public RelationSystem.RelationType getRelation() {
            return this.relation;
        }
    }
}

