/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.freecam.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import ydmsama.hundred_years_war.freecam.ui.CustomButton;
import ydmsama.hundred_years_war.freecam.ui.CustomConfirmScreen;
import ydmsama.hundred_years_war.freecam.ui.MemberListEntry;
import ydmsama.hundred_years_war.freecam.ui.MemberListWidget;
import ydmsama.hundred_years_war.network.ClientPacketHandler;
import ydmsama.hundred_years_war.network.packets.TeamMembersResponsePacket;

@Environment(value=EnvType.CLIENT)
public class TeamMembersUI
extends class_437 {
    private static final int WINDOW_WIDTH = 240;
    private static final int WINDOW_HEIGHT = 250;
    private final class_437 parentScreen;
    private final UUID teamUUID;
    private final String teamName;
    private final String teamOwnerName;
    private final List<String> teamMembers;
    private final List<String> teamAdmins;
    private int leftPos;
    private int topPos;
    private class_342 searchBox;
    private MemberListWidget memberListWidget;
    private CustomButton backButton;
    private CustomButton applyButton;
    private List<MemberInfo> filteredMembers = new ArrayList<MemberInfo>();
    private Map<UUID, MemberListEntry.MemberRole> roleChanges = new HashMap<UUID, MemberListEntry.MemberRole>();
    private boolean hasChanges = false;

    public TeamMembersUI(class_437 parentScreen, UUID teamUUID, String teamName, String teamOwnerName, List<String> teamMembers, List<String> teamAdmins) {
        super((class_2561)class_2561.method_43471((String)"ui.hundred_years_war.team_members_ui"));
        this.parentScreen = parentScreen;
        this.teamUUID = teamUUID;
        this.teamName = teamName;
        this.teamOwnerName = teamOwnerName;
        this.teamMembers = teamMembers;
        this.teamAdmins = teamAdmins;
        this.updateMembersList();
        ClientPacketHandler.requestTeamMembers(teamUUID);
        TeamMembersResponsePacket cachedData = ClientPacketHandler.getLatestTeamMembersData();
        if (cachedData != null && cachedData.getTeamUUID().equals(teamUUID)) {
            this.updateMembersFromResponse(cachedData);
        }
    }

    private void updateMembersList() {
        this.filteredMembers.clear();
        for (String memberName : this.teamMembers) {
            boolean isAdmin = this.teamAdmins.contains(memberName);
            boolean isOwner = memberName.equals(this.teamOwnerName);
            UUID memberUUID = UUID.nameUUIDFromBytes(memberName.getBytes());
            this.filteredMembers.add(new MemberInfo(memberName, memberUUID, isAdmin, isOwner));
        }
    }

    private void filterMembers(String filter) {
        System.out.println("\u6267\u884c\u8fc7\u6ee4\uff0c\u8fc7\u6ee4\u6761\u4ef6: " + filter);
        if (filter == null || filter.isEmpty()) {
            this.filteredMembers.clear();
            TeamMembersResponsePacket cachedData = ClientPacketHandler.getLatestTeamMembersData();
            if (cachedData != null && cachedData.getTeamUUID().equals(this.teamUUID)) {
                for (TeamMembersResponsePacket.Member member : cachedData.getMembers()) {
                    String memberName = member.getPlayerName();
                    UUID memberUUID = member.getPlayerUUID();
                    boolean isAdmin = member.getRole() == TeamMembersResponsePacket.Member.Role.ADMIN;
                    boolean isOwner = member.getRole() == TeamMembersResponsePacket.Member.Role.OWNER;
                    this.filteredMembers.add(new MemberInfo(memberName, memberUUID, isAdmin, isOwner));
                }
            } else {
                this.updateMembersList();
            }
        } else {
            String lowerFilter = filter.toLowerCase();
            this.filteredMembers.clear();
            TeamMembersResponsePacket cachedData = ClientPacketHandler.getLatestTeamMembersData();
            if (cachedData != null && cachedData.getTeamUUID().equals(this.teamUUID)) {
                for (TeamMembersResponsePacket.Member member : cachedData.getMembers()) {
                    if (!member.getPlayerName().toLowerCase().contains(lowerFilter)) continue;
                    String memberName = member.getPlayerName();
                    UUID memberUUID = member.getPlayerUUID();
                    boolean isAdmin = member.getRole() == TeamMembersResponsePacket.Member.Role.ADMIN;
                    boolean isOwner = member.getRole() == TeamMembersResponsePacket.Member.Role.OWNER;
                    this.filteredMembers.add(new MemberInfo(memberName, memberUUID, isAdmin, isOwner));
                }
            } else {
                this.filteredMembers = this.teamMembers.stream().filter(name -> name.toLowerCase().contains(lowerFilter)).map(name -> {
                    boolean isAdmin = this.teamAdmins.contains(name);
                    boolean isOwner = name.equals(this.teamOwnerName);
                    UUID memberUUID = UUID.nameUUIDFromBytes(name.getBytes());
                    return new MemberInfo((String)name, memberUUID, isAdmin, isOwner);
                }).collect(Collectors.toList());
            }
        }
        System.out.println("\u8fc7\u6ee4\u540e\u6210\u5458\u6570\u91cf: " + this.filteredMembers.size());
        if (this.memberListWidget != null) {
            this.updateMemberListWidget();
            this.memberListWidget.method_25307(0.0);
        }
    }

    public void updateMembersFromResponse(TeamMembersResponsePacket packet) {
        if (packet == null || !packet.getTeamUUID().equals(this.teamUUID)) {
            return;
        }
        this.filteredMembers.clear();
        for (TeamMembersResponsePacket.Member member : packet.getMembers()) {
            String memberName = member.getPlayerName();
            UUID memberUUID = member.getPlayerUUID();
            boolean isAdmin = member.getRole() == TeamMembersResponsePacket.Member.Role.ADMIN;
            boolean isOwner = member.getRole() == TeamMembersResponsePacket.Member.Role.OWNER;
            this.filteredMembers.add(new MemberInfo(memberName, memberUUID, isAdmin, isOwner));
        }
        if (this.memberListWidget != null) {
            this.updateMemberListWidget();
            this.memberListWidget.method_25307(0.0);
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.leftPos = (this.field_22789 - 240) / 2;
        this.topPos = (this.field_22790 - 250) / 2;
        this.searchBox = new class_342(this.field_22793, this.leftPos + 20, this.topPos + 20 + 25, 200, 20, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.search"));
        this.searchBox.method_1880(32);
        this.searchBox.method_1858(true);
        this.searchBox.method_1856(true);
        this.searchBox.method_1868(0xFFFFFF);
        this.searchBox.method_1852("");
        this.searchBox.method_1863(s -> {
            System.out.println("\u641c\u7d22\u6846\u8f93\u5165: " + s);
            this.filterMembers((String)s);
        });
        this.method_37063((class_364)this.searchBox);
        this.memberListWidget = new MemberListWidget(this.field_22787, 200, 140, this.topPos + 20 + 50, this.topPos + 250 - 20 - 20 - 5, 24);
        this.memberListWidget.method_25333(this.leftPos + 20);
        this.method_37063((class_364)this.memberListWidget);
        this.backButton = new CustomButton(this.leftPos + 240 - 60 - 10, this.topPos + 250 - 20 - 10, 60, 20, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.back"), button -> this.method_25419());
        this.method_37063(this.backButton);
        this.applyButton = new CustomButton(this.leftPos + 10, this.topPos + 250 - 20 - 10, 60, 20, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.apply"), button -> this.applyChanges());
        this.applyButton.field_22763 = true;
        this.method_37063(this.applyButton);
        this.updateMemberListWidget();
    }

    private void updateMemberListWidget() {
        this.memberListWidget.method_25339();
        if (this.filteredMembers.isEmpty()) {
            return;
        }
        String currentPlayerName = class_310.method_1551().field_1724.method_5477().getString();
        boolean isCurrentPlayerOwnerOrAdmin = this.teamOwnerName.equals(currentPlayerName) || this.teamAdmins.contains(currentPlayerName);
        for (MemberInfo member : this.filteredMembers) {
            boolean canRemove;
            boolean isSelf = member.getName().equals(currentPlayerName);
            boolean canModify = this.teamOwnerName.equals(currentPlayerName);
            boolean bl = canRemove = isCurrentPlayerOwnerOrAdmin && !member.isOwner() && !isSelf;
            MemberListEntry.MemberRole initialRole = member.isOwner() ? MemberListEntry.MemberRole.OWNER : (member.isAdmin() ? MemberListEntry.MemberRole.ADMIN : MemberListEntry.MemberRole.MEMBER);
            MemberListEntry.MemberRole displayRole = this.roleChanges.containsKey(member.getUuid()) ? this.roleChanges.get(member.getUuid()) : initialRole;
            MemberListEntry entry = MemberListEntry.create(member.getName(), member.getUuid(), displayRole == MemberListEntry.MemberRole.ADMIN, displayRole == MemberListEntry.MemberRole.OWNER, isSelf, this.memberListWidget, canRemove ? this::removeMember : null, canModify ? this::onRoleChanged : null);
            this.memberListWidget.addEntry(entry);
        }
    }

    private void onRoleChanged(UUID memberUUID, MemberListEntry.MemberRole newRole) {
        this.roleChanges.put(memberUUID, newRole);
        this.hasChanges = true;
    }

    private void applyChanges() {
        if (!this.validateChanges()) {
            return;
        }
        HashMap<UUID, TeamMembersResponsePacket.Member.Role> serverRoleUpdates = new HashMap<UUID, TeamMembersResponsePacket.Member.Role>();
        for (Map.Entry<UUID, MemberListEntry.MemberRole> entry : this.roleChanges.entrySet()) {
            UUID memberUUID = entry.getKey();
            MemberListEntry.MemberRole clientRole = entry.getValue();
            TeamMembersResponsePacket.Member.Role serverRole = clientRole.toServerRole();
            serverRoleUpdates.put(memberUUID, serverRole);
        }
        ClientPacketHandler.sendTeamMemberRolesUpdate(this.teamUUID, serverRoleUpdates);
        this.roleChanges.clear();
        this.hasChanges = false;
        ClientPacketHandler.requestTeamMembers(this.teamUUID);
        this.field_22787.method_1507(this.parentScreen);
    }

    private boolean validateChanges() {
        int ownerCount = 0;
        UUID ownerUUID = null;
        TeamMembersResponsePacket cachedData = ClientPacketHandler.getLatestTeamMembersData();
        if (cachedData == null) {
            this.field_22787.method_1507((class_437)new MessageScreen(this, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.error"), (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.error.data_unavailable")));
            return false;
        }
        HashMap<UUID, MemberListEntry.MemberRole> currentRoles = new HashMap<UUID, MemberListEntry.MemberRole>();
        for (TeamMembersResponsePacket.Member member : cachedData.getMembers()) {
            TeamMembersResponsePacket.Member.Role serverRole = member.getRole();
            MemberListEntry.MemberRole role = MemberListEntry.MemberRole.fromServerRole(serverRole);
            currentRoles.put(member.getPlayerUUID(), role);
            if (role != MemberListEntry.MemberRole.OWNER) continue;
            ownerUUID = member.getPlayerUUID();
        }
        for (Map.Entry entry : this.roleChanges.entrySet()) {
            currentRoles.put((UUID)entry.getKey(), (MemberListEntry.MemberRole)((Object)entry.getValue()));
        }
        for (MemberListEntry.MemberRole memberRole : currentRoles.values()) {
            if (memberRole != MemberListEntry.MemberRole.OWNER) continue;
            ++ownerCount;
        }
        if (ownerCount == 0) {
            this.field_22787.method_1507((class_437)new MessageScreen(this, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.error"), (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.error.require_owner")));
            return false;
        }
        if (ownerCount > 1) {
            this.field_22787.method_1507((class_437)new MessageScreen(this, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.error"), (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.error.too_many_owners")));
            return false;
        }
        return true;
    }

    private void showErrorMessage(String message) {
        this.field_22787.method_1507((class_437)new MessageScreen(this, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.error"), (class_2561)class_2561.method_43470((String)message)));
    }

    private void removeMember(UUID memberUUID) {
        String memberName = "\u6b64\u6210\u5458";
        for (MemberInfo info : this.filteredMembers) {
            if (!info.getUuid().equals(memberUUID)) continue;
            memberName = info.getName();
            break;
        }
        String finalMemberName = memberName;
        this.field_22787.method_1507((class_437)new CustomConfirmScreen(this, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.confirm"), (class_2561)class_2561.method_43469((String)"ui.hundred_years_war.remove_member_confirm", (Object[])new Object[]{finalMemberName}), confirmed -> {
            if (confirmed) {
                ClientPacketHandler.requestTeamManage(this.teamUUID, "remove", memberUUID);
                ClientPacketHandler.requestTeamMembers(this.teamUUID);
            }
            class_310.method_1551().method_1507((class_437)this);
        }));
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.method_25294(this.leftPos, this.topPos, this.leftPos + 240, this.topPos + 250, -1073741824);
        guiGraphics.method_25294(this.leftPos, this.topPos, this.leftPos + 240, this.topPos + 1, -1);
        guiGraphics.method_25294(this.leftPos, this.topPos + 250 - 1, this.leftPos + 240, this.topPos + 250, -1);
        guiGraphics.method_25294(this.leftPos, this.topPos, this.leftPos + 1, this.topPos + 250, -1);
        guiGraphics.method_25294(this.leftPos + 240 - 1, this.topPos, this.leftPos + 240, this.topPos + 250, -1);
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.leftPos + 120, this.topPos + 10, 0xFFFFFF);
        if (this.filteredMembers.isEmpty()) {
            guiGraphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.no_members"), this.leftPos + 120, this.topPos + 125, 0xFFFFFF);
        }
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (this.searchBox.method_25400(codePoint, modifiers)) {
            return true;
        }
        return super.method_25400(codePoint, modifiers);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        if (this.searchBox.method_25370() && this.searchBox.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        if (this.hasChanges) {
            this.field_22787.method_1507((class_437)new CustomConfirmScreen(this, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.confirm"), (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.unsaved_changes_confirm"), confirmed -> {
                if (confirmed) {
                    class_310.method_1551().method_1507(this.parentScreen);
                } else {
                    class_310.method_1551().method_1507((class_437)this);
                }
            }));
            return;
        }
        class_310.method_1551().method_1507(this.parentScreen);
    }

    @Environment(value=EnvType.CLIENT)
    public static class MemberInfo {
        private final String name;
        private final UUID uuid;
        private final boolean isAdmin;
        private final boolean isOwner;

        public MemberInfo(String name, UUID uuid, boolean isAdmin, boolean isOwner) {
            this.name = name;
            this.uuid = uuid;
            this.isAdmin = isAdmin;
            this.isOwner = isOwner;
        }

        public String getName() {
            return this.name;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public boolean isAdmin() {
            return this.isAdmin;
        }

        public boolean isOwner() {
            return this.isOwner;
        }
    }

    @Environment(value=EnvType.CLIENT)
    class MessageScreen
    extends class_437 {
        private final class_437 parent;
        private final class_2561 message;
        private CustomButton okButton;

        public MessageScreen(class_437 parent, class_2561 title, class_2561 message) {
            super(title);
            this.parent = parent;
            this.message = message;
        }

        protected void method_25426() {
            super.method_25426();
            this.okButton = new CustomButton((this.field_22789 - 100) / 2, this.field_22790 / 2 + 40, 100, 20, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.ok"), button -> class_310.method_1551().method_1507(this.parent));
            this.method_37063(this.okButton);
        }

        public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.method_25420(guiGraphics);
            guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, this.field_22790 / 2 - 30, 0xFFFFFF);
            guiGraphics.method_27534(this.field_22793, this.message, this.field_22789 / 2, this.field_22790 / 2, 0xFFFFFF);
            super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
    }
}

