/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.freecam.ui.manual;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5489;
import ydmsama.hundred_years_war.freecam.ui.manual.ManualImage;

@Environment(value=EnvType.CLIENT)
public class ManualPage {
    private final class_5489 textLabel;
    private final List<ManualImage> images = new ArrayList<ManualImage>();
    private final int width;
    private final int lineHeight;

    public ManualPage(String text, List<ManualImage> images, int width, class_327 font, int lineHeight) {
        class_2561 textComponent = ManualPage.parseFormattedText(text);
        this.textLabel = class_5489.method_30890((class_327)font, (class_5348)textComponent, (int)width);
        this.images.addAll(images);
        this.width = width;
        this.lineHeight = lineHeight;
    }

    private static class_2561 parseFormattedText(String text) {
        Pattern formatPattern = Pattern.compile("\u00a7([0-9a-fk-or])");
        class_5250 result = class_2561.method_43473();
        int lastIndex = 0;
        class_124 currentColor = null;
        boolean bold = false;
        boolean italic = false;
        boolean underlined = false;
        boolean strikethrough = false;
        boolean obfuscated = false;
        Matcher matcher = formatPattern.matcher(text);
        while (matcher.find()) {
            char formatCode;
            String beforeFormat = text.substring(lastIndex, matcher.start());
            if (!beforeFormat.isEmpty()) {
                class_5250 textPart = class_2561.method_43470((String)beforeFormat);
                textPart = ManualPage.applyCurrentFormatting(textPart, currentColor, bold, italic, underlined, strikethrough, obfuscated);
                result.method_10852((class_2561)textPart);
            }
            if ((formatCode = matcher.group(1).charAt(0)) >= '0' && formatCode <= '9' || formatCode >= 'a' && formatCode <= 'f') {
                currentColor = ManualPage.getChatFormatting(formatCode);
                obfuscated = false;
                strikethrough = false;
                underlined = false;
                italic = false;
                bold = false;
            } else if (formatCode == 'r') {
                currentColor = null;
                obfuscated = false;
                strikethrough = false;
                underlined = false;
                italic = false;
                bold = false;
            } else {
                switch (formatCode) {
                    case 'l': {
                        bold = true;
                        break;
                    }
                    case 'o': {
                        italic = true;
                        break;
                    }
                    case 'n': {
                        underlined = true;
                        break;
                    }
                    case 'm': {
                        strikethrough = true;
                        break;
                    }
                    case 'k': {
                        obfuscated = true;
                    }
                }
            }
            lastIndex = matcher.end();
        }
        String remainingText = text.substring(lastIndex);
        if (!remainingText.isEmpty()) {
            class_5250 textPart = class_2561.method_43470((String)remainingText);
            textPart = ManualPage.applyCurrentFormatting(textPart, currentColor, bold, italic, underlined, strikethrough, obfuscated);
            result.method_10852((class_2561)textPart);
        }
        return result;
    }

    private static class_5250 applyCurrentFormatting(class_5250 component, class_124 color, boolean bold, boolean italic, boolean underlined, boolean strikethrough, boolean obfuscated) {
        if (color != null) {
            component = component.method_27692(color);
        }
        if (bold) {
            component = component.method_27692(class_124.field_1067);
        }
        if (italic) {
            component = component.method_27692(class_124.field_1056);
        }
        if (underlined) {
            component = component.method_27692(class_124.field_1073);
        }
        if (strikethrough) {
            component = component.method_27692(class_124.field_1055);
        }
        if (obfuscated) {
            component = component.method_27692(class_124.field_1051);
        }
        return component;
    }

    private static class_124 getChatFormatting(char code) {
        switch (code) {
            case '0': {
                return class_124.field_1074;
            }
            case '1': {
                return class_124.field_1058;
            }
            case '2': {
                return class_124.field_1077;
            }
            case '3': {
                return class_124.field_1062;
            }
            case '4': {
                return class_124.field_1079;
            }
            case '5': {
                return class_124.field_1064;
            }
            case '6': {
                return class_124.field_1065;
            }
            case '7': {
                return class_124.field_1080;
            }
            case '8': {
                return class_124.field_1063;
            }
            case '9': {
                return class_124.field_1078;
            }
            case 'a': {
                return class_124.field_1060;
            }
            case 'b': {
                return class_124.field_1075;
            }
            case 'c': {
                return class_124.field_1061;
            }
            case 'd': {
                return class_124.field_1076;
            }
            case 'e': {
                return class_124.field_1054;
            }
            case 'f': {
                return class_124.field_1068;
            }
            case 'k': {
                return class_124.field_1051;
            }
            case 'l': {
                return class_124.field_1067;
            }
            case 'm': {
                return class_124.field_1055;
            }
            case 'n': {
                return class_124.field_1073;
            }
            case 'o': {
                return class_124.field_1056;
            }
            case 'r': {
                return class_124.field_1070;
            }
        }
        return null;
    }

    public void render(class_332 guiGraphics, int x, int y, int color) {
        this.textLabel.method_30893(guiGraphics, x, y, this.lineHeight, color);
        for (ManualImage image : this.images) {
            image.render(guiGraphics, x, y);
        }
    }

    public void renderTooltips(class_332 guiGraphics, int mouseX, int mouseY, int x, int y) {
        for (ManualImage image : this.images) {
            image.renderTooltip(guiGraphics, mouseX, mouseY, x, y);
        }
    }

    public int getLineCount() {
        return this.textLabel.method_30887();
    }
}

