/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.freecam.util;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_4050;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class FreecamPosition {
    public double x;
    public double y;
    public double z;
    public float pitch;
    public float yaw;
    private final Quaternionf rotation = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
    private final Vector3f verticalPlane = new Vector3f(0.0f, 1.0f, 0.0f);
    private final Vector3f diagonalPlane = new Vector3f(1.0f, 0.0f, 0.0f);
    private final Vector3f horizontalPlane = new Vector3f(0.0f, 0.0f, 1.0f);

    public FreecamPosition(class_1297 entity) {
        this.x = entity.method_23317();
        this.y = FreecamPosition.getSwimmingY(entity);
        this.z = entity.method_23321();
        this.setRotation(entity.method_36454(), entity.method_36455());
    }

    public void setRotation(float yaw, float pitch) {
        this.pitch = pitch;
        this.yaw = yaw;
        this.rotation.rotationYXZ(-yaw * ((float)Math.PI / 180), pitch * ((float)Math.PI / 180), 0.0f);
        this.horizontalPlane.set(0.0f, 0.0f, 1.0f).rotate((Quaternionfc)this.rotation);
        this.verticalPlane.set(0.0f, 1.0f, 0.0f).rotate((Quaternionfc)this.rotation);
        this.diagonalPlane.set(1.0f, 0.0f, 0.0f).rotate((Quaternionfc)this.rotation);
    }

    public void mirrorRotation() {
        this.setRotation(this.yaw + 180.0f, -this.pitch);
    }

    public void moveForward(double distance) {
        this.move(distance, 0.0, 0.0);
    }

    public void moveUpward(double distance) {
        this.move(0.0, distance, 0.0);
    }

    public void move(double fwd, double up, double right) {
        this.x += (double)this.horizontalPlane.x() * fwd + (double)this.verticalPlane.x() * up + (double)this.diagonalPlane.x() * right;
        this.y += (double)this.horizontalPlane.y() * fwd + (double)this.verticalPlane.y() * up + (double)this.diagonalPlane.y() * right;
        this.z += (double)this.horizontalPlane.z() * fwd + (double)this.verticalPlane.z() * up + (double)this.diagonalPlane.z() * right;
    }

    public class_1923 getChunkPos() {
        return new class_1923((int)(this.x / 16.0), (int)(this.z / 16.0));
    }

    private static double getSwimmingY(class_1297 entity) {
        if (entity.method_18376() == class_4050.field_18079) {
            return entity.method_23318();
        }
        return entity.method_23318() - (double)entity.method_18381(class_4050.field_18079) + (double)entity.method_18381(entity.method_18376());
    }
}

