/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.mixins;

import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_761;
import net.minecraft.class_898;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ydmsama.hundred_years_war.entity.entities.tags.SiegeUnit;
import ydmsama.hundred_years_war.freecam.Freecam;
import ydmsama.hundred_years_war.freecam.selection.SelectionHandler;
import ydmsama.hundred_years_war.freecam.selection.TargetInfo;
import ydmsama.hundred_years_war.freecam.ui.wheel.CommandWheelHandler;
import ydmsama.hundred_years_war.utils.ClientRelationHelper;
import ydmsama.hundred_years_war.utils.RelationSystem;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_898.class})
public abstract class EntityRenderDispatcherMixin {
    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;popPose()V", shift=At.Shift.BEFORE)})
    private <E extends class_1297> void onRender(E entity, double x, double y, double z, float yaw, float tickDelta, class_4587 poseStack, class_4597 multiBufferSource, int light, CallbackInfo ci) {
        if (entity.method_5805() && (Freecam.isEnabled() || CommandWheelHandler.getInstance().shouldRenderCommandEffect())) {
            this.renderSelectedEntityBaseBox(entity, poseStack, multiBufferSource, x, y, z);
            this.renderTargetedEntityBaseBox(entity, poseStack, multiBufferSource, x, y, z);
            this.renderFollowedEntityBaseBox(entity, poseStack, multiBufferSource, x, y, z);
        }
    }

    @Unique
    private void renderSelectedEntityBaseBox(class_1297 entity, class_4587 poseStack, class_4597 multiBufferSource, double cameraX, double cameraY, double cameraZ) {
        if (this.isSelected(entity)) {
            float b;
            float g;
            float r;
            class_238 box = entity.method_5829().method_989(-entity.method_23317(), -entity.method_23318(), -entity.method_23321());
            double xOffset = 0.2;
            double zOffset = 0.2;
            if (entity instanceof SiegeUnit) {
                xOffset = 2.0;
                zOffset = 2.0;
            }
            double minX = box.field_1323 - xOffset;
            double minY = box.field_1322 + 0.2;
            double minZ = box.field_1321 - zOffset;
            double maxX = box.field_1320 + xOffset;
            double maxY = box.field_1322 + 0.2;
            double maxZ = box.field_1324 + zOffset;
            class_4588 vertexConsumer = multiBufferSource.getBuffer(class_1921.method_23594());
            ClientRelationHelper relationHelper = ClientRelationHelper.getInstance();
            RelationSystem.RelationType relationType = relationHelper.getRelationWithPlayer(entity);
            if (relationType == RelationSystem.RelationType.CONTROL) {
                r = 0.0f;
                g = 1.0f;
                b = 0.0f;
            } else if (relationType == RelationSystem.RelationType.HOSTILE) {
                r = 1.0f;
                g = 0.0f;
                b = 0.0f;
            } else {
                r = 1.0f;
                g = 1.0f;
                b = 0.0f;
            }
            class_761.method_22980((class_4587)poseStack, (class_4588)vertexConsumer, (double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (float)r, (float)g, (float)b, (float)1.0f);
        }
    }

    @Unique
    private void renderTargetedEntityBaseBox(class_1297 entity, class_4587 poseStack, class_4597 multiBufferSource, double cameraX, double cameraY, double cameraZ) {
        if (this.isTargeted(entity)) {
            class_238 box = entity.method_5829().method_989(-entity.method_23317(), -entity.method_23318(), -entity.method_23321());
            double xOffset = 0.25;
            double zOffset = 0.25;
            if (entity instanceof SiegeUnit) {
                xOffset = 2.4;
                zOffset = 2.4;
            }
            double minX = box.field_1323 - xOffset;
            double minY = box.field_1322 + 0.2;
            double minZ = box.field_1321 - zOffset;
            double maxX = box.field_1320 + xOffset;
            double maxY = box.field_1322 + 0.2;
            double maxZ = box.field_1324 + zOffset;
            class_4588 vertexConsumer = multiBufferSource.getBuffer(class_1921.method_23594());
            float r = 1.0f;
            float g = 0.0f;
            float b = 0.0f;
            class_761.method_22980((class_4587)poseStack, (class_4588)vertexConsumer, (double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (float)r, (float)g, (float)b, (float)1.0f);
        }
    }

    @Unique
    private boolean isSelected(class_1297 entity) {
        return SelectionHandler.getInstance().getSelectedEntities().contains(entity);
    }

    @Unique
    private boolean isTargeted(class_1297 entity) {
        Map<class_1297, CopyOnWriteArraySet<TargetInfo>> combinedTargetMap = SelectionHandler.getInstance().getCombinedTargetMap();
        for (Map.Entry<class_1297, CopyOnWriteArraySet<TargetInfo>> entry : combinedTargetMap.entrySet()) {
            class_1297 attacker = entry.getKey();
            CopyOnWriteArraySet<TargetInfo> targets = entry.getValue();
            for (TargetInfo targetInfo : targets) {
                if (!"entityTarget".equals(targetInfo.getType()) || !entity.equals((Object)targetInfo.getHywTarget()) || !this.isSelected(attacker)) continue;
                return true;
            }
        }
        return false;
    }

    @Unique
    private void renderFollowedEntityBaseBox(class_1297 entity, class_4587 poseStack, class_4597 multiBufferSource, double cameraX, double cameraY, double cameraZ) {
        if (this.isFollowed(entity)) {
            class_238 box = entity.method_5829().method_989(-entity.method_23317(), -entity.method_23318(), -entity.method_23321());
            double xOffset = 0.3;
            double zOffset = 0.3;
            if (entity instanceof SiegeUnit) {
                xOffset = 2.8;
                zOffset = 2.8;
            }
            double minX = box.field_1323 - xOffset;
            double minY = box.field_1322 + 0.2;
            double minZ = box.field_1321 - zOffset;
            double maxX = box.field_1320 + xOffset;
            double maxY = box.field_1322 + 0.2;
            double maxZ = box.field_1324 + zOffset;
            class_4588 vertexConsumer = multiBufferSource.getBuffer(class_1921.method_23594());
            float r = 0.0f;
            float g = 1.0f;
            float b = 0.0f;
            class_761.method_22980((class_4587)poseStack, (class_4588)vertexConsumer, (double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (float)r, (float)g, (float)b, (float)1.0f);
        }
    }

    @Unique
    private boolean isFollowed(class_1297 entity) {
        Map<class_1297, CopyOnWriteArraySet<TargetInfo>> combinedTargetMap = SelectionHandler.getInstance().getCombinedTargetMap();
        for (Map.Entry<class_1297, CopyOnWriteArraySet<TargetInfo>> entry : combinedTargetMap.entrySet()) {
            class_1297 follower = entry.getKey();
            CopyOnWriteArraySet<TargetInfo> followedEntities = entry.getValue();
            for (TargetInfo targetInfo : followedEntities) {
                if (!"followTarget".equals(targetInfo.getType()) || !entity.equals((Object)targetInfo.getHywTarget()) || !this.isSelected(follower)) continue;
                return true;
            }
        }
        return false;
    }
}

