/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.models;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5597;
import net.minecraft.class_5601;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_583;
import net.minecraft.class_630;
import ydmsama.hundred_years_war.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.models.animation.HorseIdleAnimation;

@Environment(value=EnvType.CLIENT)
public class HywHorseModel
extends class_5597<BaseCombatEntity> {
    public static final class_5601 LAYER_LOCATION = new class_5601(new class_2960("hundred_years_war", "horsemodel"), "main");
    private final boolean scaleHead = true;
    private final float babyYHeadOffset = 16.2f;
    private final float babyZHeadOffset = 1.36f;
    private final float babyHeadScale = 2.7272f;
    private final float babyBodyScale = 2.0f;
    private final float bodyYOffset = 20.0f;
    private final class_630 root;
    protected final class_630 body;
    protected final class_630 headParts;
    private final class_630 rightHindLeg;
    private final class_630 leftHindLeg;
    private final class_630 rightFrontLeg;
    private final class_630 leftFrontLeg;
    private final class_630 rightHindBabyLeg;
    private final class_630 leftHindBabyLeg;
    private final class_630 rightFrontBabyLeg;
    private final class_630 leftFrontBabyLeg;
    private final class_630 tail;
    private final class_630[] saddleParts;
    private final class_630[] ridingParts;

    public HywHorseModel(class_630 root) {
        this.root = root;
        this.body = root.method_32086("body");
        this.headParts = root.method_32086("head_parts");
        this.rightHindLeg = root.method_32086("right_hind_leg");
        this.leftHindLeg = root.method_32086("left_hind_leg");
        this.rightFrontLeg = root.method_32086("right_front_leg");
        this.leftFrontLeg = root.method_32086("left_front_leg");
        this.rightHindBabyLeg = root.method_32086("right_hind_baby_leg");
        this.leftHindBabyLeg = root.method_32086("left_hind_baby_leg");
        this.rightFrontBabyLeg = root.method_32086("right_front_baby_leg");
        this.leftFrontBabyLeg = root.method_32086("left_front_baby_leg");
        this.tail = this.body.method_32086("tail");
        class_630 modelPart2 = this.body.method_32086("saddle");
        class_630 modelPart3 = this.headParts.method_32086("left_saddle_mouth");
        class_630 modelPart4 = this.headParts.method_32086("right_saddle_mouth");
        class_630 modelPart5 = this.headParts.method_32086("left_saddle_line");
        class_630 modelPart6 = this.headParts.method_32086("right_saddle_line");
        class_630 modelPart7 = this.headParts.method_32086("head_saddle");
        class_630 modelPart8 = this.headParts.method_32086("mouth_saddle_wrap");
        this.saddleParts = new class_630[]{modelPart2, modelPart3, modelPart4, modelPart7, modelPart8};
        this.ridingParts = new class_630[]{modelPart5, modelPart6};
    }

    public static class_5607 createBodyLayer() {
        class_5609 meshDefinition = new class_5609();
        class_5610 partDefinition = meshDefinition.method_32111();
        class_5610 body = partDefinition.method_32117("body", class_5606.method_32108().method_32101(0, 32).method_32098(-5.0f, -8.0f, -17.0f, 10.0f, 10.0f, 22.0f, new class_5605(0.05f)), class_5603.method_32090((float)0.0f, (float)11.0f, (float)5.0f));
        class_5610 headParts = partDefinition.method_32117("head_parts", class_5606.method_32108().method_32101(0, 35).method_32097(-2.05f, -6.0f, -2.0f, 4.0f, 12.0f, 7.0f), class_5603.method_32091((float)0.0f, (float)4.0f, (float)-12.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        class_5610 head = headParts.method_32117("head", class_5606.method_32108().method_32101(0, 13).method_32098(-3.0f, -11.0f, -2.0f, 6.0f, 5.0f, 7.0f, new class_5605(0.0f)), class_5603.field_27701);
        headParts.method_32117("mane", class_5606.method_32108().method_32101(56, 36).method_32098(-1.0f, -11.0f, 5.01f, 2.0f, 16.0f, 2.0f, new class_5605(0.0f)), class_5603.field_27701);
        headParts.method_32117("upper_mouth", class_5606.method_32108().method_32101(0, 25).method_32098(-2.0f, -11.0f, -7.0f, 4.0f, 5.0f, 5.0f, new class_5605(0.0f)), class_5603.field_27701);
        partDefinition.method_32117("left_hind_leg", class_5606.method_32108().method_32101(48, 21).method_32096().method_32098(-3.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, new class_5605(0.0f)), class_5603.method_32090((float)4.0f, (float)14.0f, (float)7.0f));
        partDefinition.method_32117("right_hind_leg", class_5606.method_32108().method_32101(48, 21).method_32098(-1.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, new class_5605(0.0f)), class_5603.method_32090((float)-4.0f, (float)14.0f, (float)7.0f));
        partDefinition.method_32117("left_front_leg", class_5606.method_32108().method_32101(48, 21).method_32096().method_32098(-3.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, new class_5605(0.0f)), class_5603.method_32090((float)4.0f, (float)14.0f, (float)-12.0f));
        partDefinition.method_32117("right_front_leg", class_5606.method_32108().method_32101(48, 21).method_32098(-1.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, new class_5605(0.0f)), class_5603.method_32090((float)-4.0f, (float)14.0f, (float)-12.0f));
        class_5605 cubeDeformation2 = new class_5605(0.0f).method_32095(0.0f, 5.5f, 0.0f);
        partDefinition.method_32117("left_hind_baby_leg", class_5606.method_32108().method_32101(48, 21).method_32096().method_32098(-3.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, cubeDeformation2), class_5603.method_32090((float)4.0f, (float)14.0f, (float)7.0f));
        partDefinition.method_32117("right_hind_baby_leg", class_5606.method_32108().method_32101(48, 21).method_32098(-1.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, cubeDeformation2), class_5603.method_32090((float)-4.0f, (float)14.0f, (float)7.0f));
        partDefinition.method_32117("left_front_baby_leg", class_5606.method_32108().method_32101(48, 21).method_32096().method_32098(-3.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, cubeDeformation2), class_5603.method_32090((float)4.0f, (float)14.0f, (float)-12.0f));
        partDefinition.method_32117("right_front_baby_leg", class_5606.method_32108().method_32101(48, 21).method_32098(-1.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, cubeDeformation2), class_5603.method_32090((float)-4.0f, (float)14.0f, (float)-12.0f));
        body.method_32117("tail", class_5606.method_32108().method_32101(42, 36).method_32098(-1.5f, 0.0f, 0.0f, 3.0f, 14.0f, 4.0f, new class_5605(0.0f)), class_5603.method_32091((float)0.0f, (float)-5.0f, (float)2.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        body.method_32117("saddle", class_5606.method_32108().method_32101(26, 0).method_32098(-5.0f, -8.0f, -9.0f, 10.0f, 9.0f, 9.0f, new class_5605(0.5f)), class_5603.field_27701);
        headParts.method_32117("left_saddle_mouth", class_5606.method_32108().method_32101(29, 5).method_32098(2.0f, -9.0f, -6.0f, 1.0f, 2.0f, 2.0f, new class_5605(0.0f)), class_5603.field_27701);
        headParts.method_32117("right_saddle_mouth", class_5606.method_32108().method_32101(29, 5).method_32098(-3.0f, -9.0f, -6.0f, 1.0f, 2.0f, 2.0f, new class_5605(0.0f)), class_5603.field_27701);
        headParts.method_32117("left_saddle_line", class_5606.method_32108().method_32101(32, 2).method_32097(3.1f, -6.0f, -8.0f, 0.0f, 3.0f, 16.0f), class_5603.method_32092((float)-0.5235988f, (float)0.0f, (float)0.0f));
        headParts.method_32117("right_saddle_line", class_5606.method_32108().method_32101(32, 2).method_32097(-3.1f, -6.0f, -8.0f, 0.0f, 3.0f, 16.0f), class_5603.method_32092((float)-0.5235988f, (float)0.0f, (float)0.0f));
        headParts.method_32117("head_saddle", class_5606.method_32108().method_32101(1, 1).method_32098(-3.0f, -11.0f, -1.9f, 6.0f, 5.0f, 6.0f, new class_5605(0.22f)), class_5603.field_27701);
        headParts.method_32117("mouth_saddle_wrap", class_5606.method_32108().method_32101(19, 0).method_32098(-2.0f, -11.0f, -4.0f, 4.0f, 5.0f, 2.0f, new class_5605(0.2f)), class_5603.field_27701);
        head.method_32117("left_ear", class_5606.method_32108().method_32101(19, 16).method_32098(0.55f, -13.0f, 4.0f, 2.0f, 3.0f, 1.0f, new class_5605(-0.001f)), class_5603.field_27701);
        head.method_32117("right_ear", class_5606.method_32108().method_32101(19, 16).method_32098(-2.55f, -13.0f, 4.0f, 2.0f, 3.0f, 1.0f, new class_5605(-0.001f)), class_5603.field_27701);
        return class_5607.method_32110((class_5609)meshDefinition, (int)64, (int)64);
    }

    public void method_2828(class_4587 poseStack, class_4588 vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.field_3448) {
            poseStack.method_22903();
            Objects.requireNonNull(this);
            float scale = 1.5f / this.babyHeadScale;
            poseStack.method_22905(scale, scale, scale);
            poseStack.method_46416(0.0f, this.babyYHeadOffset / 16.0f, this.babyZHeadOffset / 16.0f);
            this.headParts().forEach(modelPart -> modelPart.method_22699(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha));
            poseStack.method_22909();
            poseStack.method_22903();
            scale = 1.0f / this.babyBodyScale;
            poseStack.method_22905(scale, scale, scale);
            poseStack.method_46416(0.0f, this.bodyYOffset / 16.0f, 0.0f);
            this.bodyParts().forEach(modelPart -> modelPart.method_22699(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha));
            poseStack.method_22909();
        } else {
            this.headParts().forEach(modelPart -> modelPart.method_22699(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha));
            this.bodyParts().forEach(modelPart -> modelPart.method_22699(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha));
        }
    }

    public class_630 method_32008() {
        return this.root;
    }

    protected Iterable<class_630> headParts() {
        return ImmutableList.of((Object)this.headParts);
    }

    protected Iterable<class_630> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg, (Object)this.rightHindBabyLeg, (Object)this.leftHindBabyLeg, (Object)this.rightFrontBabyLeg, (Object)this.leftFrontBabyLeg);
    }

    public void setupAnim(BaseCombatEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.method_32008().method_32088().forEach(class_630::method_41923);
        boolean bl = true;
        boolean bl2 = entity.method_5782();
        for (class_630 modelPart : this.saddleParts) {
            modelPart.field_3665 = bl;
        }
        for (class_630 modelPart : this.ridingParts) {
            modelPart.field_3665 = bl2 && bl;
        }
        float i = class_3532.method_17821((float)0.0f, (float)entity.field_6220, (float)entity.field_6283);
        float j = class_3532.method_17821((float)0.0f, (float)entity.field_6259, (float)entity.field_6241);
        float k = class_3532.method_16439((float)0.0f, (float)entity.field_6004, (float)entity.method_36455());
        float l = j - i;
        float m = k * ((float)Math.PI / 180);
        if (l > 20.0f) {
            l = 20.0f;
        }
        if (l < -20.0f) {
            l = -20.0f;
        }
        if (limbSwingAmount > 0.2f) {
            m += class_3532.method_15362((float)(limbSwing * 0.8f)) * 0.15f * limbSwingAmount;
        }
        float n = 0.0f;
        float o = 0.0f;
        float p = 1.0f - o;
        float q = 0.0f;
        boolean bl3 = false;
        float r = (float)entity.field_6012 + ageInTicks;
        this.headParts.field_3656 = 4.0f;
        this.headParts.field_3655 = -12.0f;
        this.body.field_3654 = 0.0f;
        this.headParts.field_3654 = 0.5235988f + m;
        this.headParts.field_3675 = l * ((float)Math.PI / 180);
        float s = entity.method_5799() ? 0.2f : 1.0f;
        float t = class_3532.method_15362((float)(s * limbSwing * 0.6662f + (float)Math.PI));
        float u = t * 0.8f * limbSwingAmount;
        float v = (1.0f - Math.max(o, n)) * (0.5235988f + m + q * class_3532.method_15374((float)r) * 0.05f);
        this.headParts.field_3654 = o * (0.2617994f + m) + n * (2.1816616f + class_3532.method_15374((float)r) * 0.05f) + v;
        this.headParts.field_3675 = o * l * ((float)Math.PI / 180) + (1.0f - Math.max(o, n)) * this.headParts.field_3675;
        this.headParts.field_3656 = o * -4.0f + n * 11.0f + (1.0f - Math.max(o, n)) * this.headParts.field_3656;
        this.headParts.field_3655 = o * -4.0f + n * -12.0f + (1.0f - Math.max(o, n)) * this.headParts.field_3655;
        this.body.field_3654 = o * -0.7853982f + p * this.body.field_3654;
        float w = 0.2617994f * o;
        float x = class_3532.method_15362((float)(r * 0.6f + (float)Math.PI));
        this.leftFrontLeg.field_3656 = 2.0f * o + 14.0f * p;
        this.leftFrontLeg.field_3655 = -6.0f * o - 10.0f * p;
        this.rightFrontLeg.field_3656 = this.leftFrontLeg.field_3656;
        this.rightFrontLeg.field_3655 = this.leftFrontLeg.field_3655;
        float legSwingMultiplier = 1.2f;
        float frontLegSwing = t * 0.8f * limbSwingAmount * legSwingMultiplier * p;
        float hindLegSwing = t * 0.8f * limbSwingAmount * legSwingMultiplier * p;
        this.leftFrontLeg.field_3654 = w + frontLegSwing;
        this.rightFrontLeg.field_3654 = w - frontLegSwing;
        this.leftHindLeg.field_3654 = w - hindLegSwing;
        this.rightHindLeg.field_3654 = w + hindLegSwing;
        this.tail.field_3654 = 0.5235988f + limbSwingAmount * 0.75f;
        this.tail.field_3656 = -5.0f + limbSwingAmount;
        this.tail.field_3655 = 2.0f + limbSwingAmount * 2.0f;
        this.tail.field_3675 = bl3 ? class_3532.method_15362((float)(r * 0.7f)) : 0.0f;
        this.rightHindBabyLeg.field_3656 = this.rightHindLeg.field_3656;
        this.rightHindBabyLeg.field_3655 = this.rightHindLeg.field_3655;
        this.rightHindBabyLeg.field_3654 = this.rightHindLeg.field_3654;
        this.leftHindBabyLeg.field_3656 = this.leftHindLeg.field_3656;
        this.leftHindBabyLeg.field_3655 = this.leftHindLeg.field_3655;
        this.leftHindBabyLeg.field_3654 = this.leftHindLeg.field_3654;
        this.rightFrontBabyLeg.field_3656 = this.rightFrontLeg.field_3656;
        this.rightFrontBabyLeg.field_3655 = this.rightFrontLeg.field_3655;
        this.rightFrontBabyLeg.field_3654 = this.rightFrontLeg.field_3654;
        this.leftFrontBabyLeg.field_3656 = this.leftFrontLeg.field_3656;
        this.leftFrontBabyLeg.field_3655 = this.leftFrontLeg.field_3655;
        this.leftFrontBabyLeg.field_3654 = this.leftFrontLeg.field_3654;
        boolean bl4 = false;
        this.rightHindLeg.field_3665 = !bl4;
        this.leftHindLeg.field_3665 = !bl4;
        this.rightFrontLeg.field_3665 = !bl4;
        this.leftFrontLeg.field_3665 = !bl4;
        this.rightHindBabyLeg.field_3665 = bl4;
        this.leftHindBabyLeg.field_3665 = bl4;
        this.rightFrontBabyLeg.field_3665 = bl4;
        this.leftFrontBabyLeg.field_3665 = bl4;
        this.method_43781(entity.idleAnimationState, HorseIdleAnimation.idle, ageInTicks);
    }

    public class_630 getBody() {
        return this.body;
    }

    public class_630 getHeadParts() {
        return this.headParts;
    }

    public class_630 getLeftFrontLeg() {
        return this.leftFrontLeg;
    }

    public class_630 getLeftHindLeg() {
        return this.leftHindLeg;
    }

    public class_630 getRightFrontLeg() {
        return this.rightFrontLeg;
    }

    public class_630 getRightHindLeg() {
        return this.rightHindLeg;
    }

    public class_630 getLeftFrontBabyLeg() {
        return this.leftFrontBabyLeg;
    }

    public class_630 getLeftHindBabyLeg() {
        return this.leftHindBabyLeg;
    }

    public class_630 getRightFrontBabyLeg() {
        return this.rightFrontBabyLeg;
    }

    public class_630 getRightHindBabyLeg() {
        return this.rightHindBabyLeg;
    }

    public void copyPropertiesTo(HywHorseModel other) {
        super.method_17081((class_583)other);
        other.body.method_17138(this.body);
        other.headParts.method_17138(this.headParts);
        other.rightHindLeg.method_17138(this.rightHindLeg);
        other.leftHindLeg.method_17138(this.leftHindLeg);
        other.rightFrontLeg.method_17138(this.rightFrontLeg);
        other.leftFrontLeg.method_17138(this.leftFrontLeg);
        other.rightHindBabyLeg.method_17138(this.rightHindBabyLeg);
        other.leftHindBabyLeg.method_17138(this.leftHindBabyLeg);
        other.rightFrontBabyLeg.method_17138(this.rightFrontBabyLeg);
        other.leftFrontBabyLeg.method_17138(this.leftFrontBabyLeg);
        other.tail.method_17138(this.tail);
    }
}

