/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.network.packets;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.network.packets.RelationResponsePacket;
import ydmsama.hundred_years_war.utils.PlayerRelationData;
import ydmsama.hundred_years_war.utils.RelationData;
import ydmsama.hundred_years_war.utils.RelationSystem;
import ydmsama.hundred_years_war.utils.TeamRelationData;

public class RelationRequestPacket {
    public static final class_2960 RELATION_REQUEST_PACKET_ID = new class_2960("hundred_years_war", "relation_request_packet");

    public RelationRequestPacket() {
    }

    public RelationRequestPacket(class_2540 buf) {
    }

    public void encode(class_2540 buf) {
    }

    public static RelationRequestPacket decode(class_2540 buf) {
        return new RelationRequestPacket(buf);
    }

    public static void handle(class_3222 player) {
        RelationResponsePacket responsePacket = new RelationResponsePacket();
        class_2540 responseBuf = PacketByteBufs.create();
        UUID playerUUID = player.method_5667();
        PlayerRelationData playerData = RelationSystem.getOrCreatePlayerRelationData(playerUUID, player.method_5477().getString());
        List<UUID> playerTeams = RelationSystem.getPlayerTeams(playerUUID);
        for (Map.Entry<UUID, RelationData> entry : RelationSystem.getAllRelationData().entrySet()) {
            RelationSystem.RelationType theirRelation;
            RelationSystem.RelationType myRelation;
            UUID targetUUID = entry.getKey();
            RelationData relationData = entry.getValue();
            if (relationData instanceof PlayerRelationData) {
                PlayerRelationData targetPlayerData = (PlayerRelationData)relationData;
                if (targetUUID.equals(playerUUID)) continue;
                myRelation = RelationSystem.getRelation(playerUUID, targetUUID);
                theirRelation = RelationSystem.getRelation(targetUUID, playerUUID);
                responsePacket.addRelationInfo(targetUUID, targetPlayerData.getPlayerName(), myRelation, theirRelation);
                continue;
            }
            if (!(relationData instanceof TeamRelationData)) continue;
            TeamRelationData teamData = (TeamRelationData)relationData;
            myRelation = RelationSystem.getRelation(playerUUID, targetUUID);
            theirRelation = RelationSystem.getRelation(targetUUID, playerUUID);
            responsePacket.addTeamInfo(targetUUID, teamData.getTeamName(), myRelation, teamData.getAllMembers(), playerTeams, theirRelation);
        }
        responsePacket.encode(responseBuf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)RelationResponsePacket.RELATION_RESPONSE_PACKET_ID, (class_2540)responseBuf);
    }
}

