/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.selection.SelectionSystem;

public class SelectionPacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "selection_packet");
    private final List<UUID> selectedEntityIds;

    public SelectionPacket(List<UUID> selectedEntityIds) {
        this.selectedEntityIds = selectedEntityIds;
    }

    public SelectionPacket(class_2540 buf) {
        int size = buf.readInt();
        this.selectedEntityIds = new ArrayList<UUID>();
        for (int i = 0; i < size; ++i) {
            UUID id = buf.method_10790();
            this.selectedEntityIds.add(id);
        }
    }

    public void encode(class_2540 buf) {
        buf.writeInt(this.selectedEntityIds.size());
        for (UUID id : this.selectedEntityIds) {
            buf.method_10797(id);
        }
    }

    public static SelectionPacket decode(class_2540 buf) {
        return new SelectionPacket(buf);
    }

    public static void handle(class_3222 player, SelectionPacket packet) {
        Optional.ofNullable(SelectionSystem.getSelection(player)).ifPresent(SelectionSystem.Selection::clear);
        if (!packet.selectedEntityIds.isEmpty()) {
            SelectionSystem.addEntitiesToSelection(player, packet.selectedEntityIds);
        }
    }
}

