/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.network.packets.TeamInfoResponsePacket;
import ydmsama.hundred_years_war.utils.RelationSystem;
import ydmsama.hundred_years_war.utils.TeamRelationData;

public class TeamInfoRequestPacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "team_info_request");

    public TeamInfoRequestPacket() {
    }

    public TeamInfoRequestPacket(class_2540 buf) {
    }

    public void encode(class_2540 buf) {
    }

    public static TeamInfoRequestPacket decode(class_2540 buf) {
        return new TeamInfoRequestPacket(buf);
    }

    public static void handle(class_3222 player) {
        UUID playerUUID = player.method_5667();
        List<UUID> playerTeams = RelationSystem.getPlayerTeams(playerUUID);
        if (!playerTeams.isEmpty()) {
            UUID teamUUID = playerTeams.get(0);
            TeamRelationData teamData = RelationSystem.getTeamRelationData(teamUUID);
            if (teamData != null) {
                Map<UUID, TeamRelationData.MemberType> allMembers = teamData.getAllMembers();
                UUID ownerUUID = null;
                for (Map.Entry<UUID, TeamRelationData.MemberType> entry : allMembers.entrySet()) {
                    if (entry.getValue() != TeamRelationData.MemberType.OWNER) continue;
                    ownerUUID = entry.getKey();
                    break;
                }
                String ownerName = ownerUUID != null ? Optional.ofNullable(player.method_5682().method_3760().method_14602(ownerUUID)).map(p -> p.method_5477().getString()).orElse("Unknown") : "Unknown";
                ArrayList<String> memberNames = new ArrayList<String>();
                ArrayList<String> adminNames = new ArrayList<String>();
                for (Map.Entry<UUID, TeamRelationData.MemberType> entry : allMembers.entrySet()) {
                    UUID memberUUID = entry.getKey();
                    TeamRelationData.MemberType memberType = entry.getValue();
                    String memberName = Optional.ofNullable(player.method_5682().method_3760().method_14602(memberUUID)).map(p -> p.method_5477().getString()).orElse("Unknown");
                    if (memberType == TeamRelationData.MemberType.MEMBER) {
                        memberNames.add(memberName);
                        continue;
                    }
                    if (memberType != TeamRelationData.MemberType.ADMIN) continue;
                    adminNames.add(memberName);
                }
                ArrayList<String> pendingNames = new ArrayList<String>();
                for (UUID applicantUUID : teamData.getPendingApplications()) {
                    String applicantName = Optional.ofNullable(player.method_5682().method_3760().method_14602(applicantUUID)).map(p -> p.method_5477().getString()).orElse("Unknown");
                    pendingNames.add(applicantName);
                }
                TeamInfoResponsePacket teamInfoResponsePacket = new TeamInfoResponsePacket(true, teamData.getTeamName(), teamUUID, ownerName, memberNames, adminNames, pendingNames);
                class_2540 responseBuf = PacketByteBufs.create();
                teamInfoResponsePacket.encode(responseBuf);
                ServerPlayNetworking.send((class_3222)player, (class_2960)TeamInfoResponsePacket.ID, (class_2540)responseBuf);
            } else {
                TeamInfoRequestPacket.sendEmptyTeamInfoResponse(player);
            }
        } else {
            TeamInfoRequestPacket.sendEmptyTeamInfoResponse(player);
        }
    }

    private static void sendEmptyTeamInfoResponse(class_3222 player) {
        TeamInfoResponsePacket responsePacket = new TeamInfoResponsePacket(false, "", new UUID(0L, 0L), "", new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>());
        class_2540 responseBuf = PacketByteBufs.create();
        responsePacket.encode(responseBuf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)TeamInfoResponsePacket.ID, (class_2540)responseBuf);
    }
}

