/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class TeamInfoResponsePacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "team_info_response");
    private final boolean isInTeam;
    private final String teamName;
    private final UUID teamUUID;
    private final String teamOwnerName;
    private final List<String> teamMembers;
    private final List<String> teamAdmins;
    private final List<String> pendingApplications;

    public TeamInfoResponsePacket(boolean isInTeam, String teamName, UUID teamUUID, String teamOwnerName, List<String> teamMembers, List<String> teamAdmins, List<String> pendingApplications) {
        this.isInTeam = isInTeam;
        this.teamName = teamName;
        this.teamUUID = teamUUID;
        this.teamOwnerName = teamOwnerName;
        this.teamMembers = teamMembers;
        this.teamAdmins = teamAdmins;
        this.pendingApplications = pendingApplications;
    }

    public TeamInfoResponsePacket(class_2540 buf) {
        this.isInTeam = buf.readBoolean();
        if (this.isInTeam) {
            this.teamName = buf.method_19772();
            this.teamUUID = buf.method_10790();
            this.teamOwnerName = buf.method_19772();
            int membersCount = buf.method_10816();
            this.teamMembers = new ArrayList<String>(membersCount);
            for (int i = 0; i < membersCount; ++i) {
                this.teamMembers.add(buf.method_19772());
            }
            int adminsCount = buf.method_10816();
            this.teamAdmins = new ArrayList<String>(adminsCount);
            for (int i = 0; i < adminsCount; ++i) {
                this.teamAdmins.add(buf.method_19772());
            }
            int pendingCount = buf.method_10816();
            this.pendingApplications = new ArrayList<String>(pendingCount);
            for (int i = 0; i < pendingCount; ++i) {
                this.pendingApplications.add(buf.method_19772());
            }
        } else {
            this.teamName = "";
            this.teamUUID = new UUID(0L, 0L);
            this.teamOwnerName = "";
            this.teamMembers = new ArrayList<String>();
            this.teamAdmins = new ArrayList<String>();
            this.pendingApplications = new ArrayList<String>();
        }
    }

    public void encode(class_2540 buf) {
        buf.writeBoolean(this.isInTeam);
        if (this.isInTeam) {
            buf.method_10814(this.teamName);
            buf.method_10797(this.teamUUID);
            buf.method_10814(this.teamOwnerName);
            buf.method_10804(this.teamMembers.size());
            for (String member : this.teamMembers) {
                buf.method_10814(member);
            }
            buf.method_10804(this.teamAdmins.size());
            for (String admin : this.teamAdmins) {
                buf.method_10814(admin);
            }
            buf.method_10804(this.pendingApplications.size());
            for (String pending : this.pendingApplications) {
                buf.method_10814(pending);
            }
        }
    }

    public static TeamInfoResponsePacket decode(class_2540 buf) {
        return new TeamInfoResponsePacket(buf);
    }

    public boolean isInTeam() {
        return this.isInTeam;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public UUID getTeamUUID() {
        return this.teamUUID;
    }

    public String getTeamOwnerName() {
        return this.teamOwnerName;
    }

    public List<String> getTeamMembers() {
        return this.teamMembers;
    }

    public List<String> getTeamAdmins() {
        return this.teamAdmins;
    }

    public List<String> getPendingApplications() {
        return this.pendingApplications;
    }
}

