/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.network.packets;

import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.network.packets.TeamRelationResponsePacket;
import ydmsama.hundred_years_war.utils.PlayerRelationData;
import ydmsama.hundred_years_war.utils.RelationData;
import ydmsama.hundred_years_war.utils.RelationSystem;
import ydmsama.hundred_years_war.utils.TeamRelationData;

public class TeamRelationRequestPacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "team_relation_request_packet");
    private final UUID teamUUID;

    public TeamRelationRequestPacket(UUID teamUUID) {
        this.teamUUID = teamUUID;
    }

    public void encode(class_2540 buf) {
        buf.method_10797(this.teamUUID);
    }

    public static TeamRelationRequestPacket decode(class_2540 buf) {
        UUID teamUUID = buf.method_10790();
        return new TeamRelationRequestPacket(teamUUID);
    }

    public static void handle(class_3222 player, UUID teamUUID) {
        TeamRelationData teamData = RelationSystem.getTeamRelationData(teamUUID);
        if (teamData == null) {
            return;
        }
        if (!teamData.isMember(player.method_5667())) {
            return;
        }
        class_2540 responseBuf = PacketByteBufs.create();
        TeamRelationResponsePacket responsePacket = new TeamRelationResponsePacket(teamUUID);
        for (Map.Entry<UUID, RelationData> entry : RelationSystem.getAllRelationData().entrySet()) {
            UUID targetUUID = entry.getKey();
            RelationData relationData = entry.getValue();
            if (targetUUID.equals(teamUUID) || teamData.isMember(targetUUID)) continue;
            if (relationData instanceof PlayerRelationData) {
                PlayerRelationData targetPlayerData = (PlayerRelationData)relationData;
                RelationSystem.RelationType teamToPlayerRelation = RelationSystem.getRelation(teamUUID, targetUUID);
                RelationSystem.RelationType playerToTeamRelation = RelationSystem.getRelation(targetUUID, teamUUID);
                responsePacket.addRelationInfo(targetUUID, targetPlayerData.getPlayerName(), teamToPlayerRelation, playerToTeamRelation);
                continue;
            }
            if (!(relationData instanceof TeamRelationData)) continue;
            TeamRelationData otherTeamData = (TeamRelationData)relationData;
            RelationSystem.RelationType teamToTeamRelation = RelationSystem.getRelation(teamUUID, targetUUID);
            RelationSystem.RelationType otherTeamToTeamRelation = RelationSystem.getRelation(targetUUID, teamUUID);
            responsePacket.addTeamInfo(targetUUID, otherTeamData.getTeamName(), teamToTeamRelation, otherTeamData.getAllMembers(), otherTeamToTeamRelation);
        }
        responsePacket.encode(responseBuf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)TeamRelationResponsePacket.ID, (class_2540)responseBuf);
    }

    public UUID getTeamUUID() {
        return this.teamUUID;
    }
}

