/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.recruitment;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;

public class PlayerRecruitmentData {
    private static final Map<UUID, RecruitmentSelection> playerConfigs = new HashMap<UUID, RecruitmentSelection>();

    public static RecruitmentSelection getPlayerSelection(class_1657 player) {
        UUID playerUUID = player.method_5667();
        return playerConfigs.computeIfAbsent(playerUUID, k -> new RecruitmentSelection());
    }

    public static void setPlayerSelection(class_1657 player, RecruitmentSelection selection) {
        UUID playerUUID = player.method_5667();
        playerConfigs.put(playerUUID, selection);
    }

    public static void updatePlayerCategory(class_1657 player, String categoryId) {
        RecruitmentSelection selection = PlayerRecruitmentData.getPlayerSelection(player);
        selection.setCategoryId(categoryId);
        PlayerRecruitmentData.resetToDefaultForCategory(selection, categoryId);
    }

    public static void updatePlayerUnitType(class_1657 player, String unitTypeId) {
        RecruitmentSelection selection = PlayerRecruitmentData.getPlayerSelection(player);
        selection.setUnitTypeId(unitTypeId);
        selection.setLevel(1);
    }

    public static void updatePlayerLevel(class_1657 player, int level) {
        RecruitmentSelection selection = PlayerRecruitmentData.getPlayerSelection(player);
        selection.setLevel(level);
    }

    private static void resetToDefaultForCategory(RecruitmentSelection selection, String categoryId) {
        switch (categoryId) {
            case "melee_infantry": {
                selection.setUnitTypeId("militia");
                break;
            }
            case "melee_cavalry": {
                selection.setUnitTypeId("lancer");
                break;
            }
            case "ranged_infantry": {
                selection.setUnitTypeId("archer");
                break;
            }
            case "ranged_cavalry": {
                selection.setUnitTypeId("mounted_archer");
                break;
            }
            case "siege": {
                selection.setUnitTypeId("ballista");
                break;
            }
            case "special": {
                selection.setUnitTypeId("skeleton_archer");
                break;
            }
            case "presets": {
                selection.setUnitTypeId("light_patrol");
                break;
            }
            default: {
                selection.setUnitTypeId("militia");
            }
        }
        selection.setLevel(1);
    }

    public static String getPlayerDisplayKey(class_1657 player) {
        RecruitmentSelection selection = PlayerRecruitmentData.getPlayerSelection(player);
        return selection.getDisplayTranslationKey();
    }

    public static void clearPlayerData(UUID playerUUID) {
        playerConfigs.remove(playerUUID);
    }

    public static class RecruitmentSelection {
        private String categoryId = "melee_infantry";
        private String unitTypeId = "militia";
        private int level = 1;

        public String getCategoryId() {
            return this.categoryId;
        }

        public void setCategoryId(String categoryId) {
            this.categoryId = categoryId;
        }

        public String getUnitTypeId() {
            return this.unitTypeId;
        }

        public void setUnitTypeId(String unitTypeId) {
            this.unitTypeId = unitTypeId;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public String getDisplayTranslationKey() {
            String levelRoman = this.intToRoman(this.level);
            return "army.hundred_years_war." + this.unitTypeId + "_" + levelRoman.toLowerCase();
        }

        private String intToRoman(int num) {
            switch (num) {
                case 1: {
                    return "I";
                }
                case 2: {
                    return "II";
                }
                case 3: {
                    return "III";
                }
                case 4: {
                    return "IV";
                }
            }
            return String.valueOf(num);
        }
    }
}

