/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.structure;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import ydmsama.hundred_years_war.blocks.BaseStructureCoreBlockEntity;
import ydmsama.hundred_years_war.blocks.ModBlocks;
import ydmsama.hundred_years_war.mixins.StructureBlockInfoAccessor;
import ydmsama.hundred_years_war.mixins.StructureTemplateAccessor;

public class ConstructionTask {
    private final class_3218 serverLevel;
    private final class_3499 structureTemplate;
    private final class_3492 placeSettings;
    private final class_2338 buildPos;
    private final int totalTicks;
    private final String templateName;
    private final double blocksPerSecond;
    private int elapsedTicks;
    private final List<class_3499.class_3501> blockList;
    private int totalBlocks;
    private int currentBlockIndex;
    private BaseStructureCoreBlockEntity coreBlockEntity;
    private boolean forceComplete = false;
    private final boolean isBatchMode;
    private final double blocksPerTick;
    private final double blocksPerBatch;
    private final int batchIntervalTicks = 20;
    private final int totalBatches;
    private double blockPlacementAccumulator = 0.0;

    public ConstructionTask(class_3218 serverLevel, class_3499 structureTemplate, class_3492 placeSettings, class_2338 centerPos, int totalTicks, String templateName, int currentBlockIndex, BaseStructureCoreBlockEntity coreBlockEntity) {
        this.serverLevel = serverLevel;
        this.structureTemplate = structureTemplate;
        this.placeSettings = placeSettings;
        this.buildPos = this.getBuildPosition(centerPos);
        this.totalTicks = totalTicks;
        this.templateName = templateName;
        this.elapsedTicks = 0;
        this.blockList = new ArrayList<class_3499.class_3501>(((StructureTemplateAccessor)structureTemplate).getPalettes().get(0).method_27125());
        this.blockList.sort((block1, block2) -> {
            class_2248 block1Type = ((StructureBlockInfoAccessor)block1).getState().method_26204();
            class_2248 block2Type = ((StructureBlockInfoAccessor)block2).getState().method_26204();
            if (block1Type == ModBlocks.BASE_STRUCTURE_CORE) {
                return -1;
            }
            if (block2Type == ModBlocks.BASE_STRUCTURE_CORE) {
                return 1;
            }
            if (block1Type instanceof class_2346 && !(block2Type instanceof class_2346)) {
                return 1;
            }
            if (!(block1Type instanceof class_2346) && block2Type instanceof class_2346) {
                return -1;
            }
            return 0;
        });
        this.totalBlocks = this.blockList.size();
        this.currentBlockIndex = currentBlockIndex;
        this.coreBlockEntity = coreBlockEntity;
        this.blocksPerTick = (double)this.totalBlocks / (double)this.totalTicks;
        this.blocksPerSecond = this.blocksPerTick * 20.0;
        if (this.blocksPerSecond > 1.0) {
            this.isBatchMode = true;
            this.totalBatches = (int)Math.ceil((double)totalTicks / 20.0);
            this.blocksPerBatch = (double)this.totalBlocks / (double)this.totalBatches;
        } else {
            this.isBatchMode = false;
            this.blocksPerBatch = this.blocksPerTick;
            this.totalBatches = 0;
        }
    }

    public boolean isComplete() {
        if (this.forceComplete) {
            return true;
        }
        if (this.currentBlockIndex >= this.totalBlocks) {
            if (this.coreBlockEntity != null) {
                this.coreBlockEntity.setTaskComplete(true);
            }
            return true;
        }
        return false;
    }

    public void tick() {
        if (!this.isComplete()) {
            if (this.elapsedTicks == 0 && !this.canBuildHere()) {
                this.forceComplete = true;
                return;
            }
            ++this.elapsedTicks;
            if (this.isBatchMode) {
                if (this.elapsedTicks % 20 == 0) {
                    this.blockPlacementAccumulator += this.blocksPerBatch;
                    int blocksToPlace = (int)this.blockPlacementAccumulator;
                    this.blockPlacementAccumulator -= (double)blocksToPlace;
                    for (int i = 0; i < blocksToPlace && this.currentBlockIndex < this.totalBlocks; ++i) {
                        class_3499.class_3501 blockInfo = this.blockList.get(this.currentBlockIndex);
                        this.placeBlock(blockInfo);
                        ++this.currentBlockIndex;
                    }
                    if (this.coreBlockEntity != null) {
                        this.coreBlockEntity.setCurrentBatchIndex(this.coreBlockEntity.getCurrentBatchIndex() + 1);
                    }
                }
            } else {
                this.blockPlacementAccumulator += this.blocksPerTick;
                int blocksToPlace = (int)this.blockPlacementAccumulator;
                this.blockPlacementAccumulator -= (double)blocksToPlace;
                for (int i = 0; i < blocksToPlace && this.currentBlockIndex < this.totalBlocks; ++i) {
                    class_3499.class_3501 blockInfo = this.blockList.get(this.currentBlockIndex);
                    this.placeBlock(blockInfo);
                    ++this.currentBlockIndex;
                }
                if (this.coreBlockEntity != null) {
                    this.coreBlockEntity.setCurrentBatchIndex(this.coreBlockEntity.getCurrentBatchIndex() + 1);
                }
            }
            if (this.coreBlockEntity != null) {
                this.coreBlockEntity.setCurrentBlockIndex(this.currentBlockIndex);
            }
        }
    }

    private void placeBlock(class_3499.class_3501 blockInfo) {
        class_2338 relativePos = ((StructureBlockInfoAccessor)blockInfo).getPos();
        class_2338 rotatedPos = class_3499.method_15171((class_3492)this.placeSettings, (class_2338)relativePos);
        class_2338 absolutePos = rotatedPos.method_10081((class_2382)this.buildPos);
        class_2680 state = ((StructureBlockInfoAccessor)blockInfo).getState().method_26185(this.placeSettings.method_15114()).method_26186(this.placeSettings.method_15113());
        this.serverLevel.method_8652(absolutePos, state, 3);
        if (state.method_26204() == ModBlocks.BASE_STRUCTURE_CORE) {
            this.coreBlockEntity = (BaseStructureCoreBlockEntity)this.serverLevel.method_8321(absolutePos);
            if (this.coreBlockEntity instanceof BaseStructureCoreBlockEntity) {
                this.coreBlockEntity.setTemplateData(this.templateName, this.structureTemplate.method_15160(), this.placeSettings.method_15113(), this.placeSettings.method_15114(), this.buildPos);
            }
        }
    }

    public boolean canBuildHere() {
        return this.checkFoundation();
    }

    private boolean checkFoundation() {
        class_2382 size = this.structureTemplate.method_15160();
        int sizeX = size.method_10263();
        int sizeZ = size.method_10260();
        for (int layer = 1; layer <= 2; ++layer) {
            int currentY = this.buildPos.method_10264() - layer;
            int nonEmptyBlocks = 0;
            int totalBlocks = sizeX * sizeZ;
            for (int x = 0; x < sizeX; ++x) {
                for (int z = 0; z < sizeZ; ++z) {
                    class_2338 relativePos = new class_2338(x, 0, z);
                    class_2338 rotatedPos = class_3499.method_15171((class_3492)this.placeSettings, (class_2338)relativePos);
                    class_2338 absolutePos = new class_2338(rotatedPos.method_10263() + this.buildPos.method_10263(), currentY, rotatedPos.method_10260() + this.buildPos.method_10260());
                    class_2680 state = this.serverLevel.method_8320(absolutePos);
                    if (state.method_26215()) continue;
                    ++nonEmptyBlocks;
                }
            }
            double percentage = (double)nonEmptyBlocks / (double)totalBlocks * 100.0;
            if (!(percentage < 75.0)) continue;
            return false;
        }
        return true;
    }

    public class_2338 getBuildPosition(class_2338 position1) {
        class_2382 rotatedSize = ConstructionTask.rotateVec3i(this.structureTemplate.method_15160(), this.placeSettings.method_15113());
        int offsetX = rotatedSize.method_10263() / 2;
        int offsetY = rotatedSize.method_10264() / 2;
        int offsetZ = rotatedSize.method_10260() / 2;
        if (rotatedSize.method_10263() % 2 == 0) {
            --offsetX;
        }
        if (rotatedSize.method_10264() % 2 == 0) {
            --offsetY;
        }
        if (rotatedSize.method_10260() % 2 == 0) {
            --offsetZ;
        }
        class_2338 position2 = position1.method_10069(-offsetX, 0, -offsetZ);
        return position2;
    }

    static class_2382 rotateVec3i(class_2382 vec, class_2470 rotation) {
        return switch (rotation) {
            case class_2470.field_11463 -> new class_2382(-vec.method_10260(), vec.method_10264(), vec.method_10263());
            case class_2470.field_11464 -> new class_2382(-vec.method_10263(), vec.method_10264(), -vec.method_10260());
            case class_2470.field_11465 -> new class_2382(vec.method_10260(), vec.method_10264(), -vec.method_10263());
            default -> vec;
        };
    }

    public int getElapsedTicks() {
        return this.elapsedTicks;
    }
}

