/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.utils;

import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import ydmsama.hundred_years_war.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.utils.RelationSystem;

public class ServerRelationHelper {
    public static boolean isEnemyRelation(class_1297 entity1, class_1297 entity2) {
        if (!(entity1 instanceof class_1309) || !(entity2 instanceof class_1309)) {
            return false;
        }
        UUID uuid1 = null;
        if (entity1 instanceof class_1657) {
            uuid1 = entity1.method_5667();
        } else if (entity1 instanceof BaseCombatEntity) {
            uuid1 = ((BaseCombatEntity)entity1).getOwnerUUID();
        }
        UUID uuid2 = null;
        if (entity2 instanceof class_1657) {
            uuid2 = entity2.method_5667();
        } else if (entity2 instanceof BaseCombatEntity) {
            uuid2 = ((BaseCombatEntity)entity2).getOwnerUUID();
        }
        if (uuid1 == null && uuid2 == null) {
            return false;
        }
        if (uuid1 == null || uuid2 == null) {
            return true;
        }
        if (uuid1.equals(uuid2)) {
            return false;
        }
        RelationSystem.RelationType relation1 = RelationSystem.getRelation(uuid1, uuid2);
        RelationSystem.RelationType relation2 = RelationSystem.getRelation(uuid2, uuid1);
        return relation1 == RelationSystem.RelationType.HOSTILE || relation2 == RelationSystem.RelationType.HOSTILE;
    }

    public static boolean hasControlOver(class_1657 player, class_1297 entity) {
        if (player.method_7337()) {
            return true;
        }
        if (!(entity instanceof BaseCombatEntity)) {
            return false;
        }
        UUID playerUUID = player.method_5667();
        BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
        UUID entityOwnerUUID = combatEntity.getOwnerUUID();
        if (entityOwnerUUID != null && entityOwnerUUID.equals(playerUUID)) {
            return true;
        }
        if (entityOwnerUUID == null) {
            return false;
        }
        RelationSystem.RelationType ownerToPlayer = RelationSystem.getRelation(entityOwnerUUID, playerUUID);
        return ownerToPlayer == RelationSystem.RelationType.CONTROL;
    }

    public static boolean isNeutralRelation(class_1297 entity1, class_1297 entity2) {
        if (!(entity1 instanceof class_1309) || !(entity2 instanceof class_1309)) {
            return true;
        }
        UUID uuid1 = null;
        if (entity1 instanceof class_1657) {
            uuid1 = entity1.method_5667();
        } else if (entity1 instanceof BaseCombatEntity) {
            uuid1 = ((BaseCombatEntity)entity1).getOwnerUUID();
        }
        UUID uuid2 = null;
        if (entity2 instanceof class_1657) {
            uuid2 = entity2.method_5667();
        } else if (entity2 instanceof BaseCombatEntity) {
            uuid2 = ((BaseCombatEntity)entity2).getOwnerUUID();
        }
        if (uuid1 == null && uuid2 == null) {
            return false;
        }
        if (uuid1 == null || uuid2 == null) {
            return false;
        }
        if (uuid1.equals(uuid2)) {
            return false;
        }
        RelationSystem.RelationType relation1 = RelationSystem.getRelation(uuid1, uuid2);
        return relation1 == RelationSystem.RelationType.NEUTRAL;
    }

    public static boolean isFriendlyRelation(class_1297 entity1, class_1297 entity2) {
        if (!(entity1 instanceof class_1309) || !(entity2 instanceof class_1309)) {
            return false;
        }
        UUID uuid1 = null;
        if (entity1 instanceof class_1657) {
            uuid1 = entity1.method_5667();
        } else if (entity1 instanceof BaseCombatEntity) {
            uuid1 = ((BaseCombatEntity)entity1).getOwnerUUID();
        }
        UUID uuid2 = null;
        if (entity2 instanceof class_1657) {
            uuid2 = entity2.method_5667();
        } else if (entity2 instanceof BaseCombatEntity) {
            uuid2 = ((BaseCombatEntity)entity2).getOwnerUUID();
        }
        if (uuid1 == null && uuid2 == null) {
            return false;
        }
        if (uuid1 == null || uuid2 == null) {
            return false;
        }
        if (uuid1.equals(uuid2)) {
            return false;
        }
        RelationSystem.RelationType relation1 = RelationSystem.getRelation(uuid1, uuid2);
        return relation1 == RelationSystem.RelationType.FRIENDLY;
    }
}

