/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_7923;

public class TargetListManager {
    private static List<String> targetList = new ArrayList<String>();

    public static void loadTargetList() {
        File targetListFile;
        File configDir = new File("config/hundredyearswar");
        if (!configDir.exists()) {
            configDir.mkdirs();
            System.out.println("\u521b\u5efa\u76ee\u5f55: config/hundredyearswar");
        }
        if (!(targetListFile = new File("config/hundredyearswar/target_list.json5")).exists()) {
            System.out.println("target_list.json5\u4e0d\u5b58\u5728\uff0c\u521b\u5efa\u9ed8\u8ba4\u76ee\u6807\u5217\u8868");
            TargetListManager.createDefaultTargetList(targetListFile);
        } else {
            System.out.println("\u627e\u5230\u73b0\u6709target_list.json5");
        }
        try (FileReader reader = new FileReader(targetListFile);){
            int length;
            StringBuilder content = new StringBuilder();
            char[] buffer = new char[1024];
            while ((length = reader.read(buffer)) != -1) {
                content.append(buffer, 0, length);
            }
            String jsonContent = content.toString().replaceAll("//.*", "");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            targetList = (List)gson.fromJson(jsonContent, new TypeToken<List<String>>(){}.getType());
            System.out.println("\u6210\u529f\u52a0\u8f7d\u76ee\u6807\u5217\u8868: " + targetList);
        }
        catch (IOException e) {
            System.err.println("\u52a0\u8f7dtarget_list.json5\u65f6\u51fa\u9519: " + e.getMessage());
            e.printStackTrace();
            targetList = new ArrayList<String>();
        }
    }

    private static void createDefaultTargetList(File targetListFile) {
        try {
            ArrayList<String> defaultTargets = new ArrayList<String>();
            defaultTargets.add("minecraft:zombie");
            defaultTargets.add("minecraft:skeleton");
            defaultTargets.add("minecraft:spider");
            try (FileWriter writer = new FileWriter(targetListFile);){
                writer.write("// Target list - BaseCombatEntity will actively attack these entities\n");
                writer.write("// Format: \"namespace:entity_id\"\n");
                writer.write("// In addition to this list, soldiers will also attack enemy players, enemy soldiers, and some monsters\n");
                writer.write("[\n");
                for (int i = 0; i < defaultTargets.size(); ++i) {
                    writer.write("  \"" + (String)defaultTargets.get(i) + "\"");
                    if (i < defaultTargets.size() - 1) {
                        writer.write(",");
                    }
                    writer.write("\n");
                }
                writer.write("]\n");
            }
            targetList = defaultTargets;
            System.out.println("\u5df2\u521b\u5efa\u9ed8\u8ba4\u76ee\u6807\u5217\u8868: " + defaultTargets);
        }
        catch (IOException e) {
            e.printStackTrace();
            targetList = new ArrayList<String>();
        }
    }

    public static boolean isInTargetList(class_1309 entity) {
        if (entity == null) {
            return false;
        }
        String entityIdString = class_7923.field_41177.method_10221((Object)entity.method_5864()).toString();
        return targetList.contains(entityIdString);
    }

    public static List<String> getTargetList() {
        return new ArrayList<String>(targetList);
    }

    public static void addToTargetList(String entityId) {
        if (!targetList.contains(entityId)) {
            targetList.add(entityId);
        }
    }

    public static void removeFromTargetList(String entityId) {
        targetList.remove(entityId);
    }
}

