/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essential_client.features.carpet_client;

import carpet.api.settings.CarpetRule;
import carpet.api.settings.InvalidRuleValueException;
import carpet.api.settings.RuleHelper;
import com.google.common.collect.TreeMultimap;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import me.senseiwells.essential_client.EssentialClient;
import me.senseiwells.essential_client.features.carpet_client.CarpetClient;
import me.senseiwells.essential_client.features.carpet_client.SingleplayerCarpetClient;
import me.senseiwells.essential_client.features.carpet_client.database.CarpetRuleData;
import me.senseiwells.essential_client.features.carpet_client.database.CarpetRulesDatabase;
import me.senseiwells.essential_client.features.carpet_client.yacl.CarpetOption;
import me.senseiwells.essential_client.utils.CarpetUtils;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0010\u00a2\u0006\u0004\b\u000f\u0010\u0010J+\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000e0\u0012H\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J;\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019\"\b\b\u0000\u0010\u0018*\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00192\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ-\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u001f\"\b\b\u0000\u0010\u0018*\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0002\u00a2\u0006\u0004\b \u0010!J5\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u001f\"\b\b\u0000\u0010\u0018*\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001b2\u0006\u0010#\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b \u0010$J-\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019\"\b\b\u0000\u0010\u0018*\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0002\u00a2\u0006\u0004\b%\u0010&J\u001a\u0010(\u001a\u00020\u00072\b\u0010'\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003\u00a2\u0006\u0004\b(\u0010)J\u0010\u0010+\u001a\u00020*H\u00d6\u0001\u00a2\u0006\u0004\b+\u0010,J\u0010\u0010-\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Lme/senseiwells/essential_client/features/carpet_client/SingleplayerCarpetClient;", "Lme/senseiwells/essential_client/features/carpet_client/CarpetClient;", "<init>", "()V", "", "name", "manager", "", "isValidRule", "(Ljava/lang/String;Ljava/lang/String;)Z", "Lnet/minecraft/class_310;", "minecraft", "Lnet/minecraft/class_2487;", "tag", "", "synchronizeRuleData$EssentialClient", "(Lnet/minecraft/class_310;Lnet/minecraft/class_2487;)V", "synchronizeRuleData", "Lkotlin/Function1;", "Ldev/isxander/yacl3/api/ConfigCategory;", "consumer", "createCategories", "(Lnet/minecraft/class_310;Lkotlin/jvm/functions/Function1;)V", "", "T", "Lme/senseiwells/essential_client/features/carpet_client/yacl/CarpetOption$Builder;", "builder", "Lcarpet/api/settings/CarpetRule;", "rule", "bindOption", "(Lme/senseiwells/essential_client/features/carpet_client/yacl/CarpetOption$Builder;Lcarpet/api/settings/CarpetRule;)Lme/senseiwells/essential_client/features/carpet_client/yacl/CarpetOption$Builder;", "Lme/senseiwells/essential_client/features/carpet_client/yacl/CarpetOption;", "createOption", "(Lcarpet/api/settings/CarpetRule;)Lme/senseiwells/essential_client/features/carpet_client/yacl/CarpetOption;", "Lme/senseiwells/essential_client/features/carpet_client/database/CarpetRuleData;", "data", "(Lcarpet/api/settings/CarpetRule;Lme/senseiwells/essential_client/features/carpet_client/database/CarpetRuleData;)Lme/senseiwells/essential_client/features/carpet_client/yacl/CarpetOption;", "createUnboundOption", "(Lcarpet/api/settings/CarpetRule;)Lme/senseiwells/essential_client/features/carpet_client/yacl/CarpetOption$Builder;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "()Ljava/lang/String;", "EssentialClient"})
public final class SingleplayerCarpetClient
extends CarpetClient {
    @NotNull
    public static final SingleplayerCarpetClient INSTANCE = new SingleplayerCarpetClient();

    private SingleplayerCarpetClient() {
        super(null);
    }

    @Override
    public boolean isValidRule(@NotNull String name, @NotNull String manager) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (!CarpetClient.hasLocalCarpet) {
            return false;
        }
        for (CarpetRule<?> rule : CarpetUtils.INSTANCE.rules()) {
            if (!Intrinsics.areEqual((Object)rule.name(), (Object)name) || !Intrinsics.areEqual((Object)rule.settingsManager().identifier(), (Object)manager)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void synchronizeRuleData$EssentialClient(@NotNull class_310 minecraft, @NotNull class_2487 tag) {
        Intrinsics.checkNotNullParameter((Object)minecraft, (String)"minecraft");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
    }

    @Override
    protected void createCategories(@NotNull class_310 minecraft, @NotNull Function1<? super ConfigCategory, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)minecraft, (String)"minecraft");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (!CarpetClient.hasLocalCarpet) {
            EssentialClient.INSTANCE.getLogger().error("Tried loading singleplayer carpet rules without carpet installed!");
            return;
        }
        TreeMultimap sorted2 = TreeMultimap.create((arg_0, arg_1) -> SingleplayerCarpetClient.createCategories$lambda$0(createCategories.sorted.1.INSTANCE, arg_0, arg_1), Comparator.comparing(arg_0 -> SingleplayerCarpetClient.createCategories$lambda$2(SingleplayerCarpetClient::createCategories$lambda$1, arg_0)));
        for (CarpetRule<?> entry : CarpetUtils.INSTANCE.rules()) {
            CarpetRuleData data = CarpetRulesDatabase.INSTANCE.getDataForRule(entry);
            if (data == null) {
                sorted2.put((Object)"Carpet", this.createOption(entry));
                continue;
            }
            sorted2.put((Object)data.getModName(), this.createOption(entry, data));
        }
        NavigableMap navigableMap = sorted2.asMap();
        Intrinsics.checkNotNullExpressionValue((Object)navigableMap, (String)"asMap(...)");
        for (Map.Entry entry : ((Map)navigableMap).entrySet()) {
            String mod = (String)entry.getKey();
            Collection options = (Collection)entry.getValue();
            ConfigCategory.Builder category = ConfigCategory.createBuilder();
            category.name((class_2561)class_2561.method_43470((String)mod));
            category.options(options);
            ConfigCategory configCategory = category.build();
            Intrinsics.checkNotNullExpressionValue((Object)configCategory, (String)"build(...)");
            consumer.invoke((Object)configCategory);
        }
    }

    private final <T> CarpetOption.Builder<T> bindOption(CarpetOption.Builder<T> builder, CarpetRule<T> rule) {
        Class clazz = rule.type();
        Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"type(...)");
        Object object = rule.value();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
        Object object2 = rule.defaultValue();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"defaultValue(...)");
        Collection collection = rule.categories();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"categories(...)");
        Collection collection2 = rule.suggestions();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"suggestions(...)");
        return this.bindOption(builder, clazz, object, object2, collection, collection2, rule.strict()).applier((Function1<CarpetOption<Object>, Unit>)((Function1)arg_0 -> SingleplayerCarpetClient.bindOption$lambda$3(rule, arg_0)));
    }

    private final <T> CarpetOption<T> createOption(CarpetRule<T> rule) {
        return this.bindOption(this.createUnboundOption(rule), rule).build();
    }

    private final <T> CarpetOption<T> createOption(CarpetRule<T> rule, CarpetRuleData data) {
        return this.bindOption(this.createUnboundOption(data), rule).build();
    }

    private final <T> CarpetOption.Builder<T> createUnboundOption(CarpetRule<T> rule) {
        class_5250 class_52502 = class_2561.method_43470((String)rule.name());
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
        class_2561 class_25612 = (class_2561)class_52502;
        class_5250 class_52503 = class_2561.method_43470((String)RuleHelper.translatedDescription(rule));
        Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"literal(...)");
        class_2561 class_25613 = (class_2561)class_52503;
        List list = rule.extraInfo();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"extraInfo(...)");
        CarpetOption.Builder builder = this.createUnboundOption(class_25612, class_25613, list, CollectionsKt.emptyList());
        builder.available(!rule.settingsManager().locked());
        return builder;
    }

    @NotNull
    public String toString() {
        return "SingleplayerCarpetClient";
    }

    public int hashCode() {
        return -1865759065;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SingleplayerCarpetClient)) {
            return false;
        }
        SingleplayerCarpetClient cfr_ignored_0 = (SingleplayerCarpetClient)other;
        return true;
    }

    private static final int createCategories$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final String createCategories$lambda$1(Option option) {
        return option.name().getString();
    }

    private static final String createCategories$lambda$2(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Unit bindOption$lambda$3(CarpetRule $rule, CarpetOption option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        try {
            $rule.set(null, option.pendingValue());
            option.setValue(option.pendingValue());
        }
        catch (InvalidRuleValueException invalidRuleValueException) {
            // empty catch block
        }
        return Unit.INSTANCE;
    }
}

