/*
 * Decompiled with CFR 0.152.
 */
package me.senseiwells.essential_client.features.carpet_client.database;

import carpet.api.settings.CarpetRule;
import it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Clock;
import kotlin.time.Duration;
import kotlin.time.Instant;
import kotlin.time.jdk8.InstantConversionsJDK8Kt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JvmStreamsKt;
import me.senseiwells.essential_client.EssentialClient;
import me.senseiwells.essential_client.EssentialClientConfig;
import me.senseiwells.essential_client.features.carpet_client.CarpetClient;
import me.senseiwells.essential_client.features.carpet_client.database.CarpetRuleData;
import me.senseiwells.essential_client.features.carpet_client.database.CarpetRuleDataRegistry;
import me.senseiwells.essential_client.features.carpet_client.database.CarpetRulesDatabase;
import me.senseiwells.essential_client.features.carpet_client.yacl.CarpetOptionType;
import me.senseiwells.essential_client.utils.CarpetUtils;
import me.senseiwells.essential_client.utils.VersionUtils;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_6489;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001b\u0010\b\u001a\u0004\u0018\u00010\u00072\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\n\u00a2\u0006\u0004\b\b\u0010\fJ\u000f\u0010\u000f\u001a\u00020\rH\u0000\u00a2\u0006\u0004\b\u000e\u0010\u0003J\u001b\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00110\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001b\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00140\u0017H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u001c\u001a\u00020\r2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001b\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00140\u0017H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0019J#\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014H\u0002\u00a2\u0006\u0004\b \u0010!J\u0017\u0010 \u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b \u0010#J#\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014H\u0002\u00a2\u0006\u0004\b$\u0010!J\u0017\u0010$\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b$\u0010#R\u0014\u0010&\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0014\u0010)\u001a\u00020(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*Rh\u0010\u001b\u001aV\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0011 ,*\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00100\u0010 ,**\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0011 ,*\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00100\u0010\u0018\u00010+0+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010-R\u001d\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00110\u00108F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0013\u00a8\u00060"}, d2={"Lme/senseiwells/essential_client/features/carpet_client/database/CarpetRulesDatabase;", "", "<init>", "()V", "", "name", "manager", "Lme/senseiwells/essential_client/features/carpet_client/database/CarpetRuleData;", "getDataForRule", "(Ljava/lang/String;Ljava/lang/String;)Lme/senseiwells/essential_client/features/carpet_client/database/CarpetRuleData;", "Lcarpet/api/settings/CarpetRule;", "original", "(Lcarpet/api/settings/CarpetRule;)Lme/senseiwells/essential_client/features/carpet_client/database/CarpetRuleData;", "", "load$EssentialClient", "load", "", "Lme/senseiwells/essential_client/features/carpet_client/database/CarpetRuleDataRegistry;", "getCarpetRulesByMod", "()Ljava/util/Map;", "", "getCarpetRules", "()Ljava/util/List;", "Lkotlin/Result;", "downloadCarpetRules-d1pmJ48", "()Ljava/lang/Object;", "downloadCarpetRules", "rules", "writeCarpetRules", "(Ljava/util/List;)V", "readCarpetRules-d1pmJ48", "readCarpetRules", "cleanupData", "(Ljava/util/List;)Ljava/util/List;", "data", "(Lme/senseiwells/essential_client/features/carpet_client/database/CarpetRuleData;)Lme/senseiwells/essential_client/features/carpet_client/database/CarpetRuleData;", "resolveDataWithLocalCarpet", "Ljava/nio/file/Path;", "cache", "Ljava/nio/file/Path;", "Lkotlinx/serialization/json/Json;", "json", "Lkotlinx/serialization/json/Json;", "Ljava/util/concurrent/CompletableFuture;", "kotlin.jvm.PlatformType", "Ljava/util/concurrent/CompletableFuture;", "getRegistries", "registries", "EssentialClient"})
@SourceDebugExtension(value={"SMAP\nCarpetRulesDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CarpetRulesDatabase.kt\nme/senseiwells/essential_client/features/carpet_client/database/CarpetRulesDatabase\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n382#2,7:186\n1869#3,2:193\n1563#3:198\n1634#3,3:199\n360#3,7:202\n1563#3:210\n1634#3,3:211\n80#4:195\n42#4:196\n80#4:197\n1#5:209\n*S KotlinDebug\n*F\n+ 1 CarpetRulesDatabase.kt\nme/senseiwells/essential_client/features/carpet_client/database/CarpetRulesDatabase\n*L\n74#1:186,7\n82#1:193,2\n150#1:198\n150#1:199,3\n154#1:202,7\n171#1:210\n171#1:211,3\n126#1:195\n135#1:196\n144#1:197\n*E\n"})
public final class CarpetRulesDatabase {
    @NotNull
    public static final CarpetRulesDatabase INSTANCE = new CarpetRulesDatabase();
    @NotNull
    private static final Path cache = EssentialClientConfig.Companion.resolve("carpet_rules.json");
    @NotNull
    private static final Json json = JsonKt.Json$default(null, CarpetRulesDatabase::json$lambda$0, (int)1, null);
    private static final CompletableFuture<Map<String, CarpetRuleDataRegistry>> rules = CompletableFuture.supplyAsync(INSTANCE::getCarpetRulesByMod, (Executor)class_156.method_18349());

    private CarpetRulesDatabase() {
    }

    @NotNull
    public final Map<String, CarpetRuleDataRegistry> getRegistries() {
        Map<String, CarpetRuleDataRegistry> map2 = rules.join();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"join(...)");
        return map2;
    }

    @Nullable
    public final CarpetRuleData getDataForRule(@NotNull String name, @NotNull String manager) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        for (CarpetRuleDataRegistry rules : this.getRegistries().values()) {
            CarpetRuleData data;
            if (rules.get(name) == null || !data.getSettingManagers().contains(manager)) continue;
            return data;
        }
        return null;
    }

    @Nullable
    public final CarpetRuleData getDataForRule(@NotNull CarpetRule<?> original) {
        Intrinsics.checkNotNullParameter(original, (String)"original");
        for (CarpetRuleDataRegistry rules : this.getRegistries().values()) {
            CarpetRuleData data;
            String string = original.name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
            if (rules.get(string) == null || !CarpetUtils.INSTANCE.matches(original, data)) continue;
            return data;
        }
        return null;
    }

    public final void load$EssentialClient() {
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, CarpetRuleDataRegistry> getCarpetRulesByMod() {
        Object2ObjectAVLTreeMap map2 = new Object2ObjectAVLTreeMap((arg_0, arg_1) -> CarpetRulesDatabase.getCarpetRulesByMod$lambda$1(getCarpetRulesByMod.map.1.INSTANCE, arg_0, arg_1));
        for (CarpetRuleData rule : this.getCarpetRules()) {
            Object object;
            void $this$getOrPut$iv;
            Map map3 = (Map)map2;
            String key$iv = rule.getModName();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                ObjectArrayList answer$iv = new ObjectArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(rule);
        }
        class_6489 version = class_155.method_16673();
        Intrinsics.checkNotNull((Object)version);
        String majorVersion = VersionUtils.INSTANCE.getMajorVersion(version);
        Object2ObjectLinkedOpenHashMap rulesByMod = new Object2ObjectLinkedOpenHashMap();
        for (Map.Entry entry : ((Map)map2).entrySet()) {
            String mod = (String)entry.getKey();
            List rules = (List)entry.getValue();
            CarpetRuleDataRegistry.Builder builder = new CarpetRuleDataRegistry.Builder();
            Intrinsics.checkNotNull((Object)rules);
            Iterable $this$forEach$iv = rules;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CarpetRuleData p0 = (CarpetRuleData)element$iv;
                boolean bl = false;
                builder.add(p0);
            }
            ((Map)rulesByMod).put(mod, builder.build(majorVersion));
        }
        return (Map)rulesByMod;
    }

    private final List<CarpetRuleData> getCarpetRules() {
        List list;
        try {
            Object result;
            Path path = cache;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            FileTime fileTime = Files.getLastModifiedTime(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
            java.time.Instant instant = fileTime.toInstant();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
            Instant lastModified = InstantConversionsJDK8Kt.toKotlinInstant((java.time.Instant)instant);
            long duration = lastModified.minus-UwyO8pc(Clock.System.INSTANCE.now());
            if (Duration.getInWholeHours-impl((long)duration) < 10L && Result.isSuccess-impl((Object)(result = this.readCarpetRules-d1pmJ48()))) {
                Object object = result;
                ResultKt.throwOnFailure((Object)object);
                return (List)object;
            }
        }
        catch (IOException lastModified) {
            // empty catch block
        }
        Object result = this.downloadCarpetRules-d1pmJ48();
        if (Result.isFailure-impl((Object)result)) {
            Throwable error = Result.exceptionOrNull-impl((Object)result);
            result = this.readCarpetRules-d1pmJ48();
            if (Result.isFailure-impl((Object)result)) {
                EssentialClient.INSTANCE.getLogger().error("Failed to retrieve carpet rules from database", error);
            }
        } else {
            Object object = result;
            ResultKt.throwOnFailure((Object)object);
            this.writeCarpetRules((List)object);
        }
        if ((list = (List)(Result.isFailure-impl((Object)result) ? null : result)) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final Object downloadCarpetRules-d1pmJ48() {
        Object object;
        CarpetRulesDatabase carpetRulesDatabase = this;
        try {
            void $this$decodeFromStream$iv;
            CarpetRulesDatabase $this$downloadCarpetRules_d1pmJ48_u24lambda_u243 = carpetRulesDatabase;
            boolean bl = false;
            URL url = new URI("https://data.carpet.rubixdev.de/data/combined.json").toURL();
            URLConnection uRLConnection = url.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            Json json = CarpetRulesDatabase.json;
            InputStream inputStream = connection.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            InputStream stream$iv = inputStream;
            boolean $i$f$decodeFromStream = false;
            $this$decodeFromStream$iv.getSerializersModule();
            object = Result.constructor-impl($this$downloadCarpetRules_d1pmJ48_u24lambda_u243.resolveDataWithLocalCarpet($this$downloadCarpetRules_d1pmJ48_u24lambda_u243.cleanupData((List)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)((DeserializationStrategy)new ArrayListSerializer(CarpetRuleData.Companion.serializer())), (InputStream)stream$iv))));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void writeCarpetRules(List<CarpetRuleData> rules) {
        CarpetRulesDatabase carpetRulesDatabase = this;
        try {
            CarpetRulesDatabase $this$writeCarpetRules_u24lambda_u245 = carpetRulesDatabase;
            boolean bl = false;
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream(cache, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            Closeable closeable = outputStream;
            Throwable throwable = null;
            try {
                void value$iv;
                void $this$encodeToStream$iv;
                OutputStream stream = (OutputStream)closeable;
                boolean bl2 = false;
                Json json = CarpetRulesDatabase.json;
                List<CarpetRuleData> list = rules;
                OutputStream stream$iv = stream;
                boolean $i$f$encodeToStream = false;
                $this$encodeToStream$iv.getSerializersModule();
                JvmStreamsKt.encodeToStream((Json)$this$encodeToStream$iv, (SerializationStrategy)((SerializationStrategy)new ArrayListSerializer(CarpetRuleData.Companion.serializer())), (Object)value$iv, (OutputStream)stream$iv);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Object readCarpetRules-d1pmJ48() {
        Object object;
        CarpetRulesDatabase carpetRulesDatabase = this;
        try {
            List<CarpetRuleData> list;
            CarpetRulesDatabase $this$readCarpetRules_d1pmJ48_u24lambda_u247 = carpetRulesDatabase;
            boolean bl = false;
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream(cache, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                void $this$decodeFromStream$iv;
                InputStream stream = (InputStream)closeable;
                boolean bl2 = false;
                Json json = CarpetRulesDatabase.json;
                InputStream stream$iv = stream;
                boolean $i$f$decodeFromStream = false;
                $this$decodeFromStream$iv.getSerializersModule();
                list = $this$readCarpetRules_d1pmJ48_u24lambda_u247.resolveDataWithLocalCarpet((List)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)((DeserializationStrategy)new ArrayListSerializer(CarpetRuleData.Companion.serializer())), (InputStream)stream$iv));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            object = Result.constructor-impl(list);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<CarpetRuleData> cleanupData(List<CarpetRuleData> rules) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = rules;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            CarpetRuleData carpetRuleData = (CarpetRuleData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.cleanupData((CarpetRuleData)p0));
        }
        return (List)destination$iv$iv;
    }

    private final CarpetRuleData cleanupData(CarpetRuleData data) {
        int index;
        block3: {
            int n;
            List<String> $this$indexOfFirst$iv = data.getOptions();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<String> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                String item$iv;
                String it = item$iv = iterator.next();
                boolean bl = false;
                if (StringsKt.equals((String)data.getDefaultValueAsString(), (String)it, (boolean)true)) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (index != -1 && !Intrinsics.areEqual((Object)data.getOptions().get(index), (Object)data.getDefaultValueAsString())) {
            String defaultValueAsString = data.getOptions().get(index);
            return CarpetRuleData.copy$default(data, null, null, null, defaultValueAsString, false, null, null, null, null, null, null, null, null, null, null, data.getType().mapFromString(defaultValueAsString), null, 98295, null);
        }
        return data;
    }

    private final List<CarpetRuleData> resolveDataWithLocalCarpet(List<CarpetRuleData> rules) {
        if (!CarpetClient.hasLocalCarpet) {
            return rules;
        }
        Object t = class_310.method_1551().method_5385(() -> CarpetRulesDatabase.resolveDataWithLocalCarpet$lambda$11(rules)).join();
        Intrinsics.checkNotNullExpressionValue(t, (String)"join(...)");
        return (List)t;
    }

    private final CarpetRuleData resolveDataWithLocalCarpet(CarpetRuleData data) {
        Object v0;
        block2: {
            Iterable iterable = CarpetUtils.INSTANCE.rules();
            for (Object t : iterable) {
                CarpetRule it = (CarpetRule)t;
                boolean bl = false;
                if (!CarpetUtils.INSTANCE.matches(it, data)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        CarpetRule rule = v0;
        if (rule != null) {
            Class clazz = rule.type();
            Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"type(...)");
            Collection collection = rule.categories();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"categories(...)");
            return CarpetRuleData.copy$default(data, null, null, null, null, false, null, null, null, null, null, null, null, null, null, CarpetOptionType.Companion.resolve(clazz, (Iterable<String>)collection), rule.defaultValue(), null, 81919, null);
        }
        return data;
    }

    private static final Unit json$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }

    private static final int getCarpetRulesByMod$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    /*
     * WARNING - void declaration
     */
    private static final List resolveDataWithLocalCarpet$lambda$11(List $rules) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = $rules;
        CarpetRulesDatabase carpetRulesDatabase = INSTANCE;
        boolean $i$f$map = false;
        void var4_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            CarpetRuleData carpetRuleData = (CarpetRuleData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(carpetRulesDatabase.resolveDataWithLocalCarpet((CarpetRuleData)p0));
        }
        return (List)destination$iv$iv;
    }
}

