/*
 * Decompiled with CFR 0.152.
 */
package net.spudacious5705.shops;

import com.mojang.logging.LogUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.spudacious5705.shops.block.ModBlockEntities;
import net.spudacious5705.shops.block.ModBlockTags;
import net.spudacious5705.shops.block.ModBlocks;
import net.spudacious5705.shops.block.PostRegAssigner;
import net.spudacious5705.shops.block.VariantResources;
import net.spudacious5705.shops.block.entity.renderer.ShopIconModels;
import net.spudacious5705.shops.config.ConfigHandler;
import net.spudacious5705.shops.item.ModItemGroups;
import net.spudacious5705.shops.item.ModItems;
import net.spudacious5705.shops.properties.ModProperties;
import net.spudacious5705.shops.screen.ModScreenHandlers;
import net.spudacious5705.shops.screen.networking.NetworkHelper;
import org.slf4j.Logger;

@Mod(value="spudaciousshops")
public class SpudaciousShops {
    public static final String MOD_ID = "spudaciousshops";
    public static final Logger LOGGER = LogUtils.getLogger();

    public SpudaciousShops() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ConfigHandler.initialise();
        ModItems.registerModItems(modEventBus);
        ModBlocks.registerModBlocks(modEventBus);
        modEventBus.addListener(this::commonSetup);
        ModBlockTags.initialise();
        ModProperties.registerModProperties();
        ModBlockEntities.registerBlockEntities(modEventBus);
        ModScreenHandlers.registerScreenHandlers(modEventBus);
        ModItemGroups.register(modEventBus);
        NetworkHelper.register();
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("SETTING UP SPUD'S SHOPS...");
        ModBlocks.postRegistryTasks.forEach(Runnable::run);
        PostRegAssigner.runAllAssigners();
        ShopIconModels.initialise();
        VariantResources.register();
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    public static ResourceLocation getResource(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

