/*
 * Decompiled with CFR 0.152.
 */
package net.spudacious5705.shops.block;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.spudacious5705.shops.SpudaciousShops;
import net.spudacious5705.shops.block.PostRegAssigner;
import net.spudacious5705.shops.block.VariantResources;
import net.spudacious5705.shops.block.custom.AbstractShopBlock;
import net.spudacious5705.shops.block.custom.AngledShopBlock;
import net.spudacious5705.shops.block.custom.CrateShopBlock;
import net.spudacious5705.shops.block.custom.HookShopBlock;
import net.spudacious5705.shops.block.custom.RugShopBlock;
import net.spudacious5705.shops.block.custom.ShelfShopBlock;
import net.spudacious5705.shops.block.custom.WindowSillShopBlock;
import net.spudacious5705.shops.item.custom.ShopItem;
import net.spudacious5705.shops.properties.Colour;

public class ModBlocks {
    public static final List<Runnable> postRegistryTasks = new ArrayList<Runnable>();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"spudaciousshops");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"spudaciousshops");
    private static final BlockBehaviour.Properties settingsChain = ModBlocks.shopSettings(Blocks.f_50184_);
    private static final BlockBehaviour.Properties settingsWood = ModBlocks.shopSettings(Blocks.f_50705_);
    private static final BlockBehaviour.Properties settingsStone = ModBlocks.shopSettings(Blocks.f_50069_);
    public static final BlockBehaviour.Properties settingsCarpet = ModBlocks.shopSettings(Blocks.f_50350_);
    public static final List<RegistryObject<? extends AbstractShopBlock>> ALL_SHOPS = new ArrayList<RegistryObject<? extends AbstractShopBlock>>();
    public static final List<RegistryObject<? extends AbstractShopBlock>> BASIC_SHOPS = new ArrayList<RegistryObject<? extends AbstractShopBlock>>();
    public static final List<RegistryObject<ShelfShopBlock>> ALL_SHELF_SHOPS = new ArrayList<RegistryObject<ShelfShopBlock>>(11);
    public static final List<RegistryObject<WindowSillShopBlock>> ALL_WINDOW_SHOPS = new ArrayList<RegistryObject<WindowSillShopBlock>>(10);
    public static final List<RegistryObject<RugShopBlock>> ALL_RUG_SHOPS = new ArrayList<RegistryObject<RugShopBlock>>(11);
    public static final RegistryObject<AngledShopBlock> SHOP_BLOCK_ANGLED_ACACIA = ModBlocks.registerAngledShopBlock(VariantResources.wood_variant.ACACIA, new PostRegAssigner<Item>(() -> Items.f_42795_));
    public static final RegistryObject<AngledShopBlock> SHOP_BLOCK_ANGLED_BAMBOO = ModBlocks.registerAngledShopBlock(VariantResources.wood_variant.BAMBOO, new PostRegAssigner<Item>(() -> Items.f_243694_));
    public static final RegistryObject<AngledShopBlock> SHOP_BLOCK_ANGLED_BIRCH = ModBlocks.registerAngledShopBlock(VariantResources.wood_variant.BIRCH, new PostRegAssigner<Item>(() -> Items.f_42753_));
    public static final RegistryObject<AngledShopBlock> SHOP_BLOCK_ANGLED_CHERRY = ModBlocks.registerAngledShopBlock(VariantResources.wood_variant.CHERRY, new PostRegAssigner<Item>(() -> Items.f_271154_));
    public static final RegistryObject<AngledShopBlock> SHOP_BLOCK_ANGLED_CRIMSON = ModBlocks.registerAngledShopBlock(VariantResources.wood_variant.CRIMSON, new PostRegAssigner<Item>(() -> Items.f_42797_));
    public static final RegistryObject<AngledShopBlock> SHOP_BLOCK_ANGLED_DARK_OAK = ModBlocks.registerAngledShopBlock(VariantResources.wood_variant.DARK_OAK, new PostRegAssigner<Item>(() -> Items.f_42796_));
    public static final RegistryObject<AngledShopBlock> SHOP_BLOCK_ANGLED_MANGROVE = ModBlocks.registerAngledShopBlock(VariantResources.wood_variant.MANGROVE, new PostRegAssigner<Item>(() -> Items.f_220174_));
    public static final RegistryObject<AngledShopBlock> SHOP_BLOCK_ANGLED_OAK = ModBlocks.registerAngledShopBlock(VariantResources.wood_variant.OAK, new PostRegAssigner<Item>(() -> Items.f_42647_));
    public static final RegistryObject<AngledShopBlock> SHOP_BLOCK_ANGLED_SPRUCE = ModBlocks.registerAngledShopBlock(VariantResources.wood_variant.SPRUCE, new PostRegAssigner<Item>(() -> Items.f_42700_));
    public static final RegistryObject<AngledShopBlock> SHOP_BLOCK_ANGLED_WARPED = ModBlocks.registerAngledShopBlock(VariantResources.wood_variant.WARPED, new PostRegAssigner<Item>(() -> Items.f_42798_));
    public static final RegistryObject<AngledShopBlock> SHOP_BLOCK_ANGLED_JUNGLE = ModBlocks.registerAngledShopBlock(VariantResources.wood_variant.JUNGLE, new PostRegAssigner<Item>(() -> Items.f_42794_));
    public static final RegistryObject<WindowSillShopBlock> SHOP_BLOCK_WINDOW_CALCITE = ModBlocks.registerWindowShopBlock("calcite", new PostRegAssigner<Item>(() -> Items.f_151047_));
    public static final RegistryObject<WindowSillShopBlock> SHOP_BLOCK_WINDOW_ANDESITE = ModBlocks.registerWindowShopBlock("andesite", new PostRegAssigner<Item>(() -> Items.f_42170_));
    public static final RegistryObject<HookShopBlock> SHOP_BLOCK_HOOK = ModBlocks.registerBasic("hook_shop", () -> new HookShopBlock(settingsChain));
    public static final RegistryObject<RugShopBlock> SHOP_BLOCK_RUG_RED = ModBlocks.registerRugLegacy();
    public static final RegistryObject<RugShopBlock> SHOP_BLOCK_RUG_WHITE = ModBlocks.registerRug("white", new PostRegAssigner<Item>(() -> Items.f_42130_), new PostRegAssigner<Item>(() -> Items.f_42535_));
    public static final RegistryObject<RugShopBlock> SHOP_BLOCK_RUG_ORANGE = ModBlocks.registerRug("orange", new PostRegAssigner<Item>(() -> Items.f_42131_), new PostRegAssigner<Item>(() -> Items.f_42536_));
    public static final RegistryObject<RugShopBlock> SHOP_BLOCK_RUG_MAGENTA = ModBlocks.registerRug("magenta", new PostRegAssigner<Item>(() -> Items.f_42132_), new PostRegAssigner<Item>(() -> Items.f_42537_));
    public static final RegistryObject<RugShopBlock> SHOP_BLOCK_RUG_LIGHT_BLUE = ModBlocks.registerRug("light_blue", new PostRegAssigner<Item>(() -> Items.f_42133_), new PostRegAssigner<Item>(() -> Items.f_42538_));
    public static final RegistryObject<RugShopBlock> SHOP_BLOCK_RUG_YELLOW = ModBlocks.registerRug("yellow", new PostRegAssigner<Item>(() -> Items.f_42134_), new PostRegAssigner<Item>(() -> Items.f_42539_));
    public static final RegistryObject<RugShopBlock> SHOP_BLOCK_RUG_LIME = ModBlocks.registerRug("lime", new PostRegAssigner<Item>(() -> Items.f_42135_), new PostRegAssigner<Item>(() -> Items.f_42540_));
    public static final RegistryObject<RugShopBlock> SHOP_BLOCK_RUG_PINK = ModBlocks.registerRug("pink", new PostRegAssigner<Item>(() -> Items.f_42136_), new PostRegAssigner<Item>(() -> Items.f_42489_));
    public static final RegistryObject<RugShopBlock> SHOP_BLOCK_RUG_GRAY = ModBlocks.registerRug("gray", new PostRegAssigner<Item>(() -> Items.f_42137_), new PostRegAssigner<Item>(() -> Items.f_42490_));
    public static final RegistryObject<RugShopBlock> SHOP_BLOCK_RUG_LIGHT_GRAY = ModBlocks.registerRug("light_gray", new PostRegAssigner<Item>(() -> Items.f_42138_), new PostRegAssigner<Item>(() -> Items.f_42491_));
    public static final RegistryObject<RugShopBlock> SHOP_BLOCK_RUG_CYAN = ModBlocks.registerRug("cyan", new PostRegAssigner<Item>(() -> Items.f_42139_), new PostRegAssigner<Item>(() -> Items.f_42492_));
    public static final RegistryObject<RugShopBlock> SHOP_BLOCK_RUG_PURPLE = ModBlocks.registerRug("purple", new PostRegAssigner<Item>(() -> Items.f_42140_), new PostRegAssigner<Item>(() -> Items.f_42493_));
    public static final RegistryObject<RugShopBlock> SHOP_BLOCK_RUG_BLUE = ModBlocks.registerRug("blue", new PostRegAssigner<Item>(() -> Items.f_42141_), new PostRegAssigner<Item>(() -> Items.f_42494_));
    public static final RegistryObject<RugShopBlock> SHOP_BLOCK_RUG_BROWN = ModBlocks.registerRug("brown", new PostRegAssigner<Item>(() -> Items.f_42142_), new PostRegAssigner<Item>(() -> Items.f_42495_));
    public static final RegistryObject<RugShopBlock> SHOP_BLOCK_RUG_GREEN = ModBlocks.registerRug("green", new PostRegAssigner<Item>(() -> Items.f_42143_), new PostRegAssigner<Item>(() -> Items.f_42496_));
    public static final RegistryObject<RugShopBlock> SHOP_BLOCK_RUG_BLACK = ModBlocks.registerRug("black", new PostRegAssigner<Item>(() -> Items.f_42198_), new PostRegAssigner<Item>(() -> Items.f_42498_));
    public static final RegistryObject<CrateShopBlock> SHOP_BLOCK_CRATE = ModBlocks.registerBasic("crate_shop", () -> new CrateShopBlock(settingsWood));
    public static final RegistryObject<ShelfShopBlock> SHOP_BLOCK_SHELF_ACACIA = ModBlocks.registerShelf(VariantResources.wood_variant.ACACIA, new PostRegAssigner<Block>(() -> Blocks.f_50402_));
    public static final RegistryObject<ShelfShopBlock> SHOP_BLOCK_SHELF_BAMBOO = ModBlocks.registerShelf(VariantResources.wood_variant.BAMBOO, new PostRegAssigner<Block>(() -> Blocks.f_244004_));
    public static final RegistryObject<ShelfShopBlock> SHOP_BLOCK_SHELF_BIRCH = ModBlocks.registerShelf(VariantResources.wood_variant.BIRCH, new PostRegAssigner<Block>(() -> Blocks.f_50400_));
    public static final RegistryObject<ShelfShopBlock> SHOP_BLOCK_SHELF_CHERRY = ModBlocks.registerShelf(VariantResources.wood_variant.CHERRY, new PostRegAssigner<Block>(() -> Blocks.f_271301_));
    public static final RegistryObject<ShelfShopBlock> SHOP_BLOCK_SHELF_CRIMSON = ModBlocks.registerShelf(VariantResources.wood_variant.CRIMSON, new PostRegAssigner<Block>(() -> Blocks.f_50657_));
    public static final RegistryObject<ShelfShopBlock> SHOP_BLOCK_SHELF_DARK_OAK = ModBlocks.registerShelf(VariantResources.wood_variant.DARK_OAK, new PostRegAssigner<Block>(() -> Blocks.f_50403_));
    public static final RegistryObject<ShelfShopBlock> SHOP_BLOCK_SHELF_MANGROVE = ModBlocks.registerShelf(VariantResources.wood_variant.MANGROVE, new PostRegAssigner<Block>(() -> Blocks.f_220851_));
    public static final RegistryObject<ShelfShopBlock> SHOP_BLOCK_SHELF_OAK = ModBlocks.registerShelf(VariantResources.wood_variant.OAK, new PostRegAssigner<Block>(() -> Blocks.f_50398_));
    public static final RegistryObject<ShelfShopBlock> SHOP_BLOCK_SHELF_SPRUCE = ModBlocks.registerShelf(VariantResources.wood_variant.SPRUCE, new PostRegAssigner<Block>(() -> Blocks.f_50399_));
    public static final RegistryObject<ShelfShopBlock> SHOP_BLOCK_SHELF_WARPED = ModBlocks.registerShelf(VariantResources.wood_variant.WARPED, new PostRegAssigner<Block>(() -> Blocks.f_50658_));
    public static final RegistryObject<ShelfShopBlock> SHOP_BLOCK_SHELF_JUNGLE = ModBlocks.registerShelf(VariantResources.wood_variant.JUNGLE, new PostRegAssigner<Block>(() -> Blocks.f_50401_));

    private static BlockBehaviour.Properties shopSettings(Block example) {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)example).m_60955_().m_60913_(2.0f, Float.MAX_VALUE);
    }

    private static RegistryObject<AngledShopBlock> registerAngledShopBlock(VariantResources.wood_variant variant, PostRegAssigner<Item> woodType) {
        String name = "shop_" + variant.name;
        RegistryObject block = BLOCKS.register(name, () -> new AngledShopBlock(settingsWood, woodType, variant));
        VariantResources.putItem(VariantResources.ANGLED, woodType, () -> ((RegistryObject)block).get());
        for (Colour colour : Colour.values()) {
            RegistryObject<ShopItem> item = ModBlocks.registerShopBlockItem(name, (RegistryObject<AngledShopBlock>)block, colour);
            postRegistryTasks.add(() -> ((AngledShopBlock)((Object)((Object)block.get()))).addDropItem((ShopItem)((Object)((Object)item.get())), colour));
        }
        ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return ModBlocks.addToAllShops(block);
    }

    private static RegistryObject<RugShopBlock> registerRug(String colour, PostRegAssigner<Item> carpet, PostRegAssigner<Item> dye) {
        RegistryObject<RugShopBlock> rug = ModBlocks.registerBasic("rug_shop_" + colour, () -> new RugShopBlock(carpet, colour));
        ALL_RUG_SHOPS.add(rug);
        VariantResources.putItem(VariantResources.RUGS_CARPET, carpet, rug);
        VariantResources.putItem(VariantResources.RUGS_DYE, dye, rug);
        return rug;
    }

    private static RegistryObject<RugShopBlock> registerRugLegacy() {
        String name = "rug_shop";
        RegistryObject<RugShopBlock> rug = ModBlocks.registerBasic(name, () -> new RugShopBlock(new PostRegAssigner<Item>(() -> Items.f_42197_), "red"));
        ALL_RUG_SHOPS.add(rug);
        VariantResources.putItem(VariantResources.RUGS_CARPET, new PostRegAssigner<Item>(() -> Items.f_42197_), () -> rug.get());
        VariantResources.putItem(VariantResources.RUGS_DYE, new PostRegAssigner<Item>(() -> Items.f_42497_), () -> rug.get());
        return rug;
    }

    private static RegistryObject<ShelfShopBlock> registerShelf(VariantResources.wood_variant variant, PostRegAssigner<Block> slab) {
        String name = "shelf_shop_" + variant.name;
        RegistryObject shop = BLOCKS.register(name, () -> new ShelfShopBlock(settingsWood, slab, variant));
        ITEMS.register(name, () -> new BlockItem((Block)shop.get(), new Item.Properties()));
        ModBlocks.addToAllShops(shop);
        ALL_SHELF_SHOPS.add((RegistryObject<ShelfShopBlock>)shop);
        VariantResources.putBlock(VariantResources.SHELF, slab, () -> ((RegistryObject)shop).get());
        return shop;
    }

    private static <S extends AbstractShopBlock> RegistryObject<S> registerBasic(String name, Supplier<S> shop) {
        RegistryObject block = ModBlocks.addToBasicShops(ModBlocks.addToAllShops(BLOCKS.register(name, shop)));
        ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }

    private static RegistryObject<WindowSillShopBlock> registerWindowShopBlock(String name, PostRegAssigner<Item> stoneType) {
        RegistryObject<WindowSillShopBlock> shop = ModBlocks.registerBasic("shop_window_" + name, () -> new WindowSillShopBlock(settingsStone, stoneType));
        ALL_WINDOW_SHOPS.add(shop);
        VariantResources.putItem(VariantResources.WINDOW_SILL, stoneType, () -> shop.get());
        return shop;
    }

    private static <S extends AbstractShopBlock> RegistryObject<S> addToAllShops(RegistryObject<S> register) {
        ALL_SHOPS.add(register);
        return register;
    }

    private static <S extends AbstractShopBlock> RegistryObject<S> addToBasicShops(RegistryObject<S> register) {
        BASIC_SHOPS.add(register);
        return register;
    }

    private static RegistryObject<ShopItem> registerShopBlockItem(String name, RegistryObject<AngledShopBlock> block, Colour colour) {
        name = (String)name + "_" + colour.asString();
        return ITEMS.register((String)name, () -> new ShopItem((AngledShopBlock)((Object)((Object)block.get())), new Item.Properties(), colour));
    }

    public static void registerModBlocks(IEventBus modEventBus) {
        SpudaciousShops.LOGGER.info("Registering mod blocks for spudaciousshops");
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
    }

    public static List<RegistryObject<? extends AbstractShopBlock>> getAllShops() {
        return ALL_SHOPS;
    }
}

