/*
 * Decompiled with CFR 0.152.
 */
package net.spudacious5705.shops.block;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class PostRegAssigner<T> {
    private static final List<PostRegAssigner<?>> assigners = new CopyOnWriteArrayList();
    private static boolean locked = false;
    private final Supplier<T> supplier;
    private Consumer<T> assignment;

    public PostRegAssigner(Supplier<T> supplier) {
        if (locked) {
            throw new IllegalStateException("Cannot create new PostRegAssigner after call for assigners to be executed");
        }
        this.supplier = supplier;
        assigners.add(this);
    }

    public void assignTo(Consumer<T> assignment) {
        this.assignment = assignment;
    }

    public void runAssignment() {
        if (this.assignment != null) {
            this.assignment.accept(this.supplier.get());
        }
    }

    public PostRegAssigner<T> copy() {
        return new PostRegAssigner<T>(this.supplier);
    }

    public static void runAllAssigners() {
        if (locked) {
            throw new IllegalStateException("PostRegAssigner.runAllAssigners called more than once");
        }
        locked = true;
        assigners.forEach(PostRegAssigner::runAssignment);
        assigners.clear();
    }
}

