/*
 * Decompiled with CFR 0.152.
 */
package net.spudacious5705.shops.block.custom;

import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.spudacious5705.shops.block.ModBlockEntities;
import net.spudacious5705.shops.block.PostRegAssigner;
import net.spudacious5705.shops.block.VariantResources;
import net.spudacious5705.shops.block.custom.AbstractShopBlock;
import net.spudacious5705.shops.block.entity.AbstractShopEntity;
import net.spudacious5705.shops.block.entity.ShelfShopEntity;
import net.spudacious5705.shops.properties.PermissionLevel;
import net.spudacious5705.shops.screen.ScreenSettingsGroup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelfShopBlock
extends AbstractShopBlock {
    public static final VoxelShape CULLING_SHAPE = ShelfShopBlock.createCuboidShape(2.0, 0.0, 2.0, 14.0, 14.0, 14.0);
    public static final VoxelShape[] SHAPES_TOP = new VoxelShape[]{ShelfShopBlock.createCuboidShape(0.5, 8.0, 8.0, 15.5, 14.0, 16.0), ShelfShopBlock.createCuboidShape(8.0, 8.0, 0.5, 16.0, 14.0, 15.5), ShelfShopBlock.createCuboidShape(0.5, 8.0, 0.0, 15.5, 14.0, 8.0), ShelfShopBlock.createCuboidShape(0.0, 8.0, 0.5, 8.0, 14.0, 15.5)};
    public static final VoxelShape[] SHAPES_BOTTOM = new VoxelShape[]{ShelfShopBlock.createCuboidShape(0.5, 0.0, 8.0, 15.5, 6.0, 16.0), ShelfShopBlock.createCuboidShape(8.0, 0.0, 0.5, 16.0, 6.0, 15.5), ShelfShopBlock.createCuboidShape(0.5, 0.0, 0.0, 15.5, 6.0, 8.0), ShelfShopBlock.createCuboidShape(0.0, 0.0, 0.5, 8.0, 6.0, 15.5)};
    public static final VoxelShape[] SHAPES_DOUBLE = ShelfShopBlock.initShapes_double();
    public static final EnumProperty<SlabType> SHELVES_ENABLED = EnumProperty.m_61587_((String)"type", SlabType.class);
    public Block SlabWoodType;
    public final VariantResources.wood_variant VARIANT;

    private static VoxelShape[] initShapes_double() {
        VoxelShape[] SHAPES = new VoxelShape[4];
        for (int i = 0; i < 4; ++i) {
            SHAPES[i] = Shapes.m_83110_((VoxelShape)SHAPES_TOP[i], (VoxelShape)SHAPES_BOTTOM[i]);
        }
        return SHAPES;
    }

    public ShelfShopBlock(BlockBehaviour.Properties properties, PostRegAssigner<Block> slabAssigner, VariantResources.wood_variant variant) {
        super(properties);
        slabAssigner.assignTo(o -> {
            this.SlabWoodType = o;
        });
        this.VARIANT = variant;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, BREAKABLE, SHELVES_ENABLED});
    }

    public String getWoodName() {
        return this.VARIANT.name;
    }

    @Override
    public ScreenSettingsGroup getScreenSettings() {
        return ScreenSettingsGroup.createBasicWood(this.VARIANT);
    }

    @Override
    protected void registerDefaultStateTemplate() {
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)BREAKABLE, (Comparable)Boolean.valueOf(false))).m_61124_(SHELVES_ENABLED, (Comparable)SlabType.DOUBLE));
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos pos = ctx.m_8083_();
        BlockState blockState = ctx.m_43725_().m_8055_(pos);
        Level world = ctx.m_43725_();
        if (ctx.m_43722_().m_150930_(blockState.m_60734_().m_5456_())) {
            return (BlockState)blockState.m_61124_(SHELVES_ENABLED, (Comparable)SlabType.DOUBLE);
        }
        Direction finalDirection = null;
        Player player = ctx.m_43723_();
        Vec3 horizontalDirections = new Vec3[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
        if (player != null) {
            Vec3 lookVec = player.m_20154_();
            Arrays.sort(horizontalDirections, Comparator.comparingDouble(dir -> -lookVec.m_82526_(Vec3.m_82528_((Vec3i)dir.m_122436_()))));
        }
        for (Vec3 direction : horizontalDirections) {
            BlockPos facingBlockPos = pos.m_121945_((Direction)direction);
            if (!world.m_8055_(facingBlockPos).m_60783_((BlockGetter)world, facingBlockPos, direction.m_122424_())) continue;
            finalDirection = direction.m_122424_();
            break;
        }
        if (finalDirection == null) {
            return null;
        }
        SlabType type = ctx.m_43720_().f_82480_ - (double)pos.m_123342_() > 0.5 ? SlabType.TOP : SlabType.BOTTOM;
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, finalDirection)).m_61124_((Property)BREAKABLE, (Comparable)Boolean.valueOf(false))).m_61124_(SHELVES_ENABLED, (Comparable)type);
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ShelfShopEntity(pos, state);
    }

    @Override
    protected boolean onUseWithItem(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player) {
        BlockEntity blockEntity;
        Item item = stack.m_41720_();
        if (item != this.SlabWoodType.m_5456_() && (blockEntity = world.m_7702_(pos)) instanceof ShelfShopEntity) {
            ShelfShopEntity shopEntity = (ShelfShopEntity)blockEntity;
            if (VariantResources.SHELF.containsKey(item)) {
                ShelfShopBlock newShelf = VariantResources.SHELF.get(item);
                if (!player.m_7500_()) {
                    int i;
                    int n = i = state.m_61143_(SHELVES_ENABLED) == SlabType.DOUBLE ? 2 : 1;
                    if (stack.m_41613_() < i) {
                        return false;
                    }
                    stack.m_41774_(i);
                    ItemStack dropStack = this.SlabWoodType.m_5456_().m_7968_();
                    dropStack.m_41764_(i);
                    world.m_7967_((Entity)new ItemEntity(world, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), dropStack, 0.0, (double)0.1f, 0.0));
                }
                world.m_46597_(pos, this.copyValues(newShelf.m_49966_(), state, new Property[]{FACING, SHELVES_ENABLED}));
                shopEntity.forceUpdateClient();
                return true;
            }
        }
        return false;
    }

    @Override
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (ModBlockEntities.SHELF_SHOP_ENTITY.get() == type) {
            return level.f_46443_ ? (lvl, pos, st, be) -> ((ShelfShopEntity)be).renderTick() : (lvl, pos, st, be) -> ((ShelfShopEntity)be).serverTick((ServerLevel)lvl, pos, st);
        }
        return null;
    }

    @Override
    @NotNull
    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return CULLING_SHAPE;
    }

    @Override
    protected VoxelShape getGenericShape(BlockState state) {
        int select = switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> 0;
            case Direction.WEST -> 1;
            case Direction.SOUTH -> 2;
            default -> 3;
        };
        return switch ((SlabType)state.m_61143_(SHELVES_ENABLED)) {
            case SlabType.TOP -> SHAPES_TOP[select];
            case SlabType.BOTTOM -> SHAPES_BOTTOM[select];
            default -> SHAPES_DOUBLE[select];
        };
    }

    public boolean m_6864_(BlockState state, @NotNull BlockPlaceContext context) {
        if (state.m_61143_(SHELVES_ENABLED) == SlabType.DOUBLE) {
            return false;
        }
        return context.m_43722_().m_150930_(state.m_60734_().m_5456_());
    }

    @Override
    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21120_(hand);
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof AbstractShopEntity)) {
            return InteractionResult.FAIL;
        }
        AbstractShopEntity shop = (AbstractShopEntity)be;
        PermissionLevel perm = ShelfShopBlock.userSignIn(level, pos, player);
        if (!stack.m_41619_() && perm.canEditTrades() && this.onUseWithItem(stack, state, level, pos, player)) {
            return InteractionResult.SUCCESS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)shop.createScreenHandlerFactory(false), buf -> {
                buf.m_130064_(pos);
                buf.writeBoolean(hit.m_82450_().f_82480_ - (double)pos.m_123342_() > 0.5);
            });
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected boolean isStateReplacedValid(BlockState newShopState) {
        return newShopState.m_60734_() instanceof ShelfShopBlock;
    }
}

