/*
 * Decompiled with CFR 0.152.
 */
package net.spudacious5705.shops.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.spudacious5705.shops.block.ModBlockEntities;
import net.spudacious5705.shops.block.entity.AbstractShopEntity;
import net.spudacious5705.shops.properties.Colour;
import net.spudacious5705.shops.util.CushionTextures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngledShopEntity
extends AbstractShopEntity {
    private Colour cushionColour;
    private static final String COLOUR_NBT_TAG = "cushion_colour";

    public AngledShopEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.ANGLED_SHOP_ENTITY.get(), pos, state, 0.375f);
    }

    @Override
    public int getTextureId() {
        return 0;
    }

    @Override
    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.cushionColour = tag.m_128441_(COLOUR_NBT_TAG) ? Colour.fromId(tag.m_128451_(COLOUR_NBT_TAG)) : Colour.RED;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        tag.m_128405_(COLOUR_NBT_TAG, this.getCushionColour().getId());
        super.m_183515_(tag);
    }

    public Colour getCushionColour() {
        return this.cushionColour == null ? Colour.ORANGE : this.cushionColour;
    }

    public void setCushionColour(@NotNull Colour colour) {
        this.cushionColour = colour;
    }

    public ResourceLocation getCushionTextureID() {
        return CushionTextures.TEXTURE_MAP.get((Object)this.getCushionColour());
    }
}

