/*
 * Decompiled with CFR 0.152.
 */
package net.spudacious5705.shops.block.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.spudacious5705.shops.screen.ShopScreenHandlerOwner;

public class ShopInventory
extends NonNullList<ItemStack> {
    protected static final int INV_SIZE = 78;
    public static final int PAYMENT_SLOT = 76;
    public static final int VENDING_SLOT = 77;
    protected static final int STOCK_END = 53;
    protected static final int PROFIT_END = 75;

    protected ShopInventory(List<ItemStack> delegate) {
        super(delegate, (Object)ItemStack.f_41583_);
    }

    public static ShopInventory create() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(Collections.nCopies(78, ItemStack.f_41583_));
        return new ShopInventory(stacks);
    }

    boolean outOfStock() {
        int stock = 0;
        ItemStack vend = (ItemStack)this.get(77);
        for (int i = 0; i <= 53; ++i) {
            ItemStack stockStack = (ItemStack)this.get(i);
            if (!ShopScreenHandlerOwner.canUseInTrade(vend, stockStack) || (stock += stockStack.m_41613_()) < vend.m_41613_()) continue;
            return false;
        }
        return true;
    }

    boolean paymentRegisterFull() {
        int space = 0;
        ItemStack paymentType = (ItemStack)this.get(76);
        int price = paymentType.m_41613_();
        for (int i = 75; i > 53; --i) {
            ItemStack paymentSlot = (ItemStack)this.get(i);
            if (paymentSlot.m_41619_()) {
                space += paymentType.m_41741_();
            } else if (ShopScreenHandlerOwner.canUseInTrade(paymentSlot, paymentType)) {
                space += paymentSlot.m_41741_() - paymentSlot.m_41613_();
            }
            if (space < price) continue;
            return false;
        }
        return true;
    }

    boolean isPlayerPoor(Player player) {
        Inventory inv = player.m_150109_();
        ItemStack payment = this.getPaymentStack();
        int money = 0;
        for (int i = 0; i <= 36; ++i) {
            if (!ShopScreenHandlerOwner.canUseInTrade(inv.m_8020_(i), payment) || (money += inv.m_8020_(i).m_41613_()) < payment.m_41613_()) continue;
            return false;
        }
        return true;
    }

    public ShopInventory prepForItemScatterer() {
        this.set(76, ItemStack.f_41583_);
        this.set(77, ItemStack.f_41583_);
        return this;
    }

    public ItemStack getVendingStack() {
        return ((ItemStack)this.get(77)).m_41777_();
    }

    public ItemStack getPaymentStack() {
        return ((ItemStack)this.get(76)).m_41777_();
    }

    public int size() {
        return 78;
    }

    public int getVendingQuantity() {
        return this.getVendingStack().m_41613_();
    }

    public int getPrice() {
        return ((ItemStack)this.get(76)).m_41613_();
    }

    public ItemStack split(int slot, int amount) {
        return ((ItemStack)this.get(slot)).m_41620_(amount);
    }

    public Item getDisplayItem() {
        return ((ItemStack)this.get(77)).m_41720_();
    }

    public Item getPaymentType() {
        return ((ItemStack)this.get(76)).m_41720_();
    }

    public boolean tradeFunctional() {
        return !this.tradeNonFunctional();
    }

    public boolean tradeNonFunctional() {
        boolean bl = ((ItemStack)this.get(76)).m_41619_() || ((ItemStack)this.get(77)).m_41619_();
        return bl;
    }

    public static void ItemScatterer(Level world, BlockPos pos, ItemStack itemStack) {
        Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemStack);
    }

    public static void ItemScatterer(Level world, BlockPos pos, NonNullList<ItemStack> inventory) {
        Containers.m_19010_((Level)world, (BlockPos)pos, inventory);
    }
}

