/*
 * Decompiled with CFR 0.152.
 */
package net.spudacious5705.shops.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.spudacious5705.shops.block.entity.AbstractShopEntity;
import net.spudacious5705.shops.block.entity.ShelfShopEntity;
import net.spudacious5705.shops.block.entity.renderer.ShopRenderUtils;

public class ShelfShopEntityRenderer
implements BlockEntityRenderer<ShelfShopEntity>,
ShopRenderUtils {
    private final BlockEntityRendererProvider.Context context;

    public ShelfShopEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.context = ctx;
    }

    public void render(ShelfShopEntity shop, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        AbstractShopEntity.RendererData data1 = shop.rendererData();
        AbstractShopEntity.RendererData data2 = shop.rendererDataTop();
        matrices.m_85836_();
        matrices.m_252880_(0.5f, 0.5f, 0.5f);
        matrices.m_252781_(Axis.f_252436_.m_252977_(switch (shop.getCachedFacingDirection()) {
            case Direction.EAST -> 270.0f;
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            default -> 0.0f;
        }));
        this.renderShelf(data1, tickDelta, matrices, vertexConsumers, light, overlay, shop.furtherDataBottom());
        matrices.m_252880_(0.0f, 0.44f, 0.0f);
        this.renderShelf(data2, tickDelta, matrices, vertexConsumers, light, overlay, shop.furtherDataTop());
        matrices.m_85849_();
        ShopRenderUtils.renderShopWarns(tickDelta, matrices, vertexConsumers, light, overlay, data1, this.context, -1.05f, 0.3f);
        ShopRenderUtils.renderShopWarns(tickDelta, matrices, vertexConsumers, light, overlay, data2, this.context, -0.6f, 0.3f);
    }

    private void renderShelf(AbstractShopEntity.RendererData data, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay, ShelfShopEntity.ShelfRenderData furtherData) {
        Font font = this.context.m_173586_();
        if (data != null) {
            data.frameAccumulator();
            if (data.shopFunctional()) {
                int renderCount;
                Axis rotationAxis;
                float itemTranslationFactor;
                ItemDisplayContext mode;
                matrices.m_85836_();
                matrices.m_252880_(0.0f, -0.216f, 0.3f);
                if (data.stockDisplayType()) {
                    matrices.m_85841_(0.2f, 0.2f, 0.2f);
                    mode = ItemDisplayContext.NONE;
                    itemTranslationFactor = 1.15f;
                    rotationAxis = Axis.f_252436_;
                    renderCount = 1;
                } else {
                    matrices.m_252880_(0.0f, -0.08f, 0.0f);
                    matrices.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                    matrices.m_85841_(0.4f, 0.4f, 0.4f);
                    mode = ItemDisplayContext.GUI;
                    itemTranslationFactor = 0.5f;
                    rotationAxis = Axis.f_252403_;
                    renderCount = 3;
                }
                for (int y = 0; y < renderCount; ++y) {
                    matrices.m_85836_();
                    matrices.m_252880_(-itemTranslationFactor, 0.0f, (float)(-y) * 0.05f);
                    matrices.m_252781_(rotationAxis.m_252977_(furtherData.itemLrotation + (float)(y + 1) * 55.0f));
                    this.context.m_234447_().m_115143_(data.displayItem(), mode, false, matrices, vertexConsumers, light, overlay, this.context.m_234447_().m_174264_(data.displayItem(), null, null, 0));
                    matrices.m_85849_();
                    matrices.m_85836_();
                    matrices.m_252880_(itemTranslationFactor, 0.0f, (float)(-y) * 0.05f);
                    matrices.m_252781_(rotationAxis.m_252977_(furtherData.itemRrotation + (float)(y + 1) * 55.0f));
                    this.context.m_234447_().m_115143_(data.displayItem(), mode, false, matrices, vertexConsumers, light, overlay, this.context.m_234447_().m_174264_(data.displayItem(), null, null, 0));
                    matrices.m_85849_();
                }
                matrices.m_85849_();
                if (data.stockDisplayType()) {
                    float scaleFactor;
                    matrices.m_85836_();
                    matrices.m_252880_(-0.02f, -0.3124f, 0.16f);
                    matrices.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                    matrices.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                    matrices.m_85841_(0.02f, 0.02f, -0.02f);
                    font.m_271703_(data.text(), data.width(), -4.0f, 0xFFFFFF, false, matrices.m_85850_().m_252922_(), vertexConsumers, Font.DisplayMode.NORMAL, 0, light);
                    matrices.m_85849_();
                    matrices.m_85836_();
                    matrices.m_252880_(-0.02f, -0.17f, 0.43749f);
                    matrices.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                    matrices.m_85841_(0.022f, 0.022f, -0.022f);
                    font.m_271703_(data.stockQuantity, data.qWidth(), -4.0f, 0xFFFF00, false, matrices.m_85850_().m_252922_(), vertexConsumers, Font.DisplayMode.NORMAL, 0, light);
                    matrices.m_85849_();
                    matrices.m_85836_();
                    matrices.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    if (data.currencyDisplayType()) {
                        scaleFactor = 0.16f;
                        matrices.m_252880_(0.0f, -0.265f, -0.35f);
                        matrices.m_252781_(Axis.f_252529_.m_252977_(-30.0f));
                    } else {
                        scaleFactor = 0.35f;
                        matrices.m_252880_(0.0f, -0.308f, -0.34f);
                        matrices.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                    }
                    matrices.m_85841_(scaleFactor, scaleFactor, scaleFactor);
                    this.context.m_234447_().m_115143_(data.paymentType(), ItemDisplayContext.GUI, false, matrices, vertexConsumers, light, overlay, this.context.m_234447_().m_174264_(data.paymentType(), null, null, 0));
                    matrices.m_85849_();
                } else {
                    float scaleFactor;
                    matrices.m_85836_();
                    matrices.m_252880_(-0.08f, -0.16f, 0.43749f);
                    matrices.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                    matrices.m_85841_(0.016f, 0.016f, -0.016f);
                    font.m_271703_(data.text(), data.width(), -4.0f, 0xFFFFFF, false, matrices.m_85850_().m_252922_(), vertexConsumers, Font.DisplayMode.NORMAL, 0, light);
                    matrices.m_85849_();
                    matrices.m_85836_();
                    matrices.m_252880_(0.2f, -0.16f, 0.43749f);
                    matrices.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                    matrices.m_85841_(0.016f, 0.016f, -0.016f);
                    font.m_271703_(data.stockQuantity, data.qWidth(), -4.0f, 0xFFFF00, false, matrices.m_85850_().m_252922_(), vertexConsumers, Font.DisplayMode.NORMAL, 0, light);
                    matrices.m_85849_();
                    matrices.m_85836_();
                    matrices.m_252880_(-0.245f, -0.16f, 0.43f);
                    if (data.currencyDisplayType()) {
                        matrices.m_252781_(Axis.f_252529_.m_252977_(20.0f));
                        scaleFactor = 0.16f;
                    } else {
                        scaleFactor = 0.22f;
                    }
                    matrices.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    matrices.m_85841_(scaleFactor, scaleFactor, scaleFactor);
                    this.context.m_234447_().m_115143_(data.paymentType(), ItemDisplayContext.GUI, false, matrices, vertexConsumers, light, overlay, this.context.m_234447_().m_174264_(data.displayItem(), null, null, 0));
                    matrices.m_85849_();
                }
            }
        }
    }
}

