/*
 * Decompiled with CFR 0.152.
 */
package net.spudacious5705.shops.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemDisplayContext;
import net.spudacious5705.shops.block.entity.AbstractShopEntity;
import net.spudacious5705.shops.block.entity.renderer.ShopIconModels;

public interface ShopRenderUtils {
    public static void renderShopWarns(float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay, AbstractShopEntity.RendererData data, BlockEntityRendererProvider.Context context, float yOffset) {
        ShopRenderUtils.renderShopWarns(tickDelta, matrices, vertexConsumers, light, overlay, data, context, yOffset, 0.5f);
    }

    public static void renderShopWarns(float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay, AbstractShopEntity.RendererData data, BlockEntityRendererProvider.Context context, float yOffset, float scale) {
        if (data.shopFunctional() && data.renderIcons() && (data.stockWarning || data.paymentWarning)) {
            if (data.updateIconRotation()) {
                data.targetRotation = ShopRenderUtils.calcTargetRotation(data);
            }
            data.frameRotation = data.targetRotation - data.lastRotation;
            if (data.frameRotation > Math.PI) {
                data.frameRotation -= Math.PI * 2;
            } else if (data.frameRotation < -Math.PI) {
                data.frameRotation += Math.PI * 2;
            }
            data.frameRotation *= (double)tickDelta * 0.08;
            data.lastRotation += data.frameRotation;
            if (data.lastRotation > Math.PI) {
                data.lastRotation -= data.doublePi;
            } else if (data.lastRotation < -Math.PI) {
                data.lastRotation += data.doublePi;
            }
            matrices.m_85836_();
            matrices.m_252880_(0.5f, 1.4f + yOffset, 0.5f);
            matrices.m_252781_(Axis.f_252436_.m_252961_((float)data.lastRotation));
            matrices.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            matrices.m_85841_(scale, scale, scale);
            if (data.stockWarning && data.paymentWarning) {
                matrices.m_252880_(0.5f, 0.0f, 0.0f);
                context.m_234447_().m_115143_(ShopIconModels.NO_STOCK, ItemDisplayContext.GUI, false, matrices, vertexConsumers, light, overlay, context.m_234447_().m_174264_(ShopIconModels.NO_STOCK, null, null, 0));
                matrices.m_252880_(-1.0f, 0.0f, 0.0f);
                context.m_234447_().m_115143_(ShopIconModels.REG_FULL, ItemDisplayContext.GUI, false, matrices, vertexConsumers, light, overlay, context.m_234447_().m_174264_(ShopIconModels.REG_FULL, null, null, 0));
                matrices.m_85849_();
            } else if (data.stockWarning) {
                context.m_234447_().m_115143_(ShopIconModels.NO_STOCK, ItemDisplayContext.GUI, false, matrices, vertexConsumers, light, overlay, context.m_234447_().m_174264_(ShopIconModels.NO_STOCK, null, null, 0));
                matrices.m_85849_();
            } else {
                context.m_234447_().m_115143_(ShopIconModels.REG_FULL, ItemDisplayContext.GUI, false, matrices, vertexConsumers, light, overlay, context.m_234447_().m_174264_(ShopIconModels.REG_FULL, null, null, 0));
                matrices.m_85849_();
            }
        }
    }

    public static double calcTargetRotation(AbstractShopEntity.RendererData data) {
        LocalPlayer player1 = Minecraft.m_91087_().f_91074_;
        if (player1 != null) {
            double px = player1.m_20185_();
            double pz = player1.m_20189_();
            double dx = data.x();
            double dz = data.z();
            double x = px - (dx + 0.5);
            double z = pz - (dz + 0.5);
            return -Math.atan2(z, x);
        }
        return data.targetRotation;
    }
}

