/*
 * Decompiled with CFR 0.152.
 */
package net.spudacious5705.shops.config;

import com.electronwill.nightconfig.core.file.FileConfig;
import java.io.File;
import java.util.EnumMap;
import net.spudacious5705.shops.screen.ToggleButtonID;

public class ConfigHandler {
    private static final File CONFIG_PATH = new File("config/spudaciousshops.toml");
    public static FileConfig config;
    private static final EnumMap<ToggleButtonID, Boolean> toggleSettingsStates;

    private static EnumMap<ToggleButtonID, Boolean> getDefaultToggleSettingStates() {
        EnumMap<ToggleButtonID, Boolean> tss = new EnumMap<ToggleButtonID, Boolean>(ToggleButtonID.class);
        config = FileConfig.of((File)CONFIG_PATH);
        config.load();
        String TogEffectID = "ToggleEffectsDefault";
        boolean effectsEnabled = true;
        if (!config.contains(TogEffectID)) {
            config.set(TogEffectID, (Object)true);
            config.save();
        } else {
            effectsEnabled = (Boolean)config.getOrElse(TogEffectID, (Object)true);
        }
        for (ToggleButtonID value : ToggleButtonID.values()) {
            tss.put(value, switch (value) {
                default -> throw new IncompatibleClassChangeError();
                case ToggleButtonID.CreativeToggle -> false;
                case ToggleButtonID.ShopStyleToggle -> false;
                case ToggleButtonID.IgnoreNBTToggle -> false;
                case ToggleButtonID.EffectsToggle -> effectsEnabled;
            });
        }
        return tss;
    }

    public static Boolean getDefaultToggleSetting(ToggleButtonID ID) {
        return toggleSettingsStates.getOrDefault((Object)ID, false);
    }

    public static void initialise() {
    }

    static {
        toggleSettingsStates = ConfigHandler.getDefaultToggleSettingStates();
    }
}

