/*
 * Decompiled with CFR 0.152.
 */
package net.spudacious5705.shops.lootcondition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.spudacious5705.shops.block.entity.AngledShopEntity;
import net.spudacious5705.shops.lootcondition.ModLootConditions;

public class MatchingCushionColourCondition
implements LootItemCondition {
    private final String expectedColourName;

    public MatchingCushionColourCondition(String expectedColourName) {
        this.expectedColourName = expectedColourName;
    }

    public LootItemConditionType m_7940_() {
        return ModLootConditions.MATCHES_ENUM;
    }

    public boolean test(LootContext lootContext) {
        BlockEntity blockEntity = (BlockEntity)lootContext.m_165124_(LootContextParams.f_81462_);
        if (blockEntity instanceof AngledShopEntity) {
            AngledShopEntity shop = (AngledShopEntity)blockEntity;
            return shop.getCushionColour().matchesString(this.expectedColourName);
        }
        return false;
    }

    public static class ConditionSerializer
    implements Serializer<MatchingCushionColourCondition> {
        public void serialize(JsonObject json, MatchingCushionColourCondition condition, JsonSerializationContext context) {
            json.addProperty("expected_colour", condition.expectedColourName);
        }

        public MatchingCushionColourCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            String colourName = json.get("expected_colour").getAsString();
            return new MatchingCushionColourCondition(colourName);
        }
    }
}

