/*
 * Decompiled with CFR 0.152.
 */
package net.spudacious5705.shops.properties;

public enum PermissionLevel {
    SERVER_ADMIN(true, false, false, false, false, false, -1),
    OWNER(true, true, true, true, true, true, 4),
    MANAGER(false, true, true, true, false, true, 3),
    SUPERVISOR(false, false, true, true, false, true, 2),
    CLERK(false, false, true, false, false, true, 1),
    CUSTOMER(false, false, false, false, false, false, 0);

    final boolean breakBlock;
    final boolean editPermissions;
    final boolean importStock;
    final boolean takeItems;
    final boolean editTrades;
    final boolean viewShopScreen;
    final int level;

    private PermissionLevel(boolean breakBlock, boolean editPermissions, boolean importStock, boolean takeItems, boolean editTrades, boolean viewShopScreen, int level) {
        this.breakBlock = breakBlock;
        this.editPermissions = editPermissions;
        this.importStock = importStock;
        this.takeItems = takeItems;
        this.editTrades = editTrades;
        this.viewShopScreen = viewShopScreen;
        this.level = level;
    }

    public boolean canBreakBlock() {
        return this.breakBlock;
    }

    public boolean canImportStock() {
        return this.importStock;
    }

    public boolean canTakeItems() {
        return this.takeItems;
    }

    public boolean canEditTrades() {
        return this.editTrades;
    }

    public boolean canViewShopScreen() {
        return this.viewShopScreen;
    }

    public boolean canEditPermissions() {
        return this.editPermissions;
    }

    public int asInt() {
        return this.level;
    }

    public static PermissionLevel fromInt(int queryInt) {
        for (PermissionLevel lvl : PermissionLevel.values()) {
            if (lvl.asInt() != queryInt) continue;
            return lvl;
        }
        return CUSTOMER;
    }
}

