/*
 * Decompiled with CFR 0.152.
 */
package net.spudacious5705.shops.screen;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.SlotItemHandler;
import net.spudacious5705.shops.block.entity.AbstractShopEntity;
import net.spudacious5705.shops.screen.ModScreenHandlers;
import net.spudacious5705.shops.screen.ScreenSettingsGroup;
import org.jetbrains.annotations.NotNull;

public class ShopScreenHandlerCustomer
extends AbstractContainerMenu {
    private final AbstractShopEntity.InventoryDelegate shopInventory;
    final ScreenSettingsGroup SCREEN_SETTINGS;
    private final Inventory playerInventory;
    private final BlockPos pos;
    private static final int PAYMENT_SLOT = 76;
    private static final int VENDING_SLOT = 77;
    private static final int STOCK_END = 53;
    private static final int PROFIT_END = 75;

    public ShopScreenHandlerCustomer(int syncId, Inventory playerInv, FriendlyByteBuf buf) {
        super((MenuType)ModScreenHandlers.SHOP_SCREEN_HANDLER_CUSTOMER.get(), syncId);
        this.pos = buf.m_130135_();
        boolean openTop = buf.readBoolean();
        Player player = playerInv.f_35978_;
        this.playerInventory = playerInv;
        BlockEntity blockEntity = player.m_9236_().m_7702_(this.pos);
        if (blockEntity instanceof AbstractShopEntity) {
            AbstractShopEntity.InventoryDelegate inventoryDelegate;
            AbstractShopEntity shop = (AbstractShopEntity)blockEntity;
            AbstractShopEntity.InventoryDelegate inventoryDelegate2 = inventoryDelegate = openTop ? shop.getOtherInventoryDelegate(player) : shop.getInventoryDelegate(player);
            if (inventoryDelegate != null && inventoryDelegate.m_6643_() != 78) {
                throw new IllegalArgumentException("Inventory size must be 78");
            }
            this.shopInventory = inventoryDelegate;
            this.SCREEN_SETTINGS = shop.getScreenSettings();
            this.finishSetup();
        } else {
            Minecraft.m_91087_().m_91152_(null);
            this.shopInventory = null;
            this.SCREEN_SETTINGS = null;
        }
    }

    public ShopScreenHandlerCustomer(int syncId, Inventory playerInv, AbstractShopEntity shop, AbstractShopEntity.InventoryDelegate inventoryDelegate) {
        super((MenuType)ModScreenHandlers.SHOP_SCREEN_HANDLER_CUSTOMER.get(), syncId);
        this.shopInventory = shop.getInventoryDelegate(playerInv.f_35978_);
        this.pos = shop.m_58899_();
        this.SCREEN_SETTINGS = null;
        this.playerInventory = playerInv;
        shop.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 0, 80, 11));
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 1, 80, 59));
        });
        this.finishSetup();
    }

    private void finishSetup() {
        this.playerInventory.m_5856_(this.playerInventory.f_35978_);
        this.addPlayerInventory(this.playerInventory);
        this.addCustomerInventory();
    }

    public ScreenSettingsGroup getSettings() {
        return this.SCREEN_SETTINGS;
    }

    public void addCustomerInventory() {
        this.m_38897_(new shop_payment_slot(this.shopInventory, 76, 46, 36));
        this.m_38897_(new shop_vendor_slot(this.shopInventory, 77, 115, 36, this));
    }

    public void addPlayerInventory(Inventory playerInv) {
        this.addPlayerInventory(playerInv, 8, 84);
    }

    private void addPlayerInventory(Inventory playerInventory, int offsetx, int offsety) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, offsetx + l * 18, offsety + i * 18));
            }
        }
        offsety += 58;
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, offsetx + i * 18, offsety));
        }
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int pIndex) {
        for (int tradeCount = 0; tradeCount < 64 && this.shopInventory.canTrade(player); ++tradeCount) {
            this.trade();
        }
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(@NotNull Player player) {
        return this.playerInventory.f_35978_.m_9236_().m_7702_(this.pos) instanceof AbstractShopEntity && player.m_20238_(this.pos.m_252807_()) <= 64.0;
    }

    private void trade() {
        this.shopInventory.trade(this.playerInventory);
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.playerInventory.m_5785_(player);
    }

    static class shop_payment_slot
    extends Slot {
        public shop_payment_slot(AbstractShopEntity.InventoryDelegate inventory, int index, int x, int y) {
            super((Container)inventory, index, x, y);
        }

        @NotNull
        public Optional<ItemStack> m_150641_(int pCount, int pDecrement, Player pPlayer) {
            return Optional.empty();
        }

        public boolean m_5857_(ItemStack pStack) {
            return false;
        }

        public boolean m_8010_(Player pPlayer) {
            return false;
        }

        public ItemStack m_150659_(ItemStack pStack) {
            return pStack;
        }

        public ItemStack m_150656_(ItemStack pStack, int pIncrement) {
            return pStack;
        }

        public ItemStack m_150647_(int pCount, int pDecrement, Player pPlayer) {
            return ItemStack.f_41583_;
        }

        public void m_269060_(ItemStack pStack) {
        }
    }

    class shop_vendor_slot
    extends Slot {
        private final ShopScreenHandlerCustomer handler;

        public shop_vendor_slot(AbstractShopEntity.InventoryDelegate inventory, int index, int x, int y, ShopScreenHandlerCustomer handler) {
            super((Container)inventory, index, x, y);
            this.handler = handler;
        }

        @NotNull
        public Optional<ItemStack> m_150641_(int pCount, int pDecrement, Player pPlayer) {
            if (ShopScreenHandlerCustomer.this.shopInventory.canTrade(pPlayer)) {
                this.handler.trade();
            }
            return Optional.empty();
        }

        public ItemStack m_150647_(int pCount, int pDecrement, Player pPlayer) {
            this.handler.trade();
            return ItemStack.f_41583_;
        }

        public boolean m_8010_(@NotNull Player playerEntity) {
            return ShopScreenHandlerCustomer.this.shopInventory.canTrade(playerEntity);
        }

        public boolean m_5857_(ItemStack s) {
            return false;
        }

        public ItemStack m_150659_(ItemStack pStack) {
            return pStack;
        }

        public ItemStack m_150656_(ItemStack pStack, int pIncrement) {
            return pStack;
        }
    }
}

