/*
 * Decompiled with CFR 0.152.
 */
package net.spudacious5705.shops.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.spudacious5705.shops.SpudaciousShops;
import net.spudacious5705.shops.block.entity.AbstractShopEntity;
import net.spudacious5705.shops.item.ModItems;
import net.spudacious5705.shops.properties.PermissionLevel;
import net.spudacious5705.shops.screen.ModScreenHandlers;
import net.spudacious5705.shops.screen.ScreenSettingsGroup;
import net.spudacious5705.shops.screen.ToggleButtonID;
import net.spudacious5705.shops.screen.networking.NetworkHelper;
import net.spudacious5705.shops.screen.networking.ShopTabSyncPkt;
import net.spudacious5705.shops.screen.networking.ToggleSyncPkt;
import org.jetbrains.annotations.NotNull;

public class ShopScreenHandlerOwner
extends AbstractContainerMenu {
    private final AbstractShopEntity.settings_Delegate SETTINGS_DELEGATE;
    private SettingsUpdater SETTINGS_UPDATER = null;
    private WarningActivator warningActivator;
    final AbstractShopEntity.InventoryDelegate shopInventory;
    private final AbstractShopEntity.player_ID_Records_Delegate ID_RECORDS_DELEGATE;
    final Inventory playerInventory;
    final PermissionLevel perms;
    final ScreenSettingsGroup SCREEN_SETTINGS;
    private final List<TogglableSlot> playerInvSlots = new ArrayList<TogglableSlot>();
    private final List<TogglableSlot> tabSellerSlots = new ArrayList<TogglableSlot>();
    final List<TogglableSlot> tabSettingsSlots = new ArrayList<TogglableSlot>();
    private final List<TogglableSlot> tabCustomerSlots = new ArrayList<TogglableSlot>();
    private widgetCollection widgets;
    private static final int profit_itemStacks_start = 54;
    private static final int EXPECTED_CONTAINER_SIZE = 78;
    static final int SELLER_TAB = 1;
    static final int SETTINGS_TAB = 2;
    static final int CUSTOMER_TAB = 3;
    static final int WARNING_TAB = 4;
    private int activeTab = 1;

    void initiateWarn(WarningActivator function) {
        this.warningActivator = function;
    }

    public void selfDemotePlayer(Player player) {
        if (this.activeTab == 4) {
            this.ID_RECORDS_DELEGATE.selfDemote(player);
        }
    }

    public int getActiveTab() {
        return this.activeTab;
    }

    public boolean isPlayerCreative() {
        return this.SETTINGS_DELEGATE.isPlayerCreative();
    }

    public boolean m_6875_(@NotNull Player player) {
        return this.shopInventory.m_6542_(player);
    }

    public void close() {
        this.playerInventory.f_35978_.m_6915_();
    }

    void setWidgetFunction(widgetCollection c) {
        this.widgets = c;
    }

    public ShopScreenHandlerOwner(int syncId, Inventory playerInventory, FriendlyByteBuf buf) {
        super((MenuType)ModScreenHandlers.SHOP_SCREEN_HANDLER_OWNER.get(), syncId);
        BlockPos pos = buf.m_130135_();
        boolean openTop = buf.readBoolean();
        Player player = playerInventory.f_35978_;
        this.playerInventory = playerInventory;
        BlockEntity blockEntity = player.m_9236_().m_7702_(pos);
        if (blockEntity instanceof AbstractShopEntity) {
            AbstractShopEntity.InventoryDelegate inventoryDelegate;
            AbstractShopEntity shop = (AbstractShopEntity)blockEntity;
            AbstractShopEntity.InventoryDelegate inventoryDelegate2 = inventoryDelegate = openTop ? shop.getOtherInventoryDelegate(player) : shop.getInventoryDelegate(player);
            if (inventoryDelegate != null && inventoryDelegate.m_6643_() != 78) {
                throw new IllegalArgumentException("Inventory size must be 78");
            }
            this.shopInventory = inventoryDelegate;
            this.perms = this.shopInventory.checkPermissions();
            this.SCREEN_SETTINGS = shop.getScreenSettings();
            this.ID_RECORDS_DELEGATE = shop.getRecordsDelegate(player);
            this.SETTINGS_DELEGATE = shop.getSettingsDelegate(player);
            this.finishSetup();
        } else {
            player.m_6915_();
            this.shopInventory = null;
            this.SCREEN_SETTINGS = null;
            this.perms = PermissionLevel.CUSTOMER;
            this.ID_RECORDS_DELEGATE = null;
            this.SETTINGS_DELEGATE = null;
        }
    }

    public ShopScreenHandlerOwner(int syncId, Inventory playerInventory, AbstractShopEntity shop, AbstractShopEntity.InventoryDelegate inventoryDelegate, AbstractShopEntity.player_ID_Records_Delegate recordsDelegate, AbstractShopEntity.settings_Delegate settingsDelegate) {
        super((MenuType)ModScreenHandlers.SHOP_SCREEN_HANDLER_OWNER.get(), syncId);
        this.shopInventory = inventoryDelegate;
        ShopScreenHandlerOwner.m_38869_((Container)this.shopInventory, (int)78);
        this.perms = this.shopInventory.checkPermissions();
        this.SCREEN_SETTINGS = null;
        this.playerInventory = playerInventory;
        this.ID_RECORDS_DELEGATE = recordsDelegate;
        this.SETTINGS_DELEGATE = settingsDelegate;
        this.finishSetup();
    }

    private void finishSetup() {
        this.addPlayerInventory(this.playerInventory);
        this.playerInventory.m_5856_(this.playerInventory.f_35978_);
        this.addShopInventory();
        this.addShopTrades();
        this.addContractSlots();
        this.activeTab = 1;
        this.addSettingButtons();
    }

    private void addContractSlots() {
        int offsetx = 81;
        int offsety = 69;
        for (int y = 0; y < 4; ++y) {
            for (int i = 0; i < 6; ++i) {
                new contract_slot(this.ID_RECORDS_DELEGATE, y * 6 + i, offsetx + i * 23, offsety + y * 23);
            }
        }
    }

    private void addShopTrades() {
        int x = 25;
        int y = 31;
        new shop_trade_slot(this.shopInventory, 76, x, y);
        new shop_trade_slot(this.shopInventory, 77, x, y + 47);
        new shop_payment_slot(this.shopInventory, 76, 71, 126);
        new shop_vendor_slot(this.shopInventory, 77, 140, 126, this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateTabSelectionClientside(int tab) {
        this.activeTab = tab;
        NetworkHelper.CHANNEL.sendToServer((Object)new ShopTabSyncPkt(this.activeTab));
        this.updateTabSelection();
    }

    public void updateTabSelectionServerside(int tab) {
        this.activeTab = tab;
    }

    public boolean toggleButtonServersideUpdate(ToggleButtonID button, boolean state) {
        SpudaciousShops.LOGGER.debug("packet received: {} - {}", (Object)button.getSerialised(), (Object)state);
        this.SETTINGS_DELEGATE.attemptSetState(button, state);
        return this.SETTINGS_DELEGATE.getState(button);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean updateTabSelectionResponse(int tab) {
        if (this.activeTab != tab) {
            this.activeTab = tab;
            this.updateTabSelection();
            return true;
        }
        return false;
    }

    public void updateTabSelection() {
        switch (this.activeTab) {
            case 2: {
                this.tabSettingsSlots.forEach(TogglableSlot::enable);
                this.widgets.setToVal(true);
                this.playerInvSlots.forEach(TogglableSlot::enable);
                this.tabSellerSlots.forEach(TogglableSlot::disable);
                this.tabCustomerSlots.forEach(TogglableSlot::disable);
                break;
            }
            case 3: {
                this.playerInvSlots.forEach(TogglableSlot::enable);
                this.tabCustomerSlots.forEach(TogglableSlot::enable);
                this.tabSettingsSlots.forEach(TogglableSlot::disable);
                this.widgets.setToVal(false);
                this.tabSellerSlots.forEach(TogglableSlot::disable);
                break;
            }
            case 4: {
                this.tabSettingsSlots.forEach(TogglableSlot::disable);
                this.widgets.setToVal(false);
                this.tabSellerSlots.forEach(TogglableSlot::disable);
                this.playerInvSlots.forEach(TogglableSlot::disable);
                this.tabCustomerSlots.forEach(TogglableSlot::disable);
                break;
            }
            default: {
                this.tabSellerSlots.forEach(TogglableSlot::enable);
                this.playerInvSlots.forEach(TogglableSlot::enable);
                this.tabSettingsSlots.forEach(TogglableSlot::disable);
                this.widgets.setToVal(false);
                this.tabCustomerSlots.forEach(TogglableSlot::disable);
            }
        }
    }

    void settingsUpdater(SettingsUpdater function) {
        this.SETTINGS_UPDATER = function;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateToggleButtonFromPacket(ToggleButtonID button, boolean state) {
        this.SETTINGS_UPDATER.updateSettings(button, state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean handleToggleButtonInput(ToggleButtonID button, boolean state) {
        if (this.SETTINGS_DELEGATE.attemptSetState(button, state)) {
            NetworkHelper.CHANNEL.sendToServer((Object)new ToggleSyncPkt(button, state));
            return state;
        }
        return !state;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean getStateOfSetting(ToggleButtonID button) {
        return this.SETTINGS_DELEGATE.getState(button);
    }

    private void addSettingButtons() {
    }

    private void addShopInventory() {
        int i;
        int offsetx = 59;
        int offsety = 15;
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.createShopInvSlot(j + i * 9, offsetx + j * 18, offsety + i * 18);
            }
        }
        offsetx -= 44;
        offsety += 110;
        for (i = 0; i < 11; ++i) {
            this.createShopInvSlot(54 + i, offsetx + i * 18, offsety);
        }
        offsety += 18;
        for (i = 0; i < 11; ++i) {
            this.createShopInvSlot(65 + i, offsetx + i * 18, offsety);
        }
    }

    private void createShopInvSlot(int slotIndex, int x, int y) {
        TogglableSlot slot = new TogglableSlot(this.shopInventory, slotIndex, x, y);
        this.tabSellerSlots.add(slot);
        this.m_38897_(slot);
    }

    private void addPlayerInventory(Inventory playerInventory) {
        int i;
        int offsetx = 33;
        int offsety = 174;
        for (i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                new player_slot(playerInventory, l + i * 9 + 9, offsetx + l * 18, offsety + i * 18);
            }
        }
        offsety += 58;
        for (i = 0; i < 9; ++i) {
            new player_slot(playerInventory, i, offsetx + i * 18, offsety);
        }
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int invSlot) {
        if (this.activeTab == 3) {
            int tradeCount = 0;
            while (tradeCount < 64 & this.shopInventory.canTrade(player)) {
                this.shopInventory.trade(this.playerInventory);
                ++tradeCount;
            }
            return ItemStack.f_41583_;
        }
        if (this.activeTab != 1) {
            return ItemStack.f_41583_;
        }
        if (this.f_38839_.get(invSlot) instanceof shop_vendor_slot) {
            return ItemStack.f_41583_;
        }
        if (this.f_38839_.get(invSlot) instanceof shop_trade_slot) {
            return ItemStack.f_41583_;
        }
        if (this.f_38839_.get(invSlot) instanceof contract_slot) {
            return ItemStack.f_41583_;
        }
        ItemStack newStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(invSlot);
        if (!slot.m_6657_()) {
            return newStack;
        }
        ItemStack originalStack = slot.m_7993_();
        newStack = originalStack.m_41777_();
        if (this.f_38839_.get(invSlot) instanceof player_slot ? !this.m_38903_(originalStack, 36, 90, false) : !this.m_38903_(originalStack, 0, 35, false)) {
            return ItemStack.f_41583_;
        }
        if (originalStack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        return newStack;
    }

    public ScreenSettingsGroup getSettings() {
        return this.SCREEN_SETTINGS;
    }

    private void trade() {
        this.shopInventory.trade(this.playerInventory);
    }

    public static boolean canUseInTrade(ItemStack stack, ItemStack otherStack) {
        return stack.m_150930_(otherStack.m_41720_()) && Objects.equals(stack.m_41783_(), otherStack.m_41783_());
    }

    public void m_6877_(@NotNull Player player) {
        super.m_6877_(player);
        this.playerInventory.m_5785_(player);
    }

    static interface WarningActivator {
        public void openWarnScreen();
    }

    static interface widgetCollection {
        public void setToVal(boolean var1);
    }

    static interface SettingsUpdater {
        public void updateSettings(ToggleButtonID var1, boolean var2);
    }

    class contract_slot
    extends TogglableSlot {
        private final AbstractShopEntity.player_ID_Records_Delegate contract_delegate;

        public contract_slot(AbstractShopEntity.player_ID_Records_Delegate inventory, int slot, int x, int y) {
            super(inventory, slot, x, y);
            ShopScreenHandlerOwner.this.tabSettingsSlots.add(this);
            this.contract_delegate = inventory;
            ShopScreenHandlerOwner.this.m_38897_(this);
            this.disable();
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            if (AbstractShopEntity.player_ID_Records_Delegate.checkAction(stack, this.getSlotIndex())) {
                return this.m_7993_().m_41619_();
            }
            return false;
        }

        @NotNull
        public ItemStack m_150659_(@NotNull ItemStack stack) {
            return this.m_150656_(stack, 0);
        }

        @NotNull
        public ItemStack m_150656_(ItemStack stack, int count) {
            if (!stack.m_41619_() && stack.m_41720_() == ModItems.CONTRACT_SCROLL.get()) {
                return ((AbstractShopEntity.player_ID_Records_Delegate)this.f_40218_).insertContract(stack, this.getSlotIndex());
            }
            return stack;
        }

        @NotNull
        public ItemStack m_150647_(int pCount, int pDecrement, @NotNull Player pPlayer) {
            if (this.contract_delegate.belongsToInteractor(this.m_7993_())) {
                if (ShopScreenHandlerOwner.this.warningActivator == null) {
                    throw new IllegalStateException("[Spud's Shops] Warning activator not initialised");
                }
                ShopScreenHandlerOwner.this.warningActivator.openWarnScreen();
                return ItemStack.f_41583_;
            }
            return this.f_40218_.m_7407_(this.getSlotIndex(), 1);
        }

        @NotNull
        public Optional<ItemStack> m_150641_(int pCount, int pDecrement, @NotNull Player pPlayer) {
            if (this.contract_delegate.belongsToInteractor(this.m_7993_())) {
                if (ShopScreenHandlerOwner.this.warningActivator == null) {
                    throw new IllegalStateException("[Spud's Shops] Warning activator not initialised");
                }
                ShopScreenHandlerOwner.this.warningActivator.openWarnScreen();
                return Optional.empty();
            }
            return Optional.of(this.f_40218_.m_7407_(this.getSlotIndex(), 1));
        }

        public int m_6641_() {
            return 1;
        }

        public int m_5866_(@NotNull ItemStack pStack) {
            return 1;
        }

        public boolean m_8010_(@NotNull Player player) {
            if (this.contract_delegate.belongsToInteractor(this.m_7993_())) {
                return true;
            }
            return this.contract_delegate.canEditThat(this.getSlotIndex());
        }
    }

    class shop_trade_slot
    extends TogglableSlot {
        public shop_trade_slot(AbstractShopEntity.InventoryDelegate inventory, int slot, int x, int y) {
            super(inventory, slot, x, y);
            ShopScreenHandlerOwner.this.tabSellerSlots.add(this);
            ShopScreenHandlerOwner.this.m_38897_(this);
        }

        @NotNull
        public ItemStack m_150647_(int amount, int shouldDecrement, @NotNull Player pPlayer) {
            this.f_40218_.m_7407_(this.getSlotIndex(), amount);
            return ItemStack.f_41583_;
        }

        public boolean m_5857_(ItemStack stack) {
            if (stack.m_41720_() != this.m_7993_().m_41720_()) {
                this.m_5852_(ItemStack.f_41583_);
                return false;
            }
            return true;
        }

        public boolean m_8010_(@NotNull Player pPlayer) {
            return ShopScreenHandlerOwner.this.perms.canEditTrades();
        }

        @NotNull
        public Optional<ItemStack> m_150641_(int pCount, int pDecrement, @NotNull Player pPlayer) {
            if (ShopScreenHandlerOwner.this.perms.canEditTrades()) {
                this.f_40218_.m_7407_(this.getSlotIndex(), pCount);
            }
            return Optional.empty();
        }

        @NotNull
        public ItemStack m_150659_(@NotNull ItemStack stack) {
            this.m_150656_(stack, stack.m_41613_());
            return stack;
        }

        @NotNull
        public ItemStack m_150656_(ItemStack stack, int count) {
            ItemStack oldStack = this.m_7993_();
            if (stack.m_41720_() == oldStack.m_41720_()) {
                if ((count += oldStack.m_41613_()) > 64) {
                    count = 64;
                }
                this.f_40218_.m_6836_(this.getSlotIndex(), stack.m_255036_(count));
            } else {
                this.f_40218_.m_6836_(this.getSlotIndex(), stack.m_255036_(count));
            }
            return stack;
        }

        public void m_269060_(@NotNull ItemStack pStack) {
        }
    }

    class shop_payment_slot
    extends TogglableSlot {
        public shop_payment_slot(AbstractShopEntity.InventoryDelegate inventory, int slot, int x, int y) {
            super(inventory, slot, x, y);
            ShopScreenHandlerOwner.this.tabCustomerSlots.add(this);
            ShopScreenHandlerOwner.this.m_38897_(this);
            this.disable();
        }

        @NotNull
        public Optional<ItemStack> m_150641_(int pCount, int pDecrement, @NotNull Player pPlayer) {
            return Optional.empty();
        }

        public boolean m_5857_(@NotNull ItemStack pStack) {
            return false;
        }

        public boolean m_8010_(@NotNull Player pPlayer) {
            return false;
        }

        @NotNull
        public ItemStack m_150659_(@NotNull ItemStack pStack) {
            return pStack;
        }

        @NotNull
        public ItemStack m_150656_(@NotNull ItemStack pStack, int pIncrement) {
            return pStack;
        }

        @NotNull
        public ItemStack m_150647_(int pCount, int pDecrement, @NotNull Player pPlayer) {
            return ItemStack.f_41583_;
        }

        public void m_269060_(@NotNull ItemStack pStack) {
        }
    }

    class shop_vendor_slot
    extends TogglableSlot {
        private final ShopScreenHandlerOwner handler;

        public shop_vendor_slot(AbstractShopEntity.InventoryDelegate inventory, int index, int x, int y, ShopScreenHandlerOwner handler) {
            super(inventory, index, x, y);
            this.handler = handler;
            ShopScreenHandlerOwner.this.tabCustomerSlots.add(this);
            ShopScreenHandlerOwner.this.m_38897_(this);
            this.disable();
        }

        @NotNull
        public Optional<ItemStack> m_150641_(int pCount, int pDecrement, @NotNull Player pPlayer) {
            if (ShopScreenHandlerOwner.this.shopInventory.canTrade(pPlayer)) {
                this.handler.trade();
            }
            return Optional.empty();
        }

        @NotNull
        public ItemStack m_150647_(int pCount, int pDecrement, @NotNull Player pPlayer) {
            this.handler.trade();
            return ItemStack.f_41583_;
        }

        public boolean m_8010_(@NotNull Player playerEntity) {
            return ShopScreenHandlerOwner.this.shopInventory.canTrade(playerEntity);
        }

        public boolean m_5857_(@NotNull ItemStack s) {
            return false;
        }

        @NotNull
        public ItemStack m_150659_(@NotNull ItemStack pStack) {
            return pStack;
        }

        @NotNull
        public ItemStack m_150656_(@NotNull ItemStack pStack, int pIncrement) {
            return pStack;
        }
    }

    static class TogglableSlot
    extends Slot {
        private boolean toggled = true;

        public TogglableSlot(Container inventory, int slot, int x, int y) {
            super(inventory, slot, x, y);
        }

        public boolean m_6659_() {
            return this.toggled;
        }

        public void enable() {
            this.toggled = true;
        }

        public void disable() {
            this.toggled = false;
        }
    }

    class player_slot
    extends TogglableSlot {
        public player_slot(Inventory inventory, int slot, int x, int y) {
            super((Container)inventory, slot, x, y);
            ShopScreenHandlerOwner.this.playerInvSlots.add(this);
            ShopScreenHandlerOwner.this.m_38897_(this);
        }
    }
}

