/*
 * Decompiled with CFR 0.152.
 */
package net.spudacious5705.shops.block.custom;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.network.NetworkHooks;
import net.spudacious5705.shops.block.VariantResources;
import net.spudacious5705.shops.block.entity.AbstractShopEntity;
import net.spudacious5705.shops.properties.ModProperties;
import net.spudacious5705.shops.properties.PermissionLevel;
import net.spudacious5705.shops.screen.ScreenSettingsGroup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractShopBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final BooleanProperty BREAKABLE = ModProperties.BREAKABLE;
    private static final VoxelShape TEST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);

    public AbstractShopBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultStateTemplate();
    }

    protected void registerDefaultStateTemplate() {
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)BREAKABLE, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, BREAKABLE});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_((Property)BREAKABLE, (Comparable)Boolean.valueOf(false));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public static VoxelShape createCuboidShape(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Block.m_49796_((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    public void m_6402_(@NotNull Level world, @NotNull BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer != null && placer instanceof Player) {
            Player player = (Player)placer;
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof AbstractShopEntity) {
                AbstractShopEntity shopEntity = (AbstractShopEntity)blockEntity;
                shopEntity.userSignIn(player);
            }
        }
        super.m_6402_(world, pos, state, placer, stack);
    }

    @Nullable
    public abstract BlockEntity m_142194_(BlockPos var1, BlockState var2);

    protected static PermissionLevel userSignIn(Level world, BlockPos pos, Player player) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof AbstractShopEntity) {
            AbstractShopEntity shopEntity = (AbstractShopEntity)blockEntity;
            return shopEntity.userSignIn(player);
        }
        return PermissionLevel.CUSTOMER;
    }

    public TagKey<Block> getPreferredTool() {
        return BlockTags.f_144280_;
    }

    public void m_6256_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof AbstractShopEntity)) {
            return;
        }
        AbstractShopEntity shop = (AbstractShopEntity)blockEntity;
        if (!shop.canBreak(player)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BREAKABLE, (Comparable)Boolean.valueOf(false)), 3);
            if (level.f_46443_) {
                player.m_5661_(shop.cantBreakMessage(), true);
            }
            return;
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)BREAKABLE, (Comparable)Boolean.valueOf(true)), 3);
        level.m_186464_(pos, (Block)this, 140, TickPriority.EXTREMELY_HIGH);
        super.m_6256_(state, level, pos, player);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)BREAKABLE) != false ? super.m_5880_(state, player, level, pos) : 0.0f;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)BREAKABLE, (Comparable)Boolean.valueOf(false)), 3);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21120_(hand);
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof AbstractShopEntity)) {
            return InteractionResult.FAIL;
        }
        AbstractShopEntity shop = (AbstractShopEntity)be;
        PermissionLevel perm = AbstractShopBlock.userSignIn(level, pos, player);
        if (!stack.m_41619_() && perm.canEditTrades() && this.onUseWithItem(stack, state, level, pos, player)) {
            return InteractionResult.SUCCESS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)shop.createScreenHandlerFactory(false), buf -> {
                buf.m_130064_(pos);
                buf.writeBoolean(false);
            });
        }
        return InteractionResult.SUCCESS;
    }

    @SafeVarargs
    @NotNull
    protected final <T extends Comparable<T>> BlockState copyValues(@NotNull BlockState subject, @NotNull BlockState source, Property<?> ... properties) {
        for (Property<?> prop : properties) {
            Property<?> p = prop;
            if (!source.m_61138_(p)) continue;
            subject = (BlockState)subject.m_61124_(p, source.m_61143_(p));
        }
        return subject;
    }

    protected boolean shouldOpenTop(BlockHitResult hit) {
        return false;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (this.isStateReplacedValid(newState)) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AbstractShopEntity) {
            AbstractShopEntity shopEntity = (AbstractShopEntity)blockEntity;
            if (!((Boolean)state.m_61143_((Property)BREAKABLE)).booleanValue()) {
                level.m_7731_(pos, state, 3);
                return;
            }
            shopEntity.itemScatter(level, pos);
            level.m_46717_(pos, (Block)this);
        }
        level.m_46747_(pos);
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation direction) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return this.m_6843_(pState, pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.getGenericShape(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getGenericShape(state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getGenericShape(state);
    }

    protected VoxelShape getGenericShape(BlockState state) {
        return TEST_SHAPE;
    }

    protected boolean unbreakable(BlockState state) {
        return (Boolean)state.m_61143_((Property)BREAKABLE) == false;
    }

    protected void makeBreakable(ServerLevel level, BlockPos pos, BlockState state) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)BREAKABLE, (Comparable)Boolean.valueOf(true)), 3);
    }

    protected void makeUnbreakable(ServerLevel level, BlockPos pos, BlockState state) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)BREAKABLE, (Comparable)Boolean.valueOf(false)), 3);
    }

    protected abstract boolean isStateReplacedValid(BlockState var1);

    protected abstract boolean onUseWithItem(ItemStack var1, BlockState var2, Level var3, BlockPos var4, Player var5);

    public abstract <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level var1, BlockState var2, BlockEntityType<T> var3);

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        AbstractShopEntity shop;
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof AbstractShopEntity && !(shop = (AbstractShopEntity)be).canBreak(player)) {
            if (world.f_46443_) {
                player.m_5661_(shop.cantBreakMessage(), true);
            }
            return false;
        }
        if (player.m_7500_()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)BREAKABLE, (Comparable)Boolean.valueOf(true)), 3);
        }
        return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public ScreenSettingsGroup getScreenSettings() {
        return ScreenSettingsGroup.createBasicWood(VariantResources.wood_variant.OAK);
    }
}

