/*
 * Decompiled with CFR 0.152.
 */
package net.spudacious5705.shops.block.custom;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.spudacious5705.shops.block.ModBlockEntities;
import net.spudacious5705.shops.block.PostRegAssigner;
import net.spudacious5705.shops.block.VariantResources;
import net.spudacious5705.shops.block.custom.AbstractShopBlock;
import net.spudacious5705.shops.block.entity.AngledShopEntity;
import net.spudacious5705.shops.item.custom.ShopItem;
import net.spudacious5705.shops.properties.Colour;
import net.spudacious5705.shops.screen.ScreenSettingsGroup;
import net.spudacious5705.shops.util.CushionResources;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngledShopBlock
extends AbstractShopBlock {
    public static final VoxelShape CULLING_SHAPE = AngledShopBlock.createCuboidShape(0.0, 0.0, 0.0, 16.0, 8.0, 17.5);
    public static final VoxelShape BASE = AngledShopBlock.createCuboidShape(0.0, 0.0, 0.0, 16.0, 6.0, 16.0);
    public static final VoxelShape BASE_NORTH = Shapes.m_83110_((VoxelShape)AngledShopBlock.createCuboidShape(0.0, 6.0, 2.0, 16.0, 12.0, 16.0), (VoxelShape)BASE);
    public static final VoxelShape BASE_EAST = Shapes.m_83110_((VoxelShape)AngledShopBlock.createCuboidShape(0.0, 6.0, 0.0, 14.0, 12.0, 16.0), (VoxelShape)BASE);
    public static final VoxelShape BASE_SOUTH = Shapes.m_83110_((VoxelShape)AngledShopBlock.createCuboidShape(0.0, 6.0, 0.0, 16.0, 12.0, 14.0), (VoxelShape)BASE);
    public static final VoxelShape BASE_WEST = Shapes.m_83110_((VoxelShape)AngledShopBlock.createCuboidShape(2.0, 6.0, 0.0, 16.0, 12.0, 16.0), (VoxelShape)BASE);
    public static final VoxelShape NORTH_SHAPE = Shapes.m_83124_((VoxelShape)AngledShopBlock.createCuboidShape(1.0, 12.0, 3.0, 15.0, 15.0, 12.0), (VoxelShape[])new VoxelShape[]{AngledShopBlock.createCuboidShape(1.0, 15.0, 8.0, 15.0, 17.5, 15.0), BASE_NORTH});
    public static final VoxelShape EAST_SHAPE = Shapes.m_83124_((VoxelShape)AngledShopBlock.createCuboidShape(4.0, 12.0, 1.0, 13.0, 15.0, 15.0), (VoxelShape[])new VoxelShape[]{AngledShopBlock.createCuboidShape(1.0, 15.0, 1.0, 8.0, 17.5, 15.0), BASE_EAST});
    public static final VoxelShape SOUTH_SHAPE = Shapes.m_83124_((VoxelShape)AngledShopBlock.createCuboidShape(1.0, 12.0, 4.0, 15.0, 15.0, 13.0), (VoxelShape[])new VoxelShape[]{AngledShopBlock.createCuboidShape(1.0, 15.0, 1.0, 15.0, 17.5, 8.0), BASE_SOUTH});
    public static final VoxelShape WEST_SHAPE = Shapes.m_83124_((VoxelShape)AngledShopBlock.createCuboidShape(3.0, 12.0, 1.0, 12.0, 15.0, 15.0), (VoxelShape[])new VoxelShape[]{AngledShopBlock.createCuboidShape(8.0, 15.0, 1.0, 15.0, 17.5, 15.0), BASE_WEST});
    public Item WOOD_TYPE;
    public final VariantResources.wood_variant VARIANT;
    private final Map<Colour, ShopItem> dropMap = new HashMap<Colour, ShopItem>();

    public AngledShopBlock(BlockBehaviour.Properties settings, PostRegAssigner<Item> woodTypeAssigner, VariantResources.wood_variant variant) {
        super(settings);
        woodTypeAssigner.assignTo(o -> {
            this.WOOD_TYPE = o;
        });
        this.VARIANT = variant;
    }

    public String getWoodName() {
        return this.VARIANT.name;
    }

    @Override
    public ScreenSettingsGroup getScreenSettings() {
        return ScreenSettingsGroup.createBasicWood(this.VARIANT);
    }

    @NotNull
    public Item m_5456_() {
        return this.getDefaultColouredShopItem();
    }

    @Override
    public void m_6402_(@NotNull Level world, @NotNull BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer != null && placer instanceof Player) {
            Player player = (Player)placer;
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof AngledShopEntity) {
                AngledShopEntity shopEntity = (AngledShopEntity)blockEntity;
                shopEntity.userSignIn(player);
                Item item = stack.m_41720_();
                if (item instanceof ShopItem) {
                    ShopItem item2 = (ShopItem)item;
                    shopEntity.setCushionColour(item2.colour);
                }
            }
        }
        super.m_6402_(world, pos, state, placer, stack);
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new AngledShopEntity(pos, state);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        Colour colour = Colour.RED;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AngledShopEntity) {
            AngledShopEntity shopEntity = (AngledShopEntity)blockEntity;
            colour = shopEntity.getCushionColour();
        }
        return this.getColouredShopItem(colour).m_7968_();
    }

    @Override
    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            default -> CULLING_SHAPE;
        };
    }

    @Override
    @NotNull
    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> BASE_NORTH;
            case Direction.SOUTH -> BASE_SOUTH;
            case Direction.EAST -> BASE_EAST;
            case Direction.WEST -> BASE_WEST;
            default -> CULLING_SHAPE;
        };
    }

    @Override
    @NotNull
    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return CULLING_SHAPE;
    }

    @Override
    protected VoxelShape getGenericShape(BlockState state) {
        return BASE;
    }

    @Override
    protected boolean isStateReplacedValid(BlockState newShopState) {
        return newShopState.m_60734_() instanceof AngledShopBlock;
    }

    @Override
    protected boolean onUseWithItem(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player) {
        if (!stack.m_41619_()) {
            Item item = stack.m_41720_();
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof AngledShopEntity) {
                AngledShopEntity shopEntity = (AngledShopEntity)blockEntity;
                if (CushionResources.DYE_MAP.containsKey(item)) {
                    group = CushionResources.DYE_MAP.get(item);
                    if (shopEntity.getCushionColour() != group.colour()) {
                        if (!player.m_7500_()) {
                            stack.m_41774_(1);
                        }
                        shopEntity.setCushionColour(group.colour());
                        world.m_247517_(null, pos, SoundEvents.f_144133_, SoundSource.BLOCKS);
                        world.m_7260_(pos, state, state, 3);
                        shopEntity.forceUpdateClient();
                        return true;
                    }
                } else if (CushionResources.WOOL_MAP.containsKey(item)) {
                    group = CushionResources.WOOL_MAP.get(item);
                    Colour originalColour = shopEntity.getCushionColour();
                    if (originalColour != group.colour()) {
                        shopEntity.setCushionColour(group.colour());
                        if (!player.m_7500_()) {
                            stack.m_41774_(1);
                            group = CushionResources.COLOUR_MAP.get((Object)originalColour);
                            ItemStack releaseStack = new ItemStack((ItemLike)group.wool(), 1);
                            world.m_7967_((Entity)new ItemEntity(world, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.6f), (double)((float)pos.m_123343_() + 0.5f), releaseStack, 0.0, (double)0.1f, 0.0));
                        }
                        world.m_247517_(null, pos, SoundEvents.f_12344_, SoundSource.BLOCKS);
                        world.m_7260_(pos, state, state, 3);
                        shopEntity.forceUpdateClient();
                        return true;
                    }
                } else if (VariantResources.ANGLED.containsKey(item) && this.WOOD_TYPE != item) {
                    AngledShopBlock block = VariantResources.ANGLED.get(item);
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                        ItemEntity droppedItem = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, this.WOOD_TYPE.m_7968_());
                        droppedItem.m_20334_(0.0, 0.1, 0.0);
                        world.m_7967_((Entity)droppedItem);
                    }
                    world.m_247517_(null, pos, SoundEvents.f_12638_, SoundSource.BLOCKS);
                    world.m_46597_(pos, this.copyValues(block.m_49966_(), state, new Property[]{FACING}));
                    shopEntity.forceUpdateClient();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (ModBlockEntities.ANGLED_SHOP_ENTITY.get() == type) {
            return level.f_46443_ ? (lvl, pos, st, be) -> ((AngledShopEntity)be).renderTick() : (lvl, pos, st, be) -> ((AngledShopEntity)be).serverTick((ServerLevel)lvl, pos, st);
        }
        return null;
    }

    public void addDropItem(ShopItem shopItem, Colour colour) {
        this.dropMap.put(colour, shopItem);
    }

    public ShopItem getColouredShopItem(@Nullable Colour colour) {
        return this.dropMap.getOrDefault((Object)colour, this.getDefaultColouredShopItem());
    }

    public ShopItem getDefaultColouredShopItem() {
        return this.dropMap.get((Object)Colour.RED);
    }
}

