/*
 * Decompiled with CFR 0.152.
 */
package net.spudacious5705.shops.block.custom;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.spudacious5705.shops.block.ModBlockEntities;
import net.spudacious5705.shops.block.ModBlocks;
import net.spudacious5705.shops.block.PostRegAssigner;
import net.spudacious5705.shops.block.VariantResources;
import net.spudacious5705.shops.block.custom.AbstractShopBlock;
import net.spudacious5705.shops.block.entity.RugShopEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RugShopBlock
extends AbstractShopBlock {
    public static final BooleanProperty CONNECTED_NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty CONNECTED_EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty CONNECTED_SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty CONNECTED_WEST = BooleanProperty.m_61465_((String)"west");
    public static final VoxelShape SHAPE = RugShopBlock.createCuboidShape(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);
    public Item CARPET;
    public final String COLOUR;

    public RugShopBlock(PostRegAssigner<Item> carpetAssigner, String colour) {
        super(ModBlocks.settingsCarpet);
        carpetAssigner.assignTo(o -> {
            this.CARPET = o;
        });
        this.COLOUR = colour;
    }

    @Override
    protected void registerDefaultStateTemplate() {
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)CONNECTED_NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CONNECTED_EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CONNECTED_SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CONNECTED_WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BREAKABLE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CONNECTED_NORTH, CONNECTED_EAST, CONNECTED_SOUTH, CONNECTED_WEST, BREAKABLE});
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RugShopEntity(pos, state);
    }

    @Override
    protected boolean onUseWithItem(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player) {
        BlockEntity blockEntity;
        Item item = stack.m_41720_();
        if (item != this.CARPET && (blockEntity = world.m_7702_(pos)) instanceof RugShopEntity) {
            RugShopBlock newRug;
            RugShopEntity shopEntity = (RugShopEntity)blockEntity;
            if (VariantResources.RUGS_CARPET.containsKey(item)) {
                newRug = VariantResources.RUGS_CARPET.get(item);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                    world.m_7967_((Entity)new ItemEntity(world, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.2f), (double)((float)pos.m_123343_() + 0.5f), this.CARPET.m_7968_(), 0.0, (double)0.1f, 0.0));
                }
                world.m_247517_(null, pos, SoundEvents.f_12344_, SoundSource.BLOCKS);
                world.m_46597_(pos, this.copyValues(newRug.m_49966_(), state, new Property[]{CONNECTED_NORTH, CONNECTED_EAST, CONNECTED_SOUTH, CONNECTED_WEST}));
                shopEntity.forceUpdateClient();
                return true;
            }
            if (VariantResources.RUGS_DYE.containsKey(item)) {
                newRug = VariantResources.RUGS_DYE.get(item);
                if (newRug == state.m_60734_()) {
                    return false;
                }
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                world.m_247517_(null, pos, SoundEvents.f_144133_, SoundSource.BLOCKS);
                world.m_46597_(pos, this.copyValues(newRug.m_49966_(), state, new Property[]{CONNECTED_NORTH, CONNECTED_EAST, CONNECTED_SOUTH, CONNECTED_WEST}));
                shopEntity.forceUpdateClient();
                return true;
            }
        }
        return false;
    }

    @Override
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (ModBlockEntities.RUG_SHOP_ENTITY.get() == type) {
            return level.f_46443_ ? (lvl, pos, st, be) -> ((RugShopEntity)be).renderTick() : (lvl, pos, st, be) -> ((RugShopEntity)be).serverTick((ServerLevel)lvl, pos, st);
        }
        return null;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos pos;
        BlockPos attachedPos;
        Level world = ctx.m_43725_();
        BlockState attachedState = world.m_8055_(attachedPos = (pos = ctx.m_8083_()).m_121945_(Direction.DOWN));
        if (!attachedState.m_60783_((BlockGetter)world, attachedPos, Direction.UP)) {
            return null;
        }
        BlockState state = this.m_49966_();
        Function<Direction, Boolean> getValForDir = direction -> this.matchingCarpet(world, pos, state, (Direction)direction);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)BREAKABLE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CONNECTED_NORTH, (Comparable)getValForDir.apply(Direction.NORTH))).m_61124_((Property)CONNECTED_EAST, (Comparable)getValForDir.apply(Direction.EAST))).m_61124_((Property)CONNECTED_SOUTH, (Comparable)getValForDir.apply(Direction.SOUTH))).m_61124_((Property)CONNECTED_WEST, (Comparable)getValForDir.apply(Direction.WEST));
    }

    private boolean matchingCarpet(Level world, BlockPos pos, BlockState state, Direction dir) {
        return world.m_8055_(pos.m_121945_(dir)).m_60734_() == state.m_60734_();
    }

    @Override
    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation direction) {
        return state;
    }

    @Override
    @NotNull
    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState;
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor pLevel, BlockPos pos, BlockPos neighborPos) {
        BooleanProperty CONNECTION;
        switch (direction) {
            case NORTH: {
                BooleanProperty booleanProperty = CONNECTED_NORTH;
                break;
            }
            case SOUTH: {
                BooleanProperty booleanProperty = CONNECTED_SOUTH;
                break;
            }
            case EAST: {
                BooleanProperty booleanProperty = CONNECTED_EAST;
                break;
            }
            case WEST: {
                BooleanProperty booleanProperty = CONNECTED_WEST;
                break;
            }
            default: {
                BooleanProperty booleanProperty = CONNECTION = null;
            }
        }
        if (CONNECTION == null) {
            return state;
        }
        boolean targetValue = neighborState.m_60734_() == state.m_60734_();
        return (BlockState)state.m_61124_((Property)CONNECTION, (Comparable)Boolean.valueOf(targetValue));
    }

    @Override
    protected boolean isStateReplacedValid(BlockState newShopState) {
        return newShopState.m_60734_() instanceof RugShopBlock;
    }

    @Override
    protected VoxelShape getGenericShape(BlockState state) {
        return SHAPE;
    }

    @Override
    public TagKey<Block> getPreferredTool() {
        return BlockTags.f_144281_;
    }
}

