/*
 * Decompiled with CFR 0.152.
 */
package net.spudacious5705.shops.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.spudacious5705.shops.block.ModBlockEntities;
import net.spudacious5705.shops.block.PostRegAssigner;
import net.spudacious5705.shops.block.VariantResources;
import net.spudacious5705.shops.block.custom.AbstractShopBlock;
import net.spudacious5705.shops.block.entity.WindowSillShopEntity;
import org.jetbrains.annotations.Nullable;

public class WindowSillShopBlock
extends AbstractShopBlock {
    public Item STONE_TYPE;
    public static final VoxelShape SHAPE = WindowSillShopBlock.createCuboidShape(0.0, -1.0, -1.0, 16.0, 2.0, 17.0);
    public static final VoxelShape SHAPE_ROTATED = WindowSillShopBlock.createCuboidShape(-1.0, -1.0, 0.0, 17.0, 2.0, 16.0);

    public WindowSillShopBlock(BlockBehaviour.Properties properties, PostRegAssigner<Item> stoneTypeAssigner) {
        super(properties);
        stoneTypeAssigner.assignTo(o -> {
            this.STONE_TYPE = o;
        });
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new WindowSillShopEntity(pos, state);
    }

    @Override
    protected boolean onUseWithItem(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player) {
        BlockEntity blockEntity;
        Item item = stack.m_41720_();
        if (item != this.STONE_TYPE && (blockEntity = world.m_7702_(pos)) instanceof WindowSillShopEntity) {
            WindowSillShopEntity shopEntity = (WindowSillShopEntity)blockEntity;
            if (VariantResources.WINDOW_SILL.containsKey(item)) {
                BlockState newSill = VariantResources.WINDOW_SILL.get(item).m_49966_();
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                    world.m_7967_((Entity)new ItemEntity(world, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.3f), (double)((float)pos.m_123343_() + 0.5f), this.STONE_TYPE.m_7968_(), 0.0, (double)0.1f, 0.0));
                }
                world.m_46597_(pos, this.copyValues(newSill, state, new Property[]{FACING}));
                shopEntity.forceUpdateClient();
                return true;
            }
        }
        return false;
    }

    @Override
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (ModBlockEntities.WINDOW_SHOP_ENTITY.get() == type) {
            return level.f_46443_ ? (lvl, pos, st, be) -> ((WindowSillShopEntity)be).renderTick() : (lvl, pos, st, be) -> ((WindowSillShopEntity)be).serverTick((ServerLevel)lvl, pos, st);
        }
        return null;
    }

    @Override
    public VoxelShape getGenericShape(BlockState state) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.EAST, Direction.WEST -> SHAPE_ROTATED;
            default -> SHAPE;
        };
    }

    @Override
    protected boolean isStateReplacedValid(BlockState newShopState) {
        return newShopState.m_60734_() instanceof WindowSillShopBlock;
    }

    @Override
    public TagKey<Block> getPreferredTool() {
        return BlockTags.f_144282_;
    }
}

