/*
 * Decompiled with CFR 0.152.
 */
package net.spudacious5705.shops.block.entity;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.spudacious5705.shops.block.custom.AbstractShopBlock;
import net.spudacious5705.shops.block.entity.ShopInventory;
import net.spudacious5705.shops.block.entity.renderer.ShopRenderUtils;
import net.spudacious5705.shops.config.ConfigHandler;
import net.spudacious5705.shops.item.ModItems;
import net.spudacious5705.shops.item.custom.ContractScroll;
import net.spudacious5705.shops.properties.PermissionLevel;
import net.spudacious5705.shops.screen.ScreenSettingsGroup;
import net.spudacious5705.shops.screen.ShopScreenHandlerCustomer;
import net.spudacious5705.shops.screen.ShopScreenHandlerOwner;
import net.spudacious5705.shops.screen.ToggleButtonID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractShopEntity
extends BlockEntity {
    protected final ShopInventory shopInventory = ShopInventory.create();
    protected String ownerName;
    private final ArrayList<PlayerID> identificationRecords;
    private static final int contractsInvSize = 24;
    private final NonNullList<ItemStack> contracts;
    private static final PermissionLevel[] CONTRACT_PERMS = new PermissionLevel[]{PermissionLevel.OWNER, PermissionLevel.MANAGER, PermissionLevel.SUPERVISOR, PermissionLevel.CLERK};
    private static final String CONTRACT_NAME = "contract_name";
    private static final String CONTRACT_UUID = "contract_uuid";
    private static final String CONTRACT_LEVEL = "contract_lvl";
    private static final String CONTRACTS = "contracts";
    private final boolean isClient;
    private boolean decayed;
    private boolean shouldRenderParticles;
    protected int decayTimer;
    protected static final int hourInTicks = 72000;
    protected int checkIntervalTimer;
    protected int breakableTicks;
    protected final EnumMap<ToggleButtonID, Boolean> toggleSettings;
    @OnlyIn(value=Dist.CLIENT)
    protected RendererData rendererData;
    final float particleOffset;

    @NotNull
    public InventoryDelegate getInventoryDelegate(Player player) {
        return new InventoryDelegate(player, this.shopInventory);
    }

    public void itemScatter(Level world, BlockPos pos) {
        ShopInventory.ItemScatterer(world, pos, this.shopInventory.prepForItemScatterer());
        int contractsCount = this.identificationRecords.size() - 1;
        if (contractsCount > 0) {
            ShopInventory.ItemScatterer(world, pos, new ItemStack((ItemLike)ModItems.CONTRACT_SCROLL.get(), contractsCount));
        }
    }

    public ScreenSettingsGroup getScreenSettings() {
        return ((AbstractShopBlock)this.m_58900_().m_60734_()).getScreenSettings();
    }

    @Nullable
    public final InventoryDelegate getOtherInventoryDelegate(Player player) {
        ShopInventory inv = this.otherInventory();
        if (inv != null) {
            return new InventoryDelegate(player, inv);
        }
        return null;
    }

    @Nullable
    protected ShopInventory otherInventory() {
        return null;
    }

    @Nullable
    public final player_ID_Records_Delegate getRecordsDelegate(Player player) {
        PermissionLevel perm = this.userSignIn(player);
        if (perm.canViewShopScreen()) {
            return new player_ID_Records_Delegate(perm, player.m_20148_());
        }
        return null;
    }

    public static void initialiseStaticMethods() {
        PlayerID.initialise();
    }

    private static ItemStack RecordToContract(PlayerID id) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.CONTRACT_SCROLL.get());
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("player_name", id.name);
        nbt.m_128362_("player_uuid", id.uuid);
        stack.m_41751_(nbt);
        return stack.m_41714_((Component)Component.m_237113_((String)("Contract - " + id.name)));
    }

    public PermissionLevel quickUserSignIn(@NotNull Player player) {
        UUID signIn = player.m_20148_();
        PlayerID id = this.identificationRecords.stream().filter(record -> record.uuid.compareTo(signIn) == 0).findFirst().orElse(null);
        if (id != null) {
            return id.permissionLevel;
        }
        if (player.m_7500_()) {
            return PermissionLevel.SERVER_ADMIN;
        }
        return PermissionLevel.CUSTOMER;
    }

    public PermissionLevel userSignIn(Player player) {
        if (this.toggleSettings.getOrDefault((Object)ToggleButtonID.CreativeToggle, false).booleanValue() && !player.m_7500_()) {
            return PermissionLevel.CUSTOMER;
        }
        if (this.identificationRecords.isEmpty()) {
            this.identificationRecords.add(new PlayerID(player.m_20148_(), player.m_7755_().getString(), PermissionLevel.OWNER));
            this.m_6596_();
            return PermissionLevel.OWNER;
        }
        if (this.identificationRecords.stream().noneMatch(playerID -> playerID.permissionLevel == PermissionLevel.OWNER)) {
            int maxValue = this.identificationRecords.stream().mapToInt(record -> record.permissionLevel.asInt()).max().orElse(-1);
            this.identificationRecords.replaceAll(record -> record.permissionLevel.asInt() == maxValue ? new PlayerID(record.uuid, record.name, PermissionLevel.OWNER) : record);
            this.m_6596_();
        }
        return this.quickUserSignIn(player);
    }

    public settings_Delegate getSettingsDelegate(Player player) {
        return new settings_Delegate(this.quickUserSignIn(player), player);
    }

    public void m_6596_() {
        if (this.isClient) {
            this.forceUpdateRenderData();
        }
        super.m_6596_();
    }

    private void copyRecordsToContracts() {
        this.ownerName = this.identificationRecords.stream().filter((Predicate<PlayerID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$copyRecordsToContracts$4(net.spudacious5705.shops.block.entity.AbstractShopEntity$PlayerID ), (Lnet/spudacious5705/shops/block/entity/AbstractShopEntity$PlayerID;)Z)()).findFirst().orElse((PlayerID)PlayerID.EMPTY).name;
        this.contracts.clear();
        int indexModifier = 0;
        for (PermissionLevel lvl : CONTRACT_PERMS) {
            PlayerID[] filtered = (PlayerID[])this.identificationRecords.stream().filter(record -> record.permissionLevel == lvl).toArray(PlayerID[]::new);
            int itterations = filtered.length;
            if (itterations > 6) {
                itterations = 6;
            }
            for (int i = 0; i < itterations; ++i) {
                this.contracts.set(i + indexModifier, (Object)AbstractShopEntity.RecordToContract(filtered[i]));
            }
            indexModifier += 6;
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void forceUpdateClient() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            BlockPos pos = this.m_58899_();
            server.m_7726_().m_8450_(pos);
            Packet<ClientGamePacketListener> packet = this.m_58483_();
            if (packet != null) {
                List watchers = server.m_7726_().f_8325_.m_183262_(server.m_46865_(pos).m_7697_(), false);
                for (ServerPlayer player : watchers) {
                    player.f_8906_.m_9829_(packet);
                }
            }
        }
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)this.shopInventory);
        this.identificationRecords.clear();
        if (tag.m_128425_(CONTRACTS, 9)) {
            ListTag contractList = tag.m_128437_(CONTRACTS, 10);
            for (int index = 0; index < contractList.size(); ++index) {
                CompoundTag contract = contractList.m_128728_(index);
                String name = contract.m_128461_(CONTRACT_NAME);
                UUID uuid = contract.m_128342_(CONTRACT_UUID);
                PermissionLevel perms = PermissionLevel.fromInt(contract.m_128451_(CONTRACT_LEVEL));
                if (perms.asInt() <= 0) continue;
                this.identificationRecords.add(new PlayerID(uuid, name, perms));
            }
        }
        this.copyRecordsToContracts();
        if (tag.m_128403_("owner_id")) {
            UUID ownerID = tag.m_128342_("owner_id");
            String name = tag.m_128441_("owner_name") ? tag.m_128461_("owner_name") : ownerID.toString();
            this.identificationRecords.add(new PlayerID(ownerID, name, PermissionLevel.OWNER));
        }
        if (tag.m_128441_("decay_timer")) {
            this.decayTimer = tag.m_128451_("decay_timer");
        }
        for (ToggleButtonID id : ToggleButtonID.values()) {
            String nbtName = "toggle_" + id.getSerialised();
            if (tag.m_128441_(nbtName)) {
                this.toggleSettings.put(id, tag.m_128471_(nbtName));
                continue;
            }
            this.toggleSettings.put(id, ConfigHandler.getDefaultToggleSetting(id));
        }
        this.checkShouldRenderParticles();
    }

    protected void m_183515_(CompoundTag tag) {
        ContainerHelper.m_18973_((CompoundTag)tag, (NonNullList)this.shopInventory);
        ListTag contractList = new ListTag();
        for (PlayerID id : this.identificationRecords) {
            CompoundTag contractNBT = new CompoundTag();
            contractNBT.m_128359_(CONTRACT_NAME, id.name);
            contractNBT.m_128362_(CONTRACT_UUID, id.uuid);
            contractNBT.m_128405_(CONTRACT_LEVEL, id.permissionLevel.asInt());
            contractList.add((Object)contractNBT);
        }
        if (!contractList.isEmpty()) {
            tag.m_128365_(CONTRACTS, (Tag)contractList);
        }
        tag.m_128405_("decay_timer", this.decayTimer);
        for (ToggleButtonID id : ToggleButtonID.values()) {
            Boolean v = this.toggleSettings.get((Object)id);
            if (v == null) continue;
            tag.m_128379_("toggle_" + id.getSerialised(), v.booleanValue());
        }
        this.checkShouldRenderParticles();
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public <SHOP extends AbstractShopEntity> AbstractShopEntity(BlockEntityType<SHOP> type, BlockPos pos, BlockState state, float particleOffset) {
        super(type, pos, state);
        this.ownerName = PlayerID.EMPTY.name;
        this.identificationRecords = new ArrayList(1);
        this.contracts = NonNullList.m_122780_((int)24, (Object)ItemStack.f_41583_);
        this.decayed = false;
        this.shouldRenderParticles = false;
        this.decayTimer = -1;
        this.checkIntervalTimer = 200;
        this.breakableTicks = -1;
        this.toggleSettings = new EnumMap(ToggleButtonID.class);
        this.particleOffset = particleOffset;
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.createRendererData();
            this.isClient = true;
        } else {
            this.isClient = false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void createRendererData() {
        this.rendererData = new RendererData(this.shopInventory);
    }

    private void checkShouldRenderParticles() {
        this.shouldRenderParticles = this.toggleSettings.getOrDefault((Object)ToggleButtonID.EffectsToggle, false) != false && this.toggleSettings.getOrDefault((Object)ToggleButtonID.CreativeToggle, false) == false;
    }

    protected void editBreakability(ServerLevel level, BlockPos pos, BlockState state, boolean breakable) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)AbstractShopBlock.BREAKABLE, (Comparable)Boolean.valueOf(breakable)), 3);
    }

    public void serverTick(ServerLevel world, BlockPos pos, BlockState shopState) {
        if (this.decayTimer > -1) {
            if (this.decayTimer > 72000) {
                if (this.shouldRenderParticles && world.f_46441_.m_188501_() < 0.05f) {
                    for (int i = 0; i < 3; ++i) {
                        world.m_8767_((ParticleOptions)ParticleTypes.f_123792_, (double)pos.m_123341_() + 0.2 + (double)world.f_46441_.m_188501_(), (double)((float)pos.m_123342_() + world.f_46441_.m_188501_() + this.particleOffset), (double)((float)pos.m_123343_() + world.f_46441_.m_188501_()), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                boolean breakable = false;
                if (shopState.m_60734_() instanceof AbstractShopBlock) {
                    breakable = (Boolean)shopState.m_61143_((Property)AbstractShopBlock.BREAKABLE);
                }
                if (!breakable) {
                    this.decayed = true;
                    this.identificationRecords.clear();
                    this.editBreakability(world, pos, shopState, true);
                    shopState.m_263224_((Property)AbstractShopBlock.BREAKABLE, (Comparable)Boolean.valueOf(true));
                    this.breakableTicks = 140;
                }
            } else {
                ++this.decayTimer;
            }
        }
        --this.checkIntervalTimer;
        if (this.checkIntervalTimer < 0) {
            this.checkIntervalTimer = 6000;
            this.checkShouldRenderParticles();
            if (this.isShopFunctional()) {
                if (this.decayTimer < 0) {
                    this.decayTimer = 0;
                }
            } else {
                this.decayTimer = -1;
                this.decayed = false;
            }
        }
        if (!((Boolean)shopState.m_61143_((Property)AbstractShopBlock.BREAKABLE)).booleanValue()) {
            return;
        }
        if (this.breakableTicks > 0) {
            if (!this.decayed) {
                --this.breakableTicks;
            }
            return;
        }
        if (this.breakableTicks < 0) {
            this.breakableTicks = 140;
        } else {
            this.editBreakability(world, pos, shopState, false);
            this.breakableTicks = -1;
        }
    }

    @NotNull
    public MenuProvider createScreenHandlerFactory(final boolean openTop) {
        return new MenuProvider(){

            @NotNull
            public Component m_5446_() {
                return Component.m_237113_((String)"");
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int syncId, @NotNull Inventory playerInventory, @NotNull Player player) {
                PermissionLevel perms = AbstractShopEntity.this.userSignIn(player);
                InventoryDelegate inventoryDelegate = openTop ? AbstractShopEntity.this.getOtherInventoryDelegate(player) : AbstractShopEntity.this.getInventoryDelegate(player);
                player_ID_Records_Delegate recordsDelegate = new player_ID_Records_Delegate(perms, player.m_20148_());
                settings_Delegate set_del = new settings_Delegate(perms, player);
                if (perms.canViewShopScreen()) {
                    return new ShopScreenHandlerOwner(syncId, playerInventory, AbstractShopEntity.this, inventoryDelegate, recordsDelegate, set_del);
                }
                if (!AbstractShopEntity.this.isShopFunctional()) {
                    return null;
                }
                return new ShopScreenHandlerCustomer(syncId, playerInventory, AbstractShopEntity.this, inventoryDelegate);
            }
        };
    }

    public abstract int getTextureId();

    public boolean canBreak(Player player) {
        if (player.m_7500_() || this.decayed) {
            return true;
        }
        if (this.identificationRecords.isEmpty()) {
            return this.userSignIn(player).canBreakBlock();
        }
        return this.quickUserSignIn(player).canBreakBlock();
    }

    public Component cantBreakMessage() {
        return Component.m_237113_((String)("Cannot break - Owned by " + this.ownerName));
    }

    public boolean isShopFunctional() {
        if (this.managementFunctional() && this.hasTrade()) {
            this.decayTimer = -1;
            this.decayed = false;
            return true;
        }
        if (this.decayTimer < 0) {
            this.decayTimer = 0;
        }
        return false;
    }

    public boolean managementFunctional() {
        if (this.f_58857_ != null) {
            return !this.identificationRecords.isEmpty();
        }
        return false;
    }

    protected boolean hasTrade() {
        return this.shopInventory.tradeFunctional();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderTick() {
        this.rendererData.onTick();
    }

    @OnlyIn(value=Dist.CLIENT)
    public RendererData rendererData() {
        return this.rendererData;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void forceUpdateRenderData() {
        this.rendererData.update();
    }

    public Direction getCachedFacingDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)AbstractShopBlock.FACING);
    }

    private static /* synthetic */ boolean lambda$copyRecordsToContracts$4(PlayerID playerID) {
        return playerID.permissionLevel == PermissionLevel.OWNER;
    }

    public final class InventoryDelegate
    implements Container {
        private final ShopInventory inventory;
        private final PermissionLevel permissions;
        private final UUID reciever_UUID;

        public InventoryDelegate(Player player, ShopInventory items) {
            this.permissions = AbstractShopEntity.this.userSignIn(player);
            this.reciever_UUID = player.m_20148_();
            this.inventory = items;
        }

        public PermissionLevel checkPermissions() {
            return this.permissions;
        }

        public int m_6643_() {
            return this.inventory.size();
        }

        public boolean m_7983_() {
            return this.inventory.isEmpty();
        }

        public ItemStack m_8016_(int pSlot) {
            return null;
        }

        public void m_6596_() {
            assert (AbstractShopEntity.this.f_58857_ != null);
            AbstractShopEntity.this.f_58857_.m_7260_(AbstractShopEntity.this.f_58858_, AbstractShopEntity.this.m_58900_(), AbstractShopEntity.this.m_58900_(), 3);
            AbstractShopEntity.this.isShopFunctional();
            AbstractShopEntity.this.m_6596_();
        }

        @NotNull
        public ItemStack m_8020_(int slot) {
            if (slot > this.m_6643_() || slot < 0) {
                return ItemStack.f_41583_;
            }
            if (slot > 75) {
                return (ItemStack)this.inventory.get(slot);
            }
            if (this.permissions.canViewShopScreen()) {
                return (ItemStack)this.inventory.get(slot);
            }
            return ItemStack.f_41583_;
        }

        public void trade(Inventory playerInv) {
            NonNullList<ItemStack> vendList;
            boolean tradeCreative = AbstractShopEntity.this.toggleSettings.getOrDefault((Object)ToggleButtonID.CreativeToggle, false);
            if (tradeCreative) {
                vendList = NonNullList.m_122779_();
                vendList.add(0, (Object)this.inventory.getVendingStack().m_41777_());
            } else {
                vendList = InventoryDelegate.takeItems(this.inventory.getVendingStack(), arg_0 -> ((ShopInventory)this.inventory).get(arg_0), 0, 53);
            }
            NonNullList<ItemStack> payList = InventoryDelegate.takeItems(this.inventory.getPaymentStack(), arg_0 -> ((Inventory)playerInv).m_8020_(arg_0), 0, 36);
            if (!tradeCreative) {
                ItemStack allowStack = this.inventory.getPaymentStack();
                int ptr = 0;
                for (int i = 54; i <= 75; ++i) {
                    ItemStack storageStack = (ItemStack)this.inventory.get(i);
                    if (!ShopScreenHandlerOwner.canUseInTrade(storageStack, allowStack) && !storageStack.m_41619_()) continue;
                    while (ptr < payList.size() && storageStack.m_41613_() < storageStack.m_41741_()) {
                        int space = InventoryDelegate.getAvalableSpace(storageStack);
                        if (storageStack.m_41619_()) {
                            storageStack = ((ItemStack)payList.get(ptr)).m_278832_();
                        } else {
                            storageStack.m_41764_(((ItemStack)payList.get(ptr)).m_41620_(space).m_41613_() + storageStack.m_41613_());
                        }
                        this.inventory.set(i, storageStack);
                        if (!((ItemStack)payList.get(ptr)).m_41619_()) continue;
                        ++ptr;
                    }
                }
            }
            int ptr = 0;
            boolean success = true;
            while (success && ptr < vendList.size()) {
                success = playerInv.m_36054_((ItemStack)vendList.get(ptr));
            }
            Player player = playerInv.f_35978_;
            ShopInventory.ItemScatterer(player.m_9236_(), player.m_20097_(), vendList);
        }

        public boolean canTrade(Player playerEntity) {
            if (!AbstractShopEntity.this.toggleSettings.getOrDefault((Object)ToggleButtonID.CreativeToggle, false).booleanValue()) {
                if (this.inventory.outOfStock()) {
                    this.errorMessage("Shop is out of stock", playerEntity);
                    return false;
                }
                if (this.inventory.paymentRegisterFull()) {
                    this.errorMessage("Shop cannot store any more currency", playerEntity);
                    return false;
                }
            }
            if (this.inventory.isPlayerPoor(playerEntity)) {
                this.errorMessage("You do not have enough currency", playerEntity);
                return false;
            }
            return true;
        }

        private void errorMessage(String message, Player player) {
            if (player.m_9236_().m_5776_()) {
                player.m_5661_((Component)Component.m_237113_((String)message), true);
            }
        }

        public void m_6211_() {
        }

        private static NonNullList<ItemStack> takeItems(ItemStack retrieveStack, miniDelegate inventory, int start, int end) {
            NonNullList list = NonNullList.m_122779_();
            int moneyRequired = retrieveStack.m_41613_();
            for (int i = start; i <= end; ++i) {
                ItemStack stack = inventory.getStack(i);
                if (!ShopScreenHandlerOwner.canUseInTrade(stack, retrieveStack)) continue;
                if (stack.m_41613_() >= moneyRequired) {
                    InventoryDelegate.addToList((NonNullList<ItemStack>)list, stack.m_41620_(moneyRequired));
                    break;
                }
                moneyRequired -= stack.m_41613_();
                InventoryDelegate.addToList((NonNullList<ItemStack>)list, stack);
            }
            return list;
        }

        private static void addToList(NonNullList<ItemStack> list, ItemStack stack) {
            if (list.isEmpty()) {
                list.add((Object)stack.m_278832_());
                return;
            }
            int end = list.size() - 1;
            ItemStack listEnd = (ItemStack)list.get(end);
            int space = InventoryDelegate.getAvalableSpace(listEnd);
            ItemStack split = stack.m_41620_(space);
            list.set(end, (Object)split.m_255036_(listEnd.m_41613_() + split.m_41613_()));
            if (!split.m_41619_()) {
                list.add((Object)stack.m_278832_());
            }
        }

        private static int getAvalableSpace(ItemStack stack) {
            return Math.max(stack.m_41741_() - stack.m_41613_(), 0);
        }

        @NotNull
        public ItemStack m_7407_(int slot, int amount) {
            if (slot > this.m_6643_() || slot < 0) {
                return ItemStack.f_41583_;
            }
            if (slot < 76) {
                if (this.permissions.canTakeItems()) {
                    return this.inventory.split(slot, amount);
                }
            } else if (this.permissions.canEditTrades()) {
                this.inventory.split(slot, amount);
            }
            return ItemStack.f_41583_;
        }

        public void m_6836_(int slot, ItemStack stack) {
            if (slot >= 76) {
                if (this.permissions.canEditTrades()) {
                    this.inventory.set(slot, stack);
                }
            } else if (this.permissions.canImportStock()) {
                this.inventory.set(slot, stack);
            }
        }

        public boolean m_6542_(Player player) {
            return player.m_20148_().compareTo(this.reciever_UUID) == 0;
        }

        public Item getPaymentType() {
            return this.inventory.getPaymentType();
        }

        public int getPrice() {
            return this.inventory.getPrice();
        }

        public Item getDisplayItem() {
            return this.inventory.getDisplayItem();
        }

        private static interface miniDelegate {
            public ItemStack getStack(int var1);
        }
    }

    public final class player_ID_Records_Delegate
    implements Container {
        private final PermissionLevel perms;
        private final UUID userUUID;

        public player_ID_Records_Delegate(PermissionLevel perms, UUID userUUID) {
            this.perms = perms;
            this.userUUID = userUUID;
        }

        public ItemStack insertContract(ItemStack contract, int index) {
            PlayerID id;
            if (this.canEditThat(index) && contract != null && ContractScroll.isSigned(contract) && (id = PlayerID.fromContract(contract, player_ID_Records_Delegate.permFromIndex(index))) != null && AbstractShopEntity.this.identificationRecords.stream().noneMatch(playerID -> playerID.uuid.compareTo(id.uuid) == 0) && AbstractShopEntity.this.contracts.get(index) == ItemStack.f_41583_) {
                AbstractShopEntity.this.identificationRecords.add(id);
                AbstractShopEntity.this.contracts.set(index, (Object)contract);
                this.m_6596_();
                return ItemStack.f_41583_;
            }
            return contract;
        }

        private static PermissionLevel permFromIndex(int index) {
            return PermissionLevel.fromInt(4 - index / 6);
        }

        public static boolean checkAction(ItemStack contract, int index) {
            if (player_ID_Records_Delegate.checkIndex(index) && contract.m_41720_() == ModItems.CONTRACT_SCROLL.get()) {
                return ContractScroll.isSigned(contract);
            }
            return false;
        }

        private static boolean checkIndex(int index) {
            return index < 24 && index >= 0;
        }

        public boolean canEditThat(int index) {
            if (player_ID_Records_Delegate.checkIndex(index) && this.perms.canEditPermissions()) {
                PermissionLevel perm = player_ID_Records_Delegate.permFromIndex(index);
                if (perm.asInt() < PermissionLevel.MANAGER.asInt()) {
                    return true;
                }
                if (this.perms == PermissionLevel.OWNER) {
                    return true;
                }
                return this.belongsToInteractor(this.fetchContract(index, false));
            }
            return false;
        }

        public int m_6643_() {
            return 24;
        }

        public boolean m_7983_() {
            return AbstractShopEntity.this.contracts.isEmpty();
        }

        private ItemStack fetchContract(int index, boolean remove) {
            if (player_ID_Records_Delegate.checkIndex(index)) {
                int i;
                PermissionLevel perm = player_ID_Records_Delegate.permFromIndex(index);
                PlayerID[] array = (PlayerID[])AbstractShopEntity.this.identificationRecords.stream().filter(PlayerID2 -> PlayerID2.permissionLevel == perm).toArray(PlayerID[]::new);
                if (array.length > (i = index % 6)) {
                    PlayerID id = array[i];
                    ItemStack record = AbstractShopEntity.RecordToContract(id);
                    if (remove) {
                        AbstractShopEntity.this.identificationRecords.removeIf(playerID -> playerID.uuid.compareTo(id.uuid) == 0);
                        Level level = AbstractShopEntity.this.f_58857_;
                        if (level instanceof ServerLevel) {
                            ServerLevel server = (ServerLevel)level;
                            server.m_6907_().stream().filter(player -> player.m_20148_().compareTo(id.uuid) == 0).findFirst().ifPresent(Player::m_6915_);
                        }
                        AbstractShopEntity.this.contracts.set(index, (Object)ItemStack.f_41583_);
                        this.m_6596_();
                    }
                    return record;
                }
            }
            return ItemStack.f_41583_;
        }

        @NotNull
        public ItemStack m_8020_(int index) {
            return this.fetchContract(index, false);
        }

        @NotNull
        public ItemStack m_7407_(int index, int amount) {
            return this.removeItem(index);
        }

        public ItemStack m_8016_(int pSlot) {
            return null;
        }

        public ItemStack removeItem(int index) {
            if (this.canEditThat(index)) {
                ItemStack contract = this.fetchContract(index, true);
                this.m_6596_();
                return contract;
            }
            return ItemStack.f_41583_;
        }

        public void m_6836_(int index, @NotNull ItemStack contract) {
        }

        public void m_6596_() {
            if (AbstractShopEntity.this.f_58857_ != null) {
                AbstractShopEntity.this.f_58857_.m_7260_(AbstractShopEntity.this.f_58858_, AbstractShopEntity.this.m_58900_(), AbstractShopEntity.this.m_58900_(), 3);
            }
            AbstractShopEntity.this.copyRecordsToContracts();
            AbstractShopEntity.this.m_6596_();
        }

        public boolean m_6542_(@NotNull Player player) {
            return this.perms.canEditPermissions();
        }

        public boolean belongsToInteractor(@Nullable ItemStack stack) {
            UUID uuid;
            if (stack != null && (uuid = ContractScroll.getUUID(stack)) != null) {
                return 0 == uuid.compareTo(this.userUUID);
            }
            return false;
        }

        public void selfDemote(Player player) {
            if (player.m_20148_().compareTo(this.userUUID) == 0) {
                AbstractShopEntity.this.identificationRecords.removeIf(playerID -> playerID.uuid.compareTo(this.userUUID) == 0);
                this.m_6596_();
            }
        }

        public void m_6211_() {
        }
    }

    private record PlayerID(UUID uuid, String name, PermissionLevel permissionLevel) {
        public static final PlayerID EMPTY = new PlayerID(new UUID(0L, 0L), "##OWNER NAME NULL##", PermissionLevel.CUSTOMER);

        public static PlayerID fromContract(ItemStack contract, PermissionLevel permissionLevel) {
            CompoundTag nbt = contract.m_41783_();
            if (nbt != null && ContractScroll.isSigned(contract)) {
                return new PlayerID(nbt.m_128342_("player_uuid"), nbt.m_128461_("player_name"), permissionLevel);
            }
            return null;
        }

        public static void initialise() {
        }
    }

    public final class settings_Delegate {
        private final boolean isCreative;
        private final boolean canEditSettings;

        private settings_Delegate(PermissionLevel perms, Player player) {
            this.isCreative = player.m_7500_();
            this.canEditSettings = perms.canEditTrades();
        }

        public boolean getState(@NotNull ToggleButtonID ID) {
            return AbstractShopEntity.this.toggleSettings.getOrDefault((Object)ID, ConfigHandler.getDefaultToggleSetting(ID));
        }

        public boolean attemptSetState(@NotNull ToggleButtonID ID, @NotNull Boolean state) {
            if (this.canEditSettings && (ID != ToggleButtonID.CreativeToggle || this.isCreative)) {
                AbstractShopEntity.this.toggleSettings.put(ID, state);
                AbstractShopEntity.this.m_6596_();
                AbstractShopEntity.this.checkShouldRenderParticles();
                return true;
            }
            return false;
        }

        public boolean isPlayerCreative() {
            return this.isCreative;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class RendererData {
        protected final ShopInventory inventory;
        public double lastRotation = 0.0;
        public double targetRotation = 0.0;
        public double frameRotation = 0.0;
        public final double doublePi = Math.PI * 2;
        public String stockQuantity;
        protected Direction direction = Direction.NORTH;
        protected int rotation;
        protected float width;
        protected boolean shopFunctional = false;
        protected ItemStack paymentItem;
        protected ItemStack displayItem;
        protected String text;
        protected int frameAccumulation = 380;
        protected boolean stockDisplayType = false;
        protected boolean currencyDisplayType = true;
        protected boolean shouldUpdate = true;
        public boolean stockWarning = false;
        public boolean paymentWarning = false;
        protected float qWidth;

        public RendererData(ShopInventory inv) {
            this.inventory = inv;
        }

        public void update() {
            boolean bl = this.shopFunctional = AbstractShopEntity.this.isShopFunctional() && this.inventory.tradeFunctional();
            if (this.shopFunctional) {
                BakedModel model;
                this.paymentItem = this.inventory.getPaymentStack();
                this.stockQuantity = Integer.toString(this.inventory.getVendingStack().m_41613_());
                boolean bl2 = this.stockWarning || this.paymentWarning;
                this.paymentWarning = this.inventory.paymentRegisterFull();
                this.stockWarning = this.inventory.outOfStock();
                if (!bl2 && (this.stockWarning || this.paymentWarning)) {
                    this.lastRotation = this.targetRotation = ShopRenderUtils.calcTargetRotation(this);
                }
                this.displayItem = this.inventory.getVendingStack();
                this.text = Integer.toString(this.inventory.getPrice());
                this.direction = AbstractShopEntity.this.getCachedFacingDirection();
                this.getRotation();
                this.width = this.inventory.getPrice() >= 10 ? -7.0f : -2.5f;
                this.qWidth = this.inventory.getVendingQuantity() >= 10 ? -7.0f : -2.5f;
                Minecraft mc = Minecraft.m_91087_();
                if (this.displayItem.m_41720_() instanceof BlockItem) {
                    model = mc.m_91291_().m_174264_(this.displayItem, null, null, 0);
                    this.stockDisplayType = model.m_7539_();
                } else {
                    this.stockDisplayType = false;
                }
                if (this.paymentItem.m_41720_() instanceof BlockItem) {
                    model = mc.m_91291_().m_174264_(this.paymentItem, null, null, 0);
                    this.currencyDisplayType = model.m_7539_();
                } else {
                    this.currencyDisplayType = false;
                }
            } else {
                this.displayItem = ItemStack.f_41583_;
                this.paymentItem = ItemStack.f_41583_;
            }
        }

        public void frameAccumulator() {
            if (this.frameAccumulation == 0) {
                this.frameAccumulation += (int)(Math.random() * 40.0);
                this.shouldUpdate = true;
                this.update();
            }
            ++this.frameAccumulation;
            if (this.frameAccumulation >= 400) {
                this.frameAccumulation = 0;
            }
        }

        private void getRotation() {
            this.rotation = switch (this.direction) {
                case Direction.EAST -> 90;
                case Direction.SOUTH -> 0;
                case Direction.WEST -> 270;
                default -> 180;
            };
        }

        public boolean shopFunctional() {
            return this.shopFunctional;
        }

        public boolean stockDisplayType() {
            return this.stockDisplayType;
        }

        public boolean currencyDisplayType() {
            return this.currencyDisplayType;
        }

        public ItemStack displayItem() {
            return this.displayItem;
        }

        public Level world() {
            return AbstractShopEntity.this.f_58857_;
        }

        public Direction direction() {
            return this.direction;
        }

        public String text() {
            return this.text;
        }

        public float width() {
            return this.width;
        }

        public float qWidth() {
            return this.qWidth;
        }

        public ItemStack paymentItem() {
            return this.paymentItem;
        }

        public int rotation() {
            return this.rotation;
        }

        public boolean updateIconRotation() {
            if (this.shouldUpdate) {
                this.shouldUpdate = false;
                return true;
            }
            return false;
        }

        public void onTick() {
            this.shouldUpdate = true;
        }

        public int x() {
            return AbstractShopEntity.this.m_58899_().m_123341_();
        }

        public int y() {
            return AbstractShopEntity.this.m_58899_().m_123342_();
        }

        public int z() {
            return AbstractShopEntity.this.m_58899_().m_123343_();
        }

        public boolean renderIcons() {
            return AbstractShopEntity.this.shouldRenderParticles;
        }
    }
}

