/*
 * Decompiled with CFR 0.152.
 */
package net.spudacious5705.shops.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.spudacious5705.shops.block.ModBlockEntities;
import net.spudacious5705.shops.block.entity.AbstractShopEntity;
import net.spudacious5705.shops.block.entity.ShopInventory;
import org.jetbrains.annotations.NotNull;

public class ShelfShopEntity
extends AbstractShopEntity {
    private final ShopInventory shopInventoryTop = ShopInventory.create();
    @OnlyIn(value=Dist.CLIENT)
    protected ShelfRenderData furtherDataTop;
    @OnlyIn(value=Dist.CLIENT)
    protected ShelfRenderData furtherDataBottom;
    @OnlyIn(value=Dist.CLIENT)
    protected AbstractShopEntity.RendererData rendererDataTop;

    @OnlyIn(value=Dist.CLIENT)
    public ShelfRenderData furtherDataBottom() {
        return this.furtherDataBottom;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ShelfRenderData furtherDataTop() {
        return this.furtherDataTop;
    }

    @Override
    @NotNull
    protected ShopInventory otherInventory() {
        return this.shopInventoryTop;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void forceUpdateRenderData() {
        super.forceUpdateRenderData();
        this.rendererDataTop.update();
    }

    @Override
    public void itemScatter(Level world, BlockPos pos) {
        super.itemScatter(world, pos);
        ShopInventory.ItemScatterer(world, pos, this.shopInventoryTop.prepForItemScatterer());
    }

    @Override
    public void renderTick() {
        this.rendererData.onTick();
        this.rendererDataTop.onTick();
    }

    public ShelfShopEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SHELF_SHOP_ENTITY.get(), pos, state, -0.3f);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.createRendererDataForShelf();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void createRendererDataForShelf() {
        this.furtherDataTop = new ShelfRenderData();
        this.furtherDataBottom = new ShelfRenderData();
        this.rendererDataTop = new AbstractShopEntity.RendererData(this.shopInventoryTop);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AbstractShopEntity.RendererData rendererDataTop() {
        return this.rendererDataTop;
    }

    @Override
    protected boolean hasTrade() {
        return this.shopInventory.tradeFunctional() || this.shopInventoryTop.tradeFunctional();
    }

    @Override
    public int getTextureId() {
        return 0;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        ListTag nbtList = new ListTag();
        for (int i = 0; i < this.shopInventoryTop.size(); ++i) {
            ItemStack itemStack = (ItemStack)this.shopInventoryTop.get(i);
            if (itemStack.m_41619_()) continue;
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.m_128344_("SlotTwo", (byte)i);
            itemStack.m_41739_(compoundtag);
            nbtList.add((Object)compoundtag);
        }
        if (!nbtList.isEmpty()) {
            tag.m_128365_("ItemsTwo", (Tag)nbtList);
        }
        super.m_183515_(tag);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        ListTag nbtList = nbt.m_128437_("ItemsTwo", 10);
        for (int i = 0; i < nbtList.size(); ++i) {
            CompoundTag nbtCompound = nbtList.m_128728_(i);
            int j = nbtCompound.m_128445_("SlotTwo") & 0xFF;
            if (j >= this.shopInventoryTop.size()) continue;
            this.shopInventoryTop.set(j, ItemStack.m_41712_((CompoundTag)nbtCompound));
        }
        super.m_142466_(nbt);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ShelfRenderData {
        public final float itemLrotation = (float)(Math.random() * 90.0 + 80.0);
        public final float itemRrotation = (float)(Math.random() * 90.0 + 80.0);
    }
}

