/*
 * Decompiled with CFR 0.152.
 */
package net.spudacious5705.shops.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.spudacious5705.shops.block.entity.AbstractShopEntity;
import net.spudacious5705.shops.block.entity.AngledShopEntity;
import net.spudacious5705.shops.block.entity.renderer.ShopRenderUtils;
import net.spudacious5705.shops.util.CushionModel;

public class AngledShopBlockRenderer
implements BlockEntityRenderer<AngledShopEntity> {
    private final BlockEntityRendererProvider.Context context;
    private final CushionModel model;

    public AngledShopBlockRenderer(BlockEntityRendererProvider.Context ctx) {
        this.context = ctx;
        this.model = new CushionModel(ctx.m_173582_(CushionModel.LAYER_LOCATION));
    }

    public void render(AngledShopEntity shop, float tickDelta, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        AbstractShopEntity.RendererData data = shop.rendererData();
        Font font = this.context.m_173586_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.0f, 0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(switch (shop.getCachedFacingDirection()) {
            case Direction.EAST -> 270.0f;
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            default -> 0.0f;
        }));
        poseStack.m_252880_(-0.5f, 0.0f, -0.5f);
        this.model.m_7695_(poseStack, bufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)shop.getCushionTextureID())), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        if (data == null) {
            return;
        }
        data.frameAccumulator();
        if (data.shopFunctional()) {
            ItemDisplayContext mode;
            poseStack.m_85836_();
            poseStack.m_252880_(0.5f, 0.955f, 0.5f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)data.rotation()));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-67.5f));
            if (data.stockDisplayType()) {
                poseStack.m_85841_(0.3f, 0.3f, 0.3f);
                mode = ItemDisplayContext.NONE;
            } else {
                poseStack.m_85841_(0.4f, 0.4f, 0.4f);
                mode = ItemDisplayContext.GUI;
            }
            this.context.m_234447_().m_115143_(data.displayItem(), mode, false, poseStack, bufferSource, light, overlay, this.context.m_234447_().m_174264_(data.displayItem(), null, null, 0));
            poseStack.m_85849_();
            poseStack.m_85836_();
            if (data.direction() == Direction.NORTH) {
                poseStack.m_252880_(0.57f, 0.514375f, 0.0525f);
                poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-22.5f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
            }
            if (data.direction() == Direction.EAST) {
                poseStack.m_252880_(0.9475f, 0.514375f, 0.57f);
                poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-22.5f));
            }
            if (data.direction() == Direction.SOUTH) {
                poseStack.m_252880_(0.43f, 0.514375f, 0.9475f);
                poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-22.5f));
            }
            if (data.direction() == Direction.WEST) {
                poseStack.m_252880_(0.0525f, 0.514375f, 0.43f);
                poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-22.5f));
            }
            poseStack.m_85841_(0.018f, 0.018f, 0.018f);
            font.m_271703_(data.text(), data.width(), -4.0f, 0xFFFFFF, false, poseStack.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.NORMAL, 0, light);
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_252880_(0.3f, 1.05f, 0.25f);
            poseStack.m_252880_(0.2f, 0.0f, 0.25f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(switch (data.direction()) {
                case Direction.EAST -> 270.0f;
                case Direction.SOUTH -> 180.0f;
                case Direction.WEST -> 90.0f;
                default -> 0.0f;
            }));
            poseStack.m_252880_(-0.2f, 0.0f, -0.25f);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-67.5f));
            poseStack.m_85841_(0.018f, 0.018f, 0.018f);
            font.m_271703_(data.stockQuantity, data.qWidth(), -4.0f, 0xFFFF00, false, poseStack.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.NORMAL, 0xFFFFFF, light);
            poseStack.m_85849_();
            poseStack.m_85836_();
            if (data.direction() == Direction.NORTH) {
                poseStack.m_252880_(0.385f, 0.535f, 0.0525f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-22.5f));
            }
            if (data.direction() == Direction.EAST) {
                poseStack.m_252880_(0.9475f, 0.535f, 0.385f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-22.5f));
            }
            if (data.direction() == Direction.SOUTH) {
                poseStack.m_85837_((double)0.615f, (double)0.535f, 0.9475);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-22.5f));
            }
            if (data.direction() == Direction.WEST) {
                poseStack.m_252880_(0.0525f, 0.535f, 0.615f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-22.5f));
            }
            poseStack.m_85841_(0.18f, 0.18f, 0.18f);
            this.context.m_234447_().m_115143_(data.paymentItem(), ItemDisplayContext.GUI, false, poseStack, bufferSource, light, overlay, this.context.m_234447_().m_174264_(data.paymentItem(), null, null, 0));
            poseStack.m_85849_();
            ShopRenderUtils.renderShopWarns(tickDelta, poseStack, bufferSource, light, overlay, data, this.context, 0.375f);
        }
    }
}

