/*
 * Decompiled with CFR 0.152.
 */
package net.spudacious5705.shops.screen;

import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.spudacious5705.shops.SpudaciousShops;
import net.spudacious5705.shops.screen.ModScreenHandlers;
import net.spudacious5705.shops.screen.ScreenSettingsGroup;
import net.spudacious5705.shops.screen.ShopScreenHandlerOwner;
import net.spudacious5705.shops.screen.ToggleButtonID;
import net.spudacious5705.shops.screen.networking.NetworkHelper;
import net.spudacious5705.shops.screen.networking.ShopSelfDemotePkt;

public class ShopScreenOwner
extends AbstractContainerScreen<ShopScreenHandlerOwner> {
    private final ScreenSettingsGroup SETTINGS;
    private ResourceLocation TEXTURE;
    private static final ResourceLocation WARNING_TEXTURE = SpudaciousShops.getResource("textures/gui/warning_screen.png");
    private static final ResourceLocation RED_BUTTON = SpudaciousShops.getResource("textures/gui/red_button.png");
    private static final ResourceLocation RED_BUTTON_SELECTED = SpudaciousShops.getResource("textures/gui/red_button_selected.png");
    private static final ResourceLocation GREEN_BUTTON = SpudaciousShops.getResource("textures/gui/green_button.png");
    private static final ResourceLocation GREEN_BUTTON_SELECTED = SpudaciousShops.getResource("textures/gui/green_button_selected.png");
    private static final ResourceLocation COG_ICON = SpudaciousShops.getResource("textures/gui/settings.png");
    private static final ResourceLocation STORAGE_ICON = SpudaciousShops.getResource("textures/gui/storage.png");
    private static final ResourceLocation SHOPFRONT_ICON = ModScreenHandlers.CURRENCY_IMG_MAP.getOrDefault(Character.valueOf(Component.m_237115_((String)"gui.spudaciousshops.currency_type").getString().charAt(0)), SpudaciousShops.getResource("textures/gui/currency_textures/gbp.png"));
    private static final ResourceLocation TAB_SELECTED = SpudaciousShops.getResource("textures/gui/tab_selected.png");
    private static final ResourceLocation TAB_DESELECTED = SpudaciousShops.getResource("textures/gui/tab_deselected.png");
    private static final ResourceLocation TAB_HOVER = SpudaciousShops.getResource("textures/gui/tab_hover.png");
    private static final ResourceLocation CREATIVE_ON = SpudaciousShops.getResource("textures/gui/creative_on.png");
    private static final ResourceLocation CREATIVE_OFF = SpudaciousShops.getResource("textures/gui/creative_off.png");
    private static final ResourceLocation EFFECTS_ON = SpudaciousShops.getResource("textures/gui/effects_on.png");
    private static final ResourceLocation EFFECTS_OFF = SpudaciousShops.getResource("textures/gui/effects_off.png");
    TabWidget SellerTabButton;
    TabWidget SettingsTabButton;
    TabWidget ShopFrontTabButton;
    ButtonWidget WarningCancel;
    ButtonWidget WarningProceed;
    ToggleWidget ToggleCreative;
    ToggleWidget ToggleIconsEffects;
    ToggleWidget ToggleShopStyle;
    ToggleWidget ToggleIgnoreNBT;
    protected final EnumMap<ToggleButtonID, ToggleWidget> toggleButtons = new EnumMap(ToggleButtonID.class);
    private static final Component OWNER = Component.m_237115_((String)"gui.spudaciousshops.owner");
    private static final Component MANAGER = Component.m_237115_((String)"gui.spudaciousshops.manager");
    private static final Component SUPERVISOR = Component.m_237115_((String)"gui.spudaciousshops.supervisor");
    private static final Component CLERK = Component.m_237115_((String)"gui.spudaciousshops.clerk");
    private static final Component WARN_TITLE = Component.m_237115_((String)"gui.spudaciousshops.delete_warn_title");
    private static final Component WARN_LINE_1 = Component.m_237115_((String)"gui.spudaciousshops.delete_warn_message_line1");
    private static final Component WARN_LINE_2 = Component.m_237115_((String)"gui.spudaciousshops.delete_warn_message_line2");
    private static final Component CANCEL = Component.m_237115_((String)"gui.spudaciousshops.cancel");
    private static final Component DELETE = Component.m_237115_((String)"gui.spudaciousshops.delete");
    private final String PERMISSIONS = Component.m_237115_((String)"gui.spudaciousshops.text_permissions").getString();
    private final String IMPORT_ITEMS = Component.m_237115_((String)"gui.spudaciousshops.text_import_items").getString();
    private final String TAKE_ITEMS = Component.m_237115_((String)"gui.spudaciousshops.text_take_items").getString();
    private final String EDIT_PERMS = Component.m_237115_((String)"gui.spudaciousshops.text_edit_perms").getString();
    private final String CHANGE_TRADE = Component.m_237115_((String)"gui.spudaciousshops.text_change_trade").getString();
    private final String BREAK_SHOP = Component.m_237115_((String)"gui.spudaciousshops.text_break_shop").getString();
    private final String YES = Component.m_237115_((String)"gui.spudaciousshops.text_yes").getString();
    private final String NO = Component.m_237115_((String)"gui.spudaciousshops.text_no").getString();
    private final String ALL = Component.m_237115_((String)"gui.spudaciousshops.text_all").getString();
    private final String SUPERVISOR_AND_LOWER = Component.m_237115_((String)"gui.spudaciousshops.text_supervisor_and_lower").getString();
    private final String NONE = Component.m_237115_((String)"gui.spudaciousshops.text_none").getString();
    private final String CREATIVE_TOGGLE_TOOLTIP = Component.m_237115_((String)"gui.spudaciousshops.toggle_creative").getString();
    private final String EFFECTS_TOGGLE_TOOLTIP = Component.m_237115_((String)"gui.spudaciousshops.toggle_effects").getString();
    private ToolTipText[] TEXTS = this.addToolTipTexts();
    private Warn_popup_texts[] WARN_TEXTS = this.addWarnPopupTexts();
    private Warn_popup_texts[] STORAGE_TEXTS = this.addStorageTexts();

    public ShopScreenOwner(ShopScreenHandlerOwner menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 228;
        this.f_97727_ = 256;
        this.SETTINGS = menu.getSettings();
        this.TEXTURE = this.SETTINGS.SELLER().textureID();
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        menu.initiateWarn(this::openWarnPopup);
        menu.settingsUpdater(this::updateToggleButtonFromPacket);
        menu.setWidgetFunction(this::setWidgetsVisible);
        menu.updateTabSelection();
    }

    private void closeWarnPopup() {
        this.WarningCancel.f_93624_ = false;
        this.WarningProceed.f_93624_ = false;
        this.SettingsTabButton.f_93624_ = true;
        this.SellerTabButton.f_93624_ = true;
        this.ShopFrontTabButton.f_93624_ = true;
        this.switchToSettingsTab();
    }

    private void WarnPopupContinue() {
        NetworkHelper.CHANNEL.sendToServer((Object)new ShopSelfDemotePkt());
        ((ShopScreenHandlerOwner)this.f_97732_).close();
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    protected void m_7856_() {
        super.m_7856_();
        int posX = this.SETTINGS.tab1ButtonX() + this.f_97735_;
        int posY = this.SETTINGS.tab1ButtonY() + this.f_97736_;
        this.SellerTabButton = (TabWidget)this.m_142416_((GuiEventListener)new TabWidget(posX, posY, (Component)Component.m_237113_((String)""), this::switchToSellerTab, true, STORAGE_ICON, true));
        posX = this.SETTINGS.tab2ButtonX() + this.f_97735_;
        posY = this.SETTINGS.tab2ButtonY() + this.f_97736_;
        this.SettingsTabButton = (TabWidget)this.m_142416_((GuiEventListener)new TabWidget(posX, posY, (Component)Component.m_237113_((String)""), this::switchToSettingsTab, true, COG_ICON));
        posX = this.SETTINGS.tab3ButtonX() + this.f_97735_;
        posY = this.SETTINGS.tab3ButtonY() + this.f_97736_;
        this.ShopFrontTabButton = (TabWidget)this.m_142416_((GuiEventListener)new TabWidget(posX, posY, (Component)Component.m_237113_((String)""), this::switchToCustomerTab, true, SHOPFRONT_ICON));
        posX = 22 + this.f_97735_;
        posY = 128 + this.f_97736_;
        this.WarningCancel = (ButtonWidget)this.m_142416_((GuiEventListener)new ButtonWidget(posX, posY, (Component)Component.m_237113_((String)"CANCEL"), this::closeWarnPopup, GREEN_BUTTON, GREEN_BUTTON_SELECTED, CANCEL, 3840));
        this.WarningProceed = (ButtonWidget)this.m_142416_((GuiEventListener)new ButtonWidget(posX += 113, posY, (Component)Component.m_237113_((String)"CONTINUE"), this::WarnPopupContinue, RED_BUTTON, RED_BUTTON_SELECTED, DELETE, 984329));
        posX = this.SETTINGS.creativeButtonX() + this.f_97735_;
        posY = this.SETTINGS.creativeButtonY() + this.f_97736_;
        this.ToggleCreative = (ToggleWidget)this.m_142416_((GuiEventListener)new ToggleWidget(posX, posY, ToggleButtonID.CreativeToggle, CREATIVE_ON, CREATIVE_OFF, this.CREATIVE_TOGGLE_TOOLTIP));
        posX = this.SETTINGS.toggleEffectsButtonX() + this.f_97735_;
        posY = this.SETTINGS.toggleEffectsButtonY() + this.f_97736_;
        this.ToggleIconsEffects = (ToggleWidget)this.m_142416_((GuiEventListener)new ToggleWidget(posX, posY, ToggleButtonID.EffectsToggle, EFFECTS_ON, EFFECTS_OFF, this.EFFECTS_TOGGLE_TOOLTIP));
        for (ToggleButtonID value : ToggleButtonID.values()) {
            this.toggleButtons.put(value, switch (value) {
                default -> throw new IncompatibleClassChangeError();
                case ToggleButtonID.CreativeToggle -> this.ToggleCreative;
                case ToggleButtonID.ShopStyleToggle -> this.ToggleShopStyle;
                case ToggleButtonID.IgnoreNBTToggle -> this.ToggleIgnoreNBT;
                case ToggleButtonID.EffectsToggle -> this.ToggleIconsEffects;
            });
        }
        switch (((ShopScreenHandlerOwner)this.f_97732_).getActiveTab()) {
            case 2: {
                this.settingsGUI();
                break;
            }
            case 3: {
                this.customerGUI();
                break;
            }
            case 4: {
                this.warnGUI();
                break;
            }
            default: {
                this.sellerGUI();
            }
        }
        this.WARN_TEXTS = this.addWarnPopupTexts();
        this.STORAGE_TEXTS = this.addStorageTexts();
        this.TEXTS = this.addToolTipTexts();
    }

    private void switchToCustomerTab() {
        ((ShopScreenHandlerOwner)this.f_97732_).updateTabSelectionClientside(3);
        this.customerGUI();
    }

    protected void customerGUI() {
        this.TEXTURE = this.SETTINGS.CUSTOMER().textureID();
        this.ShopFrontTabButton.toggle();
        this.SellerTabButton.unToggle();
        this.SettingsTabButton.unToggle();
        this.setWidgetsVisible(false);
    }

    private void switchToSellerTab() {
        ((ShopScreenHandlerOwner)this.f_97732_).updateTabSelectionClientside(1);
        this.sellerGUI();
    }

    protected void sellerGUI() {
        this.TEXTURE = this.SETTINGS.SELLER().textureID();
        this.SellerTabButton.toggle();
        this.ShopFrontTabButton.unToggle();
        this.SettingsTabButton.unToggle();
        this.setWidgetsVisible(false);
    }

    private void switchToSettingsTab() {
        ((ShopScreenHandlerOwner)this.f_97732_).updateTabSelectionClientside(2);
        this.settingsGUI();
    }

    protected void settingsGUI() {
        this.TEXTURE = this.SETTINGS.SETTINGS().textureID();
        this.SettingsTabButton.toggle();
        this.setWidgetsVisible(true);
        this.ShopFrontTabButton.unToggle();
        this.SellerTabButton.unToggle();
    }

    void openWarnPopup() {
        ((ShopScreenHandlerOwner)this.f_97732_).updateTabSelectionClientside(4);
        this.warnGUI();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            Minecraft.m_91087_().f_91074_.m_5496_((SoundEvent)SoundEvents.f_12213_.m_203334_(), 3.0f, 0.3f);
        }
    }

    protected void warnGUI() {
        this.TEXTURE = WARNING_TEXTURE;
        this.SettingsTabButton.f_93624_ = false;
        this.SellerTabButton.f_93624_ = false;
        this.ShopFrontTabButton.f_93624_ = false;
        this.WarningCancel.f_93624_ = true;
        this.WarningProceed.f_93624_ = true;
        this.setWidgetsVisible(false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateTabSelectionResponse(int tab) {
        if (((ShopScreenHandlerOwner)this.f_97732_).updateTabSelectionResponse(tab)) {
            switch (tab) {
                case 4: {
                    this.warnGUI();
                    break;
                }
                case 3: {
                    this.customerGUI();
                    break;
                }
                case 2: {
                    this.settingsGUI();
                    break;
                }
                default: {
                    this.sellerGUI();
                }
            }
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.m_280218_(this.TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(context);
        super.m_88315_(context, mouseX, mouseY, partialTick);
        Font font = Minecraft.m_91087_().f_91062_;
        int activeTab = ((ShopScreenHandlerOwner)this.f_97732_).getActiveTab();
        if (activeTab == 2) {
            for (ToolTipText ttt : this.TEXTS) {
                ttt.render(context, font, mouseX, mouseY);
            }
        } else if (activeTab == 4) {
            for (Warn_popup_texts t : this.WARN_TEXTS) {
                t.render(context, font);
            }
        } else if (activeTab == 1) {
            for (Warn_popup_texts t : this.STORAGE_TEXTS) {
                t.render(context, font);
            }
        }
        this.m_280072_(context, mouseX, mouseY);
    }

    private ToolTipText[] addToolTipTexts() {
        int textX = 14 + this.f_97735_;
        int textY = 72 + this.f_97736_;
        int increment = 23;
        int colour = ((ShopScreenHandlerOwner)this.f_97732_).SCREEN_SETTINGS.SETTINGS_TEXT_COLOUR();
        ToolTipText[] texts = new ToolTipText[4];
        MutableComponent permissions_title = Component.m_237113_((String)("\u00a7l" + this.PERMISSIONS + ":"));
        texts[0] = new ToolTipText(colour, OWNER, textX, textY, List.of(permissions_title, Component.m_237113_((String)("\u00a7a + " + this.IMPORT_ITEMS + ": " + this.YES)), Component.m_237113_((String)("\u00a7a + " + this.TAKE_ITEMS + ": " + this.YES)), Component.m_237113_((String)("\u00a7a + " + this.EDIT_PERMS + ": " + this.ALL)), Component.m_237113_((String)("\u00a7a + " + this.CHANGE_TRADE + ": " + this.YES)), Component.m_237113_((String)("\u00a7a + " + this.BREAK_SHOP + ": " + this.YES))));
        texts[1] = new ToolTipText(colour, MANAGER, textX, textY += increment, List.of(permissions_title, Component.m_237113_((String)("\u00a7a + " + this.IMPORT_ITEMS + ": " + this.YES)), Component.m_237113_((String)("\u00a7a + " + this.TAKE_ITEMS + ": " + this.YES)), Component.m_237113_((String)("\u00a79 + " + this.EDIT_PERMS + ": " + this.SUPERVISOR_AND_LOWER)), Component.m_237113_((String)("\u00a7c - " + this.CHANGE_TRADE + ": " + this.NO)), Component.m_237113_((String)("\u00a7c - " + this.BREAK_SHOP + ": " + this.NO))));
        texts[2] = new ToolTipText(colour, SUPERVISOR, textX, textY += increment, List.of(permissions_title, Component.m_237113_((String)("\u00a7a + " + this.IMPORT_ITEMS + ": " + this.YES)), Component.m_237113_((String)("\u00a7a + " + this.TAKE_ITEMS + ": " + this.YES)), Component.m_237113_((String)("\u00a7c - " + this.EDIT_PERMS + ": " + this.NONE)), Component.m_237113_((String)("\u00a7c - " + this.CHANGE_TRADE + ": " + this.NO)), Component.m_237113_((String)("\u00a7c - " + this.BREAK_SHOP + ": " + this.NO))));
        texts[3] = new ToolTipText(colour, CLERK, textX, textY += increment, List.of(permissions_title, Component.m_237113_((String)("\u00a7a + " + this.IMPORT_ITEMS + ": " + this.YES)), Component.m_237113_((String)("\u00a7c - " + this.TAKE_ITEMS + ": " + this.NO)), Component.m_237113_((String)("\u00a7c - " + this.EDIT_PERMS + ": " + this.NONE)), Component.m_237113_((String)("\u00a7c - " + this.CHANGE_TRADE + ": " + this.NO)), Component.m_237113_((String)("\u00a7c - " + this.BREAK_SHOP + ": " + this.NO))));
        return texts;
    }

    private Warn_popup_texts[] addWarnPopupTexts() {
        int textX = this.f_97735_ + 110;
        int textY = this.f_97736_ + 84;
        Warn_popup_texts[] warn_texts = new Warn_popup_texts[]{new Warn_popup_texts(textX, textY, WARN_TITLE, 0xE10000, true), new Warn_popup_texts(textX, textY += 20, WARN_LINE_1, 986895, false), new Warn_popup_texts(textX, textY += 10, WARN_LINE_2, 986895, false)};
        return warn_texts;
    }

    private Warn_popup_texts[] addStorageTexts() {
        Warn_popup_texts[] storage_texts = new Warn_popup_texts[]{new Warn_popup_texts(this.f_97735_ + 90, this.f_97736_ + 5, (Component)Component.m_237113_((String)"Stock"), 0x252525, false), new Warn_popup_texts(this.f_97735_ + 35, this.f_97736_ + 113, (Component)Component.m_237113_((String)"Register"), 0x252525, false), new Warn_popup_texts(this.f_97735_ + 33, this.f_97736_ + 18, (Component)Component.m_237113_((String)"Payment"), 0x252525, false), new Warn_popup_texts(this.f_97735_ + 33, this.f_97736_ + 61, (Component)Component.m_237113_((String)"Product"), 0x252525, false)};
        return storage_texts;
    }

    protected void updateToggleButtonFromPacket(ToggleButtonID button, boolean state) {
        this.toggleButtons.get((Object)((Object)button)).toggle = state;
    }

    protected void setWidgetsVisible(boolean state) {
        ToggleWidget w = this.toggleButtons.get((Object)ToggleButtonID.EffectsToggle);
        if (w != null) {
            w.f_93624_ = state;
        }
        if ((w = this.toggleButtons.get((Object)ToggleButtonID.CreativeToggle)) != null) {
            w.f_93624_ = state && ((ShopScreenHandlerOwner)this.f_97732_).isPlayerCreative();
        }
    }

    private class ToolTipText {
        private final Component TEXT;
        private final int X;
        private final int Y;
        private final int Xmax;
        private final int Ymax;
        private final List<Component> TOOLTIP;
        private final int COLOUR;

        private ToolTipText(int colour, Component text, int x, int y, List<Component> tooltip) {
            this.TEXT = text;
            this.X = x;
            this.Y = y;
            int tXmax = 0;
            int tYmax = 0;
            try {
                tXmax = this.X + ShopScreenOwner.this.f_96547_.m_92852_((FormattedText)this.TEXT);
                Objects.requireNonNull(ShopScreenOwner.this.f_96547_);
                tYmax = this.Y + 9;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tXmax == 0 || tYmax == 0) {
                tXmax = this.X + 25;
                tYmax = this.Y + 8;
            }
            this.Xmax = tXmax;
            this.Ymax = tYmax;
            this.TOOLTIP = tooltip;
            this.COLOUR = colour;
        }

        public void render(GuiGraphics context, Font textRenderer, int mouseX, int mouseY) {
            context.m_280614_(textRenderer, this.TEXT, this.X, this.Y, this.COLOUR, false);
            if (mouseX >= this.X && mouseX <= this.Xmax && mouseY >= this.Y && mouseY <= this.Ymax) {
                context.m_280677_(textRenderer, this.TOOLTIP, Optional.empty(), mouseX, mouseY);
            }
        }
    }

    private record Warn_popup_texts(int x, int y, Component text, int colour, boolean shadow) {
        void render(GuiGraphics context, Font f) {
            context.m_280614_(f, this.text, this.x - f.m_92852_((FormattedText)this.text) / 2, this.y, this.colour, this.shadow);
        }

        void renderOffset(GuiGraphics context, Font textRenderer) {
            context.m_280614_(textRenderer, this.text, 1 + this.x - textRenderer.m_92852_((FormattedText)this.text) / 2, this.y, this.colour, this.shadow);
        }
    }

    private class ButtonWidget
    extends AbstractWidget {
        private final ClickEventHandler FUNCTION;
        private final ResourceLocation TEXTURE;
        private final ResourceLocation TEXTURE_HOVERED;
        private final Warn_popup_texts TEXT;

        public ButtonWidget(int x, int y, Component message, ClickEventHandler function, ResourceLocation texture, ResourceLocation textureHovered, Component text, int colour) {
            super(x, y, 64, 28, message);
            this.FUNCTION = function;
            this.f_93624_ = false;
            this.TEXTURE = texture;
            this.TEXTURE_HOVERED = textureHovered;
            this.TEXT = new Warn_popup_texts(x + 32, y + 13, text, colour, false);
        }

        protected void m_87963_(GuiGraphics context, int pMouseX, int pMouseY, float pPartialTick) {
            int x = this.m_252754_();
            int y = this.m_252907_() - 16;
            if (this.f_93622_) {
                context.m_280411_(this.TEXTURE_HOVERED, x, y, 64, 64, 0.0f, 0.0f, 64, 64, 64, 64);
                this.renderText(context, true);
            } else {
                context.m_280411_(this.TEXTURE, x, y, 64, 64, 0.0f, 0.0f, 64, 64, 64, 64);
                this.renderText(context, false);
            }
        }

        private void renderText(GuiGraphics context, boolean offset) {
            Font f = Minecraft.m_91087_().f_91062_;
            if (offset) {
                this.TEXT.renderOffset(context, f);
            } else {
                this.TEXT.render(context, f);
            }
        }

        public void m_5716_(double mouseX, double mouseY) {
            this.FUNCTION.execute();
        }

        protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
        }
    }

    private static class TabWidget
    extends AbstractWidget {
        private final ClickEventHandler thisTab;
        private final ResourceLocation ICON_TEXTURE;
        private boolean toggle;

        public TabWidget(int x, int y, Component message, ClickEventHandler tab, boolean visible, ResourceLocation texture) {
            this(x, y, message, tab, visible, texture, false);
        }

        public TabWidget(int x, int y, Component message, ClickEventHandler tab, boolean visible, ResourceLocation texture, boolean toggle) {
            super(x, y, 22, 22, message);
            this.thisTab = tab;
            this.f_93624_ = visible;
            this.toggle = toggle;
            this.ICON_TEXTURE = texture;
        }

        protected void m_87963_(GuiGraphics context, int pMouseX, int pMouseY, float pPartialTick) {
            int x = this.m_252754_() - 3;
            int y = this.m_252907_() - 6;
            if (this.toggle) {
                context.m_280411_(TAB_SELECTED, x, y, 32, 32, 0.0f, 0.0f, 32, 32, 32, 32);
            } else if (this.f_93622_) {
                context.m_280411_(TAB_HOVER, x, y, 32, 32, 0.0f, 0.0f, 32, 32, 32, 32);
            } else {
                context.m_280411_(TAB_DESELECTED, x, y, 32, 32, 0.0f, 0.0f, 32, 32, 32, 32);
            }
            context.m_280411_(this.ICON_TEXTURE, x + 6, y + 9, 16, 16, 0.0f, 0.0f, 16, 16, 16, 16);
        }

        public void m_5716_(double mouseX, double mouseY) {
            this.thisTab.execute();
        }

        protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
        }

        void unToggle() {
            this.toggle = false;
        }

        void toggle() {
            this.toggle = true;
        }
    }

    static interface ClickEventHandler {
        public void execute();
    }

    private class ToggleWidget
    extends AbstractWidget {
        private final ResourceLocation TEXTURE_ON;
        private final ResourceLocation TEXTURE_OFF;
        private final ToggleButtonID BUTTON_ID;
        private final Component tooltip;
        private boolean toggle;

        public ToggleWidget(int x, int y, ToggleButtonID buttonID, ResourceLocation textureON, ResourceLocation textureOFF, String tooltipText) {
            super(x, y, 32, 16, (Component)Component.m_237113_((String)""));
            this.BUTTON_ID = buttonID;
            this.f_93624_ = false;
            this.toggle = ((ShopScreenHandlerOwner)ShopScreenOwner.this.f_97732_).getStateOfSetting(this.BUTTON_ID);
            this.TEXTURE_ON = textureON;
            this.TEXTURE_OFF = textureOFF;
            this.tooltip = Component.m_237113_((String)tooltipText);
        }

        protected void m_87963_(GuiGraphics context, int mouseX, int mouseY, float pPartialTick) {
            int x = this.m_252754_();
            int y = this.m_252907_();
            context.m_280411_(ShopScreenOwner.this.SETTINGS.BUTTON_BACKGROUND(), x - 3, y - 3, 64, 64, 0.0f, 0.0f, 64, 64, 64, 64);
            context.m_280411_(this.toggle ? this.TEXTURE_ON : this.TEXTURE_OFF, x, y, 32, 32, 0.0f, 0.0f, 32, 32, 32, 32);
            if (this.f_93622_) {
                context.m_280557_(Minecraft.m_91087_().f_91062_, this.tooltip, mouseX, mouseY);
            }
        }

        public void m_5716_(double mouseX, double mouseY) {
            this.toggle = ((ShopScreenHandlerOwner)ShopScreenOwner.this.f_97732_).handleToggleButtonInput(this.BUTTON_ID, !this.toggle);
        }

        protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
        }

        void toggleOff() {
            this.toggle = false;
        }

        void toggleOn() {
            this.toggle = true;
        }
    }
}

