/*
 * Decompiled with CFR 0.152.
 */
package shandwmx.rPSPlugin;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import shandwmx.rPSPlugin.KnbPlugin;

public class KnbGUI
implements Listener {
    private final KnbPlugin plugin;
    private final Map<UUID, BukkitRunnable> playerTimers = new HashMap<UUID, BukkitRunnable>();
    private final Map<UUID, UUID> playerOpponents = new HashMap<UUID, UUID>();

    public KnbGUI(KnbPlugin plugin) {
        this.plugin = plugin;
    }

    public void openGameGUI(Player player) {
        Player opponent = this.plugin.getOpponent(player);
        if (opponent == null) {
            return;
        }
        Inventory inv = Bukkit.createInventory(null, (int)9, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0430\u0440\u0438\u0430\u043d\u0442");
        ItemStack rock = this.createItem(Material.STONE, "\u041a\u0430\u043c\u0435\u043d\u044c", "\u043a\u0430\u043c\u0435\u043d\u044c");
        ItemStack scissors = this.createItem(Material.IRON_SWORD, "\u041d\u043e\u0436\u043d\u0438\u0446\u044b", "\u043d\u043e\u0436\u043d\u0438\u0446\u044b");
        ItemStack paper = this.createItem(Material.PAPER, "\u0411\u0443\u043c\u0430\u0433\u0430", "\u0431\u0443\u043c\u0430\u0433\u0430");
        ItemStack timer = this.createTimerItem(10);
        inv.setItem(3, rock);
        inv.setItem(4, scissors);
        inv.setItem(5, paper);
        inv.setItem(8, timer);
        player.openInventory(inv);
        this.playerOpponents.put(player.getUniqueId(), opponent.getUniqueId());
        this.startCountdown(player, opponent, inv, 10);
    }

    private ItemStack createItem(Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7a" + name);
            meta.setLore(Arrays.asList(lore));
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createTimerItem(int secondsLeft) {
        ItemStack item = new ItemStack(Material.CLOCK);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7e\u041e\u0441\u0442\u0430\u043b\u043e\u0441\u044c \u0432\u0440\u0435\u043c\u0435\u043d\u0438");
            meta.setLore(Arrays.asList("\u00a7f" + secondsLeft + " \u0441\u0435\u043a\u0443\u043d\u0434"));
            item.setItemMeta(meta);
        }
        return item;
    }

    private void startCountdown(final Player player, final Player opponent, final Inventory inv, final int seconds) {
        UUID uuid = player.getUniqueId();
        BukkitRunnable timerTask = new BukkitRunnable(this){
            int timeLeft;
            final /* synthetic */ KnbGUI this$0;
            {
                this.this$0 = this$0;
                this.timeLeft = seconds;
            }

            public void run() {
                if (this.timeLeft <= 0 || !player.isOnline()) {
                    this.this$0.stopCountdown(player);
                    boolean hasPlayerChoice = this.this$0.plugin.hasChoice(player.getUniqueId());
                    boolean hasOpponentChoice = this.this$0.plugin.hasChoice(opponent.getUniqueId());
                    if (hasPlayerChoice && !hasOpponentChoice) {
                        player.sendMessage("\u00a77[\u00a7e\u26a1\u00a77] \u00a7r\u00a7a\u0412\u044b \u043f\u043e\u0431\u0435\u0434\u0438\u043b\u0438! \u041f\u0440\u043e\u0442\u0438\u0432\u043d\u0438\u043a \u043d\u0435 \u0443\u0441\u043f\u0435\u043b \u0432\u044b\u0431\u0440\u0430\u0442\u044c.");
                        opponent.sendMessage("\u00a77[\u00a7e\u26a1\u00a77] \u00a7r\u00a7c\u0412\u044b \u043f\u0440\u043e\u0438\u0433\u0440\u0430\u043b\u0438. \u041d\u0435 \u0443\u0441\u043f\u0435\u043b\u0438 \u0432\u044b\u0431\u0440\u0430\u0442\u044c.");
                    } else if (!hasPlayerChoice && hasOpponentChoice) {
                        opponent.sendMessage("\u00a77[\u00a7e\u26a1\u00a77] \u00a7r\u00a7a\u0412\u044b \u043f\u043e\u0431\u0435\u0434\u0438\u043b\u0438! \u041f\u0440\u043e\u0442\u0438\u0432\u043d\u0438\u043a \u043d\u0435 \u0443\u0441\u043f\u0435\u043b \u0432\u044b\u0431\u0440\u0430\u0442\u044c.");
                        player.sendMessage("\u00a77[\u00a7e\u26a1\u00a77] \u00a7r\u00a7c\u0412\u044b \u043f\u0440\u043e\u0438\u0433\u0440\u0430\u043b\u0438. \u041d\u0435 \u0443\u0441\u043f\u0435\u043b\u0438 \u0432\u044b\u0431\u0440\u0430\u0442\u044c.");
                    } else {
                        player.sendMessage("\u00a77[\u00a7e\u26a1\u00a77] \u00a7r\u00a7f\u0418\u0433\u0440\u0430 \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430. \u041d\u0438\u043a\u0442\u043e \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043b.");
                        opponent.sendMessage("\u00a77[\u00a7e\u26a1\u00a77] \u00a7r\u00a7f\u0418\u0433\u0440\u0430 \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430. \u041d\u0438\u043a\u0442\u043e \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043b.");
                    }
                    this.this$0.plugin.clearChoices(player, opponent);
                    player.closeInventory();
                    opponent.closeInventory();
                    return;
                }
                ItemStack timer = this.this$0.createTimerItem(this.timeLeft--);
                inv.setItem(8, timer);
            }
        };
        timerTask.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        this.playerTimers.put(uuid, timerTask);
    }

    public void stopCountdown(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.playerTimers.containsKey(uuid)) {
            this.playerTimers.get(uuid).cancel();
            this.playerTimers.remove(uuid);
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        if (e.getView().getTitle().equals("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0430\u0440\u0438\u0430\u043d\u0442")) {
            e.setCancelled(true);
            ItemStack clicked = e.getCurrentItem();
            if (clicked == null || clicked.getType() == Material.AIR) {
                return;
            }
            int choice = -1;
            switch (clicked.getType()) {
                case STONE: {
                    choice = 0;
                    break;
                }
                case IRON_SWORD: {
                    choice = 1;
                    break;
                }
                case PAPER: {
                    choice = 2;
                }
            }
            if (choice != -1) {
                this.stopCountdown(p);
                p.closeInventory();
                this.plugin.handleChoice(p, choice);
            }
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent e) {
        Player p = (Player)e.getPlayer();
        if (e.getView().getTitle().equals("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0430\u0440\u0438\u0430\u043d\u0442")) {
            this.stopCountdown(p);
        }
    }
}

