/*
 * Decompiled with CFR 0.152.
 */
package com.clearrchatz;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class ClearrChatZ
extends JavaPlugin {
    private String prefix;
    private int chatClearLines;
    private boolean showClearedBy;
    private boolean broadcastClear;
    private String clearMessage;
    private String noPermissionMessage;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.getCommand("clearchat").setExecutor(this);
        this.getCommand("cc").setExecutor(this);
        this.getLogger().info("ClearrChatZ has been enabled! Chat clearing is ready to go.");
    }

    @Override
    public void onDisable() {
        this.getLogger().info("ClearrChatZ has been disabled.");
    }

    private void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.prefix = ChatColor.translateAlternateColorCodes('&', config.getString("prefix", "&8[&bClearrChatZ&8] &r"));
        this.chatClearLines = config.getInt("chat-clear-lines", 100);
        this.showClearedBy = config.getBoolean("show-cleared-by", true);
        this.broadcastClear = config.getBoolean("broadcast-clear", true);
        this.clearMessage = ChatColor.translateAlternateColorCodes('&', config.getString("clear-message", "&aChat has been cleared!"));
        this.noPermissionMessage = ChatColor.translateAlternateColorCodes('&', config.getString("no-permission-message", "&cYou don't have permission to clear the chat."));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("clearchat") || command.getName().equalsIgnoreCase("cc")) {
            if (!sender.hasPermission("clearcatz.clear")) {
                sender.sendMessage(this.prefix + this.noPermissionMessage);
                return true;
            }
            String senderName = sender instanceof Player ? ((Player)sender).getDisplayName() : "Console";
            String clearNotice = ChatColor.translateAlternateColorCodes('&', this.clearMessage + (String)(this.showClearedBy ? " &7(Cleared by " + senderName + ")" : ""));
            if (this.broadcastClear) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    for (int i = 0; i < this.chatClearLines; ++i) {
                        player.sendMessage("");
                    }
                    player.sendMessage(this.prefix + clearNotice);
                }
                this.getServer().getConsoleSender().sendMessage(this.prefix + clearNotice);
            } else if (sender instanceof Player) {
                void var8_11;
                Player player = (Player)sender;
                boolean bl = false;
                while (var8_11 < this.chatClearLines) {
                    player.sendMessage("");
                    ++var8_11;
                }
                player.sendMessage(this.prefix + clearNotice);
            }
            return true;
        }
        return false;
    }

    public void reloadConfiguration() {
        this.reloadConfig();
        this.loadConfig();
    }
}

